/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.laboratorio.util.parsers.indlab.resultado.dto.FormatoExameIndLabDto;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ExameIndLabDto {
    private final String codigo;
    private final String descricao;
    private final String codigoTUSS;
    private final List<FormatoExameIndLabDto> formatos;

    private ExameIndLabDto(Builder builder) {
        this.codigo = builder.codigo;
        this.descricao = builder.descricao;
        this.codigoTUSS = builder.codigoTUSS;
        this.formatos = builder.formatos;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getCodigoTUSS() {
        return this.codigoTUSS;
    }

    public List<FormatoExameIndLabDto> getFormatos() {
        return this.formatos;
    }

    public static ExameIndLabDto fromXml(String xml) {
        ExameIndLabDto exameDto = null;
        if (!Funcoes.textoVazio(xml)) {
            String codigo = StringUtil.getValor(xml, "codigo");
            String descricao = StringUtil.getValor(xml, "descricao");
            String tuss = StringUtil.getValor(xml, "tuss");
            ArrayList<FormatoExameIndLabDto> formatos = new ArrayList<FormatoExameIndLabDto>();
            List<String> tagsFormato = StringUtil.getListValores(xml, "Formatos");
            tagsFormato.forEach(tag -> formatos.add(FormatoExameIndLabDto.fromXml(tag)));
            exameDto = new Builder().codigo(codigo).descricao(descricao).codigoTUSS(tuss).formatos(formatos).build();
        }
        return exameDto;
    }

    public static class Builder {
        private String codigo;
        private String descricao;
        private String codigoTUSS;
        private List<FormatoExameIndLabDto> formatos;

        public Builder codigo(String codigo) {
            this.codigo = codigo;
            return this;
        }

        public Builder descricao(String descricao) {
            this.descricao = descricao;
            return this;
        }

        public Builder codigoTUSS(String codigoTUSS) {
            this.codigoTUSS = codigoTUSS;
            return this;
        }

        public Builder formatos(List<FormatoExameIndLabDto> formatos) {
            this.formatos = formatos;
            return this;
        }

        public ExameIndLabDto build() {
            return new ExameIndLabDto(this);
        }
    }
}

