/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.util.Funcoes;
import jalis.util.StringUtil;

public class CampoExameIndLabDto {
    private final Integer itemNumero;
    private final String itemNome;
    private final String unidadeMedida;
    private final String valorReferencia;
    private final String metodologia;

    private CampoExameIndLabDto(Builder builder) {
        this.itemNome = builder.itemNome;
        this.itemNumero = builder.itemNumero;
        this.metodologia = builder.metodologia;
        this.unidadeMedida = builder.unidadeMedida;
        this.valorReferencia = builder.valorReferencia;
    }

    public Integer getItemNumero() {
        return this.itemNumero;
    }

    public String getItemNome() {
        return this.itemNome;
    }

    public String getUnidadeMedida() {
        return this.unidadeMedida;
    }

    public String getValorReferencia() {
        return this.valorReferencia;
    }

    public String getMetodologia() {
        return this.metodologia;
    }

    public static CampoExameIndLabDto fromXml(String xml) {
        CampoExameIndLabDto campodto = null;
        if (!Funcoes.textoVazio(xml)) {
            Integer itemNumero = Integer.valueOf(StringUtil.getValor(xml, "itemNumero"));
            String itemNome = StringUtil.getValor(xml, "itemNome");
            String unidadeMedida = StringUtil.getValor(xml, "unidadeMedida");
            String valorReferencia = StringUtil.getValor(xml, "valorReferencia");
            String metodologia = StringUtil.getValor(xml, "metodologia");
            campodto = new Builder().itemNome(itemNome).itemNumero(itemNumero).metodologia(metodologia).unidadeMedida(unidadeMedida).valorReferencia(valorReferencia).build();
        }
        return campodto;
    }

    public static class Builder {
        private Integer itemNumero;
        private String itemNome;
        private String unidadeMedida;
        private String valorReferencia;
        private String metodologia;

        public Builder itemNumero(Integer itemNumero) {
            this.itemNumero = itemNumero;
            return this;
        }

        public Builder itemNome(String itemNome) {
            this.itemNome = itemNome;
            return this;
        }

        public Builder unidadeMedida(String unidadeMedida) {
            this.unidadeMedida = unidadeMedida;
            return this;
        }

        public Builder valorReferencia(String valorReferencia) {
            this.valorReferencia = valorReferencia;
            return this;
        }

        public Builder metodologia(String metodologia) {
            this.metodologia = metodologia;
            return this;
        }

        public CampoExameIndLabDto build() {
            return new CampoExameIndLabDto(this);
        }
    }
}

