/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.util.Funcoes;
import jalis.util.StringUtil;

public class CabecalhoIndLabDto {
    public static final String TAG_CABECALHO = "cabecalho";
    public static final String TAG_LOTE = "lote";
    public static final String TAG_DATA_GERACAO = "dataGeracao";
    public static final String TAG_HORA_GERACAO = "horaGeracao";
    public static final String TAG_DATA_ASSINATURA_INICIAL = "dataAssinaturaInicial";
    public static final String TAG_DATA_ASSINATURA_FINAL = "dataAssinaturaFinal";
    private final String lote;
    private final String dataGeracao;
    private final String horaGeracao;
    private final String dataAssinaturaInicial;
    private final String dataAssinaturaFinal;

    private CabecalhoIndLabDto(Builder builder) {
        this.lote = builder.lote;
        this.dataGeracao = builder.dataGeracao;
        this.dataAssinaturaFinal = builder.dataAssinaturaFinal;
        this.dataAssinaturaInicial = builder.dataAssinaturaInicial;
        this.horaGeracao = builder.horaGeracao;
    }

    public String getLote() {
        return this.lote;
    }

    public String getDataGeracao() {
        return this.dataGeracao;
    }

    public String getHoraGeracao() {
        return this.horaGeracao;
    }

    public String getDataAssinaturaInicial() {
        return this.dataAssinaturaInicial;
    }

    public String getDataAssinaturaFinal() {
        return this.dataAssinaturaFinal;
    }

    public static CabecalhoIndLabDto fromXml(String xml) {
        CabecalhoIndLabDto cabecalhoDto = null;
        if (!Funcoes.textoVazio(xml)) {
            String lote = StringUtil.getValor(xml, TAG_LOTE);
            String dataGeracao = StringUtil.getValor(xml, TAG_DATA_GERACAO);
            String horaGeracao = StringUtil.getValor(xml, TAG_HORA_GERACAO);
            String dataAssinaturaInicial = StringUtil.getValor(xml, TAG_DATA_ASSINATURA_INICIAL);
            String dataAssinaturaFinal = StringUtil.getValor(xml, TAG_DATA_ASSINATURA_FINAL);
            cabecalhoDto = new Builder().dataAssinaturaFinal(StringUtil.xmlToTexto(dataAssinaturaFinal.trim())).dataAssinaturaInicial(StringUtil.xmlToTexto(dataAssinaturaInicial.trim())).dataGeracao(StringUtil.xmlToTexto(dataGeracao.trim())).horaGeracao(StringUtil.xmlToTexto(horaGeracao.trim())).lote(StringUtil.xmlToTexto(lote)).build();
        }
        return cabecalhoDto;
    }

    public static class Builder {
        private String lote;
        private String dataGeracao;
        private String horaGeracao;
        private String dataAssinaturaInicial;
        private String dataAssinaturaFinal;

        public Builder lote(String lote) {
            this.lote = lote;
            return this;
        }

        public Builder dataGeracao(String dataGeracao) {
            this.dataGeracao = dataGeracao;
            return this;
        }

        public Builder horaGeracao(String horaGeracao) {
            this.horaGeracao = horaGeracao;
            return this;
        }

        public Builder dataAssinaturaInicial(String dataAssinaturaInicial) {
            this.dataAssinaturaInicial = dataAssinaturaInicial;
            return this;
        }

        public Builder dataAssinaturaFinal(String dataAssinaturaFinal) {
            this.dataAssinaturaFinal = dataAssinaturaFinal;
            return this;
        }

        public CabecalhoIndLabDto build() {
            return new CabecalhoIndLabDto(this);
        }
    }
}

