/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.util.StringUtil;
import java.util.LinkedHashMap;

public class CamposImportacaoIndlab
implements CamposImportacao {
    LinkedHashMap<String, String> linhas = new LinkedHashMap();
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    public CamposImportacaoIndlab() {
    }

    public CamposImportacaoIndlab(String xml, String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, String versao, Integer codigoMaterialPai) {
        this.codigoExamePai = codigoExamePai;
        this.codigoExame = codigoExameLabApoio;
        this.versao = versao;
        this.codigoMaterialPai = codigoMaterialPai;
        this.linhas.put("", "Nenhum");
        for (String campo : StringUtil.getValores(xml, "campo")) {
            String itemNumero = StringUtil.getValor(campo, "itemNumero");
            this.linhas.put("itemNome_" + itemNumero, StringUtil.getValor(campo, "itemNome"));
            this.linhas.put("unidadeMedida_" + itemNumero, StringUtil.getValor(campo, "unidadeMedida"));
            this.linhas.put("valorReferencia_" + itemNumero, StringUtil.getValor(campo, "valorReferencia"));
            this.linhas.put("metodologia_" + itemNumero, StringUtil.getValor(campo, "metodologia"));
        }
        this.linhas.put("observacoesFixas", StringUtil.getValor(xml, "observacoesFixas"));
        this.linhas.put("observacoesVariaveis", StringUtil.getValor(xml, "observacoesVariaveis"));
    }

    @Deprecated
    private void carregaTemposLinhas(String linha, String descricao, String xml) {
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }

    public String toString() {
        return this.getVersao();
    }
}

