/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.indlab.CampoIndlab;
import jalis.laboratorio.util.parsers.indlab.ExameIndlab;
import jalis.laboratorio.util.parsers.indlab.ImportacaoIndlab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;

public class ParserImportacaoIndlab {
    private static final int TAG_MNEMONICO_EXAME = 0;
    private static final int TAG_FORMATACAO = 1;
    private static final int TAG_DESCRICAO_EXAME = 2;
    private static final int TAG_TUSS = 3;
    private static final int TAG_ITEM = 4;
    private static final int TAG_NOME_ITEM = 5;
    private static final int TAG_UNIDADE_MEDIDA = 6;
    private static final int TAG_VALOR_REFERENCIA = 7;
    private static final int TAG_METODOLOGIA = 8;
    private static final int TAG_OBSERVACOES_FIXA = 9;
    private static final int TAMANHO_LINHA = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ExameIndlab> importarExamesIndLab(String file, int codigoLabExterno, JProgressBar progress, ImportacaoIndlab telaImportacao) {
        HashMap<String, ExameIndlab> examesNovos = new HashMap<String, ExameIndlab>();
        HashMap<String, ExameIndlab> examesNaoAdicionados = new HashMap<String, ExameIndlab>();
        String[] linhas = file.split("\n");
        ExameIndlab eind = null;
        int qtdNaoAdicionados = 1;
        int c = 0;
        for (String s : linhas) {
            progress.setValue(c++);
            String[] exame = s.split(";", 10);
            if (ParserImportacaoIndlab.verificaPrimeiraLinha(exame)) continue;
            if (ParserImportacaoIndlab.exameValido(exame)) {
                int index = exame[1].indexOf(".");
                String numFormato = exame[1].substring(0, index);
                index = exame[4].indexOf(".");
                String numItem = exame[4].substring(0, index);
                String chave = exame[0].trim();
                String chaveRegistro = numFormato + "-" + numItem;
                String metodologia = "";
                if (exame.length > 8 && (index = exame[8].indexOf(";")) > 0) {
                    metodologia = exame[8].substring(0, index);
                }
                String observacaoFixa = "";
                if (exame.length > 9) {
                    observacaoFixa = exame[9].replace("|", "\n");
                }
                String valorRef = exame.length > 7 ? exame[7] : "";
                String unidadeMedida = exame.length > 6 ? exame[6] : "";
                String nomeItem = exame.length > 5 ? exame[5] : "";
                CampoIndlab campo = new CampoIndlab();
                campo.setFormato(Integer.valueOf(numFormato));
                campo.setItemNome(nomeItem.trim());
                campo.setItemNumero(Integer.valueOf(numItem));
                campo.setUnidadeMedida(ParserImportacaoIndlab.validaConteudoTag(unidadeMedida));
                campo.setVlrReferencia(ParserImportacaoIndlab.validaConteudoTag(valorRef));
                campo.setMetodologia(ParserImportacaoIndlab.validaConteudoTag(metodologia));
                if (!examesNovos.containsKey(chave)) {
                    eind = new ExameIndlab(exame[0], exame[2], exame[3]);
                    eind.setObservacoesFixas("observacoesFixas");
                    eind.setObservacoesVariaveis("observacoesVariaveis");
                    eind.addCamposRelacionamento(chaveRegistro, campo);
                    examesNovos.put(chave, eind);
                    continue;
                }
                ((ExameIndlab)examesNovos.get(chave)).setObservacoesFixas("observacoesFixas");
                ((ExameIndlab)examesNovos.get(chave)).setObservacoesVariaveis("observacoesVariaveis");
                ((ExameIndlab)examesNovos.get(chave)).addCamposRelacionamento(chaveRegistro, campo);
                continue;
            }
            examesNaoAdicionados.put("Exame nao adicionado-" + qtdNaoAdicionados, new ExameIndlab(exame[0], exame[2], exame[3]));
            ++qtdNaoAdicionados;
        }
        HashMap<String, ExameIndlab> examesExcluidos = new HashMap<String, ExameIndlab>();
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                Map<String, ExameIndlab> examesAntigosRelac = ParserImportacaoIndlab.examesMap(ParserImportacaoIndlab.getExamesRelacionados(codigoLabExterno));
                Map<String, ExameIndlab> examesAntigos = ParserImportacaoIndlab.loadExamesIndLab(st, codigoLabExterno);
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 14, new Object[0]);
                ParserImportacaoIndlab.inserirExamesIndLab(examesNovos, st, codigoLabExterno, examesAntigos);
                HashSet examesNovosRel = new HashSet(examesNovos.values());
                examesNovosRel.retainAll(examesAntigosRelac.values());
                for (Object ex : examesNovosRel) {
                    ExameIndlab exAntigo = examesAntigosRelac.get(((ExameIndlab)ex).getCodigoExame().toString());
                    if (exAntigo == null) continue;
                    ((ExameIndlab)ex).setExameJalis(exAntigo.getExameJalis());
                    ((ExameIndlab)ex).setMaterialJalis(exAntigo.getMaterialJalis());
                    if (!exAntigo.getMaterialJalis().equals(((ExameIndlab)ex).getMaterialJalis())) {
                        ((ExameIndlab)ex).setMaterialJalis(exAntigo.getMaterialJalis());
                    }
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((ExameIndlab)ex).getExameJalis(), Integer.parseInt(((ExameIndlab)ex).getMaterialJalis()), ((ExameIndlab)ex).getXml().replace("'", ""));
                }
                examesExcluidos.putAll(examesAntigos);
                for (Object ex : examesNovos.keySet()) {
                    if (!examesExcluidos.containsKey(ex)) continue;
                    examesExcluidos.remove(ex);
                }
                HashSet<ExameIndlab> examesExcluidosRel = new HashSet<ExameIndlab>(examesAntigosRelac.values());
                examesExcluidosRel.removeAll(examesNovos.values());
                for (ExameIndlab ex : examesExcluidosRel) {
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), ex.getXml().replace("'", ""));
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException e2) {
                        e.printStackTrace();
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        LinkedHashSet duplicados = new LinkedHashSet();
        for (String excluido : examesExcluidos.keySet()) {
            for (String naoAdicionado : examesNaoAdicionados.keySet()) {
                if (!((ExameIndlab)examesExcluidos.get(excluido)).equals(examesNaoAdicionados.get(naoAdicionado))) continue;
                duplicados.add(examesExcluidos.get(excluido));
            }
        }
        HashMap<String, ExameIndlab> examesSemDuplicados = new HashMap<String, ExameIndlab>();
        for (Map.Entry excluido : examesExcluidos.entrySet()) {
            if (duplicados.contains(excluido.getValue())) continue;
            examesSemDuplicados.put((String)excluido.getKey(), (ExameIndlab)excluido.getValue());
        }
        examesSemDuplicados.putAll(examesNaoAdicionados);
        return examesSemDuplicados;
    }

    private static boolean exameValido(String[] exameIndLab) {
        return exameIndLab[0].length() <= 8 && !Funcoes.textoVazio(exameIndLab[0]) && !Funcoes.textoVazio(exameIndLab[1]) && !Funcoes.textoVazio(exameIndLab[3]);
    }

    private static boolean verificaPrimeiraLinha(String[] exame) {
        return exame[0].contains("Mnemonico") && (exame[1].contains("Formata\u00e7\u00e3o") || exame[1].contains("Formatacao")) && exame[2].contains("Exame") && exame[3].contains("TUSS") && exame[4].contains("Item") && exame[5].contains("Nome Item") && exame[6].contains("Unidade Medida") && exame[7].contains("Valor Ref.") && exame[8].contains("Metodologia");
    }

    private static String validaConteudoTag(String conteudo) {
        if (conteudo.trim().length() == 0) {
            return "";
        }
        return conteudo.replace(";", "").trim();
    }

    private static Set<ExameIndlab> getExamesRelacionados(int codigoLabExterno) {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        if (st != null) {
            try {
                bui.append("  SELECT a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("\tFROM examematcoletalabexterno a \n");
                bui.append("\tLEFT JOIN labexterno b ON a.fil_codigo = b.fil_codigo AND a.lae_codigo = b.lae_codigo \n");
                bui.append("\tWHERE \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" AND \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno);
                bui.append("  AND a.ele_xmllabexterno IS NOT NULL AND a.ele_xmllabexterno <> '' ");
                return ExameIndlab.getExames(Conexao.executeQuery(st, bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + bui.toString(), e.getStackTrace());
            }
        }
        return new HashSet<ExameIndlab>();
    }

    private static Map<String, ExameIndlab> loadExamesIndLab(Statement st, int codigoLabExterno) throws SQLException {
        HashMap<String, ExameIndlab> exames = new HashMap<String, ExameIndlab>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT distinct fil_codigo, lae_codigo, inl_codigoexame, inl_descricaoexame, inl_xml");
        sql.append(" FROM examesindlab ");
        sql.append(" WHERE fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" AND lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            exames.put(rs.getString("inl_codigoexame"), new ExameIndlab(rs.getString("inl_xml")));
        }
        return exames;
    }

    private static void inserirExamesIndLab(Map<String, ExameIndlab> exames, Statement st, int codigoLabExterno, Map<String, ExameIndlab> examesAnt) throws SQLException, SalvaDadosException {
        for (String mnemonico : exames.keySet()) {
            ExameIndlab exame = exames.get(mnemonico);
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 14, exame.getCodigoExame(), StringUtil.textoDB(exame.getDescricaoExame()), exame.getXml().replace("'", ""));
        }
    }

    private static Map<String, ExameIndlab> examesMap(Collection<ExameIndlab> exames) {
        HashMap<String, ExameIndlab> examesMap = new HashMap<String, ExameIndlab>();
        for (ExameIndlab ex : exames) {
            examesMap.put(ex.getCodigoExame().toString(), ex);
        }
        return examesMap;
    }
}

