/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.indlab.EnvioServidorDto;
import jalis.laboratorio.triagem.externo.exportadores.indlab.IndLabComunicacao;
import jalis.laboratorio.triagem.externo.exportadores.indlab.RespostaPesquisaServidorDto;
import jalis.laboratorio.triagem.externo.exportadores.indlab.RespostaResultadoServidorDto;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.indlab.resultado.InformaPeriodoImportacaoIndLab;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.ExameIndLabDto;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.ExameResultadoIndLabDto;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.FormatoExameIndLabDto;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.ItemExameIndLabDto;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.ResultadoIndLabDto;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.SolicitacaoIndLabDto;
import jalis.model.dao.util.parsers.indlab.ImportacaoResultadoIndLabDao;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.service.cadastro.FilialService;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ImportacaoResultadoIndLab
extends AbstractImportadorResultadoLabExterno {
    private static final String TITULO = "Importa\u00e7\u00e3o de resultados";
    private static final String DESCRICAO = "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio IndLab a partir de arquivo XML";
    public static final String ULTIMO_FILTRO_DATA = "ImportarResultadosIndlab.ultimoFiltro";
    public static final String TAG_FILTRO = "filtro";
    public static final String TAG_DATA_FINAL = "dataFinal";
    public static final String TAG_HORA_FINAL = "horaFinal";
    public static final String CODIGO_LAYOUT = "codigo-layout";
    public static final String CABECALHO = "cabecalho";
    public static final String FORMATO = "formato";
    public static final String FORMATACAO = "formatacao";
    public static final String XML_LAB_EXTERNO = "xmlLabExterno";
    private static final int SITUACAO_FORMATO_OK = 0;
    private static final int SITUACAO_FORMATO_INCORRETO = 1;
    private static final int SITUACAO_FORMATO_VERSAO_NAO_LOCALIZADA = 2;
    private int contadorExames = 0;
    private ModeloGridTable modeloRelatorio;
    protected JButton botaoImprimir;
    private IndLabComunicacao comunicacao;
    private LoteExternoExameRequisicaoService loteExternoExameRequisicaoService;
    private ImportacaoResultadoIndLabDao dao;
    private LaboratorioExterno labExterno;
    private boolean conferirAutomatico;
    private boolean importou;
    private String codigoUsuarioConferenciaAutomatica;
    private String dataFinalInformada;
    private String horaFinalInformada;

    public ImportacaoResultadoIndLab(int codigoLabExterno) {
        super(TITULO, DESCRICAO, codigoLabExterno, Protocolo.INDLab, new JPanel(new FlowLayout(2)));
        this.labExterno = LaboratorioExterno.getLabExterno(String.valueOf(codigoLabExterno));
        this.comunicacao = new IndLabComunicacao(this.labExterno.configuracao);
        this.loteExternoExameRequisicaoService = new LoteExternoExameRequisicaoService();
        this.dao = new ImportacaoResultadoIndLabDao();
        this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
        this.adicionarBotaoImprimir();
        this.importou = false;
    }

    private void adicionarBotaoImprimir() {
        this.botaoImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
        this.getPanelAdicional().add(this.botaoImprimir);
    }

    @Override
    protected void importarResultado() {
        this.verificarConferenciaAutomatica();
        String urlResultados = StringUtil.getValor(this.labExterno.configuracao, "caminhoRetorno");
        if (Funcoes.textoVazio(urlResultados)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Caminho Retorno n\u00e3o configurado no Laborat\u00f3rio Externo.", 2);
            return;
        }
        InformaPeriodoImportacaoIndLab pi = InformaPeriodoImportacaoIndLab.novaInstancia(this.getTopLevelAncestor(), this.codigoLabExterno);
        pi.setVisible(true);
        if (pi.isOk()) {
            this.importou = true;
            this.dataFinalInformada = pi.getDataFinal();
            this.horaFinalInformada = pi.getHoraFinal();
            this.setTextoInformacoes("\nAguarde! Consultando o per\u00edodo informado...");
            RespostaPesquisaServidorDto respostaPesquisa = this.pesquisarResultados(pi);
            if (respostaPesquisa.getCodigo() < 0 || respostaPesquisa.getCodigo() > 0) {
                this.setTextoInformacoes("\n" + respostaPesquisa.getMensagem(), false);
                this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada!", false);
                return;
            }
            List<String> arquivosResultado = respostaPesquisa.getArquivos();
            Statement st = Conexao.getStatement();
            for (String arq : arquivosResultado) {
                boolean processado = this.processouResultado(arq, st);
                if (processado) continue;
            }
            Conexao.fecharStatement(st);
            this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada!", false);
        }
        this.botaoImprimir.setEnabled(true);
    }

    private void verificarConferenciaAutomatica() {
        LabExternoVO vo = this.dao.pesquisarPorCodLabExterno(this.codigoLabExterno);
        if (vo.getCodigo() != null) {
            this.conferirAutomatico = vo.getConferirAutomatico();
            this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(vo.getCodigoUsuarioConferir()) || Funcoes.textoVazio(vo.getCodigoUsuarioConferir()) ? null : vo.getCodigoUsuarioConferir();
        }
    }

    private RespostaPesquisaServidorDto pesquisarResultados(InformaPeriodoImportacaoIndLab pi) {
        String dataHoraInicial = pi.getDataInicial().concat(" ").concat(pi.getHoraInicial());
        String dataHoraFinal = pi.getDataFinal().concat(" ").concat(pi.getHoraFinal());
        return this.comunicacao.pesquisarResultadosPorData(dataHoraInicial.trim(), dataHoraFinal.trim());
    }

    private boolean processouResultado(String arq, Statement st) {
        String caminhoRetorno = StringUtil.getValor(this.labExterno.configuracao, "caminhoRetorno").trim();
        try {
            this.setTextoInformacoes("\nSolicitando os resultados do arquivo " + arq, false);
            EnvioServidorDto envioServidor = new EnvioServidorDto(this.labExterno, Integer.valueOf(Variaveis.filialPadrao), arq, caminhoRetorno);
            RespostaResultadoServidorDto respostaResultado = this.comunicacao.importarResultado(envioServidor);
            if (respostaResultado.getCodigo() < 0 || respostaResultado.getCodigo() > 0) {
                this.setTextoInformacoes("\n" + respostaResultado.getMensagem(), false);
                return false;
            }
            this.setTextoInformacoes("\nIniciando a importa\u00e7\u00e3o...", false);
            this.salvarXmlResultadoNoPcLocal(respostaResultado.getResultado());
            ResultadoIndLabDto resultadoDto = ResultadoIndLabDto.fromXml(respostaResultado.getResultado());
            if (resultadoDto != null && !resultadoDto.getSolicitacoes().isEmpty()) {
                this.setTextoInformacoes("\nQuantidade de requisi\u00e7\u00f5es presentes no arquivo: " + resultadoDto.getSolicitacoes().size(), false);
                this.processarSolicitacoes(resultadoDto.getSolicitacoes(), st);
            } else {
                this.setTextoInformacoes("\nNenhum resultado encontrado no arquivo " + arq, false);
            }
        }
        catch (Exception e) {
            this.setTextoInformacoes("\nFalha ao importar resultado - " + e.getMessage(), false);
        }
        return true;
    }

    private void processarSolicitacoes(List<SolicitacaoIndLabDto> solicitacoes, Statement st) throws Exception {
        this.salvarParametros();
        Long quantRequisicoes = solicitacoes.stream().map(solicitacao -> solicitacao.getPaciente().getCodigoExternoContaMedica()).count();
        Long quantExames = solicitacoes.stream().map(solicitacao -> solicitacao.getExamePaciente()).flatMap(examePaciente -> examePaciente.getExames().stream()).count();
        this.progress.setMaximum(quantExames.intValue() + quantRequisicoes.intValue());
        this.progress.setValue(0);
        this.progress.setVisible(true);
        this.progress.revalidate();
        ArrayList<String> filiaisSolicitacoes = new ArrayList<String>();
        for (SolicitacaoIndLabDto solicitacao2 : solicitacoes) {
            String codExterno = solicitacao2.getPaciente().getCodigoExternoContaMedica();
            if (Funcoes.textoVazio(codExterno) || codExterno.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) continue;
            String filial = solicitacao2.getPaciente().getCodigoExternoContaMedica().substring(0, ParametrosGerais.getDigitosTuboFilial());
            filiaisSolicitacoes.add(filial);
        }
        filiaisSolicitacoes = new ArrayList(new LinkedHashSet(filiaisSolicitacoes));
        ArrayList<FilialVOAux> filiaisExportacao = new ArrayList<FilialVOAux>();
        for (String filial : filiaisSolicitacoes) {
            FilialVOAux filialExportacao = this.getDadosExportacao(filial);
            if (null == filialExportacao || filialExportacao.getCodigo() == null) continue;
            filiaisExportacao.add(filialExportacao);
        }
        for (SolicitacaoIndLabDto solicitacao3 : solicitacoes) {
            int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
            if (solicitacao3.getPaciente() == null) continue;
            if (solicitacao3.getPaciente().getCodigoExternoContaMedica().length() != tamTubo) {
                this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + solicitacao3.getPaciente().getCodigoExternoContaMedica(), false);
                continue;
            }
            if (!Funcoes.isNumeric(solicitacao3.getPaciente().getCodigoExternoContaMedica()) || solicitacao3.getPaciente().getCodigoExternoContaMedica().contains(".") || solicitacao3.getPaciente().getCodigoExternoContaMedica().contains(",")) {
                this.setTextoInformacoes("\nRequisi\u00e7\u00e3o: " + solicitacao3.getPaciente().getCodigoExternoContaMedica() + " n\u00e3o gerada pelo Jalis ignorada na importa\u00e7\u00e3o.", false);
                continue;
            }
            String codFilial = solicitacao3.getPaciente().getCodigoExternoContaMedica().substring(0, ParametrosGerais.getDigitosTuboFilial());
            String codRequisicao = solicitacao3.getPaciente().getCodigoExternoContaMedica().substring(ParametrosGerais.getDigitosTuboFilial());
            this.processarExamesSolicitacao(codFilial, codRequisicao, solicitacao3, filiaisExportacao, st);
        }
        this.progress.setVisible(false);
    }

    private void processarExamesSolicitacao(String codFilial, String codRequisicao, SolicitacaoIndLabDto solicitacao, List<FilialVOAux> filiaisExportacao, Statement st) throws Exception {
        Integer[] multiguias = this.verificarRequisicaoMultiguia(codFilial, codRequisicao);
        HashMap<String, String> requisicoesEnvioNotificacao = new HashMap<String, String>();
        for (ExameResultadoIndLabDto exameSolicitacao : solicitacao.getExamePaciente().getExames()) {
            String codMaterialJalis;
            this.progress.setValue(this.progress.getValue() + 1);
            String mnemonico = exameSolicitacao.getMnemonicoOrigem();
            if (Funcoes.textoVazio(mnemonico) || !mnemonico.contains("|")) {
                this.setTextoInformacoes("\n Mnemonico de Origem n\u00e3o encontrado", false);
                continue;
            }
            String codExameJalis = mnemonico.substring(0, exameSolicitacao.getMnemonicoOrigem().indexOf("|"));
            String situacaoExame = this.dao.pesquisarSituacaoExame(codFilial, this.labExterno.codigoLab, multiguias, codExameJalis, codMaterialJalis = mnemonico.substring(exameSolicitacao.getMnemonicoOrigem().indexOf("|") + 1));
            if (!Funcoes.textoVazio(situacaoExame) && !situacaoExame.equals("P")) {
                String descricaoSituacao = Tipos.tipoSituacaoExame(situacaoExame);
                this.setTextoInformacoes(String.format("\n Exame %s %s", codExameJalis + "|" + codMaterialJalis, descricaoSituacao), false);
                continue;
            }
            LinkedList<Registro> exames = this.carregarExamesPaiEFilhos(codFilial, codRequisicao, exameSolicitacao, multiguias, st);
            if (exames == null || exames.isEmpty()) {
                this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis Fil.: %s Req.: %s. ", codFilial, codRequisicao), false);
                continue;
            }
            for (Registro exame : exames) {
                if (exame != null) {
                    Registro formatacao;
                    if (this.exameJaLancado(exame)) {
                        this.setTextoInformacoes(String.format("\n Exame %s %s", exame.getString("exa_codigo") + "|" + exame.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO.descricao), false);
                        this.adicionarAoModeloRelatorio(solicitacao, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO, exame);
                        continue;
                    }
                    if (!this.exameColetado(exame) && !exame.getString("exr_situacao").equals("P")) {
                        this.setTextoInformacoes(String.format("\n Exame %s %s", exame.getString("exa_codigo") + "|" + exame.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL.descricao), false);
                        this.adicionarAoModeloRelatorio(solicitacao, AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL, exame);
                        continue;
                    }
                    if (!this.dao.exameRelacionado(exame, this.codigoLabExterno)) {
                        this.adicionarAoModeloRelatorio(solicitacao, AbstractImportadorResultadoLabExterno.Situacao.SEM_RELACIONAMENTO, exame);
                        this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar " + exame.getString("req_codigo") + "|" + exame.getString("exa_codigo") + " exame - Sem relacionamento", false);
                        continue;
                    }
                    if (exame.nulo("examePai")) {
                        exame.setValor("examePai", exame.getString("exa_codigo"));
                    }
                    boolean salvoParcial = exame.getString("exr_situacao").equals("P");
                    String elm_formato = ExameUtil.pegaLayoutIdade(exame.getString("fil_codigo"), exame.getInt("req_idade"), exame.getString("req_anomes"), exame.getString(CODIGO_LAYOUT), exame.getString("examePai"), exame.getInt("mco_codigo"), exame.getInt("met_codigo"), "elm_formato", exame);
                    Registro formato = new Registro();
                    formato.setValor(FORMATO, exame.getValor("formatoPadrao"));
                    formato.setValor("met_codigo", exame.getValor("met_codigo"));
                    Registro registro = formatacao = salvoParcial ? (Registro)exame.getValor(FORMATACAO) : formato;
                    if (formatacao == null) {
                        this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + exame.getString("req_codigo") + "|" + exame.getString("exa_codigo") + " - Formata\u00e7\u00e3o n\u00e3o encontrada", false);
                        continue;
                    }
                    int situacaoFormato = this.validarSituacaoVersaoFormato(formatacao, exameSolicitacao, exame);
                    if (situacaoFormato == 1 || situacaoFormato == 2) {
                        this.adicionarAoModeloRelatorio(solicitacao, AbstractImportadorResultadoLabExterno.Situacao.VERSAO_INCOMPATIVEL, exame);
                        String mensagem = "";
                        if (situacaoFormato == 1) {
                            mensagem = " - formato do arquivo de importa\u00e7\u00e3o incorreto";
                        }
                        if (situacaoFormato == 2) {
                            mensagem = " - n\u00e3o localizado modelo para importa\u00e7\u00e3o";
                        }
                        this.setTextoInformacoes("\nResultado de  " + exame.getString("req_codigo") + "|" + exame.getString("exa_codigo") + mensagem, false);
                        continue;
                    }
                    Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(exame.getString("req_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"), exame.getString("fil_codigo"), false, false);
                    Map<String, Object> camposImportacao = this.ItemExameIndLabDtoParaHashMap(exameSolicitacao, exame);
                    dados.putAll(camposImportacao);
                    Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(exame.getString("fil_codigo"), exame.getString("req_codigo"), exame.getString("pac_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"), exame.getString("met_codigo"));
                    Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(exame.getString("exa_codigo"), exame.getString("fil_codigo"));
                    if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                        historicos = ExameUtil.getHistoricos(null, exame.getString("fil_codigo"));
                    }
                    dados.putAll(RecepcaoUtil.preencheHashDados(exame.getString("fil_codigo"), exame.getString("req_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo")));
                    Map<String, Object> resposta = Resultado.getCamposResultado(exame.getString("exr_resposta"));
                    Resultado res = new Resultado(formatacao.getString(FORMATO), dados);
                    res.atualizarComponentes();
                    res = new Resultado(null, formatacao.getString(FORMATO), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
                    res.atualizarComponentes();
                    boolean completo = true;
                    if (exame.getBoolean("exa_salvaparcial")) {
                        completo = res.resultadoCompleto(true);
                    }
                    if (!completo && exame.getBoolean("exa_salvaparcial")) {
                        completo = res.resultadoCompleto(false);
                    }
                    String novaSituacao = completo ? "L" : "P";
                    String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                    Util.gravaAlteracaoExameRequisicao(st, exame.getString("fil_codigo"), exame.getString("req_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"));
                    boolean marcarConferido = false;
                    if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                        int verificacao = res.verificarValidacao();
                        boolean bl = marcarConferido = verificacao == 1;
                        if (!marcarConferido && verificacao != 2) {
                            this.adicionarAoModeloRelatorio(solicitacao, AbstractImportadorResultadoLabExterno.Situacao.VALIDACAO_INSATISFEITA, exame);
                            this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + exame.getString("req_codigo") + "|" + exame.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                        }
                    }
                    if (exame.getValor("examePai") != null) {
                        exame.setValor("exa_codigo", exame.getString("examePai"));
                    }
                    boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                    boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                    this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), exame, exame, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                    Optional<FilialVOAux> filialExportacao = filiaisExportacao.stream().filter(f -> f.getCodigo().equals(exame.getInt("fil_codigo"))).findAny();
                    if (this.exportarBaseWeb(filialExportacao)) {
                        Statement st2 = Conexao.getStatement();
                        Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, exame.getString("fil_codigo"), exame.getString("req_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"), resultado, false);
                        this.exportarParaWeb(st, this.getCodigoBaseWeb(exame.getString("fil_codigo")), novaSituacao, exame, mapa, resultado, formatacao.getString("formatotexto"));
                        if (ExportaWeb.isGerarPdfResultado(st2, exame.getString("fil_codigo"))) {
                            ExportaWeb.enviarResultadoPDF(st2, exame.getString("fil_codigo"), exame.getString("req_codigo"), this.getCodigoBaseWeb(exame.getString("fil_codigo")));
                        }
                        this.atualizarPaginaOrdemExameWeb(st2, exame);
                        Conexao.fecharStatement(st2);
                    }
                    this.adicionarAoModeloRelatorio(solicitacao, completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE, exame);
                    if (completo) {
                        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? exame.getDate("exr_datamaterial") : new Date();
                        Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? exame.getDate("exr_datamaterial") : new Date();
                        this.atualizarTabelaExamesControle(st, exame, res.getResultadoAnterior(dataColeta, horaColeta));
                    }
                    if (this.filialExportaExames(filialExportacao)) {
                        this.editarRequisicaoExportaFiliais(exame);
                    }
                    this.atualizarSituacaoExameInterfaceamento(st, exame);
                    AbstractImportadorResultadoLabExterno.Situacao situacao = completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE;
                    this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(exame.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(exame.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + exame.getString("exa_codigo") + " - " + (Object)((Object)situacao), false);
                    Conexao.fecharStatement(st);
                }
                ++this.contadorExames;
                if (this.contadorExames >= 50) {
                    this.setTextoInformacoes("\nArquivando resultados", false);
                    Conexao.arquivaSQL();
                    this.contadorExames = 0;
                }
                String filialRequisicao = exame.getString("fil_codigo") + "|" + exame.getString("req_codigo");
                requisicoesEnvioNotificacao.put(filialRequisicao, solicitacao.getPaciente().getCodigoApoio());
            }
        }
        if (this.contadorExames > 0) {
            this.setTextoInformacoes("\nArquivando resultados", false);
            Conexao.arquivaSQL();
            this.contadorExames = 0;
        }
        this.enviarNotificacoes(requisicoesEnvioNotificacao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarNotificacoes(Map<String, String> requisicoesEnvioNotificacao) throws Exception {
        if (!requisicoesEnvioNotificacao.isEmpty()) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            try {
                for (Map.Entry<String, String> filReq : requisicoesEnvioNotificacao.entrySet()) {
                    this.progress.setValue(this.progress.getValue() + 1);
                    String[] filialRequisicao = filReq.getKey().split("\\|");
                    if (filialRequisicao.length <= 1) continue;
                    String codFil = filialRequisicao[0];
                    String codReq = filialRequisicao[1];
                    if (!this.existeRequisicaoLabExterno(Integer.valueOf(codFil), this.codigoLabExterno, Integer.valueOf(codReq), "")) {
                        this.inserirDadosRequisicao(st, this.codigoLabExterno, filReq.getValue(), codFil, Integer.valueOf(codReq));
                    }
                    if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(codFil, codReq, st)) {
                        SMSUtil.criaLogSmsComDadosRequisicao(codFil, codReq, ExportaSMS.TipoSMS.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                    }
                    if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(codFil, codReq, st)) {
                        EmailUtil.criaLogEmail(codFil, codReq, null, EmailUtil.TipoEmail.RESULTADO, true, st);
                    }
                    if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(codFil, codReq, st)) {
                        PushUtil.criaLogPushComDadosRequisicao(codFil, codReq, TipoPush.RESULTADO, st, st2);
                    }
                    if (!this.conferirAutomatico || Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) || WhatsAppUtil.isBloquearWhatsappExamePronto(codFil, codReq, st)) continue;
                    WhatsAppUtil.criaLogWhatsappComDadosRequisicao(codFil, codReq, TipoWhatsapp.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    private Map<String, Object> ItemExameIndLabDtoParaHashMap(ExameResultadoIndLabDto exameSolicitacao, Registro exame) {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        String inicioCampo = "~" + exameSolicitacao.getFormatacaoExame() + "|";
        for (ItemExameIndLabDto itemExame : exameSolicitacao.getItensExame()) {
            String finalCampo = "_" + itemExame.getItemNumero();
            if (exame.getValor("examePai") != exame.getValor("exa_codigo")) {
                finalCampo = finalCampo + "@" + exame.getString("exameFilho") + "#" + exame.getString("mco_codigo");
            }
            String itemNome = inicioCampo + "itemNome" + finalCampo;
            String unidadeMedida = inicioCampo + "unidadeMedida" + finalCampo;
            String valorRef = inicioCampo + "valorReferencia" + finalCampo;
            String metodologia = inicioCampo + "metodologia" + finalCampo;
            dados.put(itemNome, itemExame.getResultado());
            dados.put(unidadeMedida, itemExame.getUnidadeMedida());
            dados.put(valorRef, itemExame.getValorReferencia());
            dados.put(metodologia, itemExame.getMetodologia());
            if (!Funcoes.textoVazio(itemExame.getObservacoesFixas())) {
                dados.put(inicioCampo + "observacoesFixas", itemExame.getObservacoesFixas());
            }
            if (Funcoes.textoVazio(itemExame.getObservacoesVariaveis())) continue;
            dados.put(inicioCampo + "observacoesVariaveis", itemExame.getObservacoesVariaveis());
        }
        return dados;
    }

    private void atualizarPaginaOrdemExameWeb(Statement st, Registro dados) throws Exception {
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, dados.getString("fil_codigo"), dados.getString("req_codigo"), Variaveis.codigoBaseWeb);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini (1506)");
        }
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilialVOAux getDadosExportacao(String codFilial) {
        FilialVOAux filialVO;
        Statement st;
        block4: {
            FilialVOAux filialVOAux;
            st = Conexao.getStatement();
            filialVO = new FilialVOAux();
            try {
                FilialService filService = new FilialService();
                filialVO = filService.getDadosExportacao(st, codFilial);
                if (!this.carregouVO(filialVO)) break block4;
                filialVOAux = filialVO;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini: 261");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return filialVOAux;
        }
        Conexao.fecharStatement(st);
        return filialVO;
    }

    private boolean exportarBaseWeb(Optional<FilialVOAux> filialVO) {
        if (filialVO.isPresent()) {
            return !Funcoes.textoVazio(filialVO.get().getTipoBase()) && filialVO.get().isWebStandAlone() == false;
        }
        return false;
    }

    private boolean filialExportaExames(Optional<FilialVOAux> filialVO) {
        if (filialVO.isPresent()) {
            return filialVO.get().isExportarexames();
        }
        return false;
    }

    private boolean exameColetado(Registro exame) {
        return exame != null && Funcoes.textoVazio(exame.getString("exr_situacao"));
    }

    private boolean exameJaLancado(Registro exame) {
        String sit = exame.getString("exr_situacao");
        return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
    }

    @Override
    protected void importarResultadoWs() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    private void salvarParametros() {
        if (this.importou && !Funcoes.textoVazio(this.dataFinalInformada) && !Funcoes.textoVazio(this.horaFinalInformada)) {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir(TAG_FILTRO);
            xml.escrever(TAG_DATA_FINAL, this.dataFinalInformada);
            xml.escrever(TAG_HORA_FINAL, this.horaFinalInformada);
            try {
                xml.fechar(TAG_FILTRO);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ParametrosUsuarios.setValor(ULTIMO_FILTRO_DATA, xml.getXML());
            ParametrosUsuarios.salvarParametros(false);
        }
    }

    @Override
    public void run() {
        if (this.isWebService) {
            this.importarResultadoWs();
        } else {
            this.importarResultado();
        }
        this.habilitarBotoes(true);
    }

    private LinkedList<Registro> carregarExamesPaiEFilhos(String codFilial, String codRequisicao, ExameResultadoIndLabDto exameSolicitacao, Integer[] multiguias, Statement st) throws Exception {
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        if (Funcoes.textoVazio(exameSolicitacao.getMnemonicoOrigem()) || !exameSolicitacao.getMnemonicoOrigem().contains("|")) {
            return retorno;
        }
        String codExameJalis = exameSolicitacao.getMnemonicoOrigem().substring(0, exameSolicitacao.getMnemonicoOrigem().indexOf("|"));
        String codMaterialJalis = exameSolicitacao.getMnemonicoOrigem().substring(exameSolicitacao.getMnemonicoOrigem().indexOf("|") + 1);
        if (!Funcoes.isNumeric(codMaterialJalis)) {
            return retorno;
        }
        for (Integer guia : multiguias) {
            Registro reg;
            ExameDesmembrado examePai;
            Registro exameSeparado;
            boolean exameLabExterno = LoteExternoExameRequisicaoService.validaExameLabExterno(Variaveis.filialPadrao, guia.toString(), codExameJalis, codMaterialJalis, codFilial, st);
            if (exameLabExterno && (exameSeparado = this.dao.pesquisarExameRequisicao(codFilial, guia.toString(), codExameJalis, codMaterialJalis)) != null) {
                retorno.add(exameSeparado);
            }
            if ((examePai = this.getExamesDesmembrados(codFilial, guia.toString(), String.valueOf(this.labExterno.codigoLab), codExameJalis, codMaterialJalis)) == null) continue;
            boolean isExameLabExternoDesm = LoteExternoExameRequisicaoService.validaExameLabExterno(Variaveis.filialPadrao, guia.toString(), examePai.getCodigoExame(), String.valueOf(examePai.getCodigomaterial()), codFilial, st);
            if (!isExameLabExternoDesm || (reg = this.dao.pesquisarExameRequisicao(codFilial, guia.toString(), examePai.getCodigoExame(), String.valueOf(examePai.getCodigomaterial()))) == null) continue;
            reg.setValor("exa_codigo", examePai.getFilhos().get(0).getCodigoExame());
            reg.setValor("ele_xmllabexterno", examePai.getFilhos().get(0).getXmlLabExterno());
            reg.setValor("examePai", examePai.getCodigoExame());
            reg.setValor("exameFilho", examePai.getFilhos().get(0).getCodigoExame());
            retorno.add(reg);
        }
        return retorno;
    }

    private Integer[] verificarRequisicaoMultiguia(String codFilial, String codRequisicao) throws SQLException {
        Integer[] multiguias = null;
        multiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true) : new Integer[]{Integer.parseInt(codRequisicao)};
        return multiguias;
    }

    private void salvarXmlResultadoNoPcLocal(String xmlResultado) throws Exception {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Salvar");
        chooser.setApproveButtonText("Salvar");
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("XML (*.xml)", "xml"));
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd HH-mm-ssSSS");
        String nomeArquivo = sf.format(new Date());
        if (!Funcoes.diretorioExiste(System.getProperty("user.home") + "/resultados" + this.labExterno.descricao)) {
            new File(System.getProperty("user.home") + "/resultados" + this.labExterno.descricao).mkdirs();
        }
        File arquivo = new File(System.getProperty("user.home").toString() + "/resultados" + this.labExterno.descricao + "/" + nomeArquivo + ".xml");
        chooser.setSelectedFile(arquivo);
        StringUtil.escreverArquivoTexto(chooser.getSelectedFile().getPath(), xmlResultado);
    }

    private void adicionarAoModeloRelatorio(SolicitacaoIndLabDto solicitacao, AbstractImportadorResultadoLabExterno.Situacao situacao, Registro exame) {
        if (solicitacao != null && solicitacao.getPaciente() != null && exame != null && solicitacao.getPaciente().getCodigoExternoContaMedica().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            ExameDesmembrado examePai;
            String exa = exame.getString("exa_codigo");
            String mco = exame.getString("mco_codigo");
            String requisicao = solicitacao.getPaciente().getCodigoExternoContaMedica();
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String codRequisicao = exame.getString("req_codigo");
            Statement st = Conexao.getStatement();
            String exames = "";
            try {
                exames = BDUtil.getCodigoExames(filial, codRequisicao, st);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, codRequisicao, e.getStackTrace());
            }
            if (!exames.contains(exa) && (examePai = this.getExamesDesmembrados(filial, codRequisicao, String.valueOf(this.codigoLabExterno), exa, mco)) != null) {
                exa = examePai.getCodigoExame();
                mco = String.valueOf(examePai.getCodigomaterial());
            }
            if (!situacao.equals((Object)AbstractImportadorResultadoLabExterno.Situacao.VERSAO_INCOMPATIVEL)) {
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, codRequisicao, exa, Integer.parseInt(mco), situacao.descricao);
            }
        }
    }

    private int validarSituacaoVersaoFormato(Registro formatacao, ExameResultadoIndLabDto exameSolicitacao, Registro reg) throws Exception {
        String codExamePai;
        boolean mesmaVersao = false;
        String codExame = reg.getString("exa_codigo");
        if (codExame.equals(codExamePai = reg.getString("examePai"))) {
            mesmaVersao = this.mesmaVersao(formatacao.getString(FORMATO), exameSolicitacao);
        } else {
            List<String> camposImpDesm = StringUtil.getListValores(formatacao.getString(FORMATO), "campoImportacao");
            mesmaVersao = this.mesmaVersaoDesm(camposImpDesm, exameSolicitacao);
        }
        boolean mesmaVersaoEstrutura = this.mesmaVersaoEstrutura(exameSolicitacao, reg.getString("fil_codigo"));
        if (!mesmaVersao) {
            return 2;
        }
        if (!mesmaVersaoEstrutura) {
            return 1;
        }
        return 0;
    }

    private boolean mesmaVersaoDesm(List<String> camposImpDesm, ExameResultadoIndLabDto exameSolicitacao) {
        boolean mesmaVersao = false;
        for (String campoImp : camposImpDesm) {
            if (Funcoes.textoVazio(campoImp) || !campoImp.contains("~") || !campoImp.contains("|") || !campoImp.contains("@") || !campoImp.contains("#")) continue;
            String codExameDesm = campoImp.substring(campoImp.indexOf("@")).replace("</campo>", "");
            String versaoFormatoConfig = campoImp.substring(campoImp.indexOf("~") + 1, campoImp.indexOf("|"));
            String codExameJalis = codExameDesm.substring(codExameDesm.indexOf("@") + 1, codExameDesm.indexOf("#"));
            String codMaterialJalis = codExameDesm.substring(codExameDesm.indexOf("#") + 1);
            String codExameSol = exameSolicitacao.getMnemonicoOrigem().substring(0, exameSolicitacao.getMnemonicoOrigem().indexOf("|"));
            String codMaterialSol = exameSolicitacao.getMnemonicoOrigem().substring(exameSolicitacao.getMnemonicoOrigem().indexOf("|") + 1);
            if (!codExameJalis.equals(codExameSol) || !codMaterialJalis.equals(codMaterialSol)) continue;
            mesmaVersao = exameSolicitacao.getFormatacaoExame().equals(Integer.valueOf(versaoFormatoConfig));
            break;
        }
        return mesmaVersao;
    }

    private boolean mesmaVersao(String formato, ExameResultadoIndLabDto exameSolicitacao) {
        String xmlExameJalis = StringUtil.getValor(formato, "exame");
        String formatoVersoesConfiguradas = StringUtil.getValor(xmlExameJalis, "versaoExameLabExterno");
        return formatoVersoesConfiguradas.contains(exameSolicitacao.getFormatacaoExame().toString()) || formatoVersoesConfiguradas.equals("0");
    }

    private boolean mesmaVersaoEstrutura(ExameResultadoIndLabDto exameSolicitacao, String codFilial) {
        boolean mesmaVersao = true;
        String xmlLabExterno = this.dao.pesquisarXmlLabExternoPorCodLabExterno(codFilial, exameSolicitacao, this.codigoLabExterno);
        if (!Funcoes.textoVazio(xmlLabExterno)) {
            ExameIndLabDto exameIndLab = ExameIndLabDto.fromXml(xmlLabExterno);
            List codigosFormato = exameIndLab.getFormatos().stream().map(formato -> formato.getCodigo()).collect(Collectors.toList());
            if (exameSolicitacao.getMnemonicoExame().trim().equals(exameIndLab.getCodigo().trim()) && codigosFormato.contains(exameSolicitacao.getFormatacaoExame())) {
                for (FormatoExameIndLabDto formato2 : exameIndLab.getFormatos()) {
                    if (!formato2.getCodigo().equals(exameSolicitacao.getFormatacaoExame())) continue;
                    List camposExame = formato2.getCampos().stream().map(campo -> campo.getItemNumero()).collect(Collectors.toList());
                    for (ItemExameIndLabDto itemExame : exameSolicitacao.getItensExame()) {
                        if (camposExame.contains(itemExame.getItemNumero())) continue;
                        mesmaVersao = false;
                    }
                }
            } else {
                mesmaVersao = false;
            }
        }
        return mesmaVersao;
    }
}

