/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.indlab.ExameIndlab;
import jalis.laboratorio.util.parsers.indlab.ParserImportacaoIndlab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFileChooser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;

public class ImportacaoIndlab
extends AbstractImportadorLabExterno {
    private File arquivoExames = null;
    public String configuracoes = null;

    public ImportacaoIndlab(int codigoLabExterno, String configuracoes) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. IndLab a partir de arquivo XLS", codigoLabExterno, Protocolo.INDLab);
        this.configuracoes = configuracoes;
    }

    public ImportacaoIndlab(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. IndLab a partir de arquivo XLS", codigoLabExterno, Protocolo.INDLab);
        this.getButtonImportar().setText("Importar Exames");
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
    }

    public File lerArquivoExames() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS do Lab. IndLab (*.xls)", "xls"));
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static String lerArquivoXls(InputStream input) {
        StringBuilder buf = new StringBuilder();
        try {
            new WorkbookFactory();
            Workbook workbook = WorkbookFactory.create((InputStream)input);
            Sheet sheet = null;
            sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                Iterator cellIterator = row.cellIterator();
                boolean qt = false;
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    switch (cell.getCellType()) {
                        case 0: {
                            if (cell.getColumnIndex() == 3) {
                                buf.append(NumberToTextConverter.toText((double)cell.getNumericCellValue())).append(";");
                                break;
                            }
                            buf.append(cell.getNumericCellValue()).append(";");
                            break;
                        }
                        case 1: {
                            buf.append(cell.getStringCellValue()).append(";");
                            break;
                        }
                        case 3: {
                            buf.append(cell.getStringCellValue()).append(";");
                            break;
                        }
                        case 2: {
                            buf.append(cell.getStringCellValue()).append(";");
                        }
                    }
                }
                buf.replace(buf.length() - 1, buf.length(), "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS do Lab. ".concat(this.protocolo.name()).concat(" (*.xls, *.xlsx)"), "xls", "xlsx"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = chooser.getSelectedFile();
                String arquivo = ImportacaoIndlab.lerArquivoXls(new FileInputStream(file));
                StringBuilder bui = new StringBuilder();
                this.setTextoInformacoes("");
                this.anexarTextoInformacoes("Importando exames...\n");
                String[] linhas = arquivo.split("\n");
                this.progress.setValue(0);
                this.progress.setMaximum(linhas.length);
                this.progress.setVisible(true);
                Thread.sleep(50L);
                Map<String, ExameIndlab> excluidos = ParserImportacaoIndlab.importarExamesIndLab(arquivo, this.codigoLabExterno, this.progress, this);
                int qtd = 0;
                if (excluidos.size() > 0) {
                    for (String ex : excluidos.keySet()) {
                        int index;
                        String key = ex.substring(0, (index = ex.indexOf("-")) + 1);
                        if (!key.equals("Exame nao adicionado-")) continue;
                        if (Funcoes.textoVazio(excluidos.get(ex).getTuss())) {
                            bui.append(excluidos.get(ex).getCodigoExame() + " n\u00e3o importado por n\u00e3o constar o TUSS do exame.\n");
                        } else {
                            bui.append("TUSS " + excluidos.get(ex).getTuss() + " n\u00e3o importado por n\u00e3o constar o mnem\u00f4nico do exame.\n");
                        }
                        ++qtd;
                    }
                    if (excluidos.size() > 0 && excluidos.size() > qtd) {
                        bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                        bui.append("+--------+-------------------------------------------------------------------------+\n");
                        bui.append("| CODIGO | DESCRI\u00c7\u00c3O EXAME                                                         |\n");
                        bui.append("+--------+-------------------------------------------------------------------------+");
                        for (String ex : excluidos.keySet()) {
                            bui.append("\n| ").append(StringUtil.formatarColuna(Funcoes.preencheZero(excluidos.get(ex).getCodigoExame(), 6), 7, 'e'));
                            bui.append("| ").append(StringUtil.formatarColuna(excluidos.get(ex).getDescricaoExame(), 73, 'e')).append("|");
                        }
                        bui.append("\n+--------+-------------------------------------------------------------------------+");
                    }
                }
                this.anexarTextoInformacoes(bui.append("\nImporta\u00e7\u00e3o conclu\u00edda.\n\n").toString());
                Thread.sleep(50L);
                this.progress.setVisible(false);
                retorno = true;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, String.format("N\u00e3o foi possivel importar arquivo - Lab. %s %s ", this.protocolo.name(), e.getMessage()), e.getStackTrace());
        }
        return retorno;
    }
}

