/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.indlab.CampoIndlab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExameIndlab {
    public static final String TAG_PROTOCOLO = "indLab";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_CODIGO_EXAME = "codigo";
    public static final String TAG_DESCRICAO_EXAME = "descricao";
    public static final String TAG_TUSS = "tuss";
    public static final String TAG_FORMATOS = "Formatos";
    public static final String TAG_FORMATO = "formato";
    public static final String TAG_RESULTADOS = "resultados";
    public static final String TAG_OBSERVACOES_FIXAS = "observacoesFixas";
    public static final String TAG_OBSERVACOES_VARIAVEIS = "observacoesVariaveis";
    public static final String TAG_CAMPOS = "campos";
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_ITEM_NUMERO = "itemNumero";
    public static final String TAG_ITEM_NOME = "itemNome";
    public static final String TAG_UNIDADE_MEDIDA = "unidadeMedida";
    public static final String TAG_VALOR_REFERENCIA = "valorReferencia";
    public static final String TAG_METODOLOGIA = "metodologia";
    public static final String EXAME_NAO_ADICIONADO = "Exame nao adicionado-";
    private Map<String, CampoIndlab> camposRelacionamento = new HashMap<String, CampoIndlab>();
    private String codigoExame;
    private String descricaoExame;
    private String tuss;
    private String observacoesFixas = "";
    private String observacoesVariaveis = "";
    private String exameJalis;
    private String materialJalis;
    private String laboratorioExternoJalis;

    public ExameIndlab() {
    }

    public ExameIndlab(String xml) {
        this.parseXml(xml);
    }

    public ExameIndlab(String codigoExame, String descricaoExame, String tuss) {
        this.codigoExame = codigoExame;
        this.descricaoExame = descricaoExame;
        this.tuss = tuss;
    }

    public ExameIndlab(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.exameJalis = res.getString("exa_codigo");
        this.materialJalis = res.getString("mco_codigo");
        this.laboratorioExternoJalis = res.getString("lae_codigo");
        this.parseXml(res.getString("ele_xmllabexterno"));
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_PROTOCOLO);
            xml.abrir(TAG_EXAME);
            xml.escrever(TAG_CODIGO_EXAME, this.getCodigoExame().toString());
            xml.escrever(TAG_DESCRICAO_EXAME, this.getDescricaoExame());
            xml.escrever(TAG_TUSS, this.getTuss());
            for (Integer codFormato : this.getQtdFormatos()) {
                xml.escrever(TAG_FORMATOS, this.montaTagFormato(codFormato));
            }
            xml.fechar(TAG_EXAME);
            xml.fechar(TAG_PROTOCOLO);
            this.camposRelacionamento.clear();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExamesIndlab - getXML()");
        }
        return xml.getXML();
    }

    public void parseXml(String xml) {
        if (xml != null) {
            this.codigoExame = StringUtil.getValor(xml, TAG_CODIGO_EXAME);
            this.descricaoExame = StringUtil.getValor(xml, TAG_DESCRICAO_EXAME);
            this.tuss = StringUtil.getValor(xml, TAG_TUSS);
            this.camposRelacionamento = new HashMap<String, CampoIndlab>();
            for (String tagFormatos : StringUtil.getValores(xml, TAG_FORMATOS)) {
                String formato = StringUtil.getValor(tagFormatos, TAG_FORMATO);
                this.observacoesFixas = StringUtil.getValor(tagFormatos, TAG_OBSERVACOES_FIXAS);
                this.observacoesVariaveis = StringUtil.getValor(tagFormatos, TAG_OBSERVACOES_VARIAVEIS);
                for (String tagCampos : StringUtil.getValores(tagFormatos, TAG_CAMPOS)) {
                    for (String tag : StringUtil.getValores(tagCampos, TAG_CAMPO)) {
                        CampoIndlab campo = new CampoIndlab();
                        campo.setFormato(Integer.valueOf(formato));
                        campo.setItemNome(StringUtil.getValor(tag, TAG_ITEM_NOME));
                        campo.setItemNumero(Integer.valueOf(StringUtil.getValor(tag, TAG_ITEM_NUMERO)));
                        campo.setUnidadeMedida(StringUtil.getValor(tag, TAG_UNIDADE_MEDIDA));
                        campo.setVlrReferencia(StringUtil.getValor(tag, TAG_VALOR_REFERENCIA));
                        campo.setMetodologia(StringUtil.getValor(tag, TAG_METODOLOGIA));
                        String chaveRegistro = formato + "-" + StringUtil.getValor(tag, TAG_ITEM_NUMERO);
                        this.addCamposRelacionamento(chaveRegistro, campo);
                    }
                }
                this.camposRelacionamento = this.getCamposRelacionamento();
            }
        }
    }

    public static Set<ExameIndlab> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameIndlab> list = new HashSet<ExameIndlab>();
        if (res.first()) {
            do {
                list.add(new ExameIndlab(res));
            } while (res.next());
        }
        return list;
    }

    public static List<ExameIndlab> getExamesImportados(String codigoLabExterno) {
        ArrayList<ExameIndlab> exames = new ArrayList<ExameIndlab>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" SELECT * \n");
                bui.append(" FROM examesindlab \n");
                bui.append(" WHERE fil_codigo = ").append(Variaveis.filialPadrao).append(" AND \n");
                bui.append(" lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append(" ORDER BY inl_codigoexame ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    ExameIndlab exa = new ExameIndlab(res.getString("inl_xml"));
                    exa.setCodigoExame(res.getString("inl_codigoexame"));
                    exames.add(exa);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return exames;
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String vlrIndLab = StringUtil.getValor(xml, TAG_PROTOCOLO);
        return vlrIndLab != null && vlrIndLab.trim().length() > 0 && (valorExame = StringUtil.getValor(vlrIndLab, TAG_CODIGO_EXAME)) != null && valorExame.trim().length() > 0;
    }

    private String montaTagFormato(Integer codFormato) throws XMLStringBuilderException {
        ArrayList<String> formato = this.getChavesFormato(codFormato);
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever(TAG_FORMATO, String.valueOf(codFormato));
        xml.abrir(TAG_RESULTADOS);
        xml.escrever(TAG_OBSERVACOES_FIXAS, this.getObservacoesFixas());
        xml.escrever(TAG_OBSERVACOES_VARIAVEIS, this.getObservacoesVariaveis());
        xml.abrir(TAG_CAMPOS);
        for (String campos : formato) {
            CampoIndlab campo = this.camposRelacionamento.get(campos);
            xml.abrir(TAG_CAMPO);
            xml.escrever(TAG_ITEM_NUMERO, String.valueOf(campo.getItemNumero()));
            xml.escrever(TAG_ITEM_NOME, campo.getItemNome());
            xml.escrever(TAG_UNIDADE_MEDIDA, campo.getUnidadeMedida());
            xml.escrever(TAG_VALOR_REFERENCIA, campo.getVlrReferencia());
            xml.escrever(TAG_METODOLOGIA, campo.getMetodologia());
            xml.fechar(TAG_CAMPO);
        }
        xml.fechar(TAG_CAMPOS);
        xml.fechar(TAG_RESULTADOS);
        return xml.getXML();
    }

    private ArrayList<String> getChavesFormato(Integer codFormato) {
        ArrayList<String> chaves = new ArrayList<String>();
        String numeroFormato = "";
        for (String campos : this.camposRelacionamento.keySet()) {
            int index;
            numeroFormato = campos.substring(0, index = campos.indexOf("-"));
            if (!numeroFormato.equals(String.valueOf(codFormato))) continue;
            if (chaves.isEmpty()) {
                chaves.add(campos);
                continue;
            }
            index = chaves.get(0).indexOf("-");
            String formatoAdicionado = chaves.get(0).substring(0, index);
            if (!numeroFormato.equals(formatoAdicionado)) continue;
            chaves.add(campos);
        }
        return chaves;
    }

    private ArrayList<Integer> getQtdFormatos() {
        ArrayList<Integer> formatos = new ArrayList<Integer>();
        ArrayList retorno = new ArrayList();
        if (this.camposRelacionamento != null) {
            for (String campos : this.camposRelacionamento.keySet()) {
                CampoIndlab campo = this.camposRelacionamento.get(campos);
                formatos.add(campo.getFormato());
            }
            retorno = (ArrayList)formatos.clone();
            int qtd = formatos.size();
            block1: for (int i = 0; i < qtd; ++i) {
                for (int j = i + 1; j < qtd; ++j) {
                    if (formatos.get(i) != formatos.get(j)) continue;
                    retorno.remove(formatos.get(j));
                    continue block1;
                }
            }
        }
        return retorno;
    }

    public static String preencheZero(String texto, int casas) {
        String retorno = new String(texto);
        if (texto.length() > casas) {
            return texto;
        }
        for (int i = 0; i <= casas - texto.length(); ++i) {
            retorno = retorno + "0";
        }
        return retorno;
    }

    public Map<String, CampoIndlab> getCamposRelacionamento() {
        return this.camposRelacionamento;
    }

    public void addCamposRelacionamento(String campo, CampoIndlab valor) {
        this.camposRelacionamento.put(campo, valor);
    }

    public void setCamposRelacionamento(Map<String, CampoIndlab> camposRelacionamento) {
        this.camposRelacionamento = camposRelacionamento;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    public String getDescricaoExame() {
        return this.descricaoExame;
    }

    public void setDescricaoExame(String descricaoExame) {
        this.descricaoExame = descricaoExame;
    }

    public String getTuss() {
        return this.tuss;
    }

    public void setTuss(String tuss) {
        this.tuss = tuss;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public String getLaboratorioExternoJalis() {
        return this.laboratorioExternoJalis;
    }

    public void setLaboratorioExternoJalis(String laboratorioExternoJalis) {
        this.laboratorioExternoJalis = laboratorioExternoJalis;
    }

    public String getObservacoesFixas() {
        return this.observacoesFixas;
    }

    public void setObservacoesFixas(String observacoesFixas) {
        this.observacoesFixas = observacoesFixas;
    }

    public String getObservacoesVariaveis() {
        return this.observacoesVariaveis;
    }

    public void setObservacoesVariaveis(String observacoesVariaveis) {
        this.observacoesVariaveis = observacoesVariaveis;
    }

    public int hashCode() {
        return Objects.hash(this.codigoExame);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExameIndlab other = (ExameIndlab)obj;
        return Objects.equals(this.codigoExame, other.codigoExame);
    }
}

