/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.pardini.ConfiguradorException;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloIndLab
extends AbstractConfiguradorProtocolo {
    public static final String NOMELABORATORIO = "Configurador IndLab";
    public static final String TAG_INDLAB = "indlab";
    public static final String TAG_LOTE = "lote";
    public static final String TAG_LINK_SERVIDOR = "linkServidor";
    public static final String TAG_CAMINHO_ENVIO = "caminhoEnvio";
    public static final String TAG_CAMINHO_RETORNO = "caminhoRetorno";
    public static final String TAG_LOTE_PELA_REQUISICAO = "enviarLotePelaRequisicao";
    protected JTextField textLote = new TTextField(100, 1);
    protected JTextField textLinkServidor = new TTextField(100, 3);
    protected JTextField textCaminhoEnvio = new TTextField(100, 3);
    protected JTextField textCaminhoRetorno = new TTextField(100, 3);
    protected JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");

    public ConfiguradorProtocoloIndLab(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloIndLab(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        ConfiguradorProtocoloIndLab configuradorProtocolo = null;
        if (pai instanceof Frame) {
            configuradorProtocolo = new ConfiguradorProtocoloIndLab((Frame)pai, NOMELABORATORIO, codigoLaboratorio);
        } else if (pai instanceof Dialog) {
            configuradorProtocolo = new ConfiguradorProtocoloIndLab((Dialog)pai, NOMELABORATORIO, codigoLaboratorio);
        }
        return configuradorProtocolo;
    }

    protected void iniciar() {
        this.setPreferredSize(new Dimension(500, 250));
        this.setSize(new Dimension(500, 250));
        this.getPanelCentral().setPreferredSize(new Dimension(300, 200));
        this.getPanelCentral().setSize(new Dimension(300, 300));
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(0, 0, 1, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(110, 20));
        lblLote.setMinimumSize(new Dimension(110, 20));
        this.getPanelCentral().add((Component)lblLote, cons);
        ++cons.gridy;
        JLabel lblLinkServidor = ComponenteFactory.novoJLabel("Link do Servidor:", new Dimension(110, 20));
        lblLinkServidor.setMinimumSize(new Dimension(110, 20));
        this.getPanelCentral().add((Component)lblLinkServidor, cons);
        ++cons.gridy;
        JLabel lblCaminhoEnvio = ComponenteFactory.novoJLabel("Caminho Envio:", new Dimension(110, 20));
        lblCaminhoEnvio.setMinimumSize(new Dimension(110, 20));
        this.getPanelCentral().add((Component)lblCaminhoEnvio, cons);
        ++cons.gridy;
        JLabel lblCaminhoRetorno = ComponenteFactory.novoJLabel("Caminho Retorno:", new Dimension(110, 20));
        lblCaminhoRetorno.setMinimumSize(new Dimension(110, 20));
        this.getPanelCentral().add((Component)lblCaminhoRetorno, cons);
        cons.gridy = 0;
        ++cons.gridx;
        cons.gridwidth = 3;
        cons.fill = 2;
        this.textLote.setPreferredSize(new Dimension(330, 20));
        this.textLote.setMinimumSize(new Dimension(330, 20));
        this.textLote.setEnabled(false);
        this.getPanelCentral().add((Component)this.textLote, cons);
        ++cons.gridy;
        this.textLinkServidor.setPreferredSize(new Dimension(330, 20));
        this.textLinkServidor.setMinimumSize(new Dimension(330, 20));
        this.getPanelCentral().add((Component)this.textLinkServidor, cons);
        ++cons.gridy;
        this.textCaminhoEnvio.setPreferredSize(new Dimension(330, 20));
        this.textCaminhoEnvio.setMinimumSize(new Dimension(330, 20));
        this.getPanelCentral().add((Component)this.textCaminhoEnvio, cons);
        ++cons.gridy;
        this.textCaminhoRetorno.setPreferredSize(new Dimension(330, 20));
        this.textCaminhoRetorno.setMinimumSize(new Dimension(330, 20));
        this.getPanelCentral().add((Component)this.textCaminhoRetorno, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 4;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        this.textLote.setHorizontalAlignment(4);
        this.checkEnvioAutomatico.setSelected(true);
        this.checkEnvioAutomatico.setEnabled(false);
        this.pack();
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textLote);
    }

    @Override
    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever(TAG_LOTE, this.textLote.getText());
        xml.escrever(TAG_LINK_SERVIDOR, this.textLinkServidor.getText());
        xml.escrever(TAG_CAMINHO_ENVIO, this.textCaminhoEnvio.getText());
        xml.escrever(TAG_CAMINHO_RETORNO, this.textCaminhoRetorno.getText());
        xml.escrever(TAG_LOTE_PELA_REQUISICAO, this.enviarAutomaticoRequisicao());
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.getTag(TAG_INDLAB, xml.getXML()));
        return buf.toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (this.existeXml(xml)) {
            xml = StringUtil.getValor(xml, TAG_INDLAB);
            this.textLote.setText(StringUtil.getValor(xml, TAG_LOTE));
            this.textLinkServidor.setText(StringUtil.getValor(xml, TAG_LINK_SERVIDOR));
            this.textCaminhoEnvio.setText(StringUtil.getValor(xml, TAG_CAMINHO_ENVIO));
            this.textCaminhoRetorno.setText(StringUtil.getValor(xml, TAG_CAMINHO_RETORNO));
            this.checkEnvioAutomatico.setSelected(true);
        }
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textLinkServidor.getText())) {
            Funcoes.mensagem(this, "Informe o link do servidor.", 2);
            ScreenUtil.requisitarFoco(this.textLinkServidor);
            return false;
        }
        if (Funcoes.textoVazio(this.textCaminhoEnvio.getText())) {
            Funcoes.mensagem(this, "Informe o caminho de envio.", 2);
            ScreenUtil.requisitarFoco(this.textCaminhoEnvio);
            return false;
        }
        if (Funcoes.textoVazio(this.textCaminhoRetorno.getText())) {
            Funcoes.mensagem(this, "Informe o caminho de retorno.", 2);
            ScreenUtil.requisitarFoco(this.textCaminhoRetorno);
            return false;
        }
        return true;
    }

    private String enviarAutomaticoRequisicao() {
        return this.checkEnvioAutomatico.isSelected() ? "true" : "false";
    }

    private boolean possuiTag(String xml, String tag) {
        return StringUtil.getValor(xml, tag).trim().length() > 0;
    }

    private boolean existeXml(String xml) {
        return xml != null;
    }

    @Override
    public void setNumeroLote(int numeroLote) throws ConfiguradorException {
        this.textLote.setText(String.valueOf(numeroLote));
    }
}

