/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.indlab.ExameIndlab;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorIndlab
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String OBJ_EXAME_INDLAB = "objExameIndlab";
    private ModeloResultSet modExa = new ModeloResultSet("Mnem\u00f4nico", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 80, 0, 80);
    private JTextField textLocalizar = new JTextField();
    private JPanel panelMaterial = new JPanel();
    private String xmlSelecionado = "";

    public ConfiguradorIndlab(Frame pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorIndlab(Dialog pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public static ConfiguradorIndlab novaInstancia(Object pai, String codigoLabExterno, String titulo) {
        if (pai instanceof Frame) {
            return new ConfiguradorIndlab((Frame)pai, codigoLabExterno, titulo);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorIndlab((Dialog)pai, codigoLabExterno, titulo);
        }
        return null;
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameIndlab.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameIndlab exa = new ExameIndlab(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                ExameIndlab exame = new ExameIndlab();
                if (reg != null) {
                    exame = (ExameIndlab)reg.getValor(OBJ_EXAME_INDLAB);
                }
                if (Funcoes.textoVazio(exame.getCodigoExame()) || !exa.getCodigoExame().equals(exame.getCodigoExame())) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.panelMaterial.setPreferredSize(new Dimension(650, 22));
        this.panelMaterial.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorIndlab.this.modExa.filtrar(ConfiguradorIndlab.DESC_EXA, ConfiguradorIndlab.this.textLocalizar.getText());
                if (ConfiguradorIndlab.this.modExa.getRowCount() > 0) {
                    ConfiguradorIndlab.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(80);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorIndlab.this.tableExa.hasFocus() && (row = ConfiguradorIndlab.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorIndlab.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorIndlab.this.tableExa.scrollRectToVisible(ConfiguradorIndlab.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorIndlab.this.tableExa.hasFocus() && (row = ConfiguradorIndlab.this.tableExa.getSelectedRow()) < ConfiguradorIndlab.this.tableExa.getRowCount() - 1) {
                    ConfiguradorIndlab.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorIndlab.this.tableExa.scrollRectToVisible(ConfiguradorIndlab.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        for (ExameIndlab exame : ExameIndlab.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigoExame());
            reg.setValor(DESC_EXA, exame.getDescricaoExame());
            reg.setValor(OBJ_EXAME_INDLAB, exame);
            this.modExa.addRegistro(reg);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameIndlab exa = new ExameIndlab(xml);
            return exa.getCodigoExame() + "|" + exa.getDescricaoExame() + "|";
        }
        return "";
    }

    @Override
    public boolean acaoOk() {
        ExameIndlab exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private boolean atualizarXMLSelecionado() {
        ExameIndlab exa = this.getExameSelecionado();
        if (exa != null) {
            this.xmlSelecionado = exa.getXml();
            return true;
        }
        return false;
    }

    private ExameIndlab getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameIndlab)reg.getValor(OBJ_EXAME_INDLAB);
        }
        return null;
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null && xml.trim().length() > 0) {
            ExameIndlab exa = new ExameIndlab(xml);
            return exa.getDescricaoExame();
        }
        return "";
    }
}

