/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitaPeriodo
extends AbstractDialogoOKCancelar {
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JLabel labelFilial = new JLabel("C\u00f3d. Filial:");
    private JLabel labelRequisicao = new JLabel("C\u00f3d. Requisi\u00e7\u00e3o:");
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textFilial = new TTextField(10, 3);
    private TTextField textRequisicao = new TTextField(10, 3);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JCheckBox checkBoxPeriodo = new JCheckBox("Periodo: ");
    private JCheckBox checkBoxRequisicao = new JCheckBox("Requisi\u00e7\u00e3o: ");
    private JCheckBox checkBoxLote = new JCheckBox("Lote: ");
    private JButton buttonRequisicao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private boolean isOk = false;
    private String dataInicial = null;
    private String dataFinal = null;

    public static SolicitaPeriodo novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new SolicitaPeriodo((Dialog)pai, "Importa\u00e7\u00e3o via Webservice");
        }
        return new SolicitaPeriodo((Frame)pai, "Importa\u00e7\u00e3o via Webservice");
    }

    public SolicitaPeriodo(Dialog pai, String titulo) {
        super(pai, titulo);
        String valor = ParametrosLocais.getParametro("filtroImportacaoDBWS");
        if (!Funcoes.textoVazio(valor)) {
            this.dataInicial = StringUtil.getValor(valor, "dataFinal");
            this.dataFinal = Funcoes.formataData(new Date());
        }
        this.buttonOK.setText("Importar");
        this.montaTela();
    }

    public SolicitaPeriodo(Frame pai, String titulo) {
        super(pai, titulo);
        String valor = ParametrosLocais.getParametro("filtroImportacaoDBWS");
        if (!Funcoes.textoVazio(valor)) {
            this.dataInicial = StringUtil.getValor(valor, "dataFinal");
            this.dataFinal = Funcoes.formataData(new Date());
        }
        this.buttonOK.setText("Importar");
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(250, 290));
        this.setResizable(false);
        this.setModal(true);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        this.textDataInicial.setPreferredSize(new Dimension(100, 20));
        this.textDataInicial.setMinimumSize(new Dimension(100, 20));
        this.textDataFinal.setPreferredSize(new Dimension(100, 20));
        this.textDataFinal.setMinimumSize(new Dimension(100, 20));
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.buttonRequisicao.setPreferredSize(new Dimension(20, 20));
        this.buttonRequisicao.setMinimumSize(new Dimension(20, 20));
        this.buttonFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonFilial.setMinimumSize(new Dimension(20, 20));
        this.checkBoxPeriodo.setSelected(true);
        this.textFilial.setEnabled(false);
        this.textRequisicao.setEnabled(false);
        this.buttonFilial.setEnabled(false);
        this.buttonRequisicao.setEnabled(false);
        JPanel panelInicial = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.insets = new Insets(1, 1, 0, 0);
        c1.fill = 1;
        c1.anchor = 16;
        panelInicial.add((Component)this.checkBoxPeriodo, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.labelDataInicial, c1);
        ++c1.gridy;
        if (!Funcoes.textoVazio(this.dataInicial)) {
            this.textDataInicial.setText(this.dataInicial);
        }
        if (!Funcoes.textoVazio(this.dataFinal)) {
            this.textDataFinal.setText(this.dataFinal);
        }
        panelInicial.add((Component)this.textDataInicial, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonDataInicial, c1);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.labelDataFinal, c1);
        ++c1.gridy;
        panelInicial.add((Component)this.textDataFinal, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonDataFinal, c1);
        ++c1.gridy;
        c1.gridx = 0;
        panelInicial.add((Component)this.checkBoxRequisicao, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.labelFilial, c1);
        ++c1.gridy;
        panelInicial.add((Component)this.textFilial, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonFilial, c1);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.labelRequisicao, c1);
        ++c1.gridy;
        panelInicial.add((Component)this.textRequisicao, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonRequisicao, c1);
        c1.gridx = 0;
        ++c1.gridy;
        panelInicial.add((Component)this.checkBoxLote, c1);
        ++c1.gridy;
        c1.gridx = 0;
        JPanel aux = new JPanel(new BorderLayout());
        aux.add((Component)panelInicial, "North");
        panel.add((Component)aux, "West");
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textDataInicial);
        this.listener();
    }

    private void listener() {
        this.checkBoxPeriodo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (SolicitaPeriodo.this.checkBoxRequisicao.isSelected()) {
                        SolicitaPeriodo.this.checkBoxRequisicao.setSelected(!SolicitaPeriodo.this.checkBoxRequisicao.isSelected());
                    }
                    if (SolicitaPeriodo.this.checkBoxLote.isSelected()) {
                        SolicitaPeriodo.this.checkBoxLote.setSelected(!SolicitaPeriodo.this.checkBoxLote.isSelected());
                    }
                    SolicitaPeriodo.this.textDataInicial.setText(SolicitaPeriodo.this.dataInicial);
                    SolicitaPeriodo.this.textDataFinal.setText(SolicitaPeriodo.this.dataFinal);
                    SolicitaPeriodo.this.textFilial.setText("");
                    SolicitaPeriodo.this.textRequisicao.setText("");
                    SolicitaPeriodo.this.textFilial.setEnabled(false);
                    SolicitaPeriodo.this.textRequisicao.setEnabled(false);
                    SolicitaPeriodo.this.buttonFilial.setEnabled(false);
                    SolicitaPeriodo.this.buttonRequisicao.setEnabled(false);
                    SolicitaPeriodo.this.textDataInicial.setEnabled(true);
                    SolicitaPeriodo.this.textDataFinal.setEnabled(true);
                    SolicitaPeriodo.this.buttonDataFinal.setEnabled(true);
                    SolicitaPeriodo.this.buttonDataInicial.setEnabled(true);
                }
            }
        });
        this.checkBoxRequisicao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (SolicitaPeriodo.this.checkBoxPeriodo.isSelected()) {
                        SolicitaPeriodo.this.checkBoxPeriodo.setSelected(!SolicitaPeriodo.this.checkBoxPeriodo.isSelected());
                    }
                    if (SolicitaPeriodo.this.checkBoxLote.isSelected()) {
                        SolicitaPeriodo.this.checkBoxLote.setSelected(!SolicitaPeriodo.this.checkBoxLote.isSelected());
                    }
                    SolicitaPeriodo.this.textDataInicial.setText("");
                    SolicitaPeriodo.this.textDataFinal.setText("");
                    SolicitaPeriodo.this.textFilial.setEnabled(true);
                    SolicitaPeriodo.this.textRequisicao.setEnabled(true);
                    SolicitaPeriodo.this.buttonFilial.setEnabled(true);
                    SolicitaPeriodo.this.buttonRequisicao.setEnabled(true);
                    SolicitaPeriodo.this.textDataInicial.setEnabled(false);
                    SolicitaPeriodo.this.textDataFinal.setEnabled(false);
                    SolicitaPeriodo.this.buttonDataFinal.setEnabled(false);
                    SolicitaPeriodo.this.buttonDataInicial.setEnabled(false);
                }
            }
        });
        this.checkBoxLote.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (SolicitaPeriodo.this.checkBoxPeriodo.isSelected()) {
                        SolicitaPeriodo.this.checkBoxPeriodo.setSelected(!SolicitaPeriodo.this.checkBoxPeriodo.isSelected());
                    }
                    if (SolicitaPeriodo.this.checkBoxRequisicao.isSelected()) {
                        SolicitaPeriodo.this.checkBoxRequisicao.setSelected(!SolicitaPeriodo.this.checkBoxRequisicao.isSelected());
                    }
                    SolicitaPeriodo.this.textDataInicial.setText("");
                    SolicitaPeriodo.this.textDataFinal.setText("");
                    SolicitaPeriodo.this.textFilial.setText("");
                    SolicitaPeriodo.this.textRequisicao.setText("");
                    SolicitaPeriodo.this.textFilial.setEnabled(false);
                    SolicitaPeriodo.this.textRequisicao.setEnabled(false);
                    SolicitaPeriodo.this.buttonFilial.setEnabled(false);
                    SolicitaPeriodo.this.buttonRequisicao.setEnabled(false);
                    SolicitaPeriodo.this.textDataInicial.setEnabled(false);
                    SolicitaPeriodo.this.textDataFinal.setEnabled(false);
                    SolicitaPeriodo.this.buttonDataFinal.setEnabled(false);
                    SolicitaPeriodo.this.buttonDataInicial.setEnabled(false);
                }
            }
        });
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    SolicitaPeriodo.this.buscaFilial();
                    return;
                }
                super.keyPressed(e);
            }
        });
        this.textRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    SolicitaPeriodo.this.buscaRequisicao();
                    return;
                }
                super.keyPressed(e);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.textDataInicial.getParent(), true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.textDataFinal.getParent(), true);
        } else if (e.getSource() == this.buttonFilial) {
            this.buscaFilial();
        } else if (e.getSource() == this.buttonRequisicao) {
            this.buscaRequisicao();
        } else if (e.getSource() == this.buttonOK) {
            if (this.isPeriodoSelecionado()) {
                if (Funcoes.textoVazio(this.textDataInicial.getText())) {
                    Funcoes.mensagem(this, "Data inicial deve ser informada.", 2);
                    ScreenUtil.requisitarFoco(this.textDataInicial);
                    return;
                }
                if (Funcoes.textoVazio(this.textDataFinal.getText())) {
                    Funcoes.mensagem(this, "Data final deve ser informada.", 2);
                    ScreenUtil.requisitarFoco(this.textDataFinal);
                    return;
                }
                int intervalo = Funcoes.diasPorPeriodo(this.textDataInicial.getText(), this.textDataFinal.getText());
                if (intervalo < 0) {
                    Funcoes.mensagem(this, "A data final n\u00e3o pode ser menor que a data inicial.", 2);
                    ScreenUtil.requisitarFoco(this.textDataFinal);
                    return;
                }
                if (intervalo > 10) {
                    Funcoes.mensagem(this, "A consulta de resultados deve ter um per\u00edodo m\u00e1ximo de 10 dias", 2);
                    ScreenUtil.requisitarFoco(this.textDataInicial);
                    return;
                }
            } else if (this.isRequisicaoSelecionado()) {
                if (Funcoes.textoVazio(this.textFilial.getText())) {
                    Funcoes.mensagem(this, "Filial deve ser informada.", 2);
                    ScreenUtil.requisitarFoco(this.textFilial);
                    return;
                }
                if (Funcoes.textoVazio(this.textRequisicao.getText())) {
                    Funcoes.mensagem(this, "Requisi\u00e7\u00e3o deve ser informada.", 2);
                    ScreenUtil.requisitarFoco(this.textRequisicao);
                    return;
                }
            }
            this.isOk = true;
            this.setVisible(false);
        } else {
            super.actionPerformed(e);
        }
    }

    private void buscaRequisicao() {
        if (!Funcoes.textoVazio(this.textFilial)) {
            Hashtable resultado = Pesquisas.requisicao(Laboratorio.getInstancia(), this.textFilial.getText(), true, false, false);
            if (resultado != null) {
                this.textRequisicao.setText(resultado.get("req_codigo").toString());
            }
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return;
        }
        Funcoes.mensagem(this, "Filial deve ser informada.", 2);
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(Laboratorio.getInstancia(), false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    public boolean isOk() {
        if (this.isOk) {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("filtro");
            if (!Funcoes.textoVazio(this.textDataInicial.getText())) {
                this.dataInicial = this.textDataInicial.getText();
            }
            if (!Funcoes.textoVazio(this.textDataFinal.getText())) {
                this.dataFinal = this.textDataFinal.getText();
            }
            xml.escrever("dataInicial", this.dataInicial);
            xml.escrever("dataFinal", this.dataFinal);
            try {
                xml.fechar("filtro");
            }
            catch (XMLStringBuilderException xMLStringBuilderException) {
                // empty catch block
            }
            ParametrosLocais.setParametro("filtroImportacaoDBWS", xml.toString());
            ParametrosLocais.salvaParametros();
            ParametrosLocais.carregaParametros();
        }
        return this.isOk;
    }

    public String getDataInicial() {
        return this.textDataInicial.getText();
    }

    public String getDataFinal() {
        return this.textDataFinal.getText();
    }

    public boolean isPeriodoSelecionado() {
        return this.checkBoxPeriodo.isSelected();
    }

    public boolean isRequisicaoSelecionado() {
        return this.checkBoxRequisicao.isSelected();
    }

    public boolean isLoteSelecionado() {
        return this.checkBoxLote.isSelected();
    }

    public String getFiltroRequisicao() {
        return this.textRequisicao.getText();
    }

    public String getFiltroFilial() {
        return this.textFilial.getText();
    }
}

