/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParserImportacaoDB {
    public static final String DS_REGIAO_COLETA = "DS_REGIAO_COLETA";
    public static final String CD_REGIAO_COLETA = "CD_REGIAO_COLETA";
    public static final String REGIAO_COLETA = "REGIAO_COLETA";
    public static final String REGIOES_COLETA = "REGIOES_COLETA";
    public static final String TAG_EXAMES = "exames";
    public static final String TAG_DB = "db";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_CD_EXAME = "cd_exame";
    public static final String TAG_CD_DB = "cd_db";
    public static final String TAG_DS_EXAME = "ds_exame";
    public static final String TAG_SINONIMO = "sinonimo";
    public static final String TAG_METODOLOGIA = "metodologia";
    public static final String TAG_MATERIAL = "material";
    public static final String TAG_VOLUME_OBRIGATORIO = "volume_obrigatorio";
    public static final String TAG_IMPORTAR_PDF = "formato_pdf";
    @Deprecated
    public static final String TAG_PESO_E_ALTURA_OBRIGATORIO = "peso_e_altura_obrigatorio";
    public static final String TAG_ALTURA_OBRIGATORIO = "altura_obrigatorio";
    public static final String TAG_PESO_OBRIGATORIO = "peso_obrigatorio";
    public static final String TAG_DATA_ALTERACAO = "data_alteracao";
    public static final String TAG_DATA_ALTERACAO_LAUDO = "data_alteracao_laudo";
    public static final String TAG_ALTERAR_MATERIAL = "alterar_Material";
    @Deprecated
    public static final String TAG_TEXTO_PADRAO = "texto_padrao";
    public static final String TAG_PARAMETROS = "parametros";
    public static final String TAG_PARAMETRO = "parametro";
    public static final String TAG_VALOR_REFERENCIA = "valorReferencia";
    public static final String TAG_VALOR_REF = "valorRef";
    public static final String ATRIBUTO_SEQUENCIA = "sequencia";
    public static final String ATRIBUTO_CD_PARAMETRO = "cd_parametro";
    public static final String ATRIBUTO_DS_PARAMETRO = "ds_parametro";
    public static final String ATRIBUTO_UNIDADE = "unidade";
    public static final String ATRIBUTO_TIPO = "tipo";
    public static final String ATRIBUTO_METODOLOGIA_PARAMETRO = "metodologia_parametro";
    public static final String ATRIBUTO_POSSUI_VR = "possui_vr";
    public static final String ATRIBUTO_CD_EXAME = "cd_exame";
    public static final String ATRIBUTO_CD_DB = "cd_db";
    public static final String ATRIBUTO_DATA = "data";
    public static final String ATRIBUTO_SEXO = "sexo";
    public static final String ATRIBUTO_IDADE = "idade";
    public static final String ATRIBUTO_IDADE_DIAS = "idade_dias";
    public static final String TAG_EXAME_JALIS = "exa_codigo";
    public static final String TAG_MATERIAL_JALIS = "mco_codigo";
    public static final String TAG_DADOS_ADICIONAIS = "dadosAdicionais";
    public static final String TAG_DADO_ADICIONAL = "dadoAdicional";
    public static final String TAG_DADO = "dado";
    public static final String TAG_ALTURA = "Altura";
    public static final String TAG_PESO = "Peso";
    public static final String TAG_VOLUME = "Volume";
    public static final String TAG_SELECIONADO = "selecionado";
    public static final String TAG_CONFIRMAR = "confirmar";
    public static final String REQ_ALTURA = "req_altura";
    public static final String REQ_PESO = "req_peso";
    public static final String TAG_CT_LOTE_RESULTADOS_V1 = "ct_LoteResultados_v1";
    public static final String TAG_NUMERO_LOTE = "NumeroLote";
    public static final String TAG_CODIGO_APOIADO = "CodigoApoiado";
    public static final String TAG_LISTA_RESULTADOS = "ListaResultados";
    public static final String TAG_CT_RESULTADO_V1 = "ct_Resultado_v1";
    public static final String TAG_NUMERO_ATENDIMENTO_APOIADO = "NumeroAtendimentoApoiado";
    public static final String TAG_NUMERO_ATENDIMENTO_DB = "NumeroAtendimentoDB";
    public static final String TAG_RG_PACIENTE_APOIOADO = "RGPacienteApoiado";
    public static final String TAG_RG_PACIENTE_DB = "RGPacienteDB";
    public static final String TAG_LISTA_RESULTADO_PROCEDIMENTOS = "ListaResultadoProcedimentos";
    public static final String TAG_CT_RESULTADO_PROCEDIMENTOS_V1 = "ct_ResultadoProcedimentos_v1";
    public static final String TAG_CODIGO_EXAME_DB = "CodigoExameDB";
    public static final String TAG_VERSAO_LAUDO = "VersaoLaudo";
    public static final String TAG_DESCRICAO_METODOLOGIA = "DescricaoMetodologia";
    public static final String TAG_DESCRICAO_REGIAO_COLETA = "DescricaoRegiaoColeta";
    public static final String TAG_LISTA_RESULTADO_TEXTO = "ListaResultadoTexto";
    public static final String TAG_CT_RESULTADO_TEXTO_V1 = "ct_ResultadoTexto_v1";
    public static final String TAG_CODIGO_PARAMETRO_DB = "CodigoParametroDB";
    public static final String TAG_DESCRICAO_PARAMETRO_DB = "DescricaoParametrosDB";
    public static final String TAG_NOTA_FIXA = "NotaFixa";
    public static final String TAG_VALOR_RESULTADO = "ValorResultado";
    public static final String TAG_UNIDADE_MEDIDA = "UnidadeMedida";
    public static final String TAG_DATA_HORA_LIBERACAO_CLINICA = "DataHoraLiberacaoClinica";
    public static final String TAG_NOME_LIBERADOR_CLINICO = "NomeLiberadorClinico";
    public static final String TAG_OBSERVACAO1 = "Observacao1";
    public static final String TAG_OBSERVACAO2 = "Observacao2";
    public static final String TAG_OBSERVACAO3 = "Observacao3";
    public static final String TAG_OBSERVACAO4 = "Observacao4";
    public static final String TAG_OBSERVACAO5 = "Observacao5";
    public static final String TAG_LISTA_RESULTADO_IMAGEM = "ListaResultadoImagem";
    public static final String TAG_VALOR_RESULTADO_IMAGEM = "ValorResultadoImagem";
    public static final String TAG_CT_RESULTADO_IMAGEM_V1 = "ct_ResultadoImagem_v1";

    public Map<String, Registro> importarExamesDB(JFileChooser chooser, int codigoLabExterno, JProgressBar progress) throws IOException {
        HashMap<String, Registro> examesNovos = new HashMap<String, Registro>();
        HashMap<String, Registro> examesExcluidos = new HashMap<String, Registro>();
        Map<String, Registro> exames = this.parseXml(chooser, codigoLabExterno);
        examesNovos.putAll(exames);
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                Map<String, Registro> examesAntigosRelac = ParserImportacaoDB.getExamesRelacionados(codigoLabExterno);
                Map<String, Registro> examesAntigos = ParserImportacaoDB.loadExamesDB(st, codigoLabExterno);
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 8, new Object[0]);
                if (progress != null) {
                    progress.setMaximum(examesNovos.size());
                    progress.setValue(0);
                }
                ParserImportacaoDB.inserirExamesDB(examesNovos, st, codigoLabExterno, progress);
                HashMap examesNovosRel = new HashMap();
                for (String key : examesAntigosRelac.keySet()) {
                    if (!examesNovos.containsKey(key.substring(0, key.indexOf("-")))) continue;
                    examesNovosRel.put(key, examesNovos.get(key.substring(0, key.indexOf("-"))));
                }
                if (progress != null) {
                    progress.setMaximum(examesNovosRel.size());
                    progress.setValue(0);
                }
                for (String key : examesNovosRel.keySet()) {
                    if (progress != null) {
                        progress.setValue(progress.getValue() + 1);
                    }
                    Registro ex = (Registro)examesNovosRel.get(key);
                    Registro exAntigo = examesAntigosRelac.get(key);
                    ex.setValor(TAG_EXAME_JALIS, exAntigo.getString(TAG_EXAME_JALIS));
                    ex.setValor(TAG_MATERIAL_JALIS, exAntigo.getString(TAG_MATERIAL_JALIS));
                    ex.setValor(TAG_VALOR_REFERENCIA, exAntigo.getString(TAG_VALOR_REFERENCIA));
                    ex.setValor(TAG_IMPORTAR_PDF, exAntigo.getString(TAG_IMPORTAR_PDF));
                    ex.setValor(TAG_DADOS_ADICIONAIS, exAntigo.getValor(TAG_DADOS_ADICIONAIS, List.class));
                    if (!exAntigo.nulo(REGIOES_COLETA)) {
                        List lista = ex.getValor(REGIOES_COLETA, List.class);
                        List listaAntiga = exAntigo.getValor(REGIOES_COLETA, List.class);
                        if (lista != null) {
                            block6: for (Registro reg : lista) {
                                for (Registro regAntigo : listaAntiga) {
                                    if (reg.nulo(CD_REGIAO_COLETA) || regAntigo.nulo(CD_REGIAO_COLETA) || !reg.getString(CD_REGIAO_COLETA).equalsIgnoreCase(regAntigo.getString(CD_REGIAO_COLETA))) continue;
                                    reg.setValor(TAG_SELECIONADO, !regAntigo.nulo(TAG_SELECIONADO) && regAntigo.getBoolean(TAG_SELECIONADO));
                                    continue block6;
                                }
                            }
                        }
                    }
                    if (Funcoes.textoVazio(ex.getString(TAG_MATERIAL_JALIS)) || Funcoes.textoVazio(ex.getString(TAG_EXAME_JALIS))) continue;
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getString(TAG_EXAME_JALIS), Integer.parseInt(ex.getString(TAG_MATERIAL_JALIS)), StringUtil.textoDB(ParserImportacaoDB.getXml(ex)));
                }
                HashSet<Registro> examesExcluidosRel = new HashSet<Registro>();
                for (String key : examesAntigos.keySet()) {
                    if (examesNovos.containsKey(key)) continue;
                    examesExcluidos.put(key, examesAntigos.get(key));
                    if (!examesAntigosRelac.containsKey(key)) continue;
                    examesExcluidosRel.add(examesAntigos.get(key));
                }
                for (Registro ex : examesExcluidosRel) {
                    if (Funcoes.textoVazio(ex.getString(TAG_MATERIAL_JALIS)) || Funcoes.textoVazio(ex.getString(TAG_EXAME_JALIS))) continue;
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getString(TAG_EXAME_JALIS), Integer.parseInt(ex.getString(TAG_MATERIAL_JALIS)), null);
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoDB: 293");
            }
        }
        return examesExcluidos;
    }

    private static String getCodExame(String mnemonicoExame, String codigoMaterial) {
        return String.format("%s|%s", mnemonicoExame, codigoMaterial);
    }

    public static String getXml(Registro exame) {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_DB);
            xml.abrir(TAG_EXAME);
            xml.escrever("cd_exame", exame.getString("cd_exame"));
            xml.escrever("cd_db", exame.getString("cd_exame"));
            xml.escrever(TAG_DS_EXAME, exame.getString(TAG_DS_EXAME));
            xml.escrever(TAG_SINONIMO, exame.getString(TAG_SINONIMO));
            xml.escrever(TAG_METODOLOGIA, exame.getString(TAG_METODOLOGIA));
            xml.escrever(TAG_MATERIAL, exame.getString(TAG_MATERIAL));
            xml.escrever(TAG_VOLUME_OBRIGATORIO, exame.getString(TAG_VOLUME_OBRIGATORIO));
            xml.escrever(TAG_PESO_OBRIGATORIO, exame.getString(TAG_PESO_OBRIGATORIO));
            xml.escrever(TAG_ALTURA_OBRIGATORIO, exame.getString(TAG_ALTURA_OBRIGATORIO));
            xml.escrever(TAG_PESO_E_ALTURA_OBRIGATORIO, exame.getString(TAG_PESO_E_ALTURA_OBRIGATORIO));
            xml.escrever(TAG_ALTERAR_MATERIAL, exame.getString(TAG_ALTERAR_MATERIAL));
            xml.escrever(TAG_DATA_ALTERACAO_LAUDO, exame.getString(TAG_DATA_ALTERACAO_LAUDO));
            xml.escrever(TAG_IMPORTAR_PDF, exame.getString(TAG_IMPORTAR_PDF));
            xml.escrever(TAG_TEXTO_PADRAO, exame.getString(TAG_TEXTO_PADRAO));
            List dadosAd = exame.getValor(TAG_DADOS_ADICIONAIS, List.class);
            if (dadosAd != null && !dadosAd.isEmpty()) {
                xml.abrir(TAG_DADOS_ADICIONAIS);
                for (Object registro : dadosAd) {
                    xml.abrir(TAG_DADO);
                    xml.escrever(TAG_DADO_ADICIONAL, ((Registro)registro).getString(TAG_DADO_ADICIONAL));
                    xml.escrever(TAG_SELECIONADO, ((Registro)registro).getString(TAG_SELECIONADO));
                    xml.fechar(TAG_DADO);
                }
                xml.fechar(TAG_DADOS_ADICIONAIS);
            } else {
                xml.abrir(TAG_DADOS_ADICIONAIS);
                if (StringUtil.getBoolean(exame.getString(TAG_VOLUME_OBRIGATORIO))) {
                    xml.abrir(TAG_DADO);
                    xml.escrever(TAG_DADO_ADICIONAL, TAG_VOLUME);
                    xml.escrever(TAG_SELECIONADO, "true");
                    xml.fechar(TAG_DADO);
                }
                if (StringUtil.getBoolean(exame.getString(TAG_PESO_OBRIGATORIO))) {
                    xml.abrir(TAG_DADO);
                    xml.escrever(TAG_DADO_ADICIONAL, TAG_PESO);
                    xml.escrever(TAG_SELECIONADO, "true");
                    xml.fechar(TAG_DADO);
                }
                if (StringUtil.getBoolean(exame.getString(TAG_ALTURA_OBRIGATORIO))) {
                    xml.abrir(TAG_DADO);
                    xml.escrever(TAG_DADO_ADICIONAL, TAG_ALTURA);
                    xml.escrever(TAG_SELECIONADO, "true");
                    xml.fechar(TAG_DADO);
                }
                xml.fechar(TAG_DADOS_ADICIONAIS);
            }
            Map parametros = exame.getValor(TAG_PARAMETRO, Map.class);
            xml.abrir(TAG_PARAMETROS);
            if (parametros != null && !parametros.isEmpty()) {
                for (String key : parametros.keySet()) {
                    xml.abrir(TAG_PARAMETRO);
                    xml.escrever(ATRIBUTO_SEQUENCIA, ((Registro)parametros.get(key)).getString(ATRIBUTO_SEQUENCIA));
                    xml.escrever(ATRIBUTO_CD_PARAMETRO, ((Registro)parametros.get(key)).getString(ATRIBUTO_CD_PARAMETRO));
                    xml.escrever(ATRIBUTO_DS_PARAMETRO, ((Registro)parametros.get(key)).getString(ATRIBUTO_DS_PARAMETRO));
                    xml.escrever(ATRIBUTO_UNIDADE, ((Registro)parametros.get(key)).getString(ATRIBUTO_UNIDADE));
                    xml.escrever(ATRIBUTO_TIPO, ((Registro)parametros.get(key)).getString(ATRIBUTO_TIPO));
                    xml.escrever(ATRIBUTO_METODOLOGIA_PARAMETRO, ((Registro)parametros.get(key)).getString(ATRIBUTO_METODOLOGIA_PARAMETRO));
                    xml.escrever(ATRIBUTO_POSSUI_VR, ((Registro)parametros.get(key)).getString(ATRIBUTO_POSSUI_VR));
                    xml.escrever(TAG_TEXTO_PADRAO, ((Registro)parametros.get(key)).getString(TAG_TEXTO_PADRAO));
                    if (((Registro)parametros.get(key)).getValor(TAG_VALOR_REFERENCIA) != null) {
                        Registro valorRef = ((Registro)parametros.get(key)).getValor(TAG_VALOR_REFERENCIA, Registro.class);
                        xml.abrir(TAG_VALOR_REFERENCIA);
                        xml.escrever("cd_exame", valorRef.getString("cd_exame"));
                        xml.escrever("cd_db", valorRef.getString("cd_db"));
                        xml.escrever(ATRIBUTO_CD_PARAMETRO, valorRef.getString(ATRIBUTO_CD_PARAMETRO));
                        xml.escrever(ATRIBUTO_DATA, valorRef.getString(ATRIBUTO_DATA));
                        xml.escrever(ATRIBUTO_SEXO, valorRef.getString(ATRIBUTO_SEXO));
                        xml.escrever(ATRIBUTO_IDADE, valorRef.getString(ATRIBUTO_IDADE));
                        xml.escrever(ATRIBUTO_IDADE_DIAS, valorRef.getString(ATRIBUTO_IDADE_DIAS));
                        xml.escrever(TAG_VALOR_REF, valorRef.getString(TAG_VALOR_REF));
                        xml.fechar(TAG_VALOR_REFERENCIA);
                    }
                    xml.fechar(TAG_PARAMETRO);
                }
            }
            xml.fechar(TAG_PARAMETROS);
            if (!exame.nulo(REGIOES_COLETA)) {
                List dadosRegiaoColeta = exame.getValor(REGIOES_COLETA, List.class);
                xml.abrir(REGIOES_COLETA);
                for (Registro regiao : dadosRegiaoColeta) {
                    xml.abrir(REGIAO_COLETA);
                    xml.escrever(CD_REGIAO_COLETA, regiao.getString(CD_REGIAO_COLETA));
                    xml.escrever(DS_REGIAO_COLETA, regiao.getString(DS_REGIAO_COLETA));
                    xml.escrever(TAG_SELECIONADO, regiao.getString(TAG_SELECIONADO));
                    xml.fechar(REGIAO_COLETA);
                }
                xml.fechar(REGIOES_COLETA);
            }
            xml.fechar(TAG_EXAME);
            xml.fechar(TAG_DB);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoDB: 187");
        }
        return xml.getXML();
    }

    protected static void inserirExamesDB(Map<String, Registro> examesNovos, Statement st, int codigoLabExterno, JProgressBar progress) throws SalvaDadosException, SQLException {
        for (Registro ex : examesNovos.values()) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            if (Funcoes.textoVazio(ex.getString("cd_db")) || Funcoes.textoVazio(ex.getString(TAG_MATERIAL))) continue;
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 8, ex.getString("cd_db"), StringUtil.textoDB(ex.getString(TAG_DS_EXAME)), StringUtil.textoDB(ex.getString(TAG_MATERIAL)), StringUtil.textoDB(ParserImportacaoDB.getXml(ex)));
        }
    }

    protected static Map<String, Registro> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno).append(" and \n");
                bui.append("  a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ParserImportacaoDB.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ParserImportacaoDB: 401");
            }
        }
        return new HashMap<String, Registro>();
    }

    private static Registro getExame(int codigoLabExterno, String exame) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append(" fil_codigo, lae_codigo, edb_codexame, edb_descricaoexame, edb_descricaomaterial, edb_xml ");
                bui.append(" from examesdb ");
                bui.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append(" and lae_codigo = ").append(codigoLabExterno);
                bui.append(" and edb_codexame = '").append(exame).append("' ");
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                if (rs.next()) {
                    return ParserImportacaoDB.getExame(rs.getString("edb_xml"), null, null);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoDB: 498");
            }
        }
        return null;
    }

    private static Map<String, Registro> getExames(ResultSet rs) throws SQLException {
        HashMap<String, Registro> list = new HashMap<String, Registro>();
        if (rs.first()) {
            do {
                Registro ex = ParserImportacaoDB.getExame(rs);
                list.put(ex.getString("cd_db") + "-" + ex.getString(TAG_EXAME_JALIS) + "-" + ex.getString(TAG_MATERIAL_JALIS), ex);
            } while (rs.next());
        }
        return list;
    }

    public static Registro getExame(ResultSet rs) throws SQLException {
        return ParserImportacaoDB.getExame(rs.getString("ele_xmllabexterno"), rs.getString(TAG_EXAME_JALIS), rs.getString(TAG_MATERIAL_JALIS));
    }

    public static Registro getExame(String xml, String exameJalis, String materialJalis) {
        String[] regioesColeta;
        Registro exame = new Registro();
        if (!Funcoes.textoVazio(exameJalis) && !Funcoes.textoVazio(materialJalis)) {
            exame.setValor(TAG_EXAME_JALIS, exameJalis);
            exame.setValor(TAG_MATERIAL_JALIS, materialJalis);
        }
        String xmlExame = StringUtil.getValor(xml, TAG_EXAME);
        exame.setValor("cd_exame", StringUtil.getValor(xmlExame, "cd_exame"));
        exame.setValor("cd_db", StringUtil.getValor(xmlExame, "cd_db"));
        exame.setValor(TAG_DS_EXAME, StringUtil.getValor(xmlExame, TAG_DS_EXAME));
        exame.setValor(TAG_SINONIMO, StringUtil.getValor(xmlExame, TAG_SINONIMO));
        exame.setValor(TAG_METODOLOGIA, StringUtil.getValor(xmlExame, TAG_METODOLOGIA));
        exame.setValor(TAG_MATERIAL, StringUtil.getValor(xmlExame, TAG_MATERIAL));
        exame.setValor(TAG_VOLUME_OBRIGATORIO, StringUtil.getValor(xmlExame, TAG_VOLUME_OBRIGATORIO));
        exame.setValor(TAG_PESO_E_ALTURA_OBRIGATORIO, StringUtil.getValor(xmlExame, TAG_PESO_E_ALTURA_OBRIGATORIO));
        exame.setValor(TAG_PESO_OBRIGATORIO, StringUtil.getValor(xmlExame, TAG_PESO_OBRIGATORIO));
        exame.setValor(TAG_ALTURA_OBRIGATORIO, StringUtil.getValor(xmlExame, TAG_ALTURA_OBRIGATORIO));
        exame.setValor(TAG_ALTERAR_MATERIAL, StringUtil.getValor(xmlExame, TAG_ALTERAR_MATERIAL));
        exame.setValor(TAG_IMPORTAR_PDF, StringUtil.getValor(xml, TAG_IMPORTAR_PDF));
        String dataALtercaoLaudo = StringUtil.getValor(xmlExame, TAG_DATA_ALTERACAO);
        if (Funcoes.textoVazio(dataALtercaoLaudo)) {
            dataALtercaoLaudo = StringUtil.getValor(xmlExame, TAG_DATA_ALTERACAO_LAUDO);
        }
        exame.setValor(TAG_DATA_ALTERACAO_LAUDO, dataALtercaoLaudo);
        exame.setValor(TAG_TEXTO_PADRAO, StringUtil.getValor(xmlExame, TAG_TEXTO_PADRAO));
        String[] xmlDadosAd = StringUtil.getValores(xmlExame, TAG_DADO);
        if (xmlDadosAd != null && xmlDadosAd.length > 0) {
            ArrayList<Registro> dadosAd = new ArrayList<Registro>();
            for (String xmlDado : xmlDadosAd) {
                Registro dado = new Registro();
                dado.setValor(TAG_DADO_ADICIONAL, StringUtil.getValor(xmlDado, TAG_DADO_ADICIONAL));
                dado.setValor(TAG_SELECIONADO, StringUtil.getValor(xmlDado, TAG_SELECIONADO).equalsIgnoreCase(Boolean.TRUE.toString()));
                dadosAd.add(dado);
            }
            exame.setValor(TAG_DADOS_ADICIONAIS, dadosAd);
        }
        String[] parametros = StringUtil.getValores(xmlExame, TAG_PARAMETRO);
        HashMap<String, Registro> map = new HashMap<String, Registro>();
        if (parametros != null && parametros.length > 0) {
            for (String param : parametros) {
                Registro reg = new Registro();
                reg.setValor(ATRIBUTO_SEQUENCIA, StringUtil.getValor(param, ATRIBUTO_SEQUENCIA));
                reg.setValor(ATRIBUTO_CD_PARAMETRO, StringUtil.getValor(param, ATRIBUTO_CD_PARAMETRO));
                reg.setValor(ATRIBUTO_DS_PARAMETRO, StringUtil.getValor(param, ATRIBUTO_DS_PARAMETRO));
                reg.setValor(ATRIBUTO_UNIDADE, StringUtil.getValor(param, ATRIBUTO_UNIDADE));
                reg.setValor(ATRIBUTO_TIPO, StringUtil.getValor(param, ATRIBUTO_TIPO));
                reg.setValor(ATRIBUTO_METODOLOGIA_PARAMETRO, StringUtil.getValor(param, ATRIBUTO_METODOLOGIA_PARAMETRO));
                reg.setValor(ATRIBUTO_POSSUI_VR, StringUtil.getValor(param, ATRIBUTO_POSSUI_VR));
                reg.setValor(TAG_TEXTO_PADRAO, StringUtil.getValor(param, TAG_TEXTO_PADRAO));
                String vlrRef = StringUtil.getValor(param, TAG_VALOR_REFERENCIA);
                if (!Funcoes.textoVazio(vlrRef)) {
                    Registro valorRef = new Registro();
                    valorRef.setValor("cd_exame", StringUtil.getValor(vlrRef, "cd_exame"));
                    valorRef.setValor("cd_db", StringUtil.getValor(vlrRef, "cd_db"));
                    valorRef.setValor(ATRIBUTO_CD_PARAMETRO, StringUtil.getValor(vlrRef, ATRIBUTO_CD_PARAMETRO));
                    valorRef.setValor(ATRIBUTO_DATA, StringUtil.getValor(vlrRef, ATRIBUTO_DATA));
                    valorRef.setValor(ATRIBUTO_SEXO, StringUtil.getValor(vlrRef, ATRIBUTO_SEXO));
                    valorRef.setValor(ATRIBUTO_IDADE, StringUtil.getValor(vlrRef, ATRIBUTO_IDADE));
                    valorRef.setValor(ATRIBUTO_IDADE_DIAS, StringUtil.getValor(vlrRef, ATRIBUTO_IDADE_DIAS));
                    valorRef.setValor(TAG_VALOR_REF, StringUtil.getValor(vlrRef, TAG_VALOR_REF));
                    reg.setValor(TAG_VALOR_REFERENCIA, valorRef);
                }
                map.put(StringUtil.getValor(param, ATRIBUTO_CD_PARAMETRO), reg);
            }
        }
        exame.setValor(TAG_PARAMETROS, map);
        ArrayList<Registro> listaRegiao = new ArrayList<Registro>();
        String xmlRegioesColeta = StringUtil.getValor(xmlExame, REGIOES_COLETA);
        for (String regiao : regioesColeta = StringUtil.getValores(xmlRegioesColeta.trim(), REGIAO_COLETA)) {
            Registro reg = new Registro();
            reg.setValor(CD_REGIAO_COLETA, StringUtil.getValor(regiao, CD_REGIAO_COLETA));
            reg.setValor(DS_REGIAO_COLETA, StringUtil.getValor(regiao, DS_REGIAO_COLETA));
            reg.setValor(TAG_SELECIONADO, StringUtil.getBoolean(regiao, TAG_SELECIONADO) ? Boolean.TRUE : Boolean.FALSE);
            listaRegiao.add(reg);
        }
        exame.setValor(REGIOES_COLETA, listaRegiao);
        return exame;
    }

    protected static Map<String, Registro> loadExamesDB(Statement st, int codigoLabExterno) throws SQLException {
        HashMap<String, Registro> exames = new HashMap<String, Registro>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, lae_codigo, edb_codexame, edb_descricaoexame, edb_descricaomaterial, edb_xml ");
        sql.append(" from examesdb ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            Registro e = ParserImportacaoDB.getExame(rs.getString("edb_xml"), null, null);
            exames.put(rs.getString("edb_codexame"), e);
        }
        return exames;
    }

    public static boolean isXmlValido(String xml) {
        String xmlExame;
        String xmlDB = StringUtil.getValor(xml, TAG_DB);
        return xmlDB != null && xmlDB.trim().length() > 0 && (xmlExame = StringUtil.getValor(xmlDB, TAG_EXAME)) != null && xmlExame.trim().length() > 0;
    }

    public static List<Registro> getExamesImportados(String codigoLabExterno) {
        ArrayList<Registro> exames = new ArrayList<Registro>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select * \n");
                bui.append("from examesdb \n");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("      lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("order by edb_descricaoexame");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    exames.add(ParserImportacaoDB.getExame(res.getString("edb_xml"), null, null));
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ParserImportacaoDB: 527");
            }
        }
        return exames;
    }

    public Map<String, Registro> parseXml(JFileChooser chooser, int codigoLabExterno) {
        Document doc = this.analisarXML(chooser.getSelectedFile());
        if (doc == null) {
            return null;
        }
        Element raiz = doc.getDocumentElement();
        return ParserImportacaoDB.parse(XMLUtil.getElementosFilhos(raiz), codigoLabExterno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    public static Map<String, Registro> parse(List<Element> elements, int codigoLabExterno) {
        HashMap<String, Registro> examesCadastro = new HashMap<String, Registro>();
        for (Element exame : elements) {
            if (!exame.getNodeName().equalsIgnoreCase(TAG_EXAME)) continue;
            HashMap<String, Registro> parametrosCadastro = new HashMap<String, Registro>();
            List<Element> fields = XMLUtil.getElementosFilhos(exame);
            Registro reg = new Registro();
            for (Element field : fields) {
                if (field.getNodeName().equalsIgnoreCase("cd_exame")) {
                    reg.setValor("cd_exame", field.getTextContent());
                    reg.setValor("cd_db", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase("cd_db")) {
                    reg.setValor("cd_db", field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_DS_EXAME)) {
                    reg.setValor(TAG_DS_EXAME, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_SINONIMO)) {
                    reg.setValor(TAG_SINONIMO, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_METODOLOGIA)) {
                    reg.setValor(TAG_METODOLOGIA, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_MATERIAL)) {
                    reg.setValor(TAG_MATERIAL, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_VOLUME_OBRIGATORIO)) {
                    reg.setValor(TAG_VOLUME_OBRIGATORIO, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_PESO_E_ALTURA_OBRIGATORIO)) {
                    reg.setValor(TAG_PESO_E_ALTURA_OBRIGATORIO, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_PESO_OBRIGATORIO)) {
                    reg.setValor(TAG_PESO_OBRIGATORIO, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_ALTURA_OBRIGATORIO)) {
                    reg.setValor(TAG_ALTURA_OBRIGATORIO, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_DATA_ALTERACAO_LAUDO)) {
                    reg.setValor(TAG_DATA_ALTERACAO_LAUDO, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_ALTERAR_MATERIAL)) {
                    reg.setValor(TAG_ALTERAR_MATERIAL, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_IMPORTAR_PDF)) {
                    reg.setValor(TAG_IMPORTAR_PDF, field.getTextContent());
                    continue;
                }
                if (field.getNodeName().equalsIgnoreCase(TAG_TEXTO_PADRAO)) {
                    reg.setValor(TAG_TEXTO_PADRAO, field.getTextContent());
                    continue;
                }
                if (!field.getNodeName().equalsIgnoreCase(TAG_PARAMETRO)) continue;
                Registro parametro = new Registro();
                ParserImportacaoDB.getAtributo(field, parametro, ATRIBUTO_SEQUENCIA);
                ParserImportacaoDB.getAtributo(field, parametro, ATRIBUTO_CD_PARAMETRO);
                ParserImportacaoDB.getAtributo(field, parametro, ATRIBUTO_DS_PARAMETRO);
                ParserImportacaoDB.getAtributo(field, parametro, ATRIBUTO_UNIDADE);
                ParserImportacaoDB.getAtributo(field, parametro, ATRIBUTO_TIPO);
                ParserImportacaoDB.getAtributo(field, parametro, ATRIBUTO_METODOLOGIA_PARAMETRO);
                ParserImportacaoDB.getAtributo(field, parametro, ATRIBUTO_POSSUI_VR);
                if (field.hasChildNodes()) {
                    List<Element> parametrosFilho = XMLUtil.getElementosFilhos(field);
                    for (Element param : parametrosFilho) {
                        if (param.getNodeName().equalsIgnoreCase(TAG_TEXTO_PADRAO)) {
                            parametro.setValor(TAG_TEXTO_PADRAO, param.getTextContent());
                            continue;
                        }
                        if (!param.getNodeName().equalsIgnoreCase(TAG_VALOR_REFERENCIA)) continue;
                        Registro valorReferencia = new Registro();
                        ParserImportacaoDB.getAtributo(param, valorReferencia, "cd_exame");
                        ParserImportacaoDB.getAtributo(param, valorReferencia, "cd_db");
                        ParserImportacaoDB.getAtributo(param, valorReferencia, ATRIBUTO_CD_PARAMETRO);
                        ParserImportacaoDB.getAtributo(param, valorReferencia, ATRIBUTO_DATA);
                        ParserImportacaoDB.getAtributo(param, valorReferencia, ATRIBUTO_SEXO);
                        ParserImportacaoDB.getAtributo(param, valorReferencia, ATRIBUTO_IDADE);
                        ParserImportacaoDB.getAtributo(param, valorReferencia, ATRIBUTO_IDADE_DIAS);
                        if (param.hasChildNodes()) {
                            List<Element> valoresReferencia = XMLUtil.getElementosFilhos(param);
                            StringBuilder valoresRef = new StringBuilder();
                            for (Element vlrRef : valoresReferencia) {
                                if (!vlrRef.getNodeName().equalsIgnoreCase(TAG_VALOR_REFERENCIA) || Funcoes.textoVazio(vlrRef.getTextContent())) continue;
                                valoresRef.append(vlrRef.getTextContent()).append("\n");
                            }
                            valorReferencia.setValor(TAG_VALOR_REF, valoresRef.toString());
                        }
                        parametro.setValor(TAG_VALOR_REFERENCIA, valorReferencia);
                    }
                }
                parametrosCadastro.put(parametro.getString(ATRIBUTO_SEQUENCIA), parametro);
            }
            reg.setValor(TAG_PARAMETRO, parametrosCadastro);
            examesCadastro.put(reg.getString("cd_db"), reg);
        }
        return examesCadastro;
    }

    protected static void getAtributo(Element field, Registro parametro, String atributo) throws DOMException {
        for (int i = 0; i < field.getAttributes().getLength(); ++i) {
            if (!field.getAttributes().item(i).getNodeName().equalsIgnoreCase(atributo)) continue;
            parametro.setValor(atributo, field.getAttributes().item(i).getNodeValue());
        }
    }
}

