/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.db2.DBComunicacao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.db2.ConsultarPendenciasDB;
import jalis.laboratorio.util.parsers.db2.DBCamposRetornoLaudoAtendimento;
import jalis.laboratorio.util.parsers.db2.GeradorXmlImportacaoDB;
import jalis.laboratorio.util.parsers.db2.ImportacaoResultadoDB;
import jalis.laboratorio.util.parsers.db2.ParserImportacaoDB;
import jalis.laboratorio.util.parsers.db2.SolicitaPeriodo;
import jalis.model.bean.cadastro.exame.MotivoRecoletaBean;
import jalis.model.bean.loteexterno.LoteExternoRequisicaoRastreioBean;
import jalis.service.integracaolaboratorioexterno.LoteExternoRequisicaoRastreioService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JPanel;

public class ImportacaoResultadoDBWS
extends ImportacaoResultadoDB {
    private static final String MET_CODIGO = "met_codigo";
    private static final String MCO_CODIGO = "mco_codigo";
    private static final String REQ_CODIGO = "req_codigo";
    private static final String MCO_KODIGO = "mco_kodigo";
    private static final String EXA_CODIGO = "exa_codigo";
    private static final String FIL_CODIGO = "fil_codigo";
    private static final String FORMATO_DATA = "yyyy-MM-dd";
    private static final String ELE_XMLLABEXTERNO = "ele_xmllabexterno";
    private static final String UNKNOWN_HOST_EXCEPTION = "java.net.UnknownHostException";
    private static final String MENSAGEM_ERRO_CONEXAO = "N\u00e3o foi poss\u00edvel obter a comunica\u00e7\u00e3o com Webservice do Diagn\u00f3stico Brasil. (Verifique sua conex\u00e3o com a internet)";
    private static final String RECEBENDO_DADOS_DO_SERVIDOR = "\nRecebendo dados do servidor";
    private int labExternoCodigo = 0;
    private String xmlConsultarPendencias = "";
    private String configuracaoLab = null;
    private HashMap<String, String> requisicoesNotificar = new HashMap();

    public ImportacaoResultadoDBWS(int codigoLabExterno, LaboratorioExterno lab) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio DB a partir do Web Service", codigoLabExterno, Protocolo.DB, new JPanel(new FlowLayout(2)));
        this.buttonImportarWS.setEnabled(true);
        this.buttonImportarWS.setVisible(true);
        this.buttonConsultarPendencias.setEnabled(true);
        this.buttonConsultarPendencias.setVisible(true);
        this.buttonImportar.setText("Importar Arquivo");
        this.getPanelAdicional().add(this.buttonImportarWS);
        this.getPanelAdicional().add(this.buttonConsultarPendencias);
        this.pegaDadosConferencia(codigoLabExterno);
        this.labExternoCodigo = codigoLabExterno;
        this.configuracaoLab = lab.configuracao;
    }

    private void solicitarWebService(String dataInicial, String dataFinal) {
        String[] retornoResultados;
        this.setTextoInformacoes("Iniciando comunica\u00e7\u00e3o com o Webservice");
        try {
            String xml = GeradorXmlImportacaoDB.gerarXmlEnviaLaudoAtendimentoPorPeriodo(this.configuracaoLab, Funcoes.formataData(FORMATO_DATA, dataInicial), Funcoes.formataData(FORMATO_DATA, dataFinal));
            DBComunicacao comunicacao = new DBComunicacao(this.configuracaoLab);
            String retornodb = comunicacao.enviaLaudoAtendimentoPorPeriodo(xml);
            retornoResultados = StringUtil.getValores(retornodb, DBCamposRetornoLaudoAtendimento.TAG_RESULTADO_V2.getTag());
        }
        catch (Exception e) {
            if (e.getMessage().contains(UNKNOWN_HOST_EXCEPTION)) {
                this.setTextoInformacoes(MENSAGEM_ERRO_CONEXAO);
            }
            return;
        }
        if (retornoResultados == null || retornoResultados.length <= 0) {
            this.setTextoInformacoes("N\u00e3o h\u00e1 resultados para serem importados no per\u00edodo");
            return;
        }
        this.setTextoInformacoes(RECEBENDO_DADOS_DO_SERVIDOR, false);
        this.requisicoes = this.parseResultadoWS(retornoResultados);
        if (this.requisicoes.isEmpty()) {
            this.setTextoInformacoes("N\u00e3o h\u00e1 resultados para serem importados no per\u00edodo");
        } else {
            this.processaResultados(this.requisicoes);
        }
    }

    private void solicitarWebServiceRequisicao(String codigoFilial, String codigoRequisicao) {
        block4: {
            String filialRequisicao = Funcoes.preencheZero(codigoFilial, ParametrosGerais.getDigitosTuboFilial());
            filialRequisicao = filialRequisicao + Funcoes.preencheZero(codigoRequisicao, ParametrosGerais.getDigitosTuboRequisicao());
            try {
                String xml = GeradorXmlImportacaoDB.gerarXmlEnviarLaudo(this.configuracaoLab, filialRequisicao);
                DBComunicacao comunicacao = new DBComunicacao(this.configuracaoLab);
                String retornoDB = comunicacao.enviaLaudoAtendimento(xml);
                String[] valores = StringUtil.getValores(retornoDB, DBCamposRetornoLaudoAtendimento.TAG_RESULTADO_V2.getTag());
                this.setTextoInformacoes(RECEBENDO_DADOS_DO_SERVIDOR, false);
                this.requisicoes = this.parseResultadoWS(valores);
                if (this.requisicoes.isEmpty()) {
                    this.setTextoInformacoes("N\u00e3o h\u00e1 resultados para serem importados para a requisi\u00e7\u00e3o " + filialRequisicao);
                } else {
                    this.processaResultados(this.requisicoes);
                }
            }
            catch (Exception e) {
                if (!e.getMessage().contains(UNKNOWN_HOST_EXCEPTION)) break block4;
                this.setTextoInformacoes(MENSAGEM_ERRO_CONEXAO);
            }
        }
    }

    private void solicitarWebServiceLote() {
        block5: {
            try {
                String xml = GeradorXmlImportacaoDB.gerarXmlEnviaLoteResultados(this.configuracaoLab);
                DBComunicacao comunicacao = new DBComunicacao(this.configuracaoLab);
                String retornoDB = comunicacao.enviaLoteResultados(xml);
                this.setTextoInformacoes(RECEBENDO_DADOS_DO_SERVIDOR, false);
                if (retornoDB == null) {
                    this.setTextoInformacoes("N\u00e3o h\u00e1 resultados para serem importados");
                    return;
                }
                String[] listaResultados = StringUtil.getValores(retornoDB, DBCamposRetornoLaudoAtendimento.TAG_RESULTADO_V2.getTag());
                this.requisicoes = this.parseResultadoWS(listaResultados);
                if (this.requisicoes.isEmpty()) {
                    this.setTextoInformacoes("N\u00e3o h\u00e1 resultados para serem importados");
                } else {
                    this.processaResultados(this.requisicoes);
                }
            }
            catch (Exception e) {
                if (!e.getMessage().contains(UNKNOWN_HOST_EXCEPTION)) break block5;
                this.setTextoInformacoes(MENSAGEM_ERRO_CONEXAO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processaResultados(List<Registro> requisicoes) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st == null) {
            return;
        }
        try {
            this.progress.setValue(0);
            this.progress.setMaximum(requisicoes.size());
            this.progress.setVisible(true);
            this.processarResultados(requisicoes, st, st2);
            Conexao.arquivaSQL();
            this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDB: 286");
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
        this.progress.setVisible(false);
        requisicoes = null;
    }

    @Override
    protected void processarResultados(List<Registro> requisicoes, Statement st, Statement st2) throws Exception {
        int qtdeDigitos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        for (Registro requisicao : requisicoes) {
            this.progress.setValue(this.progress.getValue() + 1);
            List exames = requisicao.getValor("ListaResultadoProcedimentos", List.class);
            String tubo = requisicao.getValor("NumeroAtendimentoApoiado").toString();
            if (Funcoes.textoVazio(tubo) || tubo.length() != qtdeDigitos) {
                this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o localizada: " + tubo + " - Validar se foi inserida manualmente no site do DB.", false);
                continue;
            }
            this.processarExames(st, st2, requisicao, exames, tubo);
        }
        ResultadosUtil.enviarNotificacoes(this.requisicoesNotificar, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
    }

    private List<ExameDesmembrado> processarExames(Statement st, Statement st2, Registro requisicao, List<Registro> exames, String tubo) throws Exception {
        String filCodigo = tubo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String reqCodigo = tubo.substring(ParametrosGerais.getDigitosTuboFilial());
        Integer[] multiguias = this.verificarRequisicaoMultiguia(filCodigo, reqCodigo);
        List<ExameDesmembrado> desmembradosRetornoDB = this.getExamesDesmembradosRetornoDB(st, filCodigo, reqCodigo, exames);
        for (Registro exResultado : exames) {
            String exameMaterial = this.service.buscaCodigoExameAssociadoComDesm(filCodigo, multiguias, exResultado);
            if (Funcoes.textoVazio(exameMaterial)) {
                this.setTextoInformacoes("\nDados de exame para a requisi\u00e7\u00e3o: " + tubo + " n\u00e3o localizado.", false);
                continue;
            }
            String exaCodigo = exameMaterial.split("-")[0];
            String mcoCodigo = exameMaterial.split("-")[1];
            String situacaoExame = this.service.pesquisarSituacaoExame(filCodigo, this.labExterno.codigoLab, multiguias, exaCodigo, mcoCodigo);
            if (!Funcoes.textoVazio(situacaoExame) && !situacaoExame.equals("P")) {
                String descricaoSituacao = Tipos.tipoSituacaoExame(situacaoExame);
                this.setTextoInformacoes("\nExame " + exaCodigo + " " + descricaoSituacao, false);
                continue;
            }
            LinkedList<Registro> listaRegistros = this.processarPaiFilhos(st, requisicao, exResultado, filCodigo, reqCodigo);
            for (Registro registroExame : listaRegistros) {
                Date horaColeta;
                Registro formatacao;
                if (this.validarExameRegistro(requisicao, exResultado, registroExame)) continue;
                if (registroExame.getValor("examePai") != null) {
                    registroExame.setValor(EXA_CODIGO, registroExame.getString("examePai"));
                }
                boolean salvaParcial = registroExame.getBoolean("exa_salvaparcial");
                Registro exameSalvo = ParserImportacaoDB.getExame(registroExame.getString(ELE_XMLLABEXTERNO), registroExame.getString(EXA_CODIGO), registroExame.getString(MCO_CODIGO));
                LaboratorioExterno lab = LaboratorioExterno.getLabExterno(String.valueOf(this.codigoLabExterno));
                boolean isImportarResultadoPdfExame = exameSalvo.getString("formato_pdf").equalsIgnoreCase("SIM");
                boolean isImportarResultadoPdfLabExterno = StringUtil.getBoolean(lab.configuracao, "importarResultadoPdf");
                if (this.isWebService && (isImportarResultadoPdfLabExterno || isImportarResultadoPdfExame)) {
                    this.processaResultadoPdf(st, requisicao, exResultado, registroExame, exameSalvo, lab);
                    continue;
                }
                boolean salvoParcial = registroExame.getString("exr_situacao").equals("P");
                Registro registro = formatacao = salvoParcial ? (Registro)registroExame.getValor("formatacao") : this.localizarFormatacao(registroExame);
                if (formatacao == null || Funcoes.textoVazio(formatacao.getString("formato"))) {
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + registroExame.getString(REQ_CODIGO) + "|" + registroExame.getString(EXA_CODIGO) + " - Modelo de laudo do exame n\u00e3o configurado", false);
                    continue;
                }
                Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(registroExame.getString(REQ_CODIGO), registroExame.getString(EXA_CODIGO), registroExame.getString(MCO_CODIGO), registroExame.getString(FIL_CODIGO), false, false);
                this.complementandoDados(requisicao, exResultado, exameSalvo, dados);
                Map resultados = exResultado.getValor("ListaResultadoTexto", Map.class);
                Map resultadosImagem = exResultado.getValor("ListaResultadoImagem", Map.class);
                Map parametros = exameSalvo.getValor("parametros", Map.class);
                if (resultados == null || resultados != null && resultados.isEmpty()) {
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + registroExame.getString(REQ_CODIGO) + "|" + registroExame.getString(EXA_CODIGO) + " - arquivo de xml n\u00e3o possui resultado verifique com o laborat\u00f3rio de apoio (n\u00famero do atendimento DB = " + requisicao.getString("NumeroAtendimentoDB") + ") ", false);
                    continue;
                }
                String resultadoAtual = this.processaResultado(requisicao, exResultado, registroExame, dados, resultados, parametros);
                this.processaResultadoImagem(registroExame, dados, resultadosImagem);
                Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(registroExame.getString(FIL_CODIGO), registroExame.getString(REQ_CODIGO), registroExame.getString("pac_codigo"), registroExame.getString(EXA_CODIGO), registroExame.getString(MCO_CODIGO), registroExame.getString(MET_CODIGO));
                dados.putAll(RecepcaoUtil.preencheHashDados(registroExame.getString(FIL_CODIGO), registroExame.getString(REQ_CODIGO), registroExame.getString(EXA_CODIGO), registroExame.getString(MCO_CODIGO)));
                Map<String, Map<String, String>> historicos = this.getHistoricosPorExame(registroExame.getString(EXA_CODIGO), registroExame.getString(FIL_CODIGO));
                if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                    historicos = this.getHistoricosPorFilial(registroExame.getString(FIL_CODIGO));
                }
                Map<String, Object> resposta = Resultado.getCamposResultado(registroExame.getString("exr_resposta"));
                Resultado res = new Resultado(null, formatacao.getString("formato"), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, resultadoAtual);
                res.atualizarComponentes();
                if (!res.verificarCondicao()) {
                    this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, ImportacaoResultadoDB.Situacao.CONDICAO_INSATISFEITA);
                    this.setTextoInformacoesPadrao("Resultado recebido para", registroExame, ImportacaoResultadoDB.Situacao.CONDICAO_INSATISFEITA);
                    continue;
                }
                boolean completo = true;
                boolean processouTodosResultadosDesmembradosDB = false;
                if ((processouTodosResultadosDesmembradosDB = this.processandoDesmembrados(desmembradosRetornoDB, registroExame, processouTodosResultadosDesmembradosDB)) && !salvaParcial) {
                    boolean resultadoCompleto = res.resultadoCompleto(salvaParcial);
                    ExameDesmembrado examePai = new ExameDesmembrado(registroExame.getString("examePai"), registroExame.getInt("materialPai"));
                    if (!resultadoCompleto && desmembradosRetornoDB.contains(examePai)) {
                        this.service.removerResultadoParcial(registroExame, st);
                        this.setTextoInformacoesPadrao("N\u00e3o foi poss\u00edvel importar", registroExame, ImportacaoResultadoDB.Situacao.RESULTADO_INCOMPELTO);
                        continue;
                    }
                }
                boolean importacaoUltimo = true;
                if (registroExame.getValor("examePai") != null && !processouTodosResultadosDesmembradosDB) {
                    completo = false;
                    importacaoUltimo = false;
                } else if (registroExame.getValor("examePai") != null && processouTodosResultadosDesmembradosDB) {
                    completo = res.resultadoCompleto(salvaParcial);
                } else if (salvaParcial) {
                    completo = res.resultadoCompleto(true);
                    importacaoUltimo = res.resultadoCompleto(true);
                }
                res.setImportacaoUltimo(importacaoUltimo);
                String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                Util.gravaAlteracaoExameRequisicao(st, registroExame.getString(REQ_CODIGO), registroExame.getString(EXA_CODIGO), registroExame.getString(MCO_CODIGO));
                boolean marcarConferido = false;
                if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                    marcarConferido = this.conferenciaAutomatica(requisicao, exResultado, registroExame, res);
                }
                if (!this.existeRequisicaoLabExterno(registroExame.getInt(FIL_CODIGO), this.codigoLabExterno, registroExame.getInt(REQ_CODIGO), requisicao.getString("cd_db"))) {
                    this.inserirDadosRequisicao(st, this.codigoLabExterno, requisicao.getString("NumeroAtendimentoDB"), registroExame.getString(FIL_CODIGO), registroExame.getInt(REQ_CODIGO));
                }
                String novaSituacao = completo ? "L" : "P";
                boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString(MET_CODIGO), registroExame, registroExame, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                this.exportacaoWeb(st, st2, registroExame, formatacao, resultado, novaSituacao);
                ImportacaoResultadoDB.Situacao isExameConferido = marcarConferido ? ImportacaoResultadoDB.Situacao.CONFERIDO : ImportacaoResultadoDB.Situacao.LANCADO;
                this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, completo ? isExameConferido : ImportacaoResultadoDB.Situacao.LANCADO_PARCIALMENTE);
                Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registroExame.getDate("exr_datamaterial") : new Date();
                Date date = horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registroExame.getDate("exr_datamaterial") : new Date();
                if (completo) {
                    this.atualizarTabelaExamesControle(st, registroExame, res.getResultadoAnterior(dataColeta, horaColeta));
                }
                ExportaWeb.atualizaPaginaOrdemExameWeb(st, registroExame.getString(FIL_CODIGO), registroExame.getString(REQ_CODIGO), Variaveis.codigoBaseWeb);
                this.editarRequisicaoExportaFiliais(registroExame);
                DBUtil.setExameSituacaoInterfaceamento(st, registroExame.getString(FIL_CODIGO), registroExame.getString(REQ_CODIGO), registroExame.getString(EXA_CODIGO), registroExame.getString(MCO_CODIGO), 8);
                String exameImportado = registroExame.getString(EXA_CODIGO);
                if (!Funcoes.textoVazio(registroExame.getString("exameFilho"))) {
                    String codExame = StringUtil.getValor(registroExame.getString(ELE_XMLLABEXTERNO), "cd_db");
                    exameImportado = exameImportado + "(" + codExame + ")";
                }
                String situacaoExameConferidoDescricao = marcarConferido ? ImportacaoResultadoDB.Situacao.CONFERIDO.descricao : ImportacaoResultadoDB.Situacao.LANCADO.descricao;
                Conexao.arquivaSQL();
                this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(registroExame.getString(FIL_CODIGO), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(registroExame.getString(REQ_CODIGO), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + exameImportado + " - " + (completo ? situacaoExameConferidoDescricao : ImportacaoResultadoDB.Situacao.LANCADO_PARCIALMENTE.descricao), false);
                this.requisicoesNotificar.put(this.getChaveFilReq(registroExame.getString(FIL_CODIGO), registroExame.getString(REQ_CODIGO)), registroExame.getString(REQ_CODIGO));
            }
        }
        return desmembradosRetornoDB;
    }

    private boolean processandoDesmembrados(List<ExameDesmembrado> desmembradosRetornoDB, Registro registroExame, boolean processouTodosResultadosDesmembradosDB) {
        if (registroExame.getValor("examePai") != null) {
            for (ExameDesmembrado desmReq : desmembradosRetornoDB) {
                if (!desmReq.getCodigoExame().equals(registroExame.getString("examePai")) || desmReq.getCodigomaterial() != registroExame.getInt("materialPai")) continue;
                desmReq.getFilhos().removeIf(filho -> filho.getCodigoExame().equals(registroExame.getString("exameFilho")) && filho.getCodigomaterial() == registroExame.getInt(MCO_KODIGO));
                if (!desmReq.getFilhos().isEmpty()) continue;
                processouTodosResultadosDesmembradosDB = true;
            }
        }
        return processouTodosResultadosDesmembradosDB;
    }

    private String complementandoDados(Registro requisicao, Registro exResultado, Registro exameSalvo, Map<String, Object> dados) {
        dados.put("NumeroAtendimentoDB", requisicao.getString("NumeroAtendimentoDB"));
        dados.put("ds_exame", exameSalvo.getString("ds_exame"));
        dados.put("CodigoExameDB", exameSalvo.getString("cd_db"));
        String metodologia = Funcoes.textoVazio(exResultado.getString("DescricaoMetodologia")) ? exameSalvo.getString("metodologia") : exResultado.getString("DescricaoMetodologia");
        dados.put("metodologia", metodologia);
        dados.put("material", exResultado.getString("material"));
        dados.put("Observacao1", exResultado.getString("Observacao1"));
        dados.put("Observacao2", exResultado.getString("Observacao2"));
        dados.put("Observacao3", exResultado.getString("Observacao3"));
        dados.put("Observacao4", exResultado.getString("Observacao4"));
        dados.put("Observacao5", exResultado.getString("Observacao5"));
        dados.put("NomeLiberadorClinico", exResultado.getString("NomeLiberadorClinico"));
        dados.put("DataHoraLiberacaoClinica", exResultado.getString("DataHoraLiberacaoClinica"));
        return metodologia;
    }

    private void processaResultadoPdf(Statement st, Registro requisicao, Registro exResultado, Registro registroExame, Registro exameSalvo, LaboratorioExterno lab) throws SQLException {
        boolean conferido;
        String[] codigoExameDB = new String[]{exameSalvo.getString("cd_db")};
        String codigoApoiado = StringUtil.getValor(lab.configuracao, "codigo");
        String enderecoWS = StringUtil.getValor(lab.configuracao, "enderecoWebService");
        String numeroAtendimentoApoiado = requisicao.getString("NumeroAtendimentoApoiado");
        boolean resultadoImportado = this.importarResultadoPdfDb(codigoExameDB, registroExame.getString(EXA_CODIGO), registroExame.getString(MCO_CODIGO), codigoApoiado, numeroAtendimentoApoiado, enderecoWS, lab.configuracao);
        boolean bl = conferido = this.conferirAutomatico && !StringUtil.isEmpty(this.codigoUsuarioConferenciaAutomatica);
        if (resultadoImportado) {
            if (!this.existeRequisicaoLabExterno(registroExame.getInt(FIL_CODIGO), this.codigoLabExterno, registroExame.getInt(REQ_CODIGO), requisicao.getString("cd_db"))) {
                this.inserirDadosRequisicao(st, this.codigoLabExterno, requisicao.getString("NumeroAtendimentoDB"), registroExame.getString(FIL_CODIGO), registroExame.getInt(REQ_CODIGO));
            }
            this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, ImportacaoResultadoDB.Situacao.LANCADO);
            this.setTextoInformacoesPadrao("Resultado recebido para", registroExame, conferido ? ImportacaoResultadoDB.Situacao.CONFERIDO : ImportacaoResultadoDB.Situacao.LANCADO);
        }
    }

    private void exportacaoWeb(Statement st, Statement st2, Registro registroExame, Registro formatacao, String resultado, String novaSituacao) throws Exception {
        if (this.exportarBaseWeb(registroExame.getString(FIL_CODIGO))) {
            Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, registroExame.getString(FIL_CODIGO), registroExame.getString(REQ_CODIGO), registroExame.getString(EXA_CODIGO), registroExame.getString(MCO_CODIGO), resultado, false);
            this.exportarParaWeb(st, this.getCodigoBaseWeb(registroExame.getString(FIL_CODIGO)), novaSituacao, registroExame, mapa, resultado, formatacao.getString("formatotexto"));
            if (ExportaWeb.isGerarPdfResultado(st2, registroExame.getString(FIL_CODIGO))) {
                ExportaWeb.enviarResultadoPDF(st2, registroExame.getString(FIL_CODIGO), registroExame.getString(REQ_CODIGO), this.getCodigoBaseWeb(registroExame.getString(FIL_CODIGO)));
            }
        }
    }

    private boolean conferenciaAutomatica(Registro requisicao, Registro exResultado, Registro registroExame, Resultado res) {
        boolean marcarConferido;
        int verificacao = res.verificarValidacao();
        boolean bl = marcarConferido = verificacao == 1;
        if (!marcarConferido && verificacao != 2) {
            this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, ImportacaoResultadoDB.Situacao.VALIDACAO_INSATISFEITA);
            this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + registroExame.getString(REQ_CODIGO) + "|" + registroExame.getString(EXA_CODIGO) + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
        }
        return marcarConferido;
    }

    @Override
    protected LinkedList<Registro> processarPaiFilhos(Statement st, Registro requisicao, Registro exResultado, String filCodigo, String reqCodigo) throws Exception {
        boolean agruparMultiguias;
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        Integer[] multiguias = null;
        Registro reg = null;
        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias;
        if (agruparMultiguias) {
            if (requisicao.getValor("NumeroAtendimentoApoiado").toString().length() != tamTubo || !Funcoes.isNumeric(requisicao.getValor("NumeroAtendimentoApoiado").toString())) {
                this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + requisicao.getValor("NumeroAtendimentoApoiado").toString(), false);
                return retorno;
            }
            multiguias = RecepcaoUtil.verificaMultiGuias(filCodigo, reqCodigo, true);
        } else {
            if (requisicao.getValor("NumeroAtendimentoApoiado").toString().length() != tamTubo || !Funcoes.isNumeric(requisicao.getValor("NumeroAtendimentoApoiado").toString())) {
                this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + requisicao.getValor("NumeroAtendimentoApoiado").toString(), false);
                return retorno;
            }
            multiguias = new Integer[]{Integer.parseInt(reqCodigo)};
        }
        for (Integer multiguia : multiguias) {
            reg = this.preencheRegistroExame(st, requisicao, exResultado, filCodigo, retorno, reg, multiguia);
        }
        if (retorno.isEmpty()) {
            String req = requisicao.getString("NumeroAtendimentoApoiado");
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame " + exResultado.getString("CodigoExameDB").toUpperCase() + " na requisi\u00e7\u00e3o do Jalis Fil.:" + req.substring(0, ParametrosGerais.getDigitosTuboFilial()) + " Req.: " + req.substring(ParametrosGerais.getDigitosTuboFilial()) + ". C\u00f3digo DB: " + requisicao.getString("NumeroAtendimentoDB"), false);
            this.adicionarAoModeloRelatorio(reg, requisicao, exResultado, ImportacaoResultadoDB.Situacao.NAO_LOCALIZADO);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean verificaExameFilhoRepetido(Registro exResultado, Registro requisicao, String filCodigo) {
        Statement st;
        block4: {
            boolean bl;
            st = Conexao.getStatement();
            try {
                String req = requisicao.getString("NumeroAtendimentoApoiado");
                req = req.substring(ParametrosGerais.getDigitosTuboFilial());
                StringBuilder sql = new StringBuilder(" select req_codigo, exa_codigo from examerequisicao ");
                sql.append(" where exr_excluido = false ");
                sql.append(" and fil_codigo = ").append(filCodigo);
                sql.append(" and exa_codigo = '").append(exResultado.getString(EXA_CODIGO)).append("'");
                sql.append(" and mco_codigo = '").append(exResultado.getString(MCO_CODIGO)).append("'");
                sql.append(" and req_codigo = ").append(req);
                sql.append(" and exr_situacao <> '").append("L").append("'");
                ResultSet rs = Conexao.executeQuery(st, sql);
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (Exception exception) {
                Conexao.fecharStatement(st);
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return false;
    }

    private Registro preencheRegistroExame(Statement st, Registro requisicao, Registro exResultado, String filCodigo, LinkedList<Registro> retorno, Registro reg, Integer multiguia) throws SQLException {
        String codigoJalisAux = (String)requisicao.getValor("NumeroAtendimentoApoiado");
        requisicao.setValor("NumeroAtendimentoApoiado", StringUtil.preencheString(filCodigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1));
        if (this.buscaDadosExameAssociadoWS(filCodigo, multiguia.toString(), exResultado)) {
            List<ExameDesmembrado> listaExamesPai = this.service.getExamesDesmembradosDBWS(filCodigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), (String)exResultado.getValor(EXA_CODIGO), exResultado.getValor(MCO_CODIGO).toString());
            for (ExameDesmembrado pai : listaExamesPai) {
                if (this.verificaExameFilhoRepetido(exResultado, requisicao, filCodigo)) {
                    this.adicionaResultadoExameSimples(st, requisicao, exResultado, retorno);
                }
                String codigoJalisTemp = (String)exResultado.getValor(EXA_CODIGO);
                reg = this.localizaExameRequisicaoWS(requisicao, exResultado, st, true);
                exResultado.setValor(EXA_CODIGO, pai.getCodigoExame());
                exResultado.setValor(MCO_CODIGO, pai.getCodigomaterial());
                exResultado.setValor(MCO_KODIGO, pai.getFilhos().get(0).getCodigomaterial());
                if (reg == null) continue;
                reg.setValor(EXA_CODIGO, pai.getFilhos().get(0).getCodigoExame());
                reg.setValor(ELE_XMLLABEXTERNO, pai.getFilhos().get(0).getXmlLabExterno());
                reg.setValor("examePai", pai.getCodigoExame());
                reg.setValor("materialPai", pai.getCodigomaterial());
                reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
                exResultado.setValor(EXA_CODIGO, codigoJalisTemp);
                exResultado.setValor("examePai", pai.getCodigoExame());
                retorno.add(reg);
            }
        } else {
            this.adicionaResultadoExameSimples(st, requisicao, exResultado, retorno);
        }
        requisicao.setValor("NumeroAtendimentoApoiado", codigoJalisAux);
        return reg;
    }

    private void adicionaResultadoExameSimples(Statement st, Registro requisicao, Registro exResultado, LinkedList<Registro> retorno) throws SQLException {
        Registro exameSeparado = this.localizaExameRequisicaoWS(requisicao, exResultado, st, false);
        if (exameSeparado != null) {
            retorno.add(exameSeparado);
        }
    }

    private List<ExameDesmembrado> carregarDesmembradosPorRequisicaoWS(Statement st, String filCodigo, String reqCodigo, Registro resultadoDB) throws SQLException {
        Integer[] integerArray;
        boolean agruparMultiguias;
        Integer[] multiguias = null;
        boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filCodigo, reqCodigo);
        if (agruparMultiguias) {
            integerArray = RecepcaoUtil.verificaMultiGuias(filCodigo, reqCodigo, true);
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = Integer.parseInt(reqCodigo);
        }
        multiguias = integerArray;
        List<ExameDesmembrado> desmembrados = new ArrayList<ExameDesmembrado>();
        for (Integer multiguia : multiguias) {
            if (!this.buscaDadosExameAssociadoWS(filCodigo, multiguia.toString(), resultadoDB)) continue;
            desmembrados = this.service.getExamesDesmembradosDBWS(filCodigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), (String)resultadoDB.getValor(EXA_CODIGO), resultadoDB.getValor(MCO_CODIGO).toString());
        }
        return desmembrados;
    }

    @Override
    protected List<ExameDesmembrado> getExamesDesmembradosRetornoDB(Statement st, String filCodigo, String reqCodigo, List<Registro> exames) throws Exception {
        ArrayList<ExameDesmembrado> desmembradosRequisicao = new ArrayList<ExameDesmembrado>();
        for (Registro resultadoDB : exames) {
            List<ExameDesmembrado> desmembrados = this.carregarDesmembradosPorRequisicaoWS(st, filCodigo, reqCodigo, resultadoDB);
            for (ExameDesmembrado desmembrado : desmembrados) {
                if (desmembradosRequisicao.contains(desmembrado)) {
                    this.buscaExamesFilhosDesm(desmembradosRequisicao, desmembrado);
                    continue;
                }
                desmembradosRequisicao.addAll(desmembrados);
            }
        }
        return desmembradosRequisicao;
    }

    private void buscaExamesFilhosDesm(List<ExameDesmembrado> desmembradosRequisicao, ExameDesmembrado desmembrado) {
        for (ExameDesmembrado desmReq : desmembradosRequisicao) {
            if (!desmReq.equals(desmembrado)) continue;
            for (Exame filhoDesm : desmembrado.getFilhos()) {
                if (desmReq.getFilhos().contains(filhoDesm)) continue;
                desmReq.getFilhos().add(filhoDesm);
            }
        }
    }

    private Registro localizaExameRequisicaoWS(Registro requisicao, Registro exame, Statement st, boolean desmembrado) throws SQLException {
        String fil = "";
        Registro reg = null;
        String req = requisicao.getString("NumeroAtendimentoApoiado");
        if (Funcoes.textoVazio(req) || req.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            this.adicionarAoModeloRelatorio(reg, requisicao, exame, ImportacaoResultadoDB.Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Sem c\u00f3digo de requisi\u00e7\u00e3o no Jalis. C\u00f3digo DB: " + requisicao.getString("NumeroAtendimentoApoiado"), false);
            return null;
        }
        fil = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
        req = req.substring(ParametrosGerais.getDigitosTuboFilial());
        if (!Funcoes.isNumeric(fil) || !Funcoes.isNumeric(req)) {
            this.adicionarAoModeloRelatorio(reg, requisicao, exame, ImportacaoResultadoDB.Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Filial ou requisi\u00e7\u00e3o incorreta. C\u00f3digo DB: " + requisicao.getString("NumeroAtendimentoApoiado"), false);
            return null;
        }
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, \n");
        sql.append("  b.exa_codigo,b.exr_resposta, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(g.met_codigo, b.met_codigo) as met_codigo, \n");
        sql.append("  a.req_idade, a.req_anomes, b.exr_datamaterial, \n");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, \n");
        sql.append("  a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao, ge.mco_codigo as mco_kodigo \n");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo \n");
        sql.append("left join examematcoletalabextdesm ed on e.fil_codigo = b.fil_codigo and b.mco_codigo = ed.mco_codigo and ed.exa_codigo = b.exa_codigo \n");
        sql.append("left join examematcoletalabexterno ge on f.fil_codigo = ge.fil_codigo and ed.exa_kodigo = ge.exa_codigo and ed.mco_kodigo = ge.mco_codigo and f.lae_codigo = ge.lae_codigo \n");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        sql.append("  a.req_excluida = false and b.exr_excluido = false \n");
        sql.append(" and f.ler_datahoraestorno is null and f.usr_codestorno is null \n");
        if (!Funcoes.textoVazio(exame.getString(EXA_CODIGO)) && !Funcoes.textoVazio(exame.getString(MCO_CODIGO))) {
            if (!desmembrado) {
                sql.append(" and b.exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("'");
            } else {
                sql.append(" and ed.exa_kodigo = '").append(exame.getString(EXA_CODIGO)).append("'");
            }
            sql.append(" \n").append(" and b.mco_codigo = ").append(exame.getString(MCO_CODIGO)).append(" \n");
        } else {
            sql.append("  and ((g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
            sql.append("  and upper(g.ele_xmllabexterno) ilike '%<").append("cd_db").append(">").append(exame.getString("CodigoExameDB").toUpperCase()).append("</").append("cd_db").append(">%')");
            if (desmembrado) {
                sql.append("  or (ge.ele_xmllabexterno is not null and ge.ele_xmllabexterno <> '' \n");
                sql.append("  and upper(ge.ele_xmllabexterno) ilike '%<").append("cd_db").append(">").append(exame.getString("CodigoExameDB").toUpperCase()).append("</").append("cd_db").append(">%')");
            }
            sql.append(")");
        }
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        if (res.next()) {
            reg = new Registro(res);
            reg.setValor("codigo-layout", ExameUtil.getCodigoLayout(fil, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor("cabecalho", ExameUtil.getCabecalhoRodape(fil, reg.getString("codigo-layout")));
            Registro formatacao = new Registro();
            formatacao.setValor("formato", reg.getValor("exr_resultado"));
            formatacao.setValor(MET_CODIGO, reg.getValor(MET_CODIGO));
            reg.setValor("formatacao", formatacao);
            exame.setValor(EXA_CODIGO, res.getString(EXA_CODIGO));
            exame.setValor(MCO_CODIGO, res.getString(MCO_CODIGO));
            exame.setValor(MCO_KODIGO, res.getString(MCO_KODIGO));
            return reg;
        }
        return null;
    }

    protected boolean exameRelacionadoWS(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString(FIL_CODIGO);
            String exa = reg.getString(EXA_CODIGO);
            String mcoFilho = reg.getString(MCO_KODIGO);
            String mco = reg.getString(MCO_CODIGO);
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' ");
            sql.append(" and ");
            if (!StringUtil.isEmpty(mcoFilho)) {
                sql.append(" (mco_codigo = ").append(mcoFilho).append(" or ");
            }
            sql.append(" mco_codigo = ").append(mco);
            if (!StringUtil.isEmpty(mcoFilho)) {
                sql.append(") ");
            }
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next() && rs.getInt("lae_codigo") == this.codigoLabExterno) {
                String xml = rs.getString(ELE_XMLLABEXTERNO);
                reg.setValor(ELE_XMLLABEXTERNO, xml);
                exa = StringUtil.getValor(xml, "cd_exame");
                mco = StringUtil.getValor(xml, "material");
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("select edb_xml from examesdb where fil_codigo = ").append(fil);
                sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                sqlBuilder.append(" and edb_codexame = '").append(exa).append("' and edb_descricaomaterial = '").append(mco).append("' ");
                rs = st.executeQuery(sqlBuilder.toString());
                if (rs.next()) {
                    reg.setValor("edb_xml", rs.getString("edb_xml"));
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buscaDadosExameAssociadoWS(String filCodigo, String reqCodigo, Registro exResultado) throws SQLException {
        ResultSet resultSet;
        Statement st;
        block4: {
            boolean bl;
            block5: {
                StringBuilder sql = new StringBuilder();
                sql.append(" SELECT a.exa_codigo as examepai, ");
                sql.append(" e.exa_kodigo as examefilho, ");
                sql.append(" a.mco_codigo, ");
                sql.append(" p.ele_xmllabexterno ");
                sql.append(" FROM examerequisicao a ");
                sql.append(" JOIN examematcoletalabextdesm e ON a.fil_codigo = e.fil_codigo ");
                sql.append(" AND a.exa_codigo = e.exa_codigo ");
                sql.append(" AND a.mco_codigo = e.mco_codigo ");
                sql.append(" JOIN examematcoletalabexterno p ON e.fil_codigo = p.fil_codigo ");
                sql.append(" AND e.exa_kodigo = p.exa_codigo ");
                sql.append(" AND e.mco_kodigo = p.mco_codigo ");
                sql.append(" AND e.lae_codigo = p.lae_codigo ");
                sql.append(" WHERE a.fil_codigo = ").append(filCodigo);
                sql.append(" AND a.req_codigo =").append(reqCodigo);
                sql.append(" AND upper(p.ele_xmllabexterno) ilike '%<").append("cd_db").append(">").append(exResultado.getString("CodigoExameDB").toUpperCase()).append("</").append("cd_db").append(">%'");
                sql.append(" AND p.ele_xmllabexterno is not null and p.ele_xmllabexterno <> '' ");
                st = Conexao.getStatement();
                resultSet = null;
                try {
                    resultSet = Conexao.executeQuery(st, sql);
                    if (!resultSet.next()) break block4;
                    exResultado.setValor(EXA_CODIGO, resultSet.getString("examefilho"));
                    exResultado.setValor(MCO_CODIGO, resultSet.getString(MCO_CODIGO));
                    exResultado.setValor(ELE_XMLLABEXTERNO, resultSet.getString(ELE_XMLLABEXTERNO));
                    bl = true;
                    if (resultSet == null) break block5;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                resultSet.close();
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        Conexao.fecharStatement(st);
        return false;
    }

    private void processaResultadoImagem(Registro registroExame, Map<String, Object> dados, Map<String, Registro> resultadosImagem) {
        if (null != resultadosImagem && !resultadosImagem.isEmpty()) {
            for (Map.Entry<String, Registro> item : resultadosImagem.entrySet()) {
                String imagemResultado = resultadosImagem.get(item.getKey()).getString("ValorResultadoImagem");
                dados.put(item.getKey(), imagemResultado);
                this.adicionaValorExameDesmembradoWS(registroExame, dados, resultadosImagem.get(item.getKey()));
            }
        }
    }

    private String processaResultado(Registro requisicao, Registro exResultado, Registro registroExame, Map<String, Object> dados, Map<String, Registro> resultados, Map<String, Registro> parametros) {
        String resultadoAtual = "";
        if (null != resultados && !resultados.isEmpty()) {
            for (String key : resultados.keySet()) {
                String exaJalis = registroExame.getString("examePai");
                if (Funcoes.textoVazio(exaJalis)) {
                    resultadoAtual = this.gerarResultadoAtual(dados, resultados, parametros, key, registroExame, resultadoAtual, false);
                    continue;
                }
                Map resultadosFilho = exResultado.getValor("ListaResultadoTexto", Map.class);
                Map resultadosImagemFilho = exResultado.getValor("ListaResultadoImagem", Map.class);
                Map parametrosFilho = exResultado.getValor("parametros", Map.class);
                for (String k : resultadosFilho.keySet()) {
                    resultadoAtual = this.gerarResultadoAtual(dados, resultadosFilho, parametrosFilho, k, exResultado, resultadoAtual, true);
                    dados.put("NumeroAtendimentoDB@" + exResultado.getString(EXA_CODIGO) + "#" + exResultado.getString(MCO_KODIGO), requisicao.getString("NumeroAtendimentoDB"));
                }
                this.processaResultadoImagem(registroExame, dados, resultadosImagemFilho);
            }
        }
        return resultadoAtual;
    }

    protected void adicionaValorExameDesmembradoWS(Registro reg, Map<String, Object> dados, Registro linha) {
        String mcoCodigo;
        String string = mcoCodigo = !Funcoes.textoVazio(reg.getString("examePai")) && !Funcoes.textoVazio(reg.getString(MCO_KODIGO)) ? reg.getString(MCO_KODIGO) : reg.getString(MCO_CODIGO);
        if (reg.getString(EXA_CODIGO) != null && !Funcoes.textoVazio(reg.getString(EXA_CODIGO))) {
            String chaveResultado = linha.getString("CodigoParametroDB") + "@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo;
            dados.put(chaveResultado, linha.getValor("ValorResultado"));
        }
    }

    @Override
    protected String gerarResultadoAtual(Map<String, Object> dados, Map<String, Registro> resultados, Map<String, Registro> parametros, String key, Registro reg, String resultadoAtual, boolean isDesm) {
        String mcoCodigo;
        String valorResultado = resultados.get(key).getString("ValorResultado");
        String valorRef = resultados.get(key).getString("valorReferencia");
        String unidadeMedida = resultados.get(key).getString("UnidadeMedida");
        if (key.equals("NotaFixa")) {
            String descricaoParametro = resultados.get(key).getString("DescricaoParametrosDB");
            dados.put(key, descricaoParametro);
        } else {
            dados.put(key, valorResultado);
        }
        if (Funcoes.textoVazio(valorRef) && parametros != null && parametros.containsKey(key) && parametros.get(key).getValor("valorReferencia", Registro.class) != null) {
            valorRef = parametros.get(key).getValor("valorReferencia", Registro.class).getString("valorRef");
        }
        if (Funcoes.textoVazio(unidadeMedida) && parametros != null && parametros.containsKey(key)) {
            unidadeMedida = parametros.get(key).getString("unidade");
        }
        String string = mcoCodigo = !Funcoes.textoVazio(reg.getString("examePai")) && !Funcoes.textoVazio(reg.getString(MCO_KODIGO)) ? reg.getString(MCO_KODIGO) : reg.getString(MCO_CODIGO);
        if (isDesm) {
            dados.put("ds_exame@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("ds_exame"));
            dados.put("valorRef_" + key + "@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, valorRef);
            dados.put("unidade_" + key + "@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, unidadeMedida);
            dados.put("CodigoExameDB@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("CodigoExameDB"));
            dados.put("metodologia@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("DescricaoMetodologia"));
            dados.put("material@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("material"));
            dados.put("Observacao1@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("Observacao1"));
            dados.put("Observacao2@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("Observacao2"));
            dados.put("Observacao3@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("Observacao3"));
            dados.put("Observacao4@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("Observacao4"));
            dados.put("Observacao5@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("Observacao5"));
            dados.put("NomeLiberadorClinico@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("NomeLiberadorClinico"));
            dados.put("DataHoraLiberacaoClinica@" + reg.getString(EXA_CODIGO) + "#" + mcoCodigo, reg.getString("DataHoraLiberacaoClinica"));
        } else {
            dados.put(String.format("%s_%s", "valorRef", key), valorRef);
            dados.put(String.format("%s_%s", "unidade", key), unidadeMedida);
        }
        resultadoAtual = this.getXmlResultadoAtual(reg, resultadoAtual, valorResultado);
        this.adicionaValorExameDesmembradoWS(reg, dados, resultados.get(key));
        return resultadoAtual;
    }

    private boolean validarExameRegistro(Registro requisicao, Registro exResultado, Registro registroExame) throws SQLException {
        if (registroExame == null) {
            return true;
        }
        if (this.exameLancado(registroExame)) {
            this.setTextoInformacoesPadrao("Requisi\u00e7\u00e3o do DB", registroExame, ImportacaoResultadoDB.Situacao.JA_LANCADO);
            this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, ImportacaoResultadoDB.Situacao.JA_LANCADO);
            return true;
        }
        if (!this.exameColetado(registroExame) && !registroExame.getString("exr_situacao").equals("P")) {
            this.setTextoInformacoesPadrao("Requisi\u00e7\u00e3o do DB", registroExame, ImportacaoResultadoDB.Situacao.SEM_MATERIAL);
            this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, ImportacaoResultadoDB.Situacao.SEM_MATERIAL);
            return true;
        }
        if (!this.exameRelacionadoWS(registroExame)) {
            this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, ImportacaoResultadoDB.Situacao.SEM_RELACIONAMENTO);
            this.setTextoInformacoesPadrao("N\u00e3o foi poss\u00edvel importar", registroExame, ImportacaoResultadoDB.Situacao.SEM_RELACIONAMENTO);
            return true;
        }
        return false;
    }

    private ArrayList<Registro> parseResultadoWS(String[] retornoResultados) {
        ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
        int qtdeDigitos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        for (String atendimento : retornoResultados) {
            String tubo = StringUtil.limpaString(StringUtil.getValor(atendimento, DBCamposRetornoLaudoAtendimento.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag()), new String[]{".", ","});
            if (Funcoes.textoVazio(tubo) || tubo.length() < qtdeDigitos || !Funcoes.isNumeric(tubo)) continue;
            Registro reg = new Registro();
            reg.setValor("NumeroAtendimentoDB", StringUtil.getValor(atendimento, DBCamposRetornoLaudoAtendimento.TAG_NUMERO_ATENDIMENTO_DB.getTag()));
            reg.setValor("NumeroAtendimentoApoiado", StringUtil.getValor(atendimento, DBCamposRetornoLaudoAtendimento.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag()));
            reg.setValor("RGPacienteApoiado", StringUtil.getValor(atendimento, DBCamposRetornoLaudoAtendimento.TAG_NUMERO_CPF.getTag()));
            reg.setValor("Peso", StringUtil.getValor(atendimento, DBCamposRetornoLaudoAtendimento.TAG_PESO.getTag()));
            reg.setValor("RGPacienteApoiado", StringUtil.getValor(atendimento, DBCamposRetornoLaudoAtendimento.TAG_RG_PACIENTE_APOIOADO.getTag()));
            reg.setValor("RGPacienteDB", StringUtil.getValor(atendimento, DBCamposRetornoLaudoAtendimento.TAG_RG_PACIENTE_DB.getTag()));
            String[] resultadosExames = StringUtil.getValores(atendimento, DBCamposRetornoLaudoAtendimento.TAG_RESULTADO_PROCEDIMENTOS_V2.getTag());
            ArrayList<Registro> listaExames = new ArrayList<Registro>();
            this.parserExamesResultadoWS(resultadosExames, listaExames);
            reg.setValor("ListaResultadoProcedimentos", listaExames);
            listaRequisicoes.add(reg.clone());
        }
        return listaRequisicoes;
    }

    private void parserExamesResultadoWS(String[] resultadosExames, ArrayList<Registro> listaExames) {
        for (String exameResult : resultadosExames) {
            String[] resultadosImagem;
            Registro exame = new Registro();
            exame.setValor("CodigoExameDB", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_CODIGO_EXAME_DB.getTag()));
            exame.setValor("material", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_MATERIAL_EXAME.getTag()));
            exame.setValor("VersaoLaudo", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_VERSAO_LAUDO.getTag()));
            exame.setValor("DescricaoMetodologia", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_DESCRICAO_METODOLOGIA.getTag()));
            exame.setValor("DescricaoRegiaoColeta", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_DESCRICAO_REGIAO_COLETA.getTag()));
            exame.setValor("DataHoraLiberacaoClinica", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_DATA_HORA_LIBERACAO_CLINICA.getTag()));
            exame.setValor("NomeLiberadorClinico", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_NOME_LIBERADOR_CLINICO.getTag()));
            exame.setValor("Observacao1", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_OBSERVACAO_1.getTag()));
            exame.setValor("Observacao2", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_OBSERVACAO_2.getTag()));
            exame.setValor("Observacao3", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_OBSERVACAO_3.getTag()));
            exame.setValor("Observacao4", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_OBSERVACAO_4.getTag()));
            exame.setValor("Observacao5", StringUtil.getValor(exameResult, DBCamposRetornoLaudoAtendimento.TAG_OBSERVACAO_5.getTag()));
            String[] resultadosTexto = StringUtil.getValores(exameResult, DBCamposRetornoLaudoAtendimento.TAG_RESULTADO_TEXTO_V2.getTag());
            HashMap<String, Registro> mapResultadosTexto = new HashMap<String, Registro>();
            for (String resultadoExame : resultadosTexto) {
                Registro res = new Registro();
                res.setValor("CodigoParametroDB", StringUtil.getValor(resultadoExame, DBCamposRetornoLaudoAtendimento.TAG_CODIGO_PARAMETRO_DB.getTag()));
                res.setValor("DescricaoParametrosDB", StringUtil.getValor(resultadoExame, DBCamposRetornoLaudoAtendimento.TAG_DESCRICAO_PARAMETRO_DB.getTag()));
                res.setValor("ValorResultado", StringUtil.getValor(resultadoExame, DBCamposRetornoLaudoAtendimento.TAG_VALOR_RESULTADO.getTag()));
                res.setValor("UnidadeMedida", StringUtil.getValor(resultadoExame, DBCamposRetornoLaudoAtendimento.TAG_UNIDADE_MEDIDA.getTag()));
                res.setValor("valorReferencia", StringUtil.getValor(resultadoExame, DBCamposRetornoLaudoAtendimento.TAG_VALOR_REFERENCIA.getTag()));
                mapResultadosTexto.put(res.getString("CodigoParametroDB"), res);
            }
            exame.setValor("ListaResultadoTexto", mapResultadosTexto);
            HashMap<String, Registro> mapResultadosImagem = new HashMap<String, Registro>();
            for (String resultadoImagem : resultadosImagem = StringUtil.getValores(exameResult, DBCamposRetornoLaudoAtendimento.TAG_RESULTADO_IMAGEM_V2.getTag())) {
                Registro res = new Registro();
                res.setValor("CodigoParametroDB", StringUtil.getValor(resultadoImagem, DBCamposRetornoLaudoAtendimento.TAG_CODIGO_PARAMETRO_DB.getTag()));
                String valorResultadoImagem = StringUtil.getValor(resultadoImagem, DBCamposRetornoLaudoAtendimento.TAG_VALOR_RESULTADO_IMAGEM.getTag());
                if (!Funcoes.textoVazio(valorResultadoImagem)) {
                    if (ImportacaoResultadoDBWS.isBase64(valorResultadoImagem)) {
                        res.setValor("ValorResultadoImagem", valorResultadoImagem);
                    } else {
                        byte[] valorResultadoBase64 = valorResultadoImagem.getBytes();
                        res.setValor("ValorResultadoImagem", valorResultadoBase64);
                    }
                }
                mapResultadosImagem.put(res.getString("CodigoParametroDB"), res);
            }
            exame.setValor("ListaResultadoImagem", mapResultadosImagem);
            listaExames.add(exame.clone());
        }
    }

    @Override
    protected void importarResultadoWs() {
        if (this.isWebService) {
            this.requisicoes = null;
            SolicitaPeriodo solicita = SolicitaPeriodo.novaInstancia(this.getTopLevelAncestor());
            solicita.setVisible(true);
            if (solicita.isOk()) {
                if (solicita.isPeriodoSelecionado()) {
                    this.solicitarWebService(solicita.getDataInicial(), solicita.getDataFinal());
                } else if (solicita.isRequisicaoSelecionado()) {
                    this.solicitarWebServiceRequisicao(solicita.getFiltroFilial(), solicita.getFiltroRequisicao());
                } else if (solicita.isLoteSelecionado()) {
                    this.solicitarWebServiceLote();
                }
            }
            this.isWebService = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.salvarUltimoFiltroConsultarPendencias();
            this.fechar();
        } else {
            super.actionPerformed(e);
        }
    }

    private void salvarUltimoFiltroConsultarPendencias() {
        if (!Funcoes.textoVazio(this.xmlConsultarPendencias)) {
            ParametrosUsuarios.setValor("ImportarResultadosDB.consultarPendencias", this.xmlConsultarPendencias);
            ParametrosUsuarios.salvarParametros(true);
        }
    }

    @Override
    protected void consultarPendencias() {
        if (this.isWebService) {
            this.amostrasPendentes = null;
            ConsultarPendenciasDB consultarDB = ConsultarPendenciasDB.novaInstancia(this.getTopLevelAncestor());
            consultarDB.setVisible(true);
            if (consultarDB.isOk()) {
                this.consultarPendenciasWebService(consultarDB.getDataInicial(), consultarDB.getDataFinal(), consultarDB.getCheckMarcarRecoleta(), consultarDB.getComboMotivos());
            }
            this.isWebService = false;
        }
    }

    private void consultarPendenciasWebService(String dataInicial, String dataFinal, boolean marcarExameRecoleta, MotivoRecoletaBean motivo) {
        block3: {
            this.setTextoInformacoes("Solicitando as pend\u00eancias. Aguarde...", false);
            try {
                String[] listaPedidos;
                DBComunicacao db = new DBComunicacao(this.configuracaoLab);
                String retornoPendencias = db.listaProcedimentosPendentes(GeradorXmlImportacaoDB.gerarXmlListaProcedimentosPendentes(this.configuracaoLab, Funcoes.formataData(FORMATO_DATA, dataInicial), Funcoes.formataData(FORMATO_DATA, dataFinal)));
                for (String pedido : listaPedidos = StringUtil.getValores(retornoPendencias, DBCamposRetornoLaudoAtendimento.TAG_PEDIDOS_MMP_V2.getTag())) {
                    if (!Objects.isNull(StringUtil.getValor(pedido, DBCamposRetornoLaudoAtendimento.TAG_NUMERO_ATENDIMENTO_DB.getTag()))) continue;
                    this.setTextoInformacoes("N\u00e3o h\u00e1 pend\u00eancias para serem importadas no per\u00edodo", false);
                    return;
                }
                this.amostrasPendentes = listaPedidos;
                this.gravarRastreabilidade(marcarExameRecoleta, motivo);
                this.gerarXmlConsultaPendencias(dataFinal, marcarExameRecoleta, motivo);
            }
            catch (Exception e) {
                if (!e.getMessage().contains(UNKNOWN_HOST_EXCEPTION)) break block3;
                this.setTextoInformacoes(MENSAGEM_ERRO_CONEXAO);
            }
        }
    }

    private void gerarXmlConsultaPendencias(String dataFinal, boolean marcarExameRecoleta, MotivoRecoletaBean motivo) {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("consultarPendencias");
        xml.escrever("dataFinal", dataFinal);
        xml.escrever("marcarRecoleta", String.valueOf(marcarExameRecoleta));
        if (marcarExameRecoleta && motivo != null) {
            xml.escrever("codigoMotivoRecoleta", motivo.getCodigo().toString());
        }
        try {
            xml.fechar("consultarPendencias");
            this.xmlConsultarPendencias = xml.toString();
        }
        catch (XMLStringBuilderException xMLStringBuilderException) {
            // empty catch block
        }
    }

    private void gravarRastreabilidade(boolean marcarExameRecoleta, MotivoRecoletaBean motivo) throws SQLException {
        LoteExternoRequisicaoRastreioService requisicaoRastreioService = new LoteExternoRequisicaoRastreioService();
        List<String> amostrasJalis = this.adicionarAmostrasValidas();
        List<LoteExternoRequisicaoRastreioBean> rastreiosLote = requisicaoRastreioService.registraPendencias(amostrasJalis, this.labExternoCodigo, Variaveis.filialPadrao, marcarExameRecoleta, motivo);
        rastreiosLote.forEach(rastreio -> {
            StringBuilder linhaInformacaoImportacao = new StringBuilder();
            linhaInformacaoImportacao.append(System.lineSeparator());
            linhaInformacaoImportacao.append(rastreio.getNumeroAtendimentoApoiado()).append(" - ");
            linhaInformacaoImportacao.append(rastreio.getNomePaciente()).append(" - ");
            linhaInformacaoImportacao.append(rastreio.getCodigoExame()).append(" - ").append(rastreio.getDescricaoStatus());
            linhaInformacaoImportacao.append(rastreio.isPodeAlterarParaRecoleta() ? " - Recoleta" : "");
            linhaInformacaoImportacao.append(rastreio.isExameComResultado() ? " - Exame com Resultado" : "");
            this.setTextoInformacoes(linhaInformacaoImportacao.toString(), false);
        });
        this.setTextoInformacoes("\nConsulta finalizada.", false);
    }

    private List<String> adicionarAmostrasValidas() {
        ArrayList<String> amostrasJalis = new ArrayList<String>();
        int tamanhoCodigoJalis = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        for (String amostra : this.amostrasPendentes) {
            String numeroApoiado = StringUtil.getValor(amostra, DBCamposRetornoLaudoAtendimento.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag());
            if (numeroApoiado.length() == tamanhoCodigoJalis) {
                amostrasJalis.add(amostra);
                continue;
            }
            this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o inv\u00e1lida ou em tamanho diferente do Jalis " + numeroApoiado, false);
        }
        return amostrasJalis;
    }

    public static boolean isBase64(String valor) {
        try {
            Base64.getDecoder().decode(valor);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

