/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.db2.DBComunicacao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.db2.DBCamposRetornoLaudoAtendimento;
import jalis.laboratorio.util.parsers.db2.GeradorXmlImportacaoDB;
import jalis.laboratorio.util.parsers.db2.ParserImportacaoDB;
import jalis.service.util.parsers.db2.ImportacaoResultadoDBService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.CertificadoException;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilderException;
import jalis.util.xml.XMLUtil;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportacaoResultadoDB
extends AbstractImportadorResultadoLabExterno {
    protected static final String FORMATO = "formato";
    protected static final String FORMATO_TEXTO = "formatotexto";
    protected static final String CODIGO_LAYOUT = "codigo-layout";
    protected static final String CABECALHO = "cabecalho";
    protected static final String FORMATACAO = "formatacao";
    protected static final String TAG_IMPORTAR_RESULTADO_PDF = "importarResultadoPdf";
    protected List<Registro> requisicoes = null;
    protected String[] amostrasPendentes;
    public static final String EXAME_PAI = "examePai";
    public static final String MATERIAL_PAI = "materialPai";
    public static final String EXAME_FILHO = "exameFilho";
    protected final ImportacaoResultadoDBService service;
    protected LaboratorioExterno labExterno = null;
    private Map<String, Map<String, Map<String, String>>> historicosExame = null;
    private Map<String, Map<String, Map<String, String>>> historicosExameFilial = null;
    protected JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    protected ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    protected boolean conferirAutomatico = false;
    protected String codigoUsuarioConferenciaAutomatica = null;

    public ImportacaoResultadoDB(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio DB a partir de arquivo XML", codigoLabExterno, Protocolo.DB, new JPanel(new FlowLayout(2)));
        this.service = new ImportacaoResultadoDBService();
        this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
        this.historicosExame = null;
        this.historicosExameFilial = null;
        this.getPanelAdicional().add(this.buttonImprimir);
        this.pegaDadosConferencia(codigoLabExterno);
    }

    public ImportacaoResultadoDB(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo) {
        super(titulo, descricao, codigoLabExterno, protocolo);
        this.service = new ImportacaoResultadoDBService();
        this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
        this.historicosExame = null;
        this.historicosExameFilial = null;
        this.getPanelAdicional().add(this.buttonImprimir);
        this.pegaDadosConferencia(codigoLabExterno);
    }

    public ImportacaoResultadoDB(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo, JPanel panelAdicional) {
        super(titulo, descricao, codigoLabExterno, protocolo, panelAdicional);
        this.service = new ImportacaoResultadoDBService();
        this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
        this.historicosExame = null;
        this.historicosExameFilial = null;
        this.getPanelAdicional().add(this.buttonImprimir);
        this.pegaDadosConferencia(codigoLabExterno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pegaDadosConferencia(int codigoLabExterno) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDB (56)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importarResultado() {
        this.requisicoes = null;
        this.setTextoInformacoes("");
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        if (!this.isWebService && this.requisicoes == null) {
            this.requisicoes = this.solicitarArquivo();
        }
        if (this.requisicoes == null || this.requisicoes.isEmpty()) {
            this.habilitarBotoes(true);
            return;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st == null) {
            return;
        }
        try {
            this.progress.setValue(0);
            this.progress.setMaximum(this.requisicoes.size());
            this.progress.setVisible(true);
            this.processarResultados(this.requisicoes, st, st2);
            Conexao.arquivaSQL();
            this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDB: 286");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
        this.progress.setVisible(false);
        this.requisicoes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    private List<Registro> solicitarArquivo() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. DB (*.xml)", "xml"));
        List requisicoes = null;
        if (chooser.showOpenDialog(this) == 0) {
            Document doc = this.analisarXML(chooser.getSelectedFile());
            if (doc == null) {
                this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo: " + chooser.getSelectedFile().getPath());
                return null;
            }
            Element raiz = doc.getDocumentElement();
            try {
                if (!raiz.getNodeName().equalsIgnoreCase("ct_LoteResultados_v1")) {
                    this.setTextoInformacoes(String.format("Erro arquivo de resultado em formato incorreto, n\u00f3 principal (%s) n\u00e3o encontrado, n\u00f3 do arquivo (%s) ", "ct_LoteResultados_v1", raiz.getNodeName()));
                    return null;
                }
                Registro lote = this.parse(XMLUtil.getElementosFilhos(raiz));
                requisicoes = lote.getValor("ct_Resultado_v1", List.class);
            }
            catch (DOMException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ImportacaoResultadoDB: 137");
            }
            if (requisicoes == null || requisicoes.size() == 0) {
                this.setTextoInformacoes("O arquivo informado n\u00e3o possui requisi\u00e7\u00f5es a serem importadas!");
                return null;
            }
        }
        return requisicoes;
    }

    protected void processarResultados(List<Registro> requisicoes, Statement st, Statement st2) throws SQLException, Exception, CertificadoException, ParseException {
        int qtdeDigitos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        HashMap<String, String> requisicoesNotificar = new HashMap<String, String>();
        for (Registro requisicao : requisicoes) {
            this.progress.setValue(this.progress.getValue() + 1);
            List exames = requisicao.getValor("ListaResultadoProcedimentos", List.class);
            String tubo = requisicao.getValor("NumeroAtendimentoApoiado").toString();
            if (Funcoes.textoVazio(tubo) || tubo.length() != qtdeDigitos) {
                this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o localizada: " + tubo + " - Validar se foi inserida manualmente no site do DB.", false);
                continue;
            }
            String fil_codigo = tubo.toString().substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = tubo.substring(ParametrosGerais.getDigitosTuboFilial());
            Integer[] multiguias = this.verificarRequisicaoMultiguia(fil_codigo, req_codigo);
            List<ExameDesmembrado> desmembradosRetornoDB = this.getExamesDesmembradosRetornoDB(st, fil_codigo, req_codigo, exames);
            for (Registro exResultado : exames) {
                String exameMaterial = this.service.buscaCodigoExameAssociado(fil_codigo, multiguias, exResultado);
                if (Funcoes.textoVazio(exameMaterial)) {
                    this.setTextoInformacoes("\nDados de exame para a requisi\u00e7\u00e3o: " + tubo + " n\u00e3o localizado.", false);
                    continue;
                }
                String exa_codigo = exameMaterial.split("-")[0];
                String mco_codigo = exameMaterial.split("-")[1];
                String situacaoExame = this.service.pesquisarSituacaoExame(fil_codigo, this.labExterno.codigoLab, multiguias, exa_codigo, mco_codigo);
                if (!Funcoes.textoVazio(situacaoExame) && !situacaoExame.equals("P")) {
                    String descricaoSituacao = Tipos.tipoSituacaoExame(situacaoExame);
                    this.setTextoInformacoes(String.format("\nExame %s %s", exa_codigo, descricaoSituacao), false);
                    continue;
                }
                requisicoesNotificar.put(this.getChaveFilReq(fil_codigo, req_codigo), req_codigo);
                LinkedList<Registro> listaRegistros = this.processarPaiFilhos(st, requisicao, exResultado, fil_codigo, req_codigo);
                for (Registro registroExame : listaRegistros) {
                    if (registroExame == null) continue;
                    if (this.exameLancado(registroExame)) {
                        this.setTextoInformacoesPadrao("Requisi\u00e7\u00e3o do DB", registroExame, Situacao.JA_LANCADO);
                        this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, Situacao.JA_LANCADO);
                        continue;
                    }
                    if (!this.exameColetado(registroExame) && registroExame != null && !registroExame.getString("exr_situacao").equals("P")) {
                        this.setTextoInformacoesPadrao("Requisi\u00e7\u00e3o do DB", registroExame, Situacao.SEM_MATERIAL);
                        this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, Situacao.SEM_MATERIAL);
                        continue;
                    }
                    if (!this.exameRelacionado(registroExame)) {
                        this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, Situacao.SEM_RELACIONAMENTO);
                        this.setTextoInformacoesPadrao("N\u00e3o foi poss\u00edvel importar", registroExame, Situacao.SEM_RELACIONAMENTO);
                        continue;
                    }
                    if (registroExame.getValor(EXAME_PAI) != null) {
                        registroExame.setValor("exa_codigo", registroExame.getString(EXAME_PAI));
                    }
                    boolean salvaParcial = registroExame.getBoolean("exa_salvaparcial");
                    Registro exameSalvo = ParserImportacaoDB.getExame(registroExame.getString("ele_xmllabexterno"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"));
                    LaboratorioExterno lab = LaboratorioExterno.getLabExterno(String.valueOf(this.codigoLabExterno));
                    boolean isImportarResultadoPdfExame = exameSalvo.getString("formato_pdf").equalsIgnoreCase("SIM");
                    boolean isImportarResultadoPdfLabExterno = StringUtil.getBoolean(lab.configuracao, TAG_IMPORTAR_RESULTADO_PDF);
                    if (this.isWebService && (isImportarResultadoPdfLabExterno || isImportarResultadoPdfExame)) {
                        boolean conferido;
                        String[] codigoExameDB = new String[]{exameSalvo.getString("cd_db")};
                        String codigoSenhaIntegracao = StringUtil.getValor(lab.configuracao, "senha");
                        String codigoApoiado = StringUtil.getValor(lab.configuracao, "codigo");
                        String enderecoWS = StringUtil.getValor(lab.configuracao, "enderecoWebService");
                        String numeroAtendimentoApoiado = requisicao.getString("NumeroAtendimentoApoiado");
                        boolean resultadoImportado = this.importarResultadoPdfDb(codigoExameDB, registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), codigoApoiado, numeroAtendimentoApoiado, enderecoWS, lab.configuracao);
                        boolean bl = conferido = this.conferirAutomatico && !StringUtil.isEmpty(this.codigoUsuarioConferenciaAutomatica);
                        if (resultadoImportado) {
                            if (!this.existeRequisicaoLabExterno(registroExame.getInt("fil_codigo"), this.codigoLabExterno, registroExame.getInt("req_codigo"), requisicao.getString("cd_db"))) {
                                this.inserirDadosRequisicao(st, this.codigoLabExterno, requisicao.getString("NumeroAtendimentoDB"), registroExame.getString("fil_codigo"), registroExame.getInt("req_codigo"));
                            }
                            this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, Situacao.LANCADO);
                            this.setTextoInformacoesPadrao("Resultado recebido para", registroExame, conferido ? Situacao.CONFERIDO : Situacao.LANCADO);
                        }
                    } else {
                        Date horaColeta;
                        Registro formatacao;
                        boolean salvoParcial = registroExame.getString("exr_situacao").equals("P");
                        Registro registro = formatacao = salvoParcial ? (Registro)registroExame.getValor(FORMATACAO) : this.localizarFormatacao(registroExame);
                        if (formatacao == null || Funcoes.textoVazio(formatacao.getString(FORMATO))) {
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + registroExame.getString("req_codigo") + "|" + registroExame.getString("exa_codigo") + " - Modelo de laudo do exame n\u00e3o configurado", false);
                            continue;
                        }
                        Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), registroExame.getString("fil_codigo"), false, false);
                        dados.put("NumeroAtendimentoDB", requisicao.getString("NumeroAtendimentoDB"));
                        dados.put("ds_exame", exameSalvo.getString("ds_exame"));
                        dados.put("CodigoExameDB", exameSalvo.getString("cd_db"));
                        String metodologia = Funcoes.textoVazio(exResultado.getString("DescricaoMetodologia")) ? exameSalvo.getString("metodologia") : exResultado.getString("DescricaoMetodologia");
                        dados.put("metodologia", metodologia);
                        dados.put("material", exResultado.getString("material"));
                        dados.put("Observacao1", exResultado.getString("Observacao1"));
                        dados.put("Observacao2", exResultado.getString("Observacao2"));
                        dados.put("Observacao3", exResultado.getString("Observacao3"));
                        dados.put("Observacao4", exResultado.getString("Observacao4"));
                        dados.put("Observacao5", exResultado.getString("Observacao5"));
                        dados.put("NomeLiberadorClinico", exResultado.getString("NomeLiberadorClinico"));
                        dados.put("DataHoraLiberacaoClinica", exResultado.getString("DataHoraLiberacaoClinica"));
                        Map resultados = exResultado.getValor("ListaResultadoTexto", Map.class);
                        Map resultadosImagem = exResultado.getValor("ListaResultadoImagem", Map.class);
                        Map parametros = exameSalvo.getValor("parametros", Map.class);
                        if (resultados == null || resultados != null && resultados.isEmpty()) {
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + registroExame.getString("req_codigo") + "|" + registroExame.getString("exa_codigo") + " - arquivo de xml n\u00e3o possui resultado verifique com o laborat\u00f3rio de apoio (n\u00famero do atendimento DB = " + requisicao.getString("NumeroAtendimentoDB") + ") ", false);
                            continue;
                        }
                        String resultadoAtual = "";
                        if (null != resultados && !resultados.isEmpty()) {
                            for (String key : resultados.keySet()) {
                                String exaJalis = registroExame.getString(EXAME_PAI);
                                if (Funcoes.textoVazio(exaJalis)) {
                                    resultadoAtual = this.gerarResultadoAtual(dados, resultados, parametros, key, registroExame, resultadoAtual, false);
                                    continue;
                                }
                                Map resultadosFilho = exResultado.getValor("ListaResultadoTexto", Map.class);
                                Map resultadosImagemFilho = exResultado.getValor("ListaResultadoImagem", Map.class);
                                Map parametrosFilho = exResultado.getValor("parametros", Map.class);
                                for (String k : resultadosFilho.keySet()) {
                                    resultadoAtual = this.gerarResultadoAtual(dados, resultadosFilho, parametrosFilho, k, exResultado, resultadoAtual, true);
                                    dados.put("NumeroAtendimentoDB@" + exResultado.getString("exa_codigo") + "#" + exResultado.getString("mco_codigo"), requisicao.getString("NumeroAtendimentoDB"));
                                }
                                if (null == resultadosImagemFilho || resultadosImagemFilho.isEmpty()) continue;
                                for (String k : resultadosImagemFilho.keySet()) {
                                    String imagemResultado = ((Registro)resultadosImagemFilho.get(k)).getString("ValorResultadoImagem");
                                    dados.put(k, imagemResultado);
                                    this.adicionaValorExameDesmemmbrado(registroExame, dados, (Registro)resultadosImagemFilho.get(k));
                                }
                            }
                        }
                        if (null != resultadosImagem && !resultadosImagem.isEmpty()) {
                            for (String key : resultadosImagem.keySet()) {
                                String imagemResultado = ((Registro)resultadosImagem.get(key)).getString("ValorResultadoImagem");
                                dados.put(key, imagemResultado);
                                this.adicionaValorExameDesmemmbrado(registroExame, dados, (Registro)resultadosImagem.get(key));
                            }
                        }
                        Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("pac_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), registroExame.getString("met_codigo"));
                        dados.putAll(RecepcaoUtil.preencheHashDados(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo")));
                        Map<String, Map<String, String>> historicos = this.getHistoricosPorExame(registroExame.getString("exa_codigo"), registroExame.getString("fil_codigo"));
                        if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                            historicos = this.getHistoricosPorFilial(registroExame.getString("fil_codigo"));
                        }
                        Map<String, Object> resposta = Resultado.getCamposResultado(registroExame.getString("exr_resposta"));
                        Resultado res = new Resultado(null, formatacao.getString(FORMATO), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, resultadoAtual);
                        res.atualizarComponentes();
                        if (!res.verificarCondicao()) {
                            this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, Situacao.CONDICAO_INSATISFEITA);
                            this.setTextoInformacoesPadrao("Resultado recebido para", registroExame, Situacao.CONDICAO_INSATISFEITA);
                            continue;
                        }
                        boolean completo = true;
                        boolean processouTodosResultadosDesmembradosDB = false;
                        if (registroExame.getValor(EXAME_PAI) != null) {
                            for (ExameDesmembrado desmReq : desmembradosRetornoDB) {
                                if (!desmReq.getCodigoExame().equals(registroExame.getString(EXAME_PAI)) || desmReq.getCodigomaterial() != registroExame.getInt(MATERIAL_PAI)) continue;
                                desmReq.getFilhos().removeIf(filho -> filho.getCodigoExame().equals(registroExame.getString(EXAME_FILHO)) && filho.getCodigomaterial() == registroExame.getInt("mco_codigo"));
                                if (!desmReq.getFilhos().isEmpty()) continue;
                                processouTodosResultadosDesmembradosDB = true;
                            }
                        }
                        if (processouTodosResultadosDesmembradosDB && !salvaParcial) {
                            boolean resultadoCompleto = res.resultadoCompleto(salvaParcial);
                            ExameDesmembrado examePai = new ExameDesmembrado(registroExame.getString(EXAME_PAI), registroExame.getInt(MATERIAL_PAI));
                            if (!resultadoCompleto && desmembradosRetornoDB.contains(examePai)) {
                                this.service.removerResultadoParcial(registroExame, st);
                                this.setTextoInformacoesPadrao("N\u00e3o foi poss\u00edvel importar", registroExame, Situacao.RESULTADO_INCOMPELTO);
                                continue;
                            }
                        }
                        boolean importacaoUltimo = true;
                        if (registroExame.getValor(EXAME_PAI) != null && !processouTodosResultadosDesmembradosDB) {
                            completo = false;
                            importacaoUltimo = false;
                        } else if (registroExame.getValor(EXAME_PAI) != null && processouTodosResultadosDesmembradosDB) {
                            completo = res.resultadoCompleto(salvaParcial);
                        } else if (salvaParcial) {
                            completo = res.resultadoCompleto(true);
                            importacaoUltimo = res.resultadoCompleto(true);
                        }
                        res.setImportacaoUltimo(importacaoUltimo);
                        String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                        Util.gravaAlteracaoExameRequisicao(st, registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"));
                        boolean marcarConferido = false;
                        if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                            int verificacao = res.verificarValidacao();
                            boolean bl = marcarConferido = verificacao == 1;
                            if (!marcarConferido && verificacao != 2) {
                                this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, Situacao.VALIDACAO_INSATISFEITA);
                                this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + registroExame.getString("req_codigo") + "|" + registroExame.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                            }
                        }
                        if (!this.existeRequisicaoLabExterno(registroExame.getInt("fil_codigo"), this.codigoLabExterno, registroExame.getInt("req_codigo"), requisicao.getString("cd_db"))) {
                            this.inserirDadosRequisicao(st, this.codigoLabExterno, requisicao.getString("NumeroAtendimentoDB"), registroExame.getString("fil_codigo"), registroExame.getInt("req_codigo"));
                        }
                        String novaSituacao = completo ? "L" : "P";
                        boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                        boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                        this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), registroExame, registroExame, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                        if (this.exportarBaseWeb(registroExame.getString("fil_codigo"))) {
                            Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), resultado, false);
                            this.exportarParaWeb(st, this.getCodigoBaseWeb(registroExame.getString("fil_codigo")), novaSituacao, registroExame, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                            if (ExportaWeb.isGerarPdfResultado(st2, registroExame.getString("fil_codigo"))) {
                                ExportaWeb.enviarResultadoPDF(st2, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), this.getCodigoBaseWeb(registroExame.getString("fil_codigo")));
                            }
                        }
                        this.adicionarAoModeloRelatorio(registroExame, requisicao, exResultado, completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE);
                        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registroExame.getDate("exr_datamaterial") : new Date();
                        Date date = horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registroExame.getDate("exr_datamaterial") : new Date();
                        if (completo) {
                            this.atualizarTabelaExamesControle(st, registroExame, res.getResultadoAnterior(dataColeta, horaColeta));
                        }
                        ExportaWeb.atualizaPaginaOrdemExameWeb(st, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), Variaveis.codigoBaseWeb);
                        this.editarRequisicaoExportaFiliais(registroExame);
                        DBUtil.setExameSituacaoInterfaceamento(st, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), 8);
                        String exameImportado = registroExame.getString("exa_codigo");
                        if (!Funcoes.textoVazio(registroExame.getString(EXAME_FILHO))) {
                            String codExame = StringUtil.getValor(registroExame.getString("ele_xmllabexterno"), "cd_db");
                            exameImportado = exameImportado + "(" + codExame + ")";
                        }
                        this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(registroExame.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(registroExame.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + exameImportado + " - " + (completo ? (marcarConferido ? Situacao.CONFERIDO.descricao : Situacao.LANCADO.descricao) : Situacao.LANCADO_PARCIALMENTE.descricao), false);
                    }
                    requisicoesNotificar.put(this.getChaveFilReq(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo")), registroExame.getString("req_codigo"));
                }
            }
        }
        ResultadosUtil.enviarNotificacoes(requisicoesNotificar, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
    }

    protected List<ExameDesmembrado> getExamesDesmembradosRetornoDB(Statement st, String fil_codigo, String req_codigo, List<Registro> exames) throws Exception {
        ArrayList<ExameDesmembrado> desmembradosRequisicao = new ArrayList<ExameDesmembrado>();
        for (Registro resultadoDB : exames) {
            List<ExameDesmembrado> desmembrados = this.carregarDesmembradosPorRequisicao(st, fil_codigo, req_codigo, resultadoDB);
            for (ExameDesmembrado desmembrado : desmembrados) {
                if (desmembradosRequisicao.contains(desmembrado)) {
                    for (ExameDesmembrado desmReq : desmembradosRequisicao) {
                        if (!desmReq.equals(desmembrado)) continue;
                        for (Exame filhoDesm : desmembrado.getFilhos()) {
                            if (desmReq.getFilhos().contains(filhoDesm)) continue;
                            desmReq.getFilhos().add(filhoDesm);
                        }
                    }
                    continue;
                }
                desmembradosRequisicao.addAll(desmembrados);
            }
        }
        return desmembradosRequisicao;
    }

    protected List<ExameDesmembrado> getExamesDesmembradosTmp(List<ExameDesmembrado> desmembradosRetornoDB) {
        ArrayList<ExameDesmembrado> desmembradosTmp = new ArrayList<ExameDesmembrado>();
        for (ExameDesmembrado dr : desmembradosRetornoDB) {
            ExameDesmembrado ed = new ExameDesmembrado(dr.getCodigoExame(), dr.getCodigomaterial());
            for (Exame exa : dr.getFilhos()) {
                ed.addFilho(new Exame(exa.getCodigoExame(), exa.getCodigomaterial()));
            }
            desmembradosTmp.add(ed);
        }
        return desmembradosTmp;
    }

    protected void setTextoInformacoesPadrao(String mensagem, Registro registroExame, Situacao situacao) {
        String codFilial = Funcoes.preencheZero(registroExame.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
        String codRequisicao = Funcoes.preencheZero(registroExame.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
        String codExame = registroExame.getString("exa_codigo");
        String texto = String.format("\n%s: %s%s|%s - %s", mensagem, codFilial, codRequisicao, codExame, situacao.descricao);
        this.setTextoInformacoes(texto, false);
    }

    private List<ExameDesmembrado> carregarDesmembradosPorRequisicao(Statement st, String fil_codigo, String req_codigo, Registro resultadoDB) throws Exception {
        Integer[] integerArray;
        boolean agruparMultiguias;
        Integer[] multiguias = null;
        boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, fil_codigo, req_codigo);
        if (agruparMultiguias) {
            integerArray = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = Integer.parseInt(req_codigo);
        }
        multiguias = integerArray;
        List<ExameDesmembrado> desmembrados = new ArrayList<ExameDesmembrado>();
        for (Integer multiguia : multiguias) {
            if (!this.buscaDadosExameAssociado(fil_codigo, multiguia.toString(), resultadoDB)) continue;
            desmembrados = this.service.getExamesDesmembradosDB(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), (String)resultadoDB.getValor("exa_codigo"), resultadoDB.getValor("mco_codigo").toString());
        }
        return desmembrados;
    }

    protected boolean importarResultadoPdfDb(String[] codigoExameDB, String codigoExame, String codigoMaterial, String codigoApoiado, String numeroAtendimentoApoiado, String enderecoWS, String configuracao) {
        try {
            DBComunicacao comunicacao = new DBComunicacao(configuracao);
            String retornoDB = comunicacao.enviaResultadoBase64(GeradorXmlImportacaoDB.gerarXmlEnviaResultadoBase64(configuracao, "", numeroAtendimentoApoiado, codigoExameDB));
            String linkPDF = StringUtil.getValor(retornoDB, DBCamposRetornoLaudoAtendimento.TAG_LINK_LAUDO.getTag());
            linkPDF = linkPDF.replace("amp;", "");
            URL url = new URL(linkPDF);
            InputStream is = url.openStream();
            ByteArrayOutputStream byos = new ByteArrayOutputStream();
            int bytes = 0;
            while ((bytes = is.read()) != -1) {
                byos.write(bytes);
            }
            is.close();
            String resultadoPDF = new Base64().encodeAsString(byos.toByteArray());
            String filCodigo = numeroAtendimentoApoiado.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = numeroAtendimentoApoiado.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            if (!ResultadosUtil.verificaIntegridadePDFImportado(byos.toByteArray())) {
                this.setTextoInformacoes(String.format("\n%s: %s%s|%s %s", "Resultado de", filCodigo, reqCodigo, codigoExame, "- PDF inv\u00e1lido. Entre com contato com Laborat\u00f3rio DB informando o c\u00f3digo da requisi\u00e7\u00e3o"), false);
                return false;
            }
            this.atualizarExameRequisicaoConferencia(resultadoPDF, codigoExame, codigoMaterial, filCodigo, reqCodigo);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDb2 (486)");
            return false;
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDb2 (570)");
            return false;
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDb2 (591)");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarExameRequisicaoConferencia(String retorno, String codigoExame, String codigoMaterial, String codigoFilial, String codigoRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String resultado = "''";
        String situacao = "";
        Integer[] requisicoes = RecepcaoUtil.verificaMultiGuias(codigoFilial, codigoRequisicao, true);
        if (requisicoes == null) {
            requisicoes = new Integer[]{Integer.valueOf(codigoRequisicao)};
        }
        StringBuilder condicaoRequisicoes = new StringBuilder("(");
        for (Integer req : requisicoes) {
            condicaoRequisicoes.append(req).append(",");
        }
        condicaoRequisicoes.replace(condicaoRequisicoes.length() - 1, condicaoRequisicoes.length(), "");
        condicaoRequisicoes.append(")");
        Statement st = Conexao.getStatement();
        if (!Funcoes.textoVazio(retorno)) {
            resultado = StringUtil.textoDBEscape(retorno);
            situacao = this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) ? "C" : "L";
        }
        sql.append(" update examerequisicaoresultado set ert_resultadopdf = ");
        sql.append(resultado);
        sql.append(" where fil_codigo = ").append(codigoFilial);
        sql.append(" and req_codigo in ").append(condicaoRequisicoes.toString());
        sql.append(" and exa_codigo = '").append(codigoExame).append("'");
        sql.append(" and mco_codigo = '").append(codigoMaterial).append("'");
        Conexao.executeUpdate(codigoFilial, st, sql.toString());
        sql = new StringBuilder();
        sql.append(" update examerequisicao set exr_resultadoempdf = '").append(true).append("'");
        sql.append(" ,exr_situacao = '").append(situacao).append("'");
        if (situacao.equalsIgnoreCase("L") || situacao.equalsIgnoreCase("C")) {
            sql.append(" ,exr_datadigita = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("'");
            sql.append(" ,usr_coddigitador = '").append(Variaveis.login).append("'");
        }
        if (situacao.equalsIgnoreCase("C")) {
            sql.append(" ,exr_dataassina = current_timestamp ");
            sql.append(" ,usr_codassina = '").append(this.codigoUsuarioConferenciaAutomatica).append("'");
        }
        sql.append(" where fil_codigo = ").append(codigoFilial);
        sql.append(" and req_codigo in ").append(condicaoRequisicoes.toString());
        sql.append(" and exa_codigo = '").append(codigoExame).append("'");
        sql.append(" and mco_codigo = '").append(codigoMaterial).append("'");
        Conexao.executeUpdate(codigoFilial, st, sql.toString());
        try {
            Conexao.arquivaSQL();
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
    }

    protected String gerarResultadoAtual(Map<String, Object> dados, Map<String, Registro> resultados, Map<String, Registro> parametros, String key, Registro reg, String resultadoAtual, boolean isDesm) {
        String valorResultado = resultados.get(key).getString("ValorResultado");
        String valorRef = resultados.get(key).getString("valorReferencia");
        String unidadeMedida = resultados.get(key).getString("UnidadeMedida");
        if (key.equals("NotaFixa")) {
            String descricaoParametro = resultados.get(key).getString("DescricaoParametrosDB");
            dados.put(key, descricaoParametro);
        } else {
            dados.put(key, valorResultado);
        }
        if (Funcoes.textoVazio(valorRef) && parametros != null && parametros.containsKey(key) && parametros.get(key).getValor("valorReferencia", Registro.class) != null) {
            valorRef = parametros.get(key).getValor("valorReferencia", Registro.class).getString("valorRef");
        }
        if (Funcoes.textoVazio(unidadeMedida) && parametros != null && parametros.containsKey(key)) {
            unidadeMedida = parametros.get(key).getString("unidade");
        }
        if (isDesm) {
            dados.put("ds_exame@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("ds_exame"));
            dados.put(String.format("%s_%s", "valorRef", key) + "@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), valorRef);
            dados.put(String.format("%s_%s", "unidade", key) + "@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), unidadeMedida);
            dados.put("CodigoExameDB@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("CodigoExameDB"));
            dados.put("metodologia@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("DescricaoMetodologia"));
            dados.put("material@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("material"));
            dados.put("Observacao1@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("Observacao1"));
            dados.put("Observacao2@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("Observacao2"));
            dados.put("Observacao3@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("Observacao3"));
            dados.put("Observacao4@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("Observacao4"));
            dados.put("Observacao5@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("Observacao5"));
            dados.put("NomeLiberadorClinico@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("NomeLiberadorClinico"));
            dados.put("DataHoraLiberacaoClinica@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo"), reg.getString("DataHoraLiberacaoClinica"));
        } else {
            dados.put(String.format("%s_%s", "valorRef", key), valorRef);
            dados.put(String.format("%s_%s", "unidade", key), unidadeMedida);
        }
        resultadoAtual = this.getXmlResultadoAtual(reg, resultadoAtual, valorResultado);
        this.adicionaValorExameDesmemmbrado(reg, dados, resultados.get(key));
        return resultadoAtual;
    }

    protected String getXmlResultadoAtual(Registro reg, String resultadoAtual, String linhaResultado) {
        String tag = reg.getValor("exa_codigo") != null ? reg.getValor("exa_codigo").toString() : reg.getValor(EXAME_FILHO).toString();
        tag = tag.toLowerCase();
        resultadoAtual = resultadoAtual + "<" + tag + ">";
        resultadoAtual = resultadoAtual + linhaResultado;
        resultadoAtual = resultadoAtual + "</" + tag + ">";
        return resultadoAtual;
    }

    protected void adicionaValorExameDesmemmbrado(Registro reg, Map<String, Object> dados, Registro linha) {
        if (reg.getString("exa_codigo") != null && !Funcoes.textoVazio(reg.getString("exa_codigo"))) {
            String chaveResultado = linha.getString("CodigoParametroDB") + "@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo");
            dados.put(chaveResultado, linha.getValor("ValorResultado"));
        }
    }

    protected LinkedList<Registro> processarPaiFilhos(Statement st, Registro requisicao, Registro exResultado, String fil_codigo, String req_codigo) throws Exception {
        boolean agruparMultiguias;
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        Integer[] multiguias = null;
        Registro reg = null;
        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias;
        if (agruparMultiguias) {
            if (requisicao.getValor("NumeroAtendimentoApoiado").toString().length() != tamTubo || !Funcoes.isNumeric(requisicao.getValor("NumeroAtendimentoApoiado").toString())) {
                this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + requisicao.getValor("NumeroAtendimentoApoiado").toString(), false);
                return retorno;
            }
            multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
        } else {
            if (requisicao.getValor("NumeroAtendimentoApoiado").toString().length() != tamTubo || !Funcoes.isNumeric(requisicao.getValor("NumeroAtendimentoApoiado").toString())) {
                this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + requisicao.getValor("NumeroAtendimentoApoiado").toString(), false);
                return retorno;
            }
            multiguias = new Integer[]{Integer.parseInt(req_codigo)};
        }
        for (Integer multiguia : multiguias) {
            String codigoJalisAux = (String)requisicao.getValor("NumeroAtendimentoApoiado");
            requisicao.setValor("NumeroAtendimentoApoiado", StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1));
            Registro exameSeparado = this.localizaExameRequisicao(requisicao, exResultado, st, false);
            if (exameSeparado != null) {
                retorno.add(exameSeparado);
            }
            if (this.buscaDadosExameAssociado(fil_codigo, multiguia.toString(), exResultado)) {
                List<ExameDesmembrado> listaExamesPai = this.service.getExamesDesmembradosDB(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), (String)exResultado.getValor("exa_codigo"), exResultado.getValor("mco_codigo").toString());
                for (ExameDesmembrado pai : listaExamesPai) {
                    String codigoJalisTemp = (String)exResultado.getValor("exa_codigo");
                    exResultado.setValor("exa_codigo", pai.getCodigoExame());
                    exResultado.setValor("mco_codigo", pai.getCodigomaterial());
                    reg = this.localizaExameRequisicao(requisicao, exResultado, st, true);
                    if (reg == null) continue;
                    reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                    reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                    reg.setValor(EXAME_PAI, pai.getCodigoExame());
                    reg.setValor(MATERIAL_PAI, pai.getCodigomaterial());
                    reg.setValor(EXAME_FILHO, pai.getFilhos().get(0).getCodigoExame());
                    exResultado.setValor("exa_codigo", codigoJalisTemp);
                    retorno.add(reg);
                }
            }
            requisicao.setValor("NumeroAtendimentoApoiado", codigoJalisAux);
        }
        if (retorno.isEmpty()) {
            String req = requisicao.getString("NumeroAtendimentoApoiado");
            this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame " + exResultado.getString("CodigoExameDB").toUpperCase() + " na requisi\u00e7\u00e3o do Jalis Fil.: %s Req.: %s. C\u00f3digo DB:%s ", req.substring(0, ParametrosGerais.getDigitosTuboFilial()), req.substring(ParametrosGerais.getDigitosTuboFilial()), requisicao.getString("NumeroAtendimentoDB")), false);
            this.adicionarAoModeloRelatorio(reg, requisicao, exResultado, Situacao.NAO_LOCALIZADO);
        }
        return retorno;
    }

    private boolean isAgruparMultguia(Statement st, String fil_codigo, String req_codigo) throws SQLException {
        Integer[] multiguia = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, fil_codigo, req_codigo) || !Funcoes.objectIsNull(multiguia) && multiguia.length > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean buscaDadosExamesFilhos(String fil_codigo, String req_codigo, Registro exResultado) throws SQLException {
        Statement st;
        block4: {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT a.exa_codigo as examepai, ");
            sql.append(" e.exa_kodigo as examefilho, ");
            sql.append(" a.mco_codigo, ");
            sql.append(" p.ele_xmllabexterno ");
            sql.append(" \t\tFROM examerequisicao a ");
            sql.append(" \t\t\tJOIN examematcoletalabextdesm e ON a.fil_codigo = e.fil_codigo ");
            sql.append(" \t\t\t\tAND a.exa_codigo = e.exa_codigo ");
            sql.append(" \t\t\t\tAND a.mco_codigo = e.mco_codigo ");
            sql.append(" \t\t\tJOIN examematcoletalabexterno p ON e.fil_codigo = p.fil_codigo ");
            sql.append(" \t\t\t\tAND e.exa_kodigo = p.exa_codigo ");
            sql.append(" \t\t\t\tAND e.mco_codigo = p.mco_codigo ");
            sql.append(" \t\t\t\tAND e.lae_codigo = p.lae_codigo ");
            sql.append(" WHERE a.fil_codigo = ").append(fil_codigo);
            sql.append(" \t\tAND a.req_codigo = ").append(req_codigo);
            sql.append("    AND e.exa_codigo = '").append(exResultado.getString("exa_codigo")).append("' ");
            sql.append("    AND upper(p.ele_xmllabexterno) ilike '%<").append("cd_db").append(">%'");
            sql.append(" \t\tAND p.ele_xmllabexterno is not null and p.ele_xmllabexterno <> '' ");
            st = Conexao.getStatement();
            ResultSet resultSet = null;
            ArrayList<Registro> examesFilhos = new ArrayList<Registro>();
            try {
                resultSet = Conexao.executeQuery(st, sql);
                while (resultSet.next()) {
                    Registro exame = new Registro(resultSet);
                    examesFilhos.add(exame.clone());
                }
                exResultado.setValor("examesFilhos", examesFilhos);
                if (resultSet == null) break block4;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                Conexao.fecharStatement(st);
                throw throwable;
            }
            resultSet.close();
        }
        Conexao.fecharStatement(st);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buscaDadosExameAssociado(String fil_codigo, String req_codigo, Registro exResultado) throws SQLException {
        ResultSet resultSet;
        Statement st;
        block4: {
            boolean bl;
            block5: {
                StringBuilder sql = new StringBuilder();
                sql.append(" SELECT a.exa_codigo as examepai, ");
                sql.append(" e.exa_kodigo as examefilho, ");
                sql.append(" a.mco_codigo, ");
                sql.append(" p.ele_xmllabexterno ");
                sql.append(" \t\tFROM examerequisicao a ");
                sql.append(" \t\t\tJOIN examematcoletalabextdesm e ON a.fil_codigo = e.fil_codigo ");
                sql.append(" \t\t\t\tAND a.exa_codigo = e.exa_codigo ");
                sql.append(" \t\t\t\tAND a.mco_codigo = e.mco_codigo ");
                sql.append(" \t\t\tJOIN examematcoletalabexterno p ON e.fil_codigo = p.fil_codigo ");
                sql.append(" \t\t\t\tAND e.exa_kodigo = p.exa_codigo ");
                sql.append(" \t\t\t\tAND e.mco_codigo = p.mco_codigo ");
                sql.append(" \t\t\t\tAND e.lae_codigo = p.lae_codigo ");
                sql.append(" WHERE a.fil_codigo = ").append(fil_codigo);
                sql.append(" \t\tAND a.req_codigo = ").append(req_codigo);
                sql.append("    AND upper(p.ele_xmllabexterno) ilike '%<").append("cd_db").append(">").append(exResultado.getString("CodigoExameDB").toUpperCase()).append("</").append("cd_db").append(">%'");
                sql.append(" \t\tAND p.ele_xmllabexterno is not null and p.ele_xmllabexterno <> '' ");
                st = Conexao.getStatement();
                resultSet = null;
                try {
                    resultSet = Conexao.executeQuery(st, sql);
                    if (!resultSet.next()) break block4;
                    exResultado.setValor("exa_codigo", resultSet.getString("examefilho"));
                    exResultado.setValor("mco_codigo", resultSet.getString("mco_codigo"));
                    exResultado.setValor("ele_xmllabexterno", resultSet.getString("ele_xmllabexterno"));
                    bl = true;
                    if (resultSet == null) break block5;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                resultSet.close();
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        Conexao.fecharStatement(st);
        return false;
    }

    protected Registro parse(List<Element> elementosFilhos) {
        Registro lote = new Registro();
        for (Element element : elementosFilhos) {
            if (element.getNodeName().equalsIgnoreCase("NumeroLote")) {
                lote.setValor("NumeroLote", element.getTextContent());
                continue;
            }
            if (element.getNodeName().equalsIgnoreCase("CodigoApoiado")) {
                lote.setValor("CodigoApoiado", element.getTextContent());
                continue;
            }
            if (!element.getNodeName().equalsIgnoreCase("ListaResultados") || !element.hasChildNodes()) continue;
            this.parseRequisicoes(XMLUtil.getElementosFilhos(element), lote);
        }
        return lote;
    }

    private void parseRequisicoes(List<Element> requisicoes, Registro lote) {
        ArrayList<Registro> listaReq = new ArrayList<Registro>();
        for (Element element : requisicoes) {
            if (!element.getNodeName().equalsIgnoreCase("ct_Resultado_v1") || !element.hasChildNodes()) continue;
            Registro requisicao = new Registro();
            ArrayList<Registro> listaExames = new ArrayList<Registro>();
            for (Element dados : XMLUtil.getElementosFilhos(element)) {
                if (dados.getNodeName().equalsIgnoreCase("NumeroAtendimentoApoiado")) {
                    requisicao.setValor("NumeroAtendimentoApoiado", dados.getTextContent());
                    continue;
                }
                if (dados.getNodeName().equalsIgnoreCase("NumeroAtendimentoDB")) {
                    requisicao.setValor("NumeroAtendimentoDB", dados.getTextContent());
                    continue;
                }
                if (dados.getNodeName().equalsIgnoreCase("RGPacienteApoiado")) {
                    requisicao.setValor("RGPacienteApoiado", dados.getTextContent());
                    continue;
                }
                if (dados.getNodeName().equalsIgnoreCase("RGPacienteDB")) {
                    requisicao.setValor("RGPacienteDB", dados.getTextContent());
                    continue;
                }
                if (!dados.getNodeName().equalsIgnoreCase("ListaResultadoProcedimentos") || !dados.hasChildNodes()) continue;
                for (Element eleExame : XMLUtil.getElementosFilhos(dados)) {
                    if (!eleExame.getNodeName().equalsIgnoreCase("ct_ResultadoProcedimentos_v1") || !eleExame.hasChildNodes()) continue;
                    listaExames.add(this.parseExame(XMLUtil.getElementosFilhos(eleExame)));
                }
            }
            requisicao.setValor("ListaResultadoProcedimentos", listaExames);
            listaReq.add(requisicao);
        }
        lote.setValor("ct_Resultado_v1", listaReq);
    }

    private Registro parseExame(List<Element> elementosFilhos) {
        Registro exame = new Registro();
        for (Element eleExame : elementosFilhos) {
            if (eleExame.getNodeName().equalsIgnoreCase("CodigoExameDB")) {
                exame.setValor("CodigoExameDB", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("VersaoLaudo")) {
                exame.setValor("VersaoLaudo", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("DescricaoMetodologia")) {
                exame.setValor("DescricaoMetodologia", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("material")) {
                exame.setValor("material", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("DescricaoRegiaoColeta")) {
                exame.setValor("DescricaoRegiaoColeta", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("DataHoraLiberacaoClinica")) {
                exame.setValor("DataHoraLiberacaoClinica", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("NomeLiberadorClinico")) {
                exame.setValor("NomeLiberadorClinico", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("Observacao1")) {
                exame.setValor("Observacao1", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("Observacao2")) {
                exame.setValor("Observacao2", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("Observacao3")) {
                exame.setValor("Observacao3", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("Observacao4")) {
                exame.setValor("Observacao4", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("Observacao5")) {
                exame.setValor("Observacao5", eleExame.getTextContent());
                continue;
            }
            if (eleExame.getNodeName().equalsIgnoreCase("ListaResultadoTexto") && eleExame.hasChildNodes()) {
                this.parseResultado(exame, XMLUtil.getElementosFilhos(eleExame));
                continue;
            }
            if (!eleExame.getNodeName().equalsIgnoreCase("ListaResultadoImagem") || !eleExame.hasChildNodes()) continue;
            this.parseResultadoImagem(exame, XMLUtil.getElementosFilhos(eleExame));
        }
        return exame;
    }

    private void parseResultado(Registro exame, List<Element> elementosFilhos) {
        HashMap<String, Registro> resultados = new HashMap<String, Registro>();
        for (Element element : elementosFilhos) {
            Registro res = new Registro();
            if (element.getNodeName().equalsIgnoreCase("ct_ResultadoTexto_v1") && element.hasChildNodes()) {
                for (Element resultado : XMLUtil.getElementosFilhos(element)) {
                    if (resultado.getNodeName().equalsIgnoreCase("CodigoParametroDB")) {
                        res.setValor("CodigoParametroDB", resultado.getTextContent());
                    }
                    if (resultado.getNodeName().equalsIgnoreCase("DescricaoParametrosDB")) {
                        res.setValor("DescricaoParametrosDB", resultado.getTextContent());
                        continue;
                    }
                    if (resultado.getNodeName().equalsIgnoreCase("ValorResultado")) {
                        res.setValor("ValorResultado", resultado.getTextContent());
                        continue;
                    }
                    if (resultado.getNodeName().equalsIgnoreCase("UnidadeMedida")) {
                        res.setValor("UnidadeMedida", resultado.getTextContent());
                        continue;
                    }
                    if (!resultado.getNodeName().equalsIgnoreCase("valorReferencia")) continue;
                    res.setValor("valorReferencia", resultado.getTextContent());
                }
            }
            resultados.put(res.getString("CodigoParametroDB"), res);
        }
        exame.setValor("ListaResultadoTexto", resultados);
    }

    private void parseResultadoImagem(Registro exame, List<Element> elementosFilhos) {
        HashMap<String, Registro> resultados = new HashMap<String, Registro>();
        for (Element element : elementosFilhos) {
            Registro res = new Registro();
            if (element.getNodeName().equalsIgnoreCase("ct_ResultadoImagem_v1") && element.hasChildNodes()) {
                for (Element resultado : XMLUtil.getElementosFilhos(element)) {
                    if (resultado.getNodeName().equalsIgnoreCase("CodigoParametroDB")) {
                        res.setValor("CodigoParametroDB", resultado.getTextContent());
                        continue;
                    }
                    if (!resultado.getNodeName().equalsIgnoreCase("ValorResultadoImagem")) continue;
                    res.setValor("ValorResultadoImagem", resultado.getTextContent());
                }
            }
            resultados.put(res.getString("CodigoParametroDB"), res);
        }
        exame.setValor("ListaResultadoImagem", resultados);
    }

    private Registro localizaExameRequisicao(Registro requisicao, Registro exame, Statement st, boolean procuraDesm) throws SQLException {
        String fil = "";
        Registro reg = null;
        String req = requisicao.getString("NumeroAtendimentoApoiado");
        if (Funcoes.textoVazio(req) || req.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            this.adicionarAoModeloRelatorio(reg, requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Sem c\u00f3digo de requisi\u00e7\u00e3o no Jalis. C\u00f3digo DB: " + requisicao.getString("NumeroAtendimentoApoiado"), false);
            return null;
        }
        fil = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
        req = req.substring(ParametrosGerais.getDigitosTuboFilial());
        if (!Funcoes.isNumeric(fil) || !Funcoes.isNumeric(req)) {
            this.adicionarAoModeloRelatorio(reg, requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Filial ou requisi\u00e7\u00e3o incorreta. C\u00f3digo DB: " + requisicao.getString("NumeroAtendimentoApoiado"), false);
            return null;
        }
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, \n");
        sql.append("  b.exa_codigo,b.exr_resposta, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(g.met_codigo, b.met_codigo) as met_codigo, \n");
        sql.append("  a.req_idade, a.req_anomes, b.exr_datamaterial, \n");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, \n");
        sql.append("  a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao \n");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo \n");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        sql.append("  a.req_excluida = false and b.exr_excluido = false \n");
        if (!Funcoes.textoVazio(exame.getString("exa_codigo")) && !Funcoes.textoVazio(exame.getString("mco_codigo"))) {
            sql.append(" and b.exa_codigo = '").append(exame.getString("exa_codigo")).append("' \n");
            sql.append(" and b.mco_codigo = ").append(exame.getString("mco_codigo")).append(" \n");
        } else {
            sql.append("  and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
            sql.append("  and upper(g.ele_xmllabexterno) ilike '%<").append("cd_db").append(">").append(exame.getString("CodigoExameDB").toUpperCase()).append("</").append("cd_db").append(">%'");
        }
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        if (res.next()) {
            reg = new Registro(res);
            reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(fil, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(fil, reg.getString(CODIGO_LAYOUT)));
            Registro formatacao = new Registro();
            formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor(FORMATACAO, formatacao);
            exame.setValor("exa_codigo", res.getString("exa_codigo"));
            exame.setValor("mco_codigo", res.getInt("mco_codigo"));
            return reg;
        }
        return null;
    }

    protected void adicionarAoModeloRelatorio(Registro reg, Registro requisicao, Registro exame, Situacao situacao) {
        if (requisicao.getString("NumeroAtendimentoApoiado").length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboFilial()) {
            return;
        }
        String fil_codigo = requisicao.getString("NumeroAtendimentoApoiado").substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = "";
        req_codigo = reg != null ? reg.getString("req_codigo") : requisicao.getString("NumeroAtendimentoApoiado").substring(ParametrosGerais.getDigitosTuboFilial());
        String exa = exame.getString("exa_codigo");
        String mco = exame.getString("mco_codigo");
        if (!Funcoes.textoVazio(exa) && !Funcoes.textoVazio(mco)) {
            String exames = "";
            Statement st = Conexao.getStatement();
            try {
                ExameDesmembrado pai;
                exames = BDUtil.getCodigoExames(fil_codigo, req_codigo, st);
                if (!Funcoes.textoVazio(exames) && !exames.contains(exa) && (pai = this.getExamesDesmembrados(fil_codigo, req_codigo, String.valueOf(this.codigoLabExterno), exa, mco)) != null) {
                    exa = pai.getCodigoExame();
                    mco = String.valueOf(pai.getCodigomaterial());
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDb2 (1264)");
            }
        }
        if (exame != null && !Funcoes.textoVazio(exame.getString("exa_codigo")) && !Funcoes.textoVazio(exame.getString("mco_codigo"))) {
            RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, fil_codigo, req_codigo, exa, Integer.parseInt(mco), situacao.descricao);
        }
    }

    protected boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    protected boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao")) || reg.getString("exr_situacao").equals("P");
    }

    protected boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next() && rs.getInt("lae_codigo") == this.codigoLabExterno) {
                String xml = rs.getString("ele_xmllabexterno");
                reg.setValor("ele_xmllabexterno", xml);
                exa = StringUtil.getValor(xml, "cd_exame");
                mco = StringUtil.getValor(xml, "material");
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("select edb_xml from examesdb where fil_codigo = ").append(fil);
                sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                sqlBuilder.append(" and edb_codexame = '").append(exa).append("' and edb_descricaomaterial = '").append(mco).append("' ");
                rs = st.executeQuery(sqlBuilder.toString());
                if (rs.next()) {
                    reg.setValor("edb_xml", rs.getString("edb_xml"));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected Registro localizarFormatacao(Registro reg) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                int codLay = Integer.parseInt(reg.getString(CODIGO_LAYOUT));
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  c.met_codigo, \n");
                bui.append("  b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, b.ela_padrao \n");
                bui.append("from examematcoleta a \n");
                bui.append("left join examelayout b \n");
                bui.append("  on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo \n");
                bui.append("left join examematcoletalabexterno c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append("where \n");
                bui.append("  a.fil_codigo = ").append(reg.getString("fil_codigo")).append(" and \n");
                bui.append("  a.exa_codigo = '").append(reg.getString("exa_codigo")).append("' and \n");
                bui.append("  a.mco_codigo = ").append(reg.getString("mco_codigo")).append(" and \n");
                bui.append("  c.lae_codigo = ").append(this.codigoLabExterno);
                bui.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                int linha = 0;
                while (rs.next()) {
                    boolean idadeZero;
                    boolean padrao = rs.getBoolean("ela_padrao");
                    boolean interValido = codLay == rs.getInt("lay_codigo") && this.pertenceAoIntervalo(rs, reg);
                    boolean bl = idadeZero = codLay == rs.getInt("lay_codigo") && rs.getInt("ela_idadeini") == 0 && rs.getInt("ela_idadefim") == 0;
                    if ((!padrao || linha != 0) && !idadeZero && !interValido) continue;
                    linha = rs.getRow();
                    if (!interValido) continue;
                    break;
                }
                if (linha > 0) {
                    rs.first();
                    while (rs.getRow() < linha && rs.next()) {
                    }
                    bui.setLength(0);
                    bui.append("select \n");
                    bui.append("  a.elm_formato as ").append(FORMATO).append(", \n");
                    bui.append("  a.elm_exportartexto as ").append(FORMATO_TEXTO).append(", \n");
                    bui.append("  b.met_codigo \n");
                    bui.append("from examelayoutmetodo a \n");
                    bui.append("left join metodologia b \n");
                    bui.append("  on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo \n");
                    bui.append("where \n");
                    bui.append("  a.fil_codigo = ").append(reg.getString("fil_codigo")).append(" and \n");
                    bui.append("  a.exa_codigo = '").append(reg.getString("exa_codigo")).append("' and \n");
                    bui.append("  a.mco_codigo = ").append(reg.getString("mco_codigo")).append(" and \n");
                    bui.append("  a.lay_codigo = ").append(rs.getString("lay_codigo")).append(" and \n");
                    bui.append("  a.ela_idadeini = ").append(rs.getString("ela_idadeini")).append(" and \n");
                    bui.append("  a.ela_idadefim = ").append(rs.getString("ela_idadefim")).append(" and \n");
                    bui.append("  a.ela_idadeinitipo = '").append(rs.getString("ela_idadeinitipo")).append("' and \n");
                    bui.append("  a.ela_idadefimtipo = '").append(rs.getString("ela_idadefimtipo")).append("' and \n");
                    bui.append("  b.met_codigo = ").append(rs.getString("met_codigo"));
                    rs = Conexao.executeQuery(st, bui.toString());
                    if (rs.next()) {
                        return new Registro(rs);
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAtitude: 1241");
            }
        }
        return null;
    }

    @Override
    protected boolean pertenceAoIntervalo(ResultSet res, Registro pac) throws SQLException {
        int idadePac = pac.getInt("req_idade") * this.diasTipo(pac.getString("req_anomes"));
        int ini = res.getInt("ela_idadeini") * this.diasTipo(res.getString("ela_idadeinitipo"));
        int fim = res.getInt("ela_idadefim") * this.diasTipo(res.getString("ela_idadefimtipo"));
        return ini <= idadePac && idadePac <= fim;
    }

    @Override
    protected int diasTipo(String tipo) {
        if ("A".equals(tipo)) {
            return 365;
        }
        if ("M".equals(tipo)) {
            return 31;
        }
        return 1;
    }

    protected void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAtitude 784");
        }
    }

    protected Integer[] verificarRequisicaoMultiguia(String codFilial, String codRequisicao) throws SQLException {
        Integer[] multiguias = null;
        multiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true) : new Integer[]{Integer.parseInt(codRequisicao)};
        return multiguias;
    }

    protected String getChaveFilReq(String fil_codigo, String req_codigo) {
        return fil_codigo + "-" + req_codigo;
    }

    protected Map<String, Map<String, String>> getHistoricosPorExame(String codigoExame, String codigoFilial) {
        HashMap<String, Map<String, Map<String, String>>> tmp = new HashMap<String, Map<String, Map<String, String>>>();
        String key = codigoFilial + "|" + codigoExame;
        if (this.historicosExame == null || this.historicosExame.isEmpty()) {
            tmp.put(key, ExameUtil.getHistoricos(codigoExame, codigoFilial));
            this.historicosExame = tmp;
        } else if (this.historicosExame.get(key) == null || this.historicosExame.get(key).isEmpty()) {
            tmp.put(key, ExameUtil.getHistoricos(codigoExame, codigoFilial));
            this.historicosExame = tmp;
        }
        return this.historicosExame.get(key);
    }

    protected Map<String, Map<String, String>> getHistoricosPorFilial(String codigoFilial) {
        HashMap<String, Map<String, Map<String, String>>> tmp = new HashMap<String, Map<String, Map<String, String>>>();
        if (this.historicosExameFilial == null || this.historicosExameFilial.isEmpty()) {
            tmp.put(codigoFilial, ExameUtil.getHistoricos(null, codigoFilial));
            this.historicosExameFilial = tmp;
        } else if (this.historicosExameFilial.get(codigoFilial) == null || this.historicosExameFilial.get(codigoFilial).isEmpty()) {
            tmp.put(codigoFilial, ExameUtil.getHistoricos(null, codigoFilial));
            this.historicosExameFilial = tmp;
        }
        return this.historicosExameFilial.get(codigoFilial);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    @Override
    protected void importarResultadoWs() {
    }

    @Override
    protected void consultarPendencias() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        RESULTADO_INCOMPELTO("N\u00e3o Importado - Resultado Incompleto"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_RELACIONAMENTO("Sem relacionamento"),
        SEM_MATERIAL("Sem material"),
        LAYOUT_ATUALIZADO("Layout atualizado, mas n\u00e3o relacionado");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

