/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.db2.ParserImportacaoDB;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.util.Map;
import javax.swing.JFileChooser;

public class ImportacaoDB
extends AbstractImportadorLabExterno {
    public ImportacaoDB(int codigoLabExterno, String titulo, String descricao, Protocolo protocolo) {
        super(titulo, descricao, codigoLabExterno, protocolo);
        this.protocolo = protocolo;
        this.getButtonImportar().setText("Importar Exames");
    }

    public ImportacaoDB(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. DB partir de arquivo XML", codigoLabExterno, Protocolo.DBV2);
        this.getButtonImportar().setText("Importar Exames");
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
    }

    @Override
    public boolean importarArquivo() {
        boolean retorno = true;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS/XML do Lab. " + this.protocolo.getCodigo() + " (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0) {
                StringBuilder bui = new StringBuilder();
                bui.append("Importando exames...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                Map<String, Registro> excluidos = new ParserImportacaoDB().importarExamesDB(chooser, this.codigoLabExterno, this.progress);
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (!excluidos.isEmpty()) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (Registro registro : excluidos.values()) {
                    }
                    bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
                retorno = true;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoDB: 67");
        }
        this.progress.setVisible(false);
        return retorno;
    }
}

