/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.laboratorio.triagem.externo.exportadores.db2.EscreverXmlDB;
import jalis.laboratorio.util.parsers.db2.DBCamposEnvioLaudoAtendimento;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilderException;

public class GeradorXmlImportacaoDB {
    private static final String SENHA = "senha";
    private static final String CODIGO = "codigo";

    private GeradorXmlImportacaoDB() {
    }

    public static String gerarXmlEnviarLaudo(String configuracaoLabExterno, String numeroAtendimentoApoiado) throws XMLStringBuilderException {
        String codigoConfiguracao = StringUtil.getValor(configuracaoLabExterno, CODIGO);
        String senhaIntegracao = StringUtil.getValor(configuracaoLabExterno, SENHA);
        EscreverXmlDB xml = new EscreverXmlDB();
        GeradorXmlImportacaoDB.comecoArquivoSQL(xml);
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_ENVIA_LAUDO_ATENDIMENTO.getTag());
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_APOIADO.getTag(), codigoConfiguracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_SENHA_INTEGRACAO.getTag(), senhaIntegracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag(), numeroAtendimentoApoiado);
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_ENVIA_LAUDO_ATENDIMENTO.getTag());
        GeradorXmlImportacaoDB.fecharArquivoSQL(xml);
        return xml.getXML();
    }

    public static String gerarXmlEnviaLoteResultados(String configuracaoLabExterno) throws XMLStringBuilderException {
        String codigoConfiguracao = StringUtil.getValor(configuracaoLabExterno, CODIGO);
        String senhaIntegracao = StringUtil.getValor(configuracaoLabExterno, SENHA);
        EscreverXmlDB xml = new EscreverXmlDB();
        GeradorXmlImportacaoDB.comecoArquivoSQL(xml);
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_ENVIA_LOTE_RESULTADO.getTag());
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_APOIADO.getTag(), codigoConfiguracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_SENHA_INTEGRACAO.getTag(), senhaIntegracao);
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_LOTE_RESULTADO.getTag());
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_LOTE_RESULTADO.getTag());
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_ENVIA_LOTE_RESULTADO.getTag());
        GeradorXmlImportacaoDB.fecharArquivoSQL(xml);
        return xml.getXML();
    }

    public static String gerarXmlEnviaLaudoAtendimentoPorPeriodo(String configuracaoLabExterno, String dataInicial, String dataFinal) throws XMLStringBuilderException {
        String codigoConfiguracao = StringUtil.getValor(configuracaoLabExterno, CODIGO);
        String senhaIntegracao = StringUtil.getValor(configuracaoLabExterno, SENHA);
        EscreverXmlDB xml = new EscreverXmlDB();
        GeradorXmlImportacaoDB.comecoArquivoSQL(xml);
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_ENVIA_LAUDO_ATENDIMENTO_PERIODO.getTag());
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_APOIADO.getTag(), codigoConfiguracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_SENHA_INTEGRACAO.getTag(), senhaIntegracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_DATA_INICIAL.getTag(), dataInicial);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_DATA_FINAL.getTag(), dataFinal);
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_ENVIA_LAUDO_ATENDIMENTO_PERIODO.getTag());
        GeradorXmlImportacaoDB.fecharArquivoSQL(xml);
        return xml.getXML();
    }

    public static String gerarXmlListaProcedimentosPendentes(String configuracaoLabExterno, String dataInicial, String dataFinal) throws XMLStringBuilderException {
        String codigoConfiguracao = StringUtil.getValor(configuracaoLabExterno, CODIGO);
        String senhaIntegracao = StringUtil.getValor(configuracaoLabExterno, SENHA);
        EscreverXmlDB xml = new EscreverXmlDB();
        GeradorXmlImportacaoDB.comecoArquivoSQL(xml);
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_LISTA_PROCEDIMENTOS_PENDENTES.getTag());
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_APOIADO.getTag(), codigoConfiguracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_SENHA_INTEGRACAO.getTag(), senhaIntegracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_DATA_INICIAL.getTag(), dataInicial);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_DATA_FINAL.getTag(), dataFinal);
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_LISTA_PROCEDIMENTOS_PENDENTES.getTag());
        GeradorXmlImportacaoDB.fecharArquivoSQL(xml);
        return xml.getXML();
    }

    public static String gerarXmlEnviaResultadoBase64(String configuracaoLabExterno, String tipoCabecalho, String numeroAtendimento, String[] codigosExames) throws XMLStringBuilderException {
        String codigoConfiguracao = StringUtil.getValor(configuracaoLabExterno, CODIGO);
        String senhaIntegracao = StringUtil.getValor(configuracaoLabExterno, SENHA);
        EscreverXmlDB xml = new EscreverXmlDB();
        GeradorXmlImportacaoDB.comecoArquivoSQL(xml);
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_ENVIA_RESULTADO_BASE_64.getTag());
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_APOIADO.getTag(), codigoConfiguracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_SENHA_INTEGRACAO.getTag(), senhaIntegracao);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_TIPO_CABECALHO.getTag(), tipoCabecalho);
        xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag(), numeroAtendimento);
        xml.abrir(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_EXAME_DB.getTag());
        for (String codigoExame : codigosExames) {
            xml.escrever(DBCamposEnvioLaudoAtendimento.TAG_STRING.getTag(), codigoExame);
        }
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_CODIGO_EXAME_DB.getTag());
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_REQUEST.getTag());
        xml.fechar(DBCamposEnvioLaudoAtendimento.TAG_ENVIA_RESULTADO_BASE_64.getTag());
        GeradorXmlImportacaoDB.fecharArquivoSQL(xml);
        return xml.getXML();
    }

    private static void fecharArquivoSQL(EscreverXmlDB xml) {
        xml.escrever("</soapenv:Body>");
        xml.escrever("</soapenv:Envelope>");
    }

    private static void comecoArquivoSQL(EscreverXmlDB xml) {
        xml.escrever("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:diag=\"http://diagnosticosdobrasil.com.br\">");
        xml.escrever("<soapenv:Header/>");
        xml.escrever("<soapenv:Body>");
    }
}

