/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.cadastro.exame.MotivoRecoletaBean;
import jalis.service.cadastro.exame.MotivoRecoletaService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConsultarPendenciasDB
extends AbstractDialogoOKCancelar {
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JLabel labelMotivo = new JLabel("Motivo:");
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JCheckBox checkMarcarRecoleta = new JCheckBox("Marcar exames com Recoleta");
    private JComboBox comboMotivos = new JComboBox();
    public static final String PARAMETRO_IMPORTAR_RESULTADO_DB = "ImportarResultadosDB.consultarPendencias";
    private boolean isOk = false;
    private String dataInicial = null;
    private String dataFinal = null;

    public static ConsultarPendenciasDB novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConsultarPendenciasDB((Dialog)pai, "Consultar amostras pendentes");
        }
        return new ConsultarPendenciasDB((Frame)pai, "Consultar amostras pendentes");
    }

    public ConsultarPendenciasDB(Dialog pai, String titulo) {
        super(pai, titulo);
        this.buttonOK.setText("Consultar");
        this.montaTela();
    }

    public ConsultarPendenciasDB(Frame pai, String titulo) {
        super(pai, titulo);
        this.buttonOK.setText("Consultar");
        this.montaTela();
    }

    private void montaTela() {
        this.textDataInicial.setPreferredSize(new Dimension(100, 20));
        this.textDataInicial.setMinimumSize(new Dimension(100, 20));
        this.textDataFinal.setPreferredSize(new Dimension(100, 20));
        this.textDataFinal.setMinimumSize(new Dimension(100, 20));
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.comboMotivos.setEnabled(false);
        this.comboMotivos.setMinimumSize(new Dimension(180, 20));
        this.setSize(new Dimension(355, 250));
        this.setResizable(false);
        this.setModal(true);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        JPanel panelInicial = new JPanel(new GridBagLayout());
        JPanel panelGridBag = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder(" "));
        panelGridBag.setPreferredSize(new Dimension(340, 90));
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 16;
        c1.fill = 0;
        c1.insets = new Insets(1, 10, 0, 0);
        c1.gridx = 0;
        c1.gridy = 0;
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        panelInicial.add((Component)this.labelDataInicial, c1);
        ++c1.gridy;
        panelInicial.add((Component)this.textDataInicial, c1);
        ++c1.gridx;
        c1.insets = new Insets(0, 1, 0, 0);
        panelInicial.add((Component)this.buttonDataInicial, c1);
        ++c1.gridy;
        c1.gridx = 0;
        c1.insets = new Insets(1, 10, 0, 0);
        panelInicial.add((Component)this.labelDataFinal, c1);
        ++c1.gridy;
        panelInicial.add((Component)this.textDataFinal, c1);
        c1.insets = new Insets(0, 1, 0, 0);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonDataFinal, c1);
        panelGridBag.add((Component)this.checkMarcarRecoleta, cons);
        ++cons.gridy;
        panelGridBag.add((Component)this.labelMotivo, cons);
        ++cons.gridy;
        cons.fill = 2;
        panelGridBag.add((Component)this.comboMotivos, cons);
        HashSet<MotivoRecoletaBean> motivos = new HashSet();
        try {
            MotivoRecoletaService service = new MotivoRecoletaService();
            motivos = service.load(" where fil_codigo = " + Variaveis.filialPadrao);
            ArrayList listaMotivoRecoleta = new ArrayList(motivos);
            Collections.sort(listaMotivoRecoleta, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof MotivoRecoletaBean && o2 instanceof MotivoRecoletaBean) {
                        return o1.toString().compareTo(o2.toString());
                    }
                    return 0;
                }
            });
            for (MotivoRecoletaBean motivo : listaMotivoRecoleta) {
                this.comboMotivos.addItem(motivo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "SolicitarMotivoRecoleta");
        }
        JPanel aux = new JPanel(new BorderLayout());
        aux.add((Component)panelInicial, "West");
        aux.add((Component)panelGridBag, "South");
        panel.add((Component)aux, "West");
        this.preencherFiltrosComValorAnterior(motivos);
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textDataInicial);
        this.listener();
    }

    private void preencherFiltrosComValorAnterior(Set<MotivoRecoletaBean> motivos) {
        String str = StringUtil.getValor(ParametrosUsuarios.getValor(PARAMETRO_IMPORTAR_RESULTADO_DB), "consultarPendencias");
        if (!Funcoes.textoVazio(str)) {
            this.checkMarcarRecoleta.setSelected(StringUtil.getBoolean(str, "marcarRecoleta"));
            this.dataFinal = StringUtil.getValor(str, "dataFinal");
            String codMotivoRecoleta = StringUtil.getValor(str, "codigoMotivoRecoleta");
            if (StringUtil.getBoolean(str, "marcarRecoleta") && !Funcoes.textoVazio(codMotivoRecoleta)) {
                MotivoRecoletaBean motivo = new MotivoRecoletaBean();
                for (MotivoRecoletaBean mtvo : motivos) {
                    if (!mtvo.getCodigo().equals(Integer.valueOf(codMotivoRecoleta))) continue;
                    motivo = mtvo;
                    break;
                }
                this.comboMotivos.setSelectedItem(motivo);
            }
            this.textDataInicial.setText(Funcoes.textoVazio(this.dataFinal) ? "" : this.dataFinal);
            this.comboMotivos.setEnabled(this.checkMarcarRecoleta.isSelected());
        }
    }

    private void listener() {
        this.checkMarcarRecoleta.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (ConsultarPendenciasDB.this.checkMarcarRecoleta.isSelected()) {
                        ConsultarPendenciasDB.this.comboMotivos.setEnabled(true);
                    }
                } else {
                    ConsultarPendenciasDB.this.comboMotivos.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.textDataInicial.getParent(), true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.textDataFinal.getParent(), true);
        } else if (e.getSource() == this.buttonOK) {
            if (Funcoes.textoVazio(this.textDataInicial.getText())) {
                Funcoes.mensagem(this, "Data inicial deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textDataInicial);
                return;
            }
            if (Funcoes.textoVazio(this.textDataFinal.getText())) {
                Funcoes.mensagem(this, "Data final deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textDataFinal);
                return;
            }
            int intervalo = Funcoes.diasPorPeriodo(this.textDataInicial.getText(), this.textDataFinal.getText());
            if (intervalo < 0) {
                Funcoes.mensagem(this, "Data final n\u00e3o pode ser inferior a data inicial.", 2);
                ScreenUtil.requisitarFoco(this.textDataInicial);
                return;
            }
            if (intervalo > 7) {
                Funcoes.mensagem(this, "Informe um per\u00edodo que compreenda no m\u00e1ximo 7 dias", 2);
                ScreenUtil.requisitarFoco(this.textDataFinal);
                return;
            }
            this.isOk = true;
            this.setVisible(false);
        } else {
            super.actionPerformed(e);
        }
    }

    public boolean isOk() {
        return this.isOk;
    }

    public String getDataInicial() {
        return this.textDataInicial.getText();
    }

    public String getDataFinal() {
        return this.textDataFinal.getText();
    }

    public boolean getCheckMarcarRecoleta() {
        return this.checkMarcarRecoleta.isSelected();
    }

    public MotivoRecoletaBean getComboMotivos() {
        return (MotivoRecoletaBean)this.comboMotivos.getSelectedItem();
    }
}

