/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.comum.Pesquisas;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.Medico;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.db2.TipoObservacao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.EditorTermica;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloDB
extends AbstractConfiguradorProtocolo {
    private TTextField textCodigo = ComponenteFactory.novoTTextField(10, 3, this);
    protected TTextField textSenha = ComponenteFactory.novoTTextField(11, 3, this);
    protected JTextField textEndWebService = new TTextField(100, 3);
    protected JTextField textNomeMedico = new TTextField(80, 3);
    protected JCheckBox checkEnviaLoteUsandoWebService = new JCheckBox("Enviar lote utilizando WebService");
    protected JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    protected JCheckBox checkNaoEnviarDadosDoMedicoDaRequisicao = new JCheckBox("N\u00e3o enviar os dados do m\u00e9dico da requisi\u00e7\u00e3o");
    public JCheckBox checkImportarResultadoPdf = new JCheckBox("Importar resultados no formato PDF");
    public static final String TAG_CODIGO_PROTOCOLO = "codigo";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_ENVIAR_UTILIZANDO_WEBSERVICE = "enviarLoteWebservice";
    public static final String TAG_ENDERECO_WEBSERVICE = "enderecoWebService";
    public static final String TAG_CONFIGURADOR_CABECALHO_ETIQUETA = "configuradorCabecalho";
    public static final String TAG_ENVIAR_LOTE_PELA_REQUISICAO = "enviarLotePelaRequisicao";
    public static final String TAG_ENVIAR_MEDICO = "enviarMedico";
    public static final String TAG_MEDICO_PADRAO = "medicoPadrao";
    public static final String TAG_MEDICO_UF = "medicoUF";
    public static final String TAG_MEDICO_CRM = "medicoCRM";
    public static final String TAG_MEDICO_CONSELHO = "medicoConselho";
    public static final String TAG_MEDICO_NOME = "medicoNome";
    public static final String TAG_TIPO_OBSERVACAO = "enviarObservacao";
    public static final String TAG_IMPORTAR_RESULTADO_PDF = "importarResultadoPdf";
    protected JButton buttonConfigurarCabecalhoEtiqueta = ComponenteFactory.novoJButton("Configurar impress\u00e3o de etiquetas", this);
    protected JButton buttonBuscaMedico = ComponenteFactory.novoJButton(this, true);
    private Medico medico = null;
    protected JComboBox comboObservacao = new JComboBox<TipoObservacao>(TipoObservacao.values());
    private String xmlCabecalhoEtiqueta = "";
    EditorTermica termica = EditorTermica.novaInstancia(Laboratorio.getInstancia(), "Configurando ", true, true);
    private JLabel labelMedico;

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloDB((Frame)pai, "Laborat\u00f3rio DB", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloDB((Dialog)pai, "Laborat\u00f3rio DB", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloDB(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloDB(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<dbv2_1>");
        bui.append(StringUtil.getTag("lote", this.textLote.getText()));
        bui.append(StringUtil.getTag(TAG_CODIGO_PROTOCOLO, this.textCodigo.getText()));
        bui.append(StringUtil.getTag(TAG_SENHA, this.textSenha.getText()));
        bui.append(StringUtil.getTag(TAG_ENDERECO_WEBSERVICE, this.textEndWebService.getText()));
        bui.append(StringUtil.getTag(TAG_ENVIAR_UTILIZANDO_WEBSERVICE, this.checkEnviaLoteUsandoWebService.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_LOTE_PELA_REQUISICAO, this.checkEnvioAutomatico.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_MEDICO, this.checkNaoEnviarDadosDoMedicoDaRequisicao.isSelected() ? "false" : "true"));
        bui.append(StringUtil.getTag(TAG_CONFIGURADOR_CABECALHO_ETIQUETA, this.xmlCabecalhoEtiqueta));
        if (this.checkNaoEnviarDadosDoMedicoDaRequisicao.isSelected() && this.medico != null) {
            bui.append(this.getXmlMedico());
        }
        bui.append(StringUtil.getTag(TAG_TIPO_OBSERVACAO, ((TipoObservacao)((Object)this.comboObservacao.getSelectedItem())).getCodigo()));
        bui.append(StringUtil.getTag(TAG_IMPORTAR_RESULTADO_PDF, this.checkImportarResultadoPdf.isSelected() ? "true" : "false"));
        return bui.append("</dbv2_1>").toString();
    }

    private String getXmlMedico() {
        StringBuilder bui = new StringBuilder();
        bui.append("<").append(TAG_MEDICO_PADRAO).append(">");
        bui.append(StringUtil.getTag(TAG_MEDICO_CRM, this.medico.getCrm()));
        bui.append(StringUtil.getTag(TAG_MEDICO_CONSELHO, this.medico.getConselho()));
        bui.append(StringUtil.getTag(TAG_MEDICO_UF, this.medico.getUf()));
        bui.append(StringUtil.getTag(TAG_MEDICO_NOME, this.medico.getNome()));
        bui.append("</").append(TAG_MEDICO_PADRAO).append(">");
        return bui.toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            String xmlTipoObservacao;
            xml = StringUtil.getValor(xml, "dbv2_1");
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
            this.textCodigo.setText(StringUtil.getValor(xml, TAG_CODIGO_PROTOCOLO));
            this.textSenha.setText(StringUtil.getValor(xml, TAG_SENHA));
            this.textEndWebService.setText(StringUtil.getValor(xml, TAG_ENDERECO_WEBSERVICE));
            this.checkEnviaLoteUsandoWebService.setSelected(StringUtil.getBoolean(xml, TAG_ENVIAR_UTILIZANDO_WEBSERVICE));
            this.checkEnvioAutomatico.setSelected(StringUtil.getValor(xml, TAG_ENVIAR_LOTE_PELA_REQUISICAO).trim().length() > 0 ? StringUtil.getBoolean(xml, TAG_ENVIAR_LOTE_PELA_REQUISICAO) : false);
            this.checkNaoEnviarDadosDoMedicoDaRequisicao.setSelected(StringUtil.getValor(xml, TAG_ENVIAR_MEDICO).trim().length() > 0 ? !StringUtil.getBoolean(xml, TAG_ENVIAR_MEDICO) : false);
            this.xmlCabecalhoEtiqueta = StringUtil.getValor(xml, TAG_CONFIGURADOR_CABECALHO_ETIQUETA);
            if (StringUtil.getBoolean(xml, TAG_ENVIAR_UTILIZANDO_WEBSERVICE)) {
                this.checkEnviaLoteUsandoWebService.setSelected(true);
                this.buttonConfigurarCabecalhoEtiqueta.setEnabled(true);
            } else {
                this.checkEnviaLoteUsandoWebService.setSelected(false);
                this.buttonConfigurarCabecalhoEtiqueta.setEnabled(false);
            }
            String xmlMedico = StringUtil.getValor(xml, TAG_MEDICO_PADRAO);
            if (!Funcoes.textoVazio(xmlMedico)) {
                this.medico = new Medico(StringUtil.getValor(xmlMedico, TAG_MEDICO_CONSELHO), StringUtil.getValor(xmlMedico, TAG_MEDICO_CRM), StringUtil.getValor(xmlMedico, TAG_MEDICO_UF), StringUtil.getValor(xmlMedico, TAG_MEDICO_NOME));
                this.textNomeMedico.setText(this.medico.getNome());
            }
            if (!Funcoes.textoVazio(xmlTipoObservacao = StringUtil.getValor(xml, TAG_TIPO_OBSERVACAO))) {
                this.comboObservacao.setSelectedItem((Object)TipoObservacao.get(xmlTipoObservacao));
            }
            this.checkImportarResultadoPdf.setSelected(StringUtil.getBoolean(xml, TAG_IMPORTAR_RESULTADO_PDF));
            this.controlaCampoMedico();
        }
    }

    public void setXmlConfiguracao(String xml) {
        this.xmlCabecalhoEtiqueta = xml;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonBuscaMedico) {
            this.pesquisarMedico();
        } else if (o == this.checkNaoEnviarDadosDoMedicoDaRequisicao) {
            this.controlaCampoMedico();
            if (!this.checkNaoEnviarDadosDoMedicoDaRequisicao.isSelected()) {
                this.textNomeMedico.setText("");
                this.medico = null;
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private void controlaCampoMedico() {
        this.buttonBuscaMedico.setEnabled(this.checkNaoEnviarDadosDoMedicoDaRequisicao.isSelected());
        this.textNomeMedico.setEnabled(this.checkNaoEnviarDadosDoMedicoDaRequisicao.isSelected());
        this.labelMedico.setEnabled(this.checkNaoEnviarDadosDoMedicoDaRequisicao.isSelected());
    }

    private void pesquisarMedico() {
        Hashtable resultado = Pesquisas.medico(this, true);
        if (resultado != null) {
            this.textNomeMedico.setText(resultado.get("med_nome").toString());
            this.medico = new Medico(resultado.get("med_conselho").toString(), resultado.get("med_crm").toString(), resultado.get("med_uf").toString(), resultado.get("med_nome").toString());
        }
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        Dimension dimensionLabels = new Dimension(77, 20);
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", dimensionLabels);
        lblLote.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textLote.setPreferredSize(new Dimension(200, 20));
        this.textLote.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 1;
        JLabel lblCodigo = ComponenteFactory.novoJLabel("C\u00f3digo:", dimensionLabels);
        lblCodigo.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblCodigo, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textCodigo.setPreferredSize(new Dimension(200, 20));
        this.textCodigo.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.gridwidth = 1;
        JLabel lblChave = ComponenteFactory.novoJLabel("Senha:", dimensionLabels);
        lblChave.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblChave, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textSenha.setPreferredSize(new Dimension(150, 20));
        this.textSenha.setMinimumSize(new Dimension(150, 20));
        this.getPanelCentral().add((Component)this.textSenha, cons);
        cons.gridx = 0;
        cons.gridy = 5;
        cons.gridwidth = 1;
        JLabel lblService = ComponenteFactory.novoJLabel("Web Services:", dimensionLabels);
        this.getPanelCentral().add((Component)lblService, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textEndWebService.setPreferredSize(new Dimension(200, 20));
        this.textEndWebService.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textEndWebService, cons);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnviaLoteUsandoWebService, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        cons.gridx = 0;
        cons.gridy = 8;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkNaoEnviarDadosDoMedicoDaRequisicao, cons);
        cons.gridx = 0;
        cons.gridy = 9;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkImportarResultadoPdf, cons);
        cons.gridx = 0;
        cons.gridy = 10;
        cons.gridwidth = 1;
        this.labelMedico = ComponenteFactory.novoJLabel("M\u00e9dico padr\u00e3o:", dimensionLabels);
        this.getPanelCentral().add((Component)this.labelMedico, cons);
        cons.gridx = 1;
        this.textNomeMedico.setEditable(false);
        this.textNomeMedico.setPreferredSize(new Dimension(150, 20));
        this.textNomeMedico.setMinimumSize(new Dimension(150, 20));
        this.getPanelCentral().add((Component)this.textNomeMedico, cons);
        cons.insets.left = 0;
        cons.insets.right = 0;
        cons.gridx = 2;
        cons.weightx = 0.0;
        this.buttonBuscaMedico.setPreferredSize(new Dimension(19, 19));
        this.buttonBuscaMedico.setMinimumSize(new Dimension(19, 19));
        this.getPanelCentral().add((Component)this.buttonBuscaMedico, cons);
        cons.gridx = 0;
        cons.gridy = 11;
        cons.gridwidth = 1;
        JLabel labelObservacao = ComponenteFactory.novoJLabel("Enviar Obs.:", dimensionLabels);
        this.getPanelCentral().add((Component)labelObservacao, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.comboObservacao.setSize(this.textEndWebService.getSize());
        this.getPanelCentral().add((Component)this.comboObservacao, cons);
        cons.insets.left = 1;
        cons.insets.right = 1;
        cons.gridx = 0;
        cons.gridy = 12;
        cons.weightx = 0.5;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.buttonConfigurarCabecalhoEtiqueta, cons);
        this.pack();
        this.setSize(new Dimension(360, 360));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textLote);
        this.checkNaoEnviarDadosDoMedicoDaRequisicao.addActionListener(this);
        this.checkEnviaLoteUsandoWebService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorProtocoloDB.this.checkEnviaLoteUsandoWebService.isSelected()) {
                    ConfiguradorProtocoloDB.this.buttonConfigurarCabecalhoEtiqueta.setEnabled(true);
                } else {
                    ConfiguradorProtocoloDB.this.buttonConfigurarCabecalhoEtiqueta.setEnabled(false);
                    ConfiguradorProtocoloDB.this.checkEnvioAutomatico.setSelected(false);
                }
            }
        });
        this.checkEnvioAutomatico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorProtocoloDB.this.checkEnvioAutomatico.isSelected()) {
                    ConfiguradorProtocoloDB.this.checkEnviaLoteUsandoWebService.setSelected(true);
                    ConfiguradorProtocoloDB.this.buttonConfigurarCabecalhoEtiqueta.setEnabled(true);
                }
            }
        });
        this.buttonConfigurarCabecalhoEtiqueta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTermica termica = EditorTermica.novaInstancia(Laboratorio.getInstancia(), "Configurando ", true, true);
                if (!Funcoes.textoVazio(ConfiguradorProtocoloDB.this.xmlCabecalhoEtiqueta)) {
                    termica.setDocumento(ConfiguradorProtocoloDB.this.xmlCabecalhoEtiqueta);
                }
                termica.setVisible(true);
                if (!Funcoes.textoVazio(termica.getDocumento())) {
                    ConfiguradorProtocoloDB.this.xmlCabecalhoEtiqueta = termica.getDocumento();
                }
            }
        });
    }

    @Override
    public boolean acaoOk() {
        if (this.checkEnviaLoteUsandoWebService.isSelected()) {
            if (Funcoes.textoVazio(this.textCodigo.getText())) {
                Funcoes.mensagem(this, "Informe o campo c\u00f3digo.", 2);
                ScreenUtil.requisitarFoco(this.textCodigo);
                return false;
            }
            if (Funcoes.textoVazio(this.textSenha.getText())) {
                Funcoes.mensagem(this, "Informe o campo senha.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return false;
            }
            if (Funcoes.textoVazio(this.textEndWebService.getText())) {
                Funcoes.mensagem(this, "Informe o campo Web services.", 2);
                ScreenUtil.requisitarFoco(this.textEndWebService);
                return false;
            }
        }
        if (Funcoes.textoVazio(this.textSenha.getText())) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado uma senha", 1);
        } else if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um c\u00f3digo v\u00e1lido", 1);
        } else {
            return true;
        }
        return false;
    }
}

