/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.db2.ParserImportacaoDB;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorDB
extends AbstractConfigurador
implements ListSelectionListener {
    public static final String DESCRICAO_MAT = "descricaoMat";
    public static final String COD_EXA = "codigoExame";
    public static final String DESC_EXA = "descricaoExame";
    public static final String MATERIAL = "material";
    public static final String OBJ_EXAME_DB = "objExameDB";
    protected ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "material");
    protected JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 100, 0, 170);
    private JTextField textLocalizar = new JTextField();
    private ModeloResultSet modDadosAdicionais = new ModeloResultSet("Dado Adicional", "dadoAdicional", "Sel", "selecionado");
    private JTable tableDadosAdicionais = ComponenteFactory.novoJTable((TableModel)this.modDadosAdicionais, null, 0, 40);
    private JScrollPane scrollDadosAdicionais = new JScrollPane(this.tableDadosAdicionais);
    public ModeloResultSet modDadosRegiaoColeta = new ModeloResultSet("C\u00f3digo", "CD_REGIAO_COLETA", "Descri\u00e7\u00e3o", "DS_REGIAO_COLETA", "Sel", "selecionado");
    public JTable tableDadosRegiaoColeta = ComponenteFactory.novoJTable((TableModel)this.modDadosRegiaoColeta, null, 0, 0, 40);
    private JScrollPane scrollmodDadosRegiaoColeta = new JScrollPane(this.tableDadosRegiaoColeta);
    public JPanel panelRegiao = ComponenteFactory.novoJPanelBorderLayout("Regi\u00e3o de coleta", (Component)this.scrollmodDadosRegiaoColeta, null, null, null, null);
    public String xmlSelecionado = "";
    private int ultimoSelecinoado = -1;
    private JCheckBox importarPDF = new JCheckBox("Importar resultado no formato PDF");

    public ConfiguradorDB(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio DB v2.1", codigoLabExterno);
        this.panelRegiao.setVisible(false);
        this.iniciar();
    }

    public ConfiguradorDB(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio DB v2.1", codigoLabExterno);
        this.panelRegiao.setVisible(false);
        this.iniciar();
    }

    public ConfiguradorDB(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorDB(Dialog pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ParserImportacaoDB.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            Registro exa = ParserImportacaoDB.getExame(xml, null, null);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.getString("cd_db").equals(reg.getValor(OBJ_EXAME_DB, Registro.class).getString("cd_db"))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                this.atualizarDadosAdicionais(exa);
                Registro r = (Registro)reg.getValor(OBJ_EXAME_DB);
                r.setValor("formato_pdf", exa.getValor("formato_pdf"));
                reg.setValor(OBJ_EXAME_DB, r);
                this.modExa.addRegistro(reg);
                this.importarPDF.setSelected(exa.getValor("formato_pdf").equals("SIM"));
                break;
            }
        }
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null) {
            String exame = StringUtil.getValor(xml, "exame");
            return StringUtil.getValor(exame, "ds_exame");
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            String exa = StringUtil.getValor(xml, "exame");
            return StringUtil.getValor(exa, "cd_db") + "|1";
        }
        return "";
    }

    public static ConfiguradorDB novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorDB((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorDB((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 250));
        this.scrollDadosAdicionais.setPreferredSize(new Dimension(650, 100));
        this.scrollmodDadosRegiaoColeta.setPreferredSize(new Dimension(650, 100));
        this.modDadosAdicionais.setColunaEditavel("selecionado");
        this.modDadosRegiaoColeta.setColunaEditavel("selecionado");
        TableColumn col = this.tableDadosAdicionais.getColumnModel().getColumn(1);
        col.setMinWidth(30);
        col.setMaxWidth(30);
        TableColumn colSel = this.tableDadosRegiaoColeta.getColumnModel().getColumn(2);
        colSel.setMinWidth(30);
        colSel.setMaxWidth(30);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        JPanel p = ComponenteFactory.novoJPanelBorderLayout("", (Component)ComponenteFactory.novoJPanelBorderLayout("Dados Adicionais", (Component)this.scrollDadosAdicionais, null, null, null, null), (Component)this.panelRegiao, null, null, null);
        this.getPanelCentral().add((Component)p, "Center");
        this.getPanelCentral().add((Component)this.importarPDF, "South");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorDB.this.modExa.filtrar(ConfiguradorDB.DESC_EXA, ConfiguradorDB.this.textLocalizar.getText());
                if (ConfiguradorDB.this.modExa.getRowCount() > 0) {
                    ConfiguradorDB.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorDB.this.tableExa.hasFocus() && (row = ConfiguradorDB.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorDB.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorDB.this.tableExa.scrollRectToVisible(ConfiguradorDB.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorDB.this.tableExa.hasFocus() && (row = ConfiguradorDB.this.tableExa.getSelectedRow()) < ConfiguradorDB.this.tableExa.getRowCount() - 1) {
                    ConfiguradorDB.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorDB.this.tableExa.scrollRectToVisible(ConfiguradorDB.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        for (Registro exame : ParserImportacaoDB.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getString("cd_db"));
            reg.setValor(DESC_EXA, exame.getString("ds_exame"));
            reg.setValor(MATERIAL, exame.getString(MATERIAL));
            reg.setValor(OBJ_EXAME_DB, exame);
            this.modExa.addRegistro(reg);
        }
    }

    @Override
    public boolean acaoOk() {
        Registro exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private boolean atualizarXMLSelecionado() {
        Registro exa = this.getExameSelecionado();
        if (exa != null) {
            if (this.modDadosAdicionais.getRowCount() > 0) {
                exa.setValor("dadosAdicionais", this.modDadosAdicionais.getRegistros());
            }
            if (this.modDadosRegiaoColeta.getRowCount() > 0) {
                int qt = 0;
                for (Registro reg : this.modDadosRegiaoColeta.getRegistros()) {
                    if (reg.nulo("selecionado") || !reg.getBoolean("selecionado")) continue;
                    ++qt;
                }
                if (qt > 1) {
                    Funcoes.mensagem(this, "Apenas uma regi\u00e3o de coleta sever\u00e1 ser selecionada.", 2);
                    return false;
                }
                if (qt == 0) {
                    Funcoes.mensagem(this, "Nenhuma regi\u00e3o de coleta foi selecionada.", 2);
                    return false;
                }
                exa.setValor("REGIOES_COLETA", this.modDadosRegiaoColeta.getRegistros());
            }
            exa.setValor("formato_pdf", "N\u00c3O");
            if (this.importarPDF.isSelected()) {
                exa.setValor("formato_pdf", "SIM");
            }
            this.xmlSelecionado = ParserImportacaoDB.getXml(exa);
            return true;
        }
        return false;
    }

    private Registro getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return reg.getValor(OBJ_EXAME_DB, Registro.class);
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro obj;
        Registro reg;
        if (this.ultimoSelecinoado > -1) {
            reg = this.modExa.getRegistro(this.ultimoSelecinoado);
            this.modExa.getValueAt(this.ultimoSelecinoado, 2);
            if (reg != null) {
                obj = reg.getValor(OBJ_EXAME_DB, Registro.class);
                this.atualizarDadosAdicionais(obj);
                this.atualizarDadosRegiaoColeta(obj, true);
            }
        }
        if ((reg = this.modExa.getRegistro(this.tableExa.getSelectedRow())) != null) {
            obj = reg.getValor(OBJ_EXAME_DB, Registro.class);
            this.atualizarDadosAdicionais(obj);
            this.atualizarDadosRegiaoColeta(obj, false);
            this.importarPDF.setSelected(obj.getValor("formato_pdf").equals("SIM"));
        }
        this.ultimoSelecinoado = this.tableExa.getSelectedRow();
    }

    protected void atualizarDadosAdicionais(Registro exame) {
        this.modDadosAdicionais.limpar();
        List dadosAd = exame.getValor("dadosAdicionais", List.class);
        if (dadosAd != null && dadosAd.size() > 0) {
            for (Registro dado : dadosAd) {
                this.modDadosAdicionais.addRegistro(dado);
            }
        } else {
            Registro r = new Registro();
            if (!exame.getString("volume_obrigatorio").equalsIgnoreCase("N\u00c3O")) {
                r.setValor("dadoAdicional", "Volume");
                r.setValor("selecionado", Boolean.TRUE);
                this.modDadosAdicionais.addRegistro(r);
            }
            boolean peso = false;
            boolean altura = false;
            if (exame.getString("peso_obrigatorio").equalsIgnoreCase("SIM")) {
                r = new Registro();
                r.setValor("dadoAdicional", "Peso");
                r.setValor("selecionado", Boolean.TRUE);
                this.modDadosAdicionais.addRegistro(r);
                peso = true;
            }
            if (exame.getString("altura_obrigatorio").equalsIgnoreCase("SIM")) {
                r = new Registro();
                r.setValor("dadoAdicional", "Altura");
                r.setValor("selecionado", Boolean.TRUE);
                this.modDadosAdicionais.addRegistro(r);
                altura = true;
            }
            if (exame.getString("peso_e_altura_obrigatorio").equalsIgnoreCase("SIM")) {
                if (!peso) {
                    r = new Registro();
                    r.setValor("dadoAdicional", "Peso");
                    r.setValor("selecionado", Boolean.TRUE);
                    this.modDadosAdicionais.addRegistro(r);
                }
                if (!altura) {
                    r = new Registro();
                    r.setValor("dadoAdicional", "Altura");
                    r.setValor("selecionado", Boolean.TRUE);
                    this.modDadosAdicionais.addRegistro(r);
                }
            }
        }
    }

    public void atualizarDadosRegiaoColeta(Registro exa, boolean atualizarSelecao) {
        List dadosRegiaoColeta = exa.getValor("REGIOES_COLETA", List.class);
        if (atualizarSelecao) {
            block0: for (Registro regiao : dadosRegiaoColeta) {
                for (int i = 0; i < this.modDadosRegiaoColeta.getRowCount(); ++i) {
                    Registro regAtual = this.modDadosRegiaoColeta.getRegistro(i);
                    if (regiao.nulo("CD_REGIAO_COLETA") || !regiao.getString("CD_REGIAO_COLETA").equalsIgnoreCase(regAtual.getString("CD_REGIAO_COLETA")) || regAtual.nulo("selecionado") || !regAtual.getBoolean("selecionado")) continue;
                    regiao.setValor("selecionado", Boolean.TRUE);
                    continue block0;
                }
            }
        } else {
            this.modDadosRegiaoColeta.limpar();
            for (Registro regiao : dadosRegiaoColeta) {
                if (!regiao.nulo("selecionado") && regiao.getBoolean("selecionado")) {
                    regiao.setValor("selecionado", Boolean.TRUE);
                } else {
                    regiao.setValor("selecionado", Boolean.FALSE);
                }
                this.modDadosRegiaoColeta.addRegistro(regiao);
            }
        }
    }
}

