/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db2;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.db2.ParserImportacaoDB;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CamposImportacaoDB
implements CamposImportacao {
    LinkedHashMap<String, String> linhas;
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    public CamposImportacaoDB(String xmlDB, String xmlExameLabApoio, String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPai) {
        block9: {
            block8: {
                Map parametros;
                this.linhas = new LinkedHashMap();
                this.codigoExamePai = codigoExamePai;
                this.codigoMaterialPai = codigoMaterialPai;
                this.linhas.put("", "Nenhum");
                this.linhas.put("NumeroAtendimentoDB", "C\u00f3digo da requisi\u00e7\u00e3o no DB");
                this.linhas.put("CodigoExameDB", "C\u00f3digo do exame no DB");
                this.linhas.put("ds_exame", "Descri\u00e7\u00e3o do exame no DB");
                this.linhas.put("metodologia", "Metodologia");
                this.linhas.put("material", "material");
                this.linhas.put("Observacao1", "Valor da Observa\u00e7\u00e3o 1");
                this.linhas.put("Observacao2", "Valor da Observa\u00e7\u00e3o 2");
                this.linhas.put("Observacao3", "Valor da Observa\u00e7\u00e3o 3");
                this.linhas.put("Observacao4", "Valor da Observa\u00e7\u00e3o 4");
                this.linhas.put("Observacao5", "Valor da Observa\u00e7\u00e3o 5");
                this.linhas.put("NomeLiberadorClinico", "Nome do Liberador Cl\u00ednico");
                this.linhas.put("DataHoraLiberacaoClinica", "Data/Hora libera\u00e7\u00e3o cl\u00ednica");
                Registro exame = ParserImportacaoDB.getExame(xmlExameLabApoio, null, null);
                if (xmlDB.indexOf("?xml version") >= 0) break block8;
                this.codigoExame = StringUtil.getValor(xmlDB, "cd_db");
                this.versao = StringUtil.getValor(xmlDB, "data_alteracao");
                if (Funcoes.textoVazio(this.versao)) {
                    this.versao = StringUtil.getValor(xmlDB, "data_alteracao_laudo");
                }
                if ((parametros = exame.getValor("parametros", Map.class)) != null && parametros.size() == 0) {
                    exame = ParserImportacaoDB.getExame(xmlDB, null, null);
                    parametros = exame.getValor("parametros", Map.class);
                }
                if (parametros == null || parametros.size() <= 0) break block9;
                for (String key : parametros.keySet()) {
                    String codigo = ((Registro)parametros.get(key)).getString("cd_parametro");
                    String descricao = ((Registro)parametros.get(key)).getString("ds_parametro");
                    String unidade = ((Registro)parametros.get(key)).getString("unidade");
                    this.linhas.put(codigo, descricao);
                    this.linhas.put(String.format("%s_%s", "valorRef", codigo), String.format("Vlr. ref. /p %s ", descricao));
                    this.linhas.put(String.format("%s_%s", "unidade", codigo), String.format("Unidade de /p %s ", descricao));
                }
                break block9;
            }
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(xmlDB)));
                Element elem = doc.getDocumentElement();
                NodeList nl = elem.getElementsByTagName("exame");
                String tempExame = StringUtil.getValor(xmlExameLabApoio, "cd_db");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element tagExame = (Element)nl.item(i);
                    this.codigoExame = tagExame.getAttribute("cd_db");
                    if (!this.codigoExame.equalsIgnoreCase(tempExame)) continue;
                    this.versao = tagExame.getAttribute("data_alteracao");
                    List<Element> childs = XMLUtil.getElementosFilhos(tagExame);
                    for (Element c : childs) {
                        if (!c.getNodeName().equalsIgnoreCase("parametros")) continue;
                        List<Element> l = XMLUtil.getElementosFilhos(c);
                        for (Element e : l) {
                            String linhaCodigo = e.getAttribute("cd_db");
                            String linhaDescricao = e.getAttribute("ds_parametro");
                            this.linhas.put(linhaCodigo, linhaDescricao);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }
}

