/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.db.rastreabilidade;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.loteexterno.LoteExternoRequisicaoRastreioBean;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class TelaRastreabilidadeAmostraDB
extends AbstractDialogoOKCancelar {
    private JPanel panelRastro = new JPanel();
    private JTextPane lista = new JTextPane();
    private JScrollPane scroll = new JScrollPane(this.lista);

    public static TelaRastreabilidadeAmostraDB novaInstancia(Object pai, String titulo) {
        if (pai instanceof Dialog) {
            return new TelaRastreabilidadeAmostraDB((Dialog)pai, titulo);
        }
        return new TelaRastreabilidadeAmostraDB((Frame)pai, titulo);
    }

    public TelaRastreabilidadeAmostraDB(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public TelaRastreabilidadeAmostraDB(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.getBotaoCancelar().setVisible(false);
        this.getBotaoOK().setText("Fechar");
        this.setSize(new Dimension(380, 500));
        this.setLocationRelativeTo(Laboratorio.getInstancia());
        this.getPanelCentral().setLayout(new BorderLayout());
        this.lista.setContentType("text/html");
        this.getPanelCentral().add((Component)this.scroll, "Center");
    }

    public void setRastreabilidade(List<LoteExternoRequisicaoRastreioBean> listaRastro) {
        this.lista.setText("");
        if (this.possuiRastreio(listaRastro)) {
            StringBuilder buf = new StringBuilder("<html>");
            for (LoteExternoRequisicaoRastreioBean rastreio : listaRastro) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    String dataConsultado = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", sdf.parse(rastreio.getDataHoraStatus()));
                    buf.append("<b>Consultado em:</b> ").append(dataConsultado).append("<br>");
                    buf.append("<html><b>N\u00b0 Atendimento DB:</b> ").append(rastreio.getOrigemPedido()).append("<br>");
                    String dataHoraPedido = rastreio.getDataHoraPedido();
                    String data = "";
                    if (!StringUtil.isEmpty(dataHoraPedido)) {
                        data = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", sdf.parse(dataHoraPedido));
                    }
                    buf.append("<html><b>Data/Hora Pedido:</b> ").append(data).append("<br>");
                    buf.append("<html><b>Sequ\u00eancia Exame DB:</b> ").append(rastreio.getSequencialExame()).append("<br>");
                    buf.append("<html><b>Status no DB:</b> ").append(rastreio.getCodigoStatusTexto() != null ? rastreio.getCodigoStatusTexto() : "").append("<br>");
                    buf.append("<html><b>Descri\u00e7\u00e3o:</b> ").append(rastreio.getDescricaoStatus()).append("<br>");
                    buf.append("<br>");
                }
                catch (ParseException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "setRastreabilidade ");
                }
            }
            buf.append("</html>");
            this.lista.setText(buf.toString());
        }
        ScreenUtil.requisitarFoco(this.scroll);
    }

    private boolean possuiRastreio(List<LoteExternoRequisicaoRastreioBean> listaRastro) {
        return listaRastro.size() > 0;
    }
}

