/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.concent;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.laboratorio.util.parsers.concent.AmostraConcent;
import jalis.laboratorio.util.parsers.concent.CampoResultadoConcent;
import jalis.laboratorio.util.parsers.concent.ExameResultadoConcent;
import jalis.laboratorio.util.parsers.concent.LinhaResultadoConcent;
import jalis.laboratorio.util.parsers.concent.PacienteConcent;
import jalis.laboratorio.util.parsers.concent.RequisicaoConcent;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportacaoResultadoConcent
extends AbstractImportadorResultadoLabExterno {
    private static String VERSAO = "20060809";
    private static final String FORMATO = "formato";
    private static final String FORMATACAO = "formatacao";
    private static final String CODIGO_LAYOUT = "codigo-layout";
    private static final String CABECALHO = "cabecalho";
    private static final String FORMATO_TEXTO = "formatotexto";
    private static final String VERSAO_EXAME = "versaoExameLabExterno";
    private ArrayList<PacienteConcent> pacientes;
    public ArrayList<RequisicaoConcent> requisicoes;
    private Map<String, ExameAlvaro> examesCadastro;
    private JButton buttonImprimir;
    private ModeloGridTable modeloRelatorio;
    public boolean adicionarEnterNaTagResultado;
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;
    private boolean agruparMultiguia;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportacaoResultadoConcent(int codigoLabExterno) {
        Statement st;
        block5: {
            super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio Concent a partir de arquivo XML", codigoLabExterno, Protocolo.Concent, new JPanel(new FlowLayout(2)));
            this.pacientes = new ArrayList();
            this.requisicoes = new ArrayList();
            this.examesCadastro = new HashMap<String, ExameAlvaro>();
            this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
            this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
            this.adicionarEnterNaTagResultado = false;
            this.conferirAutomatico = false;
            this.codigoUsuarioConferenciaAutomatica = null;
            this.agruparMultiguia = false;
            this.getPanelAdicional().add(this.buttonImprimir);
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir, lae_agruparmultiguias from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block5;
                if (!DBUtil.campoNull(rs.getString("lae_configuracao")) && StringUtil.getValor(rs.getString("lae_configuracao"), "processarEnter").trim().length() > 0) {
                    this.adicionarEnterNaTagResultado = StringUtil.getBoolean(rs.getString("lae_configuracao"), "processarEnter");
                }
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.agruparMultiguia = rs.getBoolean("lae_agruparmultiguias");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoConcent (128)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importarResultado() {
        block50: {
            if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
                return;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Concent (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) != 0) break block50;
            try {
                if (this.adicionarEnterNaTagResultado) {
                    String arquivo = StringUtil.lerArquivoTexto(chooser.getSelectedFile());
                    String[] linhas = arquivo.split("/>");
                    StringBuilder b = new StringBuilder();
                    StringBuilder novoArquivo = new StringBuilder();
                    for (int j = 0; j < linhas.length; ++j) {
                        b.setLength(0);
                        b.append(linhas[j]);
                        if (j != linhas.length - 1) {
                            b.append("/>");
                        }
                        int pos = -1;
                        int pos2 = -1;
                        pos = b.indexOf("<resultado");
                        if (pos > 0 && (pos2 = b.indexOf(" resultado", pos)) > pos) {
                            String tmp;
                            int posAspasInicio = -1;
                            int posAspasFim = -1;
                            for (int i = pos2; i < b.length(); ++i) {
                                if (b.toString().charAt(i) != '\"') continue;
                                if (posAspasInicio == -1) {
                                    posAspasInicio = i;
                                    continue;
                                }
                                posAspasFim = i;
                                break;
                            }
                            if ((tmp = b.substring(posAspasInicio + 1, posAspasFim)).indexOf("&#xD;") < 0) {
                                tmp = tmp.replaceAll("\n", "&#xD;").replaceAll("\r", "");
                                b.delete(posAspasInicio + 1, posAspasFim);
                                b.insert(posAspasInicio + 1, tmp);
                            }
                        }
                        novoArquivo.append((CharSequence)b);
                    }
                    StringUtil.escreverArquivoTexto(chooser.getSelectedFile().getPath(), novoArquivo.toString());
                }
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel importar os resultados.\nMensagem: " + e.getMessage(), 1);
                return;
            }
            Document doc = this.analisarXML(chooser.getSelectedFile());
            if (doc == null) {
                this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo: " + chooser.getSelectedFile().getPath());
                return;
            }
            Element raiz = doc.getDocumentElement();
            this.parse(XMLUtil.getElementosFilhos(raiz));
            if (this.requisicoes == null || this.requisicoes.size() == 0) {
                this.setTextoInformacoes("O arquivo informado n\u00e3o possui requisi\u00e7\u00f5es a serem importadas!");
                return;
            }
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            if (st == null) {
                return;
            }
            try {
                String req_codigo;
                this.progress.setValue(0);
                this.progress.setMaximum(this.requisicoes.size());
                this.progress.setVisible(true);
                for (RequisicaoConcent reqConcent : this.requisicoes) {
                    this.progress.setValue(this.progress.getValue() + 1);
                    for (ExameResultadoConcent exResultado : reqConcent.exames) {
                        String fil_codigo;
                        LinkedList<Registro> listaRegistros = this.processarPaiFilhos(st, reqConcent, exResultado, fil_codigo = reqConcent.codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial()), req_codigo = reqConcent.codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial()), false);
                        if (listaRegistros == null || listaRegistros.size() == 0) {
                            this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis Fil.: %s Req.: %s. C\u00f3digo Concent:%s ", fil_codigo, req_codigo, reqConcent.codigoConcent), false);
                            this.adicionarAoModeloRelatorio(reqConcent, exResultado, Situacao.NAO_LOCALIZADO);
                            continue;
                        }
                        for (Registro reg : listaRegistros) {
                            boolean salvoParcial;
                            Registro formatacao;
                            if (reg == null) continue;
                            if (this.exameLancado(reg)) {
                                this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do Concent: %s exame %s %s", reqConcent.codigoConcent, exResultado.codigo, Situacao.JA_LANCADO.descricao), false);
                                this.adicionarAoModeloRelatorio(reqConcent, exResultado, Situacao.JA_LANCADO);
                                continue;
                            }
                            if (!this.exameColetado(reg) && reg != null && !reg.getString("exr_situacao").equals("P")) {
                                this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do Concent: %s exame %s %s", reqConcent.codigoConcent, exResultado.codigo, Situacao.SEM_MATERIAL.descricao), false);
                                this.adicionarAoModeloRelatorio(reqConcent, exResultado, Situacao.SEM_MATERIAL);
                                continue;
                            }
                            if (!this.exameRelacionado(reg)) {
                                this.adicionarAoModeloRelatorio(reqConcent, exResultado, Situacao.SEM_RELACIONAMENTO);
                                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento", false);
                                continue;
                            }
                            if (reg.getValor("examePai") != null) {
                                reg.setValor("exa_codigo", reg.getString("examePai"));
                            }
                            Registro registro = formatacao = (salvoParcial = reg.getString("exr_situacao").equals("P")) ? (Registro)reg.getValor(FORMATACAO) : this.localizarFormatacao(reg);
                            if (formatacao == null) {
                                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Formata\u00e7\u00e3o n\u00e3o encontrada", false);
                                continue;
                            }
                            ExameAlvaro exConcentSalvo = new ExameAlvaro(reg.getString("ele_xmllabexterno"));
                            ExameAlvaro exConcentNovo = this.examesCadastro.get(exResultado.codigo);
                            Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                            String resultadoAtual = "";
                            for (LinhaResultadoConcent linha : exResultado.linhasResultado) {
                                LinhaResultado linhaEstrutura = exConcentSalvo.getLinha(linha.codigo);
                                if (linhaEstrutura != null && !linhaEstrutura.getTempos().isEmpty()) {
                                    for (String tempo : linhaEstrutura.getTempos()) {
                                        String descricao = tempo + "min.";
                                        AmostraConcent amostra = reqConcent.amostras.get(linha.codigoAmostra);
                                        if (amostra == null || !descricao.equals(amostra.descricao)) continue;
                                        dados.put(linha.codigo + "_tempo_" + tempo, linha.resultado);
                                        dados.put("descricao_tempo_" + tempo, linha.descricao);
                                        dados.put("unidade_tempo_" + tempo, linha.unidade);
                                        this.adicionaValorExameDesmembrado(reg, dados, linha);
                                        break;
                                    }
                                } else if (!linha.codigoAmostra.equals("0") && reqConcent.amostras.get(linha.codigoAmostra) != null && reqConcent.amostras.get((Object)linha.codigoAmostra).descricao.equals("basal")) {
                                    dados.put(linha.codigo + "_tempo_0", linha.resultado);
                                    dados.put(linha.codigo, linha.resultado);
                                    dados.put("descricao_" + linha.codigo, linha.descricao);
                                    dados.put("unidade_" + linha.codigo, linha.unidade);
                                    resultadoAtual = this.getXmlResultadoAtual(reg, resultadoAtual, linha);
                                    this.adicionaValorExameDesmembrado(reg, dados, linha);
                                } else {
                                    if (linha.codigoAmostra.equals("0")) {
                                        dados.put(linha.codigo + "_tempo_" + linha.codigoAmostra, linha.resultado);
                                    }
                                    dados.put(linha.codigo, linha.resultado);
                                    dados.put("descricao_" + linha.codigo, linha.descricao);
                                    dados.put("unidade_" + linha.codigo, linha.unidade);
                                    resultadoAtual = this.getXmlResultadoAtual(reg, resultadoAtual, linha);
                                    this.adicionaValorExameDesmembrado(reg, dados, linha);
                                }
                                for (CampoResultadoConcent campo : linha.camposCompl) {
                                    dados.put(linha.codigo + "_" + campo.codigo, campo.resultado);
                                }
                            }
                            if (!Funcoes.textoVazio(exResultado.resultadoAntibiogramas)) {
                                dados.put("antibiogramas", exResultado.resultadoAntibiogramas);
                            }
                            if (!Funcoes.textoVazio(exResultado.grafico)) {
                                dados.put("grafico", this.getGrafico(exResultado.grafico));
                            }
                            dados.put("codigo", reqConcent.codigoConcent);
                            dados.put("codigo_aol", reqConcent.codigoAOL);
                            dados.put("observacao", exResultado.observacao);
                            dados.put("metodologia", exResultado.metodo);
                            dados.put("data_rst", exResultado.dataResultado);
                            dados.put("desc_exame", exConcentSalvo.getDescricao());
                            dados.put("cod_exame_alv", exConcentSalvo.getCodigo());
                            dados.put("data_alt", exConcentSalvo.getDataAlteracao());
                            dados.put("valor_ref", exConcentNovo != null && exConcentNovo.getValorReferencia() != null && !exConcentNovo.getValorReferencia().equals(exConcentSalvo.getValorReferencia()) ? exConcentNovo.getValorReferencia() : exConcentSalvo.getValorReferencia());
                            dados.put("cod_mat_alv", exConcentSalvo.getMaterial());
                            Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(fil_codigo, reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                            dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                            Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                            if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                                historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                            }
                            Resultado res = new Resultado(formatacao.getString(FORMATO), dados);
                            res.atualizarComponentes();
                            res = new Resultado(null, formatacao.getString(FORMATO), dados, null, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
                            res.atualizarComponentes();
                            if (!res.verificarCondicao()) {
                                this.adicionarAoModeloRelatorio(reqConcent, exResultado, Situacao.CONDICAO_INSATISFEITA);
                                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                                continue;
                            }
                            boolean completo = true;
                            if (reg.getBoolean("exa_salvaparcial")) {
                                completo = res.resultadoCompleto(true);
                            }
                            String novaSituacao = completo ? "L" : "P";
                            String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                            Util.gravaAlteracaoExameRequisicao(st, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                            boolean marcarConferido = false;
                            if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                                int verificacao = res.verificarValidacao();
                                boolean bl = marcarConferido = verificacao == 1;
                                if (!marcarConferido && verificacao != 2) {
                                    this.adicionarAoModeloRelatorio(reqConcent, exResultado, Situacao.VALIDACAO_INSATISFEITA);
                                    this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                                }
                            }
                            if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), reqConcent.codigoConcent)) {
                                this.inserirDadosRequisicao(st, this.codigoLabExterno, reqConcent.codigoConcent, reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                            }
                            boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                            boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                            this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                            if (this.exportarBaseWeb(fil_codigo)) {
                                Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, fil_codigo, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                                this.exportarParaWeb(st, this.getCodigoBaseWeb(fil_codigo), novaSituacao, reg, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                                if (ExportaWeb.isGerarPdfResultado(st2, fil_codigo)) {
                                    ExportaWeb.enviarResultadoPDF(st2, fil_codigo, reg.getString("req_codigo"), this.getCodigoBaseWeb(fil_codigo));
                                }
                            }
                            this.adicionarAoModeloRelatorio(reqConcent, exResultado, completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE);
                            if (completo) {
                                Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                                Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                                this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                            }
                            this.atualizarPaginaOrdemExameWeb(st, reg);
                            this.editarRequisicaoExportaFiliais(reg);
                            this.atualizarSituacaoExameInterfaceamento(st, reg);
                            this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE)), false);
                        }
                    }
                }
                for (RequisicaoConcent reqConcent : this.requisicoes) {
                    for (ExameResultadoConcent exResultado : reqConcent.exames) {
                        String fil_codigo = reqConcent.codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        req_codigo = reqConcent.codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial());
                        this.processarPaiFilhos(st, reqConcent, exResultado, fil_codigo, req_codigo, true);
                    }
                }
                Conexao.arquivaSQL();
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoConcent: 69");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
            Conexao.fecharStatement(st, st2);
            this.progress.setVisible(false);
        }
    }

    private String getXmlResultadoAtual(Registro reg, String resultadoAtual, LinhaResultadoConcent linha) {
        String tag = reg.getValor("exameFilho") == null ? reg.getValor("exa_codigo").toString() : reg.getValor("exameFilho").toString();
        tag = tag.toLowerCase();
        resultadoAtual = resultadoAtual + "<" + tag + ">";
        resultadoAtual = resultadoAtual + linha.resultado;
        resultadoAtual = resultadoAtual + "</" + tag + ">";
        return resultadoAtual;
    }

    private void adicionaValorExameDesmembrado(Registro reg, Map<String, Object> dados, LinhaResultadoConcent linha) {
        if (reg.getString("examePai") != null) {
            String chave = linha.codigo.trim() + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linha.resultado);
            dados.put("unidade_" + chave, linha.unidade);
        }
    }

    private LinkedList<Registro> processarPaiFilhos(Statement st, RequisicaoConcent reqConcent, ExameResultadoConcent exResultado, String fil_codigo, String req_codigo, boolean isLogEmailSMS) throws Exception {
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        Integer[] multiguias = null;
        boolean agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || this.agruparMultiguia;
        multiguias = agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true) : new Integer[]{Integer.parseInt(req_codigo)};
        for (Integer multiguia : multiguias) {
            ExameDesmembrado pai;
            String codigoJalisAux = reqConcent.codigoJalis;
            reqConcent.codigoJalis = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            Registro exameSeparado = this.localizaExameRequisicao(reqConcent, exResultado, st);
            if (exameSeparado != null) {
                retorno.add(exameSeparado);
                if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), Conexao.getStatement())) {
                    SMSUtil.criaLogSmsComDadosRequisicao(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
                if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), Conexao.getStatement())) {
                    EmailUtil.criaLogEmail(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                }
                if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), Conexao.getStatement())) {
                    PushUtil.criaLogPushComDadosRequisicao(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), TipoPush.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
                if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !WhatsAppUtil.isBloquearWhatsappExamePronto(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), Conexao.getStatement())) {
                    WhatsAppUtil.criaLogWhatsappComDadosRequisicao(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), TipoWhatsapp.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
            }
            if ((pai = this.getExamesDesmembrados(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exResultado.codigoJalis, exResultado.materialJalis)) != null) {
                String codigoJalisTemp = exResultado.codigoJalis;
                exResultado.codigoJalis = pai.getCodigoExame();
                Registro reg = this.localizaExameRequisicao(reqConcent, exResultado, st);
                if (reg != null) {
                    reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                    reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                    reg.setValor("examePai", pai.getCodigoExame());
                    reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
                    exResultado.codigoJalis = codigoJalisTemp;
                    retorno.add(reg);
                    if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                        SMSUtil.criaLogSmsComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                    }
                    if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                        EmailUtil.criaLogEmail(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                    }
                    if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                        PushUtil.criaLogPushComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoPush.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                    }
                    if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !WhatsAppUtil.isBloquearWhatsappExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                        WhatsAppUtil.criaLogWhatsappComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoWhatsapp.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                    }
                }
            }
            reqConcent.codigoJalis = codigoJalisAux;
        }
        return retorno;
    }

    private Registro localizaExameRequisicao(RequisicaoConcent requisicao, ExameResultadoConcent exame, Statement st) throws SQLException {
        String fil = "";
        String req = requisicao.codigoJalis;
        String exa = exame.codigoJalis;
        String mco = exame.materialJalis;
        if (Funcoes.textoVazio(req) || req.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Sem c\u00f3digo de requisi\u00e7\u00e3o no Jalis. C\u00f3digo Concent: " + requisicao.codigoConcent, false);
            return null;
        }
        if (Funcoes.textoVazio(exa) || Funcoes.textoVazio(mco)) {
            this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis. C\u00f3digo Concent: " + requisicao.codigoConcent, false);
            return null;
        }
        fil = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
        if (!new ExameRequisicaoService().examePossuiExameRequisicao(st, fil, req = req.substring(ParametrosGerais.getDigitosTuboFilial()), exa, mco)) {
            return null;
        }
        StringBuilder sql = this.getSqlLocalizaExame(fil, req, exa, mco);
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        if (res.next()) {
            Registro reg = new Registro(res);
            reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(fil, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(fil, reg.getString(CODIGO_LAYOUT)));
            Registro formatacao = new Registro();
            formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor(FORMATACAO, formatacao);
            return reg;
        }
        this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis Fil.: %s Req.: %s. C\u00f3digo Concent:%s ", fil, req, requisicao.codigoConcent), false);
        this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.NAO_LOCALIZADO);
        return null;
    }

    private String getGrafico(String pontos) {
        LinkedList<String[]> coordenadas = new LinkedList<String[]>();
        Double pontoMaisAlto = 0.0;
        for (String hex : pontos.split(";")) {
            Double ponto = this.ponto(hex.substring(1));
            if (ponto > pontoMaisAlto) {
                pontoMaisAlto = ponto;
            }
            coordenadas.add(new String[]{hex.substring(0, 1), String.valueOf(ponto)});
        }
        Image i = Toolkit.getDefaultToolkit().createImage(this.criarImagem(coordenadas, pontoMaisAlto).getSource());
        String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(i));
        return foto64;
    }

    private Double ponto(String ponto) {
        Double ret = 0.0;
        String hex = "0123456789ABCDEF";
        int x = ponto.length();
        for (int i = 0; i < ponto.length(); ++i) {
            int pos = hex.indexOf(String.valueOf(ponto.charAt(i)));
            pos = pos == -1 ? 0 : pos;
            Double d = Math.pow(Double.parseDouble("16"), Double.parseDouble(String.valueOf(x)));
            ret = ret + (double)pos * d;
            --x;
        }
        return ret / 100.0;
    }

    private BufferedImage criarImagem(List<String[]> coordenadas, double pontoMaisAlto) {
        BufferedImage b = new BufferedImage(640, 480, 1);
        Graphics2D g = b.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 640, 480);
        g.setColor(Color.BLACK);
        int px1 = 0;
        int py1 = 480;
        int max = coordenadas.size();
        int pos = 0;
        for (String[] coordenada : coordenadas) {
            int px2 = Math.round(pos * 640 / max);
            int py2 = (int)(480L - Math.round(Double.parseDouble(coordenada[1]) * 480.0 / pontoMaisAlto) - 1L);
            g.drawLine(px1, py1, px2, py2);
            if (coordenada[0].equals("B")) {
                g.drawLine(px1, 480, px2 - 1, py2);
            }
            px1 = px2 + 1;
            py1 = py2;
            ++pos;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExameAlvaro getExameConcent(String codigoFilial, String codigoExameConcent) {
        Statement st;
        block4: {
            ExameAlvaro exameAlvaro;
            st = Conexao.getStatement();
            try {
                String sql = "select alv_xml from examesAlvaro where fil_codigo = " + codigoFilial + " and alv_codexame = '" + codigoExameConcent + "'";
                ResultSet rs = st.executeQuery(sql);
                if (!rs.next()) break block4;
                exameAlvaro = new ExameAlvaro(rs.getString("alv_xml"));
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoConcent: 237");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return exameAlvaro;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    public boolean verificarVersao(Registro reg, RequisicaoConcent requisicao, ExameResultadoConcent exResultado, ExameAlvaro exConcentSalvo, ExameAlvaro exConcentNovo) {
        boolean mesmaVersao = exConcentSalvo.getDataAlteracao().equals(exConcentNovo.getDataAlteracao());
        boolean mesmaVersaoEstrutura = true;
        if (exConcentSalvo.getLinhasResultado() != null && exConcentNovo.getLinhasResultado() != null || exConcentSalvo.getLinhasResultado().size() != exConcentNovo.getLinhasResultado().size()) {
            for (LinhaResultado linhaAntiga : exConcentSalvo.getLinhasResultado()) {
                LinhaResultado linhaNova = exConcentNovo.getLinha(linhaAntiga.getCodigo());
                if (linhaNova != null && linhaNova.getDescricao().equalsIgnoreCase(linhaAntiga.getDescricao())) continue;
                mesmaVersaoEstrutura = false;
                break;
            }
        }
        if (!mesmaVersao && !mesmaVersaoEstrutura) {
            this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.VERSAO_INCOMPATIVEL);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Vers\u00e3o incorreta (estrutura e vers\u00e3o)", false);
            return false;
        }
        if (mesmaVersao && !mesmaVersaoEstrutura) {
            this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.VERSAO_INCOMPATIVEL);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Vers\u00e3o incorreta (estrutura)", false);
            return false;
        }
        if (!mesmaVersao && mesmaVersaoEstrutura) {
            this.atualizaVersaoLayoutExame(reg, exResultado);
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizaVersaoLayoutExame(Registro reg, ExameResultadoConcent exame) {
        Statement st = Conexao.getStatement();
        try {
            ExameAlvaro exaConcent = new ExameAlvaro(reg.getString("ele_xmllabexterno"));
            exaConcent.setDataAlteracao(exame.dataAlteracao);
            String exa = StringUtil.getValor(reg.getString("ele_xmllabexterno"), "codigo");
            String mco = StringUtil.getValor(reg.getString("ele_xmllabexterno"), "material");
            StringBuilder bui = new StringBuilder("");
            bui.append("update examematcoletalabexterno set \n");
            bui.append("  ele_xmllabexterno = '").append(exaConcent.getXml()).append("' \n");
            bui.append("where \n");
            bui.append("  fil_codigo = ").append(reg.getString("fil_codigo")).append(" and \n");
            bui.append("  exa_codigo = '").append(exa).append("' and \n");
            bui.append("  mco_codigo = ").append(mco).append(" and \n");
            bui.append("  lae_codigo = ").append(this.codigoLabExterno).append(" \n");
            Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
            exaConcent = null;
            exaConcent = new ExameAlvaro(reg.getString("alv_xml"));
            exaConcent.setDataAlteracao(exame.dataAlteracao);
            bui.setLength(0);
            bui.append("update examesalvaro set alv_xml = '").append(exaConcent.getXml()).append("' ");
            bui.append(" where fil_codigo = ").append(reg.getString("fil_codigo"));
            bui.append(" and lae_codigo = ").append(this.codigoLabExterno);
            bui.append(" and alv_codexame = '").append(exa).append("'");
            bui.append(" and alv_codmaterial = '").append(mco).append("' ");
            Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoConcent: 268");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    public void parse(List<Element> elements) {
        for (Element e : elements) {
            if (e.getNodeName().equalsIgnoreCase("resultados")) {
                if (e.getAttribute("versao").equalsIgnoreCase(VERSAO)) continue;
                this.setTextoInformacoes("O arquivo selecionado n\u00e3o \u00e9 um XML de resultado v\u00e1lido");
                return;
            }
            if (e.getNodeName().equalsIgnoreCase("exame")) {
                this.parseExameCadastro(e);
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("pacientes")) {
                this.parsePacientes(XMLUtil.getElementosFilhos(e));
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("solicitacao")) {
                this.parseSolicitacao(e);
                continue;
            }
            if (!e.hasChildNodes()) continue;
            this.parse(XMLUtil.getElementosFilhos(e));
        }
    }

    private void parseExameCadastro(Element element) {
        ExameAlvaro exame = new ExameAlvaro();
        String codigoExame = element.getAttribute("codigo");
        this.verificaCodigoExame(codigoExame, null);
        exame.setCodigo(codigoExame);
        exame.setDescricao(element.getAttribute("descricao"));
        exame.setDataAlteracao(element.getAttribute("dataalteracao"));
        if (element.hasAttribute("unidade")) {
            exame.setUnidade(element.getAttribute("unidade"));
        }
        List<Element> list = XMLUtil.getElementosFilhos(element);
        for (Element e : list) {
            if (e.getNodeName().equalsIgnoreCase("linhasresultado")) {
                for (Element l : XMLUtil.getElementosFilhos(e)) {
                    LinhaResultado linha = new LinhaResultado();
                    linha.setCodigo(l.getAttribute("codigo"));
                    linha.setDescricao(l.getAttribute("descricao"));
                    if (l.hasAttribute("unidade")) {
                        linha.setUnidade(l.getAttribute("unidade"));
                    }
                    exame.getLinhasResultado().add(linha);
                }
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("valorreferencia") || Funcoes.textoVazio(e.getTextContent())) continue;
            exame.setValorReferencia(e.getTextContent().trim());
        }
        this.examesCadastro.put(codigoExame, exame);
    }

    private void verificaCodigoExame(String codigoExame, String solicitacao) {
        if (codigoExame.indexOf(45) < 0) {
            this.anexarTextoInformacoes("C\u00f3digo de exame incorreto para o exame " + codigoExame + (solicitacao == null ? "" : " da solicita\u00e7\u00e3o " + solicitacao) + ", o material n\u00e3o foi informado - verifique a estrutura do arquivo.\n");
        }
    }

    private void parsePacientes(List<Element> elements) {
        for (Element e : elements) {
            PacienteConcent paciente = new PacienteConcent();
            paciente.codigoConcent = e.getAttribute("codigo");
            paciente.codigoJalis = e.getAttribute("codigo_lis");
            paciente.codigoAOL = e.getAttribute("codigo_aol");
            paciente.dataNascimento = e.getAttribute("datanasc");
            paciente.nome = e.getAttribute("nome");
            paciente.sexo = e.getAttribute("sexo");
            this.pacientes.add(paciente);
        }
    }

    private void parseSolicitacao(Element element) {
        RequisicaoConcent requisicao = new RequisicaoConcent();
        requisicao.codigoConcent = element.getAttribute("codigo");
        requisicao.codigoJalis = element.getAttribute("codigo_lis");
        requisicao.codigoAOL = element.getAttribute("codigo_aol");
        requisicao.paciente = this.locatePaciente(element.getAttribute("paciente"));
        if (!Funcoes.isNumeric(requisicao.codigoJalis)) {
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: C\u00f3digo incorreto da requisi\u00e7\u00e3o Jalis. C\u00f3digo \u00c1lvaro: " + requisicao.codigoConcent, false);
            return;
        }
        HashMap<String, String> examesJalis = this.localizaExameJalis(requisicao, element.getAttribute("paciente"));
        List<Element> list = XMLUtil.getElementosFilhos(element);
        requisicao.exames = new ArrayList();
        for (Element e : list) {
            if (e.getNodeName().equalsIgnoreCase("amostras")) {
                this.parseAmostras(XMLUtil.getElementosFilhos(e), requisicao);
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("exame")) continue;
            this.parseExameResultado(e, requisicao, examesJalis);
        }
        this.requisicoes.add(requisicao);
    }

    private String buscaUnidadeLinhas(ExameAlvaro exame, String codigo) {
        String unidade = null;
        for (LinhaResultado linha : exame.getLinhasResultado()) {
            if (null == linha || !linha.getCodigo().equals(codigo)) continue;
            unidade = linha.getUnidade();
            break;
        }
        return unidade;
    }

    private void parseExameResultado(Element e, RequisicaoConcent requisicao, HashMap<String, String> examesJalis) {
        String codigoExame = e.getAttribute("codigo");
        this.verificaCodigoExame(codigoExame, requisicao.codigoJalis);
        if (!this.examesCadastro.containsKey(codigoExame)) {
            return;
        }
        ExameAlvaro exameCadastro = this.examesCadastro.get(codigoExame);
        ExameResultadoConcent exame = new ExameResultadoConcent();
        exame.codigo = codigoExame;
        exame.dataResultado = e.getAttribute("dataresultado");
        exame.metodo = e.getAttribute("metodo");
        exame.normal = e.getAttribute("normal");
        exame.dataAlteracao = exameCadastro.getDataAlteracao();
        exame.descricao = exameCadastro.getDescricao();
        StringBuilder observacao = new StringBuilder();
        if (!Funcoes.textoVazio(e.getAttribute("observacao"))) {
            observacao.append(this.trocaCaracteres(e.getAttribute("observacao") + "\n"));
        }
        List<Element> elements = XMLUtil.getElementosFilhos(e);
        StringBuilder resultadoAntibiogramas = new StringBuilder("");
        String grafico = null;
        for (Element ele : elements) {
            if (ele.getNodeName().equals("resultado")) {
                String lis;
                int index;
                LinhaResultadoConcent linha = new LinhaResultadoConcent();
                linha.codigo = ele.getAttribute("linharesultado");
                linha.codigoAmostra = ele.getAttribute("amostra");
                linha.resultado = this.trocaCaracteres(ele.getAttribute("resultado"));
                linha.unidade = ele.hasAttribute("unidade") ? ele.getAttribute("unidade") : this.buscaUnidadeLinhas(exameCadastro, linha.codigo);
                if (!Funcoes.textoVazio(ele.getAttribute("observacao"))) {
                    observacao.append(this.trocaCaracteres(ele.getAttribute("observacao") + "\n"));
                }
                if ((index = (lis = ele.getAttribute("id_lis")).indexOf("|")) > 0) {
                    exame.codigoJalis = lis.substring(0, lis.indexOf("|"));
                    exame.materialJalis = lis.substring(lis.indexOf("|") + 1);
                } else if (examesJalis.containsKey(exame.codigo)) {
                    lis = examesJalis.get(exame.codigo);
                    exame.codigoJalis = lis.substring(0, lis.indexOf("|"));
                    exame.materialJalis = lis.substring(lis.indexOf("|") + 1);
                }
                exame.linhasResultado.add(linha);
                continue;
            }
            if (ele.getNodeName().equals("camposcomplementares")) {
                for (Element element : XMLUtil.getElementosFilhos(ele)) {
                    CampoResultadoConcent campo = new CampoResultadoConcent();
                    campo.codigo = element.getAttribute("codigo");
                    campo.resultado = this.trocaCaracteres(element.getAttribute("resultado"));
                    if (exame.linhasResultado.size() <= 0) continue;
                    exame.linhasResultado.get((int)(exame.linhasResultado.size() - 1)).camposCompl.add(campo);
                }
                continue;
            }
            if (ele.getNodeName().equals("antibiograma")) {
                for (Element element : XMLUtil.getElementosFilhos(ele)) {
                    CampoResultadoConcent campo = new CampoResultadoConcent();
                    resultadoAntibiogramas.append(element.getAttribute("antibiotico")).append(" - ");
                    resultadoAntibiogramas.append(campo.getResistencia(element.getAttribute("resistencia")));
                    if (element.hasAttribute("mic")) {
                        resultadoAntibiogramas.append(element.getAttribute("mic"));
                    }
                    resultadoAntibiogramas.append("\n");
                }
                continue;
            }
            if (!ele.getNodeName().equals("curvas")) continue;
            for (Element element : XMLUtil.getElementosFilhos(ele)) {
                grafico = element.getAttribute("pontos");
            }
        }
        exame.observacao = observacao.toString();
        exame.resultadoAntibiogramas = resultadoAntibiogramas.toString();
        exame.grafico = grafico;
        requisicao.exames.add(exame);
    }

    private HashMap<String, String> localizaExameJalis(RequisicaoConcent requisicao, String paciente) {
        String fil = Funcoes.getFilialRequisicao(requisicao.codigoJalis)[0];
        String req = Funcoes.getFilialRequisicao(requisicao.codigoJalis)[1];
        Statement st = Conexao.getStatement();
        HashMap<String, String> retorno = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  f.ele_xmllabexterno , b.exa_codigo, b.mco_codigo \n");
        sql.append("from requisicao a \n");
        sql.append(" join examerequisicao b  on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append(" join loteexternoexamerequisicao c  on a.fil_codigo = c.fil_kodigo and a.req_codigo = c.req_codigo and b.exa_codigo = c.exa_codigo and b.mco_codigo = c.mco_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join examematcoletalabexterno f on e.fil_codigo = f.fil_codigo and e.exa_codigo = f.exa_codigo and e.mco_codigo = f.mco_codigo and c.lae_codigo = f.lae_codigo ");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        if (!Funcoes.textoVazio(paciente)) {
            sql.append("  a.pac_codigo = ").append(paciente).append(" and \n");
        } else {
            this.setTextoInformacoes("\nSem o c\u00f3digo do paciente na requisi\u00e7\u00e3o do Jalis. : " + requisicao.codigoJalis, false);
        }
        sql.append("  c.lae_codigo = ").append(this.codigoLabExterno).append(" and \n");
        sql.append("  a.req_excluida = false and b.exr_excluido = false and \n");
        sql.append("  f.ele_xmllabexterno is not null and f.ele_xmllabexterno <> '' ");
        try {
            ResultSet res = Conexao.executeQuery(st, sql.toString());
            StringBuilder buf = new StringBuilder();
            while (res.next()) {
                buf.setLength(0);
                String exameConcent = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(res.getString("ele_xmllabexterno"), "Concent"), "exame"), "codigo");
                buf.append(res.getString("exa_codigo")).append("|").append(res.getString("mco_codigo"));
                if (Funcoes.textoVazio(exameConcent)) continue;
                retorno.put(exameConcent, buf.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    private String trocaCaracteres(String texto) {
        if (texto == null) {
            return null;
        }
        texto = texto.replace("&#xD;", "\n");
        texto = texto.replace("&#xA;", "\n");
        texto = texto.replace("&amp;#xA;", "\n");
        texto = texto.replace("&amp;#xD;", "\n");
        return texto;
    }

    private void parseAmostras(List<Element> elements, RequisicaoConcent requisicao) {
        for (Element e : elements) {
            String codigo;
            AmostraConcent amostra = new AmostraConcent();
            amostra.codigo = codigo = e.getAttribute("codigo");
            amostra.descricao = e.getAttribute("descricao");
            amostra.material = e.getAttribute("material");
            requisicao.amostras.put(codigo, amostra);
        }
    }

    private PacienteConcent locatePaciente(String paciente) {
        for (PacienteConcent p : this.pacientes) {
            if (!p.codigoAOL.equalsIgnoreCase(paciente)) continue;
            return p;
        }
        return null;
    }

    protected StringBuilder getSqlLocalizaExame(String fil, String req, String exa, String mco) {
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append("  b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(g.met_codigo, b.met_codigo) as met_codigo, \n");
        sql.append("  c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append("  a.req_guia as req_guia, b.exr_codautorizacao as exr_codautorizacao, b.exr_solicitadotiss as exr_solicitadotiss, ");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital \n");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        sql.append("  b.exa_codigo = '").append(exa).append("' and \n");
        sql.append("  b.mco_codigo = ").append(mco);
        sql.append("  and a.req_excluida = false and b.exr_excluido = false \n");
        return sql;
    }

    private boolean validaExameRelacionamento(ExameResultadoConcent exame, Statement st, String fil_codigo) throws SQLException {
        ResultSet rs;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(mco_codigo) as count from examematcoleta where fil_codigo = ");
        sql.append(fil_codigo);
        sql.append(" and exa_codigo = '");
        sql.append(exame.codigoJalis);
        sql.append("' and mco_codigo = ");
        sql.append(exame.materialJalis);
        if (!Funcoes.textoVazio(exame.codigoJalis) && !Funcoes.textoVazio(exame.materialJalis) && (rs = Conexao.executeQuery(st, sql.toString())).next()) {
            return rs.getInt("count") == 1;
        }
        return false;
    }

    private void adicionarAoModeloRelatorio(RequisicaoConcent requisicao, ExameResultadoConcent exame, Situacao situacao) {
        if (requisicao.codigoJalis.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboFilial()) {
            return;
        }
        String fil_codigo = requisicao.codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = requisicao.codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial());
        if (exame != null && !Funcoes.textoVazio(exame.codigoJalis) && !Funcoes.textoVazio(exame.materialJalis)) {
            RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, fil_codigo, req_codigo, exame.codigoJalis, Integer.parseInt(exame.materialJalis), situacao.descricao);
        }
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "codigo");
                    mco = StringUtil.getValor(xml, "material");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select alv_xml from examesalvaro where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sqlBuilder.append(" and alv_codexame = '").append(exa).append("' and alv_codmaterial = '").append(mco).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("alv_xml", rs.getString("alv_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    private void atualizarPaginaOrdemExameWeb(Statement st, Registro dados) throws Exception {
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, dados.getString("fil_codigo"), dados.getString("req_codigo"), Variaveis.codigoBaseWeb);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoConcent 643");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_RELACIONAMENTO("Sem relacionamento"),
        SEM_MATERIAL("Sem material"),
        LAYOUT_ATUALIZADO("Layout atualizado, mas n\u00e3o relacionado");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

