/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.concent;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.alvaro.ConfiguradorProtocoloAlvaro;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloConcent
extends ConfiguradorProtocoloAlvaro
implements ActionListener {
    public static final String LOTE = "lote";
    public static final String CODIGO = "codigo";
    public static final String CHAVE = "chave";
    public static final String ENVIAR_MEDICO = "enviarMedico";
    public static final String PROCESSAR_ENTER = "processarEnter";
    public static final String ENVIAR_TUBO_LIS = "enviarTuboLis";
    public static final String CODIGO_TUBO_LIS = "codigoTuboLis";
    protected JCheckBox checkEnviarTuboLis;
    protected JTextField textCodTuboLis;

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloConcent((Frame)pai, "Laborat\u00f3rio Concent", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloConcent((Dialog)pai, "Laborat\u00f3rio Concent", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloConcent(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
    }

    public ConfiguradorProtocoloConcent(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.checkEnviarTuboLis) {
            this.textCodTuboLis.setEnabled(this.checkEnviarTuboLis.isSelected());
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void iniciar() {
        this.textCodTuboLis = new TTextField(2, 1);
        this.checkEnviarTuboLis = new JCheckBox("Enviar c\u00f3digo do tubo LIS");
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        JLabel lblChave = ComponenteFactory.novoJLabel("Chave:", new Dimension(85, 25));
        lblChave.setMinimumSize(new Dimension(85, 25));
        this.getPanelCentral().add((Component)lblChave, cons);
        cons.gridx = 1;
        this.textChave = new TTextField(16, 3);
        this.textChave.setPreferredSize(new Dimension(150, 25));
        this.textChave.setMinimumSize(new Dimension(150, 25));
        this.getPanelCentral().add((Component)this.textChave, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        JLabel lblCodigo = ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(85, 25));
        lblCodigo.setMinimumSize(new Dimension(85, 25));
        this.getPanelCentral().add((Component)lblCodigo, cons);
        cons.gridx = 1;
        this.textCodigo.setPreferredSize(new Dimension(200, 25));
        this.textCodigo.setMinimumSize(new Dimension(200, 25));
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(85, 25));
        lblLote.setMinimumSize(new Dimension(85, 25));
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        this.textLote.setPreferredSize(new Dimension(200, 25));
        this.textLote.setMinimumSize(new Dimension(200, 25));
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkMedico, cons);
        cons.gridx = 0;
        cons.gridy = 4;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkEnterNoResultado, cons);
        cons.gridx = 0;
        cons.gridy = 5;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkEnviarTuboLis, cons);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridwidth = 1;
        JLabel lblCodLIS = ComponenteFactory.novoJLabel("C\u00f3digo LIS:", new Dimension(100, 25));
        lblLote.setMinimumSize(new Dimension(100, 25));
        this.getPanelCentral().add((Component)lblCodLIS, cons);
        cons.gridx = 1;
        this.textCodTuboLis.setPreferredSize(new Dimension(200, 25));
        this.textCodTuboLis.setMinimumSize(new Dimension(200, 25));
        this.getPanelCentral().add((Component)this.textCodTuboLis, cons);
        this.pack();
        this.setSize(new Dimension(280, 255));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textChave);
        this.checkEnviarTuboLis.addActionListener(this);
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<alvaro>");
        bui.append(StringUtil.getTag(LOTE, this.textLote.getText()));
        bui.append(StringUtil.getTag(CODIGO, this.textCodigo.getText()));
        bui.append(StringUtil.getTag(CHAVE, this.textChave.getText()));
        bui.append(StringUtil.getTag(ENVIAR_MEDICO, this.checkMedico.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(PROCESSAR_ENTER, this.checkEnterNoResultado.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(ENVIAR_TUBO_LIS, this.checkEnviarTuboLis.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(CODIGO_TUBO_LIS, this.textCodTuboLis.getText()));
        return bui.append("</alvaro>").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        super.setXML(xml, verificarMaiorLote);
        this.checkEnviarTuboLis.setSelected(StringUtil.getValor(xml, ENVIAR_TUBO_LIS).trim().length() > 0 ? StringUtil.getBoolean(xml, ENVIAR_TUBO_LIS) : true);
        this.textCodTuboLis.setText(StringUtil.getValor(xml, CODIGO_TUBO_LIS));
        this.textCodTuboLis.setEnabled(this.checkEnviarTuboLis.isSelected());
    }
}

