/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.cerba;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.cerba.ParserImportacaoCerba;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.util.Map;
import javax.swing.JFileChooser;

public class ImportacaoCerba
extends AbstractImportadorLabExterno {
    public ImportacaoCerba(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Cerba partir de arquivo XML", codigoLabExterno, Protocolo.Cerba);
        this.getButtonImportar().setText("Importar Exames");
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = true;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS/XML do Lab. Cerba (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0) {
                StringBuilder bui = new StringBuilder();
                bui.append("Importando exames...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                Map<String, Registro> excluidos = ParserImportacaoCerba.importarExamesCerba(chooser, this.codigoLabExterno, this.progress);
                if (excluidos == null) {
                    retorno = false;
                    if (ParserImportacaoCerba.isArquivoValido()) {
                        bui.append("\nNenhum registro para ser importado.\n");
                    } else {
                        bui.append("\nArquivo inv\u00e1lido.");
                    }
                } else {
                    bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                }
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (excluidos != null && !excluidos.isEmpty()) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (Registro e : excluidos.values()) {
                        bui.append("\n\t|").append(StringUtil.formatarColuna(e.getString("ds_exame"), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getString("material").trim(), 50, 'c')).append("|");
                    }
                    bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
                retorno = true;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoDB: 67");
        }
        this.progress.setVisible(false);
        return retorno;
    }
}

