/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.cerba;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ConfiguradorProtocoloCerba
extends AbstractConfiguradorProtocolo {
    private static final String LABORATORIO = "Laborat\u00f3rio Cerba Internacional";
    private static final String LOTE = "lote";
    private static final String CERBA = "cerba";
    public static final String TAG_CODIGO_PROTOCOLO = "codigo";
    public static final String TAG_SENHA = "senha";
    private TTextField textCodigo = ComponenteFactory.novoTTextField(10, 3, this);
    protected TTextField textSenha = ComponenteFactory.novoTTextField(11, 3, this);

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloCerba((Frame)pai, LABORATORIO, codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloCerba((Dialog)pai, LABORATORIO, codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloCerba(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloCerba(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    @Override
    public String getXML() {
        XMLStringBuilder bui = new XMLStringBuilder();
        bui.abrir(CERBA);
        bui.escrever(TAG_CODIGO_PROTOCOLO, this.textCodigo.getText());
        bui.escrever(LOTE, this.textLote.getText());
        bui.escrever(TAG_SENHA, this.textSenha.getText());
        try {
            bui.fechar(CERBA);
        }
        catch (XMLStringBuilderException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel gerar xml de configura\u00e7\u00e3o.\n" + e.getMessage(), 2);
        }
        return bui.getXML();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, CERBA);
            this.textLote.setText(StringUtil.getValor(xml, LOTE));
            this.textCodigo.setText(StringUtil.getValor(xml, TAG_CODIGO_PROTOCOLO));
            this.textSenha.setText(StringUtil.getValor(xml, TAG_SENHA));
        }
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.anchor = 13;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(85, 20));
        lblLote.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        this.textLote.setPreferredSize(new Dimension(200, 20));
        this.textLote.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        JLabel lblCodigo = ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(85, 20));
        lblCodigo.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblCodigo, cons);
        cons.gridx = 1;
        this.textCodigo.setPreferredSize(new Dimension(200, 20));
        this.textCodigo.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        JLabel lblChave = ComponenteFactory.novoJLabel("Senha:", new Dimension(85, 20));
        lblChave.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblChave, cons);
        cons.gridx = 1;
        this.textSenha.setPreferredSize(new Dimension(150, 20));
        this.textSenha.setMinimumSize(new Dimension(150, 20));
        this.getPanelCentral().add((Component)this.textSenha, cons);
        this.pack();
        this.setSize(new Dimension(330, 180));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textLote);
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textSenha.getText())) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado uma senha", 1);
        } else if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um c\u00f3digo v\u00e1lido", 1);
        } else {
            return true;
        }
        return false;
    }
}

