/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.balague;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.balague.CampoBalague;
import jalis.laboratorio.util.parsers.balague.ExameBalague;
import jalis.laboratorio.util.parsers.balague.RequisicaoBalague;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParserImportacaoBalague {
    public static List<RequisicaoBalague> loadDadosExame(File file, int codigoLabExterno) {
        ArrayList<RequisicaoBalague> requisicoes = new ArrayList<RequisicaoBalague>();
        Document doc = ParserImportacaoBalague.analisarXML(file);
        if (doc != null) {
            Element raiz = doc.getDocumentElement();
            for (Element e : XMLUtil.getElementosFilhos(raiz)) {
                if (!e.getNodeName().toLowerCase().equals("pacientes")) continue;
                for (Element paciente : XMLUtil.getElementosFilhos(e)) {
                    if (!paciente.getNodeName().toLowerCase().equals("paciente")) continue;
                    requisicoes.add(ParserImportacaoBalague.parseRequisicao(paciente, codigoLabExterno));
                }
            }
        }
        return requisicoes;
    }

    private static Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    private static RequisicaoBalague parseRequisicao(Element paciente, int codigoLabExterno) {
        RequisicaoBalague req = new RequisicaoBalague();
        HashMap<String, ExameBalague> exames = new HashMap<String, ExameBalague>();
        for (Element e : XMLUtil.getElementosFilhos(paciente)) {
            if (e.getNodeName().toLowerCase().equals("cd_paciente")) {
                req.setPaciente(e.getTextContent());
                continue;
            }
            if (e.getNodeName().toLowerCase().equals("cd_pedido")) {
                String[] codigo = Funcoes.getFilialRequisicao(e.getTextContent());
                req.setFilial(codigo[0]);
                req.setRequisicao(codigo[1]);
                continue;
            }
            if (!e.getNodeName().toLowerCase().equals("exames")) continue;
            for (Element resultado : XMLUtil.getElementosFilhos(e)) {
                ExameBalague ex;
                if (!resultado.getNodeName().toLowerCase().equals("resultados") || (ex = ParserImportacaoBalague.parseExame(resultado, codigoLabExterno)) == null) continue;
                if (ex.getCodigo() != null) {
                    if (exames.containsKey(ex.getCodigo().toString())) {
                        for (CampoBalague campo : ex.getCampos()) {
                            ((ExameBalague)exames.get(ex.getCodigo().toString())).addCampo(campo);
                        }
                        continue;
                    }
                    exames.put(ex.getCodigo().toString(), ex);
                    continue;
                }
                exames.put(ex.getDescricao(), ex);
            }
        }
        req.getExames().addAll(exames.values());
        return req;
    }

    private static ExameBalague parseExame(Element resultado, int codigoLabExterno) {
        CampoBalague campoBalague = new CampoBalague();
        ExameBalague exameBalague = new ExameBalague();
        String codigoParametro = "";
        exameBalague.addCampo(campoBalague);
        for (Element e : XMLUtil.getElementosFilhos(resultado)) {
            if (e.getNodeName().toLowerCase().equals("cd_exame")) {
                if (Funcoes.isNumeric(e.getTextContent())) {
                    exameBalague.setCodigo(Integer.parseInt(e.getTextContent()));
                    ParserImportacaoBalague.getExame(e.getTextContent(), codigoLabExterno, exameBalague);
                    continue;
                }
                exameBalague.setDescricao(e.getTextContent());
                continue;
            }
            if (e.getNodeName().toLowerCase().equals("cd_parametro")) {
                codigoParametro = e.getTextContent();
                campoBalague.setCodigo(e.getTextContent());
                continue;
            }
            if (e.getNodeName().toLowerCase().equals("dt_alteracao")) {
                exameBalague.setDataAlteracao(Funcoes.stringToDate("yyyy-MM-dd HH:mm:ss", e.getTextContent()));
                continue;
            }
            if (e.getNodeName().toLowerCase().equals("dt_resultado")) {
                exameBalague.setDataResultado(Funcoes.stringToDate("yyyy-MM-dd HH:mm:ss", e.getTextContent()));
                continue;
            }
            if (e.getNodeName().toLowerCase().equals("valor")) {
                campoBalague.setResultado(e.getTextContent().replace('.', ','));
                continue;
            }
            if (e.getNodeName().toLowerCase().equals("unidade")) {
                campoBalague = new CampoBalague();
                campoBalague.setCodigo(codigoParametro + "UN");
                campoBalague.setResultado(e.getTextContent());
                exameBalague.addCampo(campoBalague);
                continue;
            }
            if (!e.getNodeName().toLowerCase().equals("metodologia")) continue;
            campoBalague = new CampoBalague();
            campoBalague.setCodigo("Metodologia");
            campoBalague.setResultado(e.getTextContent());
            exameBalague.addCampo(campoBalague);
        }
        return exameBalague;
    }

    private static void getExame(String codigoExame, int codigoLabExterno, ExameBalague exameBalague) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("where \n");
                bui.append(" a.ele_xmllabexterno <> '' and a.ele_xmllabexterno is not null and \n");
                bui.append(" a.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append(" a.lae_codigo = ").append(codigoLabExterno).append(" and \n");
                bui.append(" a.ele_xmllabexterno ilike '%<codigo>").append(codigoExame).append("</codigo>%'");
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                if (rs.next()) {
                    exameBalague.setExameJalis(rs.getString("exa_codigo"));
                    exameBalague.setMaterialJalis(rs.getString("mco_codigo"));
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
            Conexao.fecharStatement(st);
        }
    }
}

