/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.balague;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.balague.CampoBalague;
import jalis.laboratorio.util.parsers.balague.ExameBalague;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.excel.EscreverArquivoXls;
import jalis.util.excel.Excel;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;

public class ImportacaoBalague
extends AbstractImportadorLabExterno {
    private static final int COLUNA_MATERIAL = 0;
    private static final int COLUNA_CODIGO_BCL_NUMERICO = 1;
    private static final int COLUNA_CODIGO_BCL_TEXTO = 2;
    private static final int COLUNA_DESCRICAO_EXAME_BCL = 3;
    private static final int COLUNA_DESCRICAO_CAMPO_RESULTADO = 4;
    private JButton buttonExportarExames = ComponenteFactory.novoJButton("Exportar planilha de exames", 'I', this);

    public ImportacaoBalague(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Balague", codigoLabExterno, Protocolo.Balague);
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().add((Component)this.buttonExportarExames, 1);
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
    }

    @Override
    public void anexarTextoInformacoes(String texto) {
        super.anexarTextoInformacoes(texto);
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        try {
            StringBuilder bui = new StringBuilder();
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo [Excel 97/2000/XP] do Lab. S. Balagu\u00e9 (*.xls)", "xls"));
            if (chooser.showOpenDialog(this) == 0) {
                Set<ExameBalague> excluidos = this.importarExamesBalague(chooser.getSelectedFile(), this.codigoLabExterno, this.progress);
                Thread.sleep(50L);
                this.setTextoInformacoes("Buscando dados... aguarde.");
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                if (excluidos != null && excluidos.size() > 0) {
                    bui.append("\n\nOs seguintes exames foram excluidos: \n\n");
                    bui.append("+--------+-----------------------------------------------------------------------------+\n");
                    bui.append("| CODIGO |                      EXAME                       |          MATERIAL        |\n");
                    bui.append("+--------+-----------------------------------------------------------------------------+");
                    for (ExameBalague exameBalague : excluidos) {
                        bui.append("\n|").append(StringUtil.formatarColuna(exameBalague.getCodigo().toString(), 8, 'e'));
                        bui.append("|").append(StringUtil.formatarColuna(exameBalague.getDescricao(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(exameBalague.getMaterial(), 26, 'c')).append("|");
                    }
                    bui.append("\n+--------+-----------------------------------------------------------------------------+");
                    this.anexarTextoInformacoes(bui.toString());
                }
                this.anexarTextoInformacoes("\nImporta\u00e7\u00e3o conclu\u00edda");
                retorno = true;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar arquivo - Lab. Rede - " + e.getMessage(), e.getStackTrace());
        }
        this.progress.setVisible(false);
        return retorno;
    }

    private Set<ExameBalague> importarExames(File file) throws IOException {
        HashSet<ExameBalague> examesBalague = new HashSet<ExameBalague>();
        List<List<Object>> dados = Excel.ler(file);
        ExameBalague exBcl = new ExameBalague();
        exBcl.setCodigo(-1);
        for (List<Object> linha : dados) {
            if (linha.size() != 5 && !Funcoes.isNumeric(linha.get(1).toString())) continue;
            int codigo = new Double(Double.parseDouble(linha.get(1).toString())).intValue();
            if (!exBcl.getCodigo().equals(codigo)) {
                exBcl = new ExameBalague();
                exBcl.setCodigo(codigo);
                exBcl.setDescricao(linha.get(3) instanceof String ? linha.get(3).toString() : "Tipo n\u00e3o \u00e9 uma String");
                exBcl.setMaterial(linha.get(3) instanceof String ? linha.get(0).toString() : "Tipo n\u00e3o \u00e9 uma String");
                examesBalague.add(exBcl);
            }
            CampoBalague campoBcl = new CampoBalague();
            campoBcl.setCodigo(linha.get(2) instanceof String ? linha.get(2).toString() : "Tipo informado \u00e9 uma String");
            campoBcl.setComentario(linha.get(4) instanceof String ? linha.get(4).toString() : "Tipo informado \u00e9 uma String");
            exBcl.addCampo(campoBcl);
        }
        return examesBalague;
    }

    private Set<ExameBalague> importarExamesBalague(File file, int codigoLabExterno, JProgressBar progress) throws Exception {
        Object materiais = null;
        Set<ExameBalague> examesNovos = this.importarExames(file);
        HashSet<ExameBalague> examesExcluidos = new HashSet<ExameBalague>();
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                Map<Integer, ExameBalague> examesAntigosRelac = this.examesMap(ImportacaoBalague.getExamesRelacionados(codigoLabExterno));
                Set<ExameBalague> examesAntigos = ImportacaoBalague.loadExamesBalague(st, codigoLabExterno);
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 4, new Object[0]);
                if (progress != null) {
                    progress.setMaximum(examesNovos.size());
                    progress.setValue(0);
                }
                ImportacaoBalague.inserirExamesBalague(examesNovos, st, codigoLabExterno, progress);
                HashSet<ExameBalague> examesNovosRel = new HashSet<ExameBalague>(examesNovos);
                examesNovosRel.retainAll(examesAntigosRelac.values());
                if (progress != null) {
                    progress.setMaximum(examesNovosRel.size());
                    progress.setValue(0);
                }
                for (ExameBalague ex : examesNovosRel) {
                    if (progress != null) {
                        progress.setValue(progress.getValue() + 1);
                    }
                    ExameBalague exAntigo = examesAntigosRelac.get(ex.getCodigo());
                    ex.setExameJalis(exAntigo.getExameJalis());
                    ex.setMaterialJalis(exAntigo.getMaterialJalis());
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), StringUtil.textoDB(ex.getXml()));
                }
                examesExcluidos.addAll(examesAntigos);
                examesExcluidos.removeAll(examesNovos);
                HashSet<ExameBalague> examesExcluidosRel = new HashSet<ExameBalague>(examesAntigosRelac.values());
                examesExcluidosRel.removeAll(examesNovos);
                for (ExameBalague ex : examesExcluidosRel) {
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), StringUtil.textoDB(ex.getXml()));
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImportacaoBalague");
            }
        }
        return examesExcluidos;
    }

    private static void inserirExamesBalague(Set<ExameBalague> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws SQLException, SalvaDadosException {
        for (ExameBalague eb : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            if (Funcoes.textoVazio(eb.getMaterial())) continue;
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 4, eb.getCodigo(), StringUtil.textoDB(eb.getDescricao().trim().length() > 100 ? eb.getDescricao().trim().substring(0, 100) : eb.getDescricao().trim()), StringUtil.textoDB(eb.getMaterial()), StringUtil.textoDB(eb.getXml()));
        }
    }

    private static Set<ExameBalague> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno).append(" and \n");
                bui.append("  a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameBalague.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameBalague>();
    }

    private Map<Integer, ExameBalague> examesMap(Collection<ExameBalague> exames) {
        HashMap<Integer, ExameBalague> examesMap = new HashMap<Integer, ExameBalague>();
        for (ExameBalague ex : exames) {
            examesMap.put(ex.getCodigo(), ex);
        }
        return examesMap;
    }

    private static Set<ExameBalague> loadExamesBalague(Statement st, int codigoLabExterno) throws SQLException {
        HashSet<ExameBalague> exames = new HashSet<ExameBalague>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, lae_codigo, bal_codexame, bal_descricaoexame, bal_descricaomaterial, bal_xml ");
        sql.append(" from examesbalague ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ExameBalague e = new ExameBalague(rs.getString("bal_xml"));
            e.setCodigo(rs.getInt("bal_codexame"));
            e.setDescricao(rs.getString("bal_descricaoexame"));
            e.setMaterial(rs.getString("bal_descricaomaterial"));
            exames.add(e);
        }
        return exames;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonExportarExames) {
            this.exportarPlanilha();
        } else {
            super.actionPerformed(e);
        }
    }

    private void exportarPlanilha() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setSelectedFile(new File("Depara" + Funcoes.formataData("dd-MM-yyyy", new Date()) + ".xls"));
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo [Excel 97/2000/XP] do Lab. S. Balagu\u00e9 (*.xls)", "xls"));
        if (chooser.showOpenDialog(this) == 0) {
            EscreverArquivoXls xls = new EscreverArquivoXls();
            this.setTextoInformacoes("Exportando lista de exames relacionados\n");
            try {
                int plan = xls.addAba("Plan1");
                Statement st = Conexao.getStatement();
                StringBuilder bui = new StringBuilder();
                bui.append("select a.exa_codigo, a.mco_codigo, b.exa_descricao, a.ele_xmllabexterno from examematcoletalabexterno a");
                bui.append(" join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo");
                bui.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append(" and a.lae_codigo = ").append(this.codigoLabExterno);
                ResultSet rs = Conexao.executeQuery(st, bui);
                int linha = 0;
                while (rs.next()) {
                    String xml = rs.getString("ele_xmllabexterno");
                    for (String campo : StringUtil.getValores(xml, "campo")) {
                        Object[] cel = new Object[]{StringUtil.getValor(xml, "codigo"), rs.getString("exa_descricao"), StringUtil.getValor(campo, "codigo"), StringUtil.getValor(campo, "comentario"), StringUtil.getValor(xml, "material"), StringUtil.getValor(xml, "codigo"), StringUtil.getValor(campo, "codigo"), StringUtil.getValor(xml, "descricao"), StringUtil.getValor(campo, "comentario")};
                        xls.setLinha(plan, linha++, cel);
                    }
                }
                Conexao.fecharStatement(st);
                xls.escreverArquivo(chooser.getSelectedFile().getAbsolutePath());
                this.anexarTextoInformacoes("Gera\u00e7\u00e3o da planilha conclu\u00edda!");
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel executar sql  " + e.getMessage(), e.getStackTrace());
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar planilha  " + e.getMessage(), e.getStackTrace());
            }
        }
    }
}

