/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.balague;

import jalis.comum.Conexao;
import jalis.laboratorio.util.parsers.balague.CampoBalague;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExameBalague {
    public static final String TAG_BALAGUE = "balague";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_DESCRICAO = "descricao";
    public static final String TAG_MATERIAL = "material";
    public static final String TAG_CAMPOS = "campos";
    private Integer codigo;
    private String descricao;
    private String material;
    private String exameJalis;
    private String materialJalis;
    private Date dataAlteracao;
    private Date dataResultado;
    private List<CampoBalague> campos = new ArrayList<CampoBalague>();

    public ExameBalague() {
    }

    public ExameBalague(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.exameJalis = res.getString("exa_codigo");
        this.materialJalis = res.getString("mco_codigo");
        this.parseXml(res.getString("ele_xmllabexterno"));
    }

    public ExameBalague(String xml) {
        this.parseXml(xml);
    }

    private void parseXml(String xml) {
        if (xml != null) {
            String exame = StringUtil.getValor(xml, TAG_EXAME);
            this.codigo = Integer.parseInt(StringUtil.getValor(exame, TAG_CODIGO));
            this.descricao = StringUtil.getValor(exame, TAG_DESCRICAO);
            this.material = StringUtil.getValor(exame, TAG_MATERIAL);
            this.campos = new ArrayList<CampoBalague>();
            for (String campo : StringUtil.getValores(xml, "campo")) {
                CampoBalague cb = new CampoBalague();
                cb.setCodigo(StringUtil.getValor(campo, TAG_CODIGO));
                cb.setComentario(StringUtil.getValor(campo, "comentario"));
                this.addCampo(cb);
            }
        }
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getMaterial() {
        return this.material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public Date getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(Date dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public Date getDataResultado() {
        return this.dataResultado;
    }

    public void setDataResultado(Date dataResultado) {
        this.dataResultado = dataResultado;
    }

    public List<CampoBalague> getCampos() {
        return Collections.unmodifiableList(this.campos);
    }

    public void addCampo(CampoBalague campo) {
        this.campos.add(campo);
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_BALAGUE);
            xml.abrir(TAG_EXAME);
            xml.escrever(TAG_CODIGO, String.valueOf(this.getCodigo()));
            xml.escrever(TAG_DESCRICAO, this.getDescricao());
            xml.escrever(TAG_MATERIAL, this.getMaterial());
            xml.abrir(TAG_CAMPOS);
            for (CampoBalague campo : this.campos) {
                campo.escreveXml(xml);
            }
            xml.fechar(TAG_CAMPOS);
            xml.fechar(TAG_EXAME);
            xml.fechar(TAG_BALAGUE);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameBalague");
        }
        return xml.getXML();
    }

    public static Set<ExameBalague> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameBalague> list = new HashSet<ExameBalague>();
        if (res.first()) {
            do {
                list.add(new ExameBalague(res));
            } while (res.next());
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExameBalague) {
            return this.codigo.equals(((ExameBalague)obj).getCodigo());
        }
        return false;
    }

    public int hashCode() {
        return this.codigo.hashCode();
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorBalague = StringUtil.getValor(xml, TAG_BALAGUE);
        return valorBalague != null && valorBalague.trim().length() > 0 && (valorExame = StringUtil.getValor(valorBalague, TAG_EXAME)) != null && valorExame.trim().length() > 0;
    }

    public static Set<ExameBalague> getExames(Integer filial, Integer codigoLaboratorio) throws SQLException {
        StringBuilder bui = new StringBuilder("Select");
        bui.append(" bal_xml from examesbalague ");
        bui.append(" where fil_codigo = ").append(filial);
        bui.append(" and lae_codigo = ").append(codigoLaboratorio);
        bui.append(" order by bal_descricaoexame ");
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, bui);
        HashSet<ExameBalague> exames = new HashSet<ExameBalague>();
        while (res.next()) {
            exames.add(new ExameBalague(res.getString("bal_xml")));
        }
        Conexao.fecharStatement(st);
        return exames;
    }
}

