/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.balague;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ConfiguradorProtocoloBalague
extends AbstractConfiguradorProtocolo {
    @Override
    public int getNumeroLote() {
        if (Funcoes.textoVazio(this.textLote)) {
            return 0;
        }
        return Integer.parseInt(this.textLote.getText());
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloBalague((Frame)pai, "Laborat\u00f3rio Balague", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloBalague((Dialog)pai, "Laborat\u00f3rio Balague", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloBalague(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloBalague(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<Balague>");
        bui.append(StringUtil.getTag("lote", this.textLote.getText()));
        return bui.append("</Balague>").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "Balague");
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
        }
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        JLabel labelLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(80, 20));
        this.textLote.setMaximumSize(new Dimension(80, 20));
        this.textLote.setMinimumSize(this.textLote.getMaximumSize());
        this.textLote.setSize(this.textLote.getMaximumSize());
        this.textLote.setPreferredSize(this.textLote.getMaximumSize());
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 1, 1, 1);
        this.getPanelCentral().add((Component)labelLote, cons);
        ++cons.gridx;
        this.textLote.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textLote, cons);
        this.setSize(new Dimension(200, 120));
        this.setLocationRelativeTo(null);
        ScreenUtil.requisitarFoco(this.textLote);
        this.setResizable(false);
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textLote)) {
            Funcoes.mensagem(this, "Numero do lote n\u00e3o informado", 1);
            return false;
        }
        return true;
    }
}

