/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.balague;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.balague.ExameBalague;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorBalague
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String DESC_MAT = "descricaoMaterial";
    private static final String OBJ_EXAME_BALAGUE = "objExameBalague";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "descricaoMaterial");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 70, 0, 200);
    private JTextField textLocalizar = new JTextField();
    private String xmlSelecionado = "";

    public ConfiguradorBalague(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Balagu\u00e9", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorBalague(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Balagu\u00e9", codigoLabExterno);
        this.iniciar();
    }

    public static ConfiguradorBalague novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorBalague((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorBalague((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(690, 200));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        try {
            this.carregarExames();
        }
        catch (NumberFormatException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel formatar n\u00famero " + e.getMessage(), e.getStackTrace());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados dos exames " + e.getMessage(), e.getStackTrace());
        }
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorBalague.this.modExa.filtrar(ConfiguradorBalague.DESC_EXA, ConfiguradorBalague.this.textLocalizar.getText());
                if (ConfiguradorBalague.this.modExa.getRowCount() > 0) {
                    ConfiguradorBalague.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(80);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorBalague.this.tableExa.hasFocus() && (row = ConfiguradorBalague.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorBalague.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorBalague.this.tableExa.scrollRectToVisible(ConfiguradorBalague.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorBalague.this.tableExa.hasFocus() && (row = ConfiguradorBalague.this.tableExa.getSelectedRow()) < ConfiguradorBalague.this.tableExa.getRowCount() - 1) {
                    ConfiguradorBalague.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorBalague.this.tableExa.scrollRectToVisible(ConfiguradorBalague.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() throws NumberFormatException, SQLException {
        for (ExameBalague exame : ExameBalague.getExames(Integer.valueOf(Variaveis.filialPadrao), Integer.valueOf(this.getCodigoLabExterno()))) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigo());
            reg.setValor(DESC_EXA, exame.getDescricao());
            reg.setValor(DESC_MAT, exame.getMaterial());
            reg.setValor(OBJ_EXAME_BALAGUE, exame);
            this.modExa.addRegistro(reg);
        }
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameBalague exa = new ExameBalague(xml);
            return exa.getCodigo() + "|1";
        }
        return "";
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null && xml.trim().length() > 0) {
            ExameBalague exa = new ExameBalague(xml);
            return exa.getDescricao();
        }
        return "";
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public boolean acaoOk() {
        ExameBalague exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    @Override
    public void setXML(String xml) {
        if (ExameBalague.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameBalague exa = new ExameBalague(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.equals(reg.getValor(OBJ_EXAME_BALAGUE))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    private ExameBalague getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameBalague)reg.getValor(OBJ_EXAME_BALAGUE);
        }
        return null;
    }

    private boolean atualizarXMLSelecionado() {
        ExameBalague exa = this.getExameSelecionado();
        if (exa != null) {
            this.xmlSelecionado = exa.getXml();
            return true;
        }
        return false;
    }
}

