/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.atitude.resultado;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.atitude.ParserImportacaoAtitude;
import jalis.laboratorio.util.parsers.atitude.resultado.CamposRelacionamentoAtitudeUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CamposImportacaoAtitude
implements CamposImportacao {
    LinkedHashMap<String, String> linhas;
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPaiDesm;

    public CamposImportacaoAtitude(String xmlAtitude, String xmlExameLabApoio, String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPaiDesm) {
        block9: {
            block8: {
                this.linhas = new LinkedHashMap();
                this.codigoExamePai = codigoExamePai;
                this.codigoMaterialPaiDesm = codigoMaterialPaiDesm;
                this.linhas.put("", "Nenhum");
                this.linhas.put(CamposRelacionamentoAtitudeUtil.REQUISICAO_ATITUDE, "C\u00f3digo da requisi\u00e7\u00e3o no Atitude");
                this.linhas.put(CamposRelacionamentoAtitudeUtil.OBSERVACAO_EXAME, "Observa\u00e7\u00e3o do Exame");
                this.linhas.put(CamposRelacionamentoAtitudeUtil.CODIGO_EXAME_ATITUDE, "C\u00f3digo do exame no Atitude");
                this.linhas.put(CamposRelacionamentoAtitudeUtil.DESCRICAO_EXAME, "Descri\u00e7\u00e3o do exame no Atitude");
                this.linhas.put(CamposRelacionamentoAtitudeUtil.CODIGO_MAT_ATITUDE, "C\u00f3digo do material no Atitude");
                this.linhas.put(CamposRelacionamentoAtitudeUtil.DATA_ALTERACAO, "Data de altera\u00e7\u00e3o do layout do exame no Atitude");
                this.linhas.put(CamposRelacionamentoAtitudeUtil.VALOR_REFERENCIA, "Valores de refer\u00eancia");
                this.linhas.put(CamposRelacionamentoAtitudeUtil.METODOLOGIA, "Metodologia");
                Registro exame = ParserImportacaoAtitude.getExame(xmlExameLabApoio, null, null);
                if (xmlAtitude.indexOf("?xml version") >= 0) break block8;
                this.codigoExame = StringUtil.getValor(xmlAtitude, "codigo");
                this.versao = StringUtil.getValor(xmlAtitude, "data_alteracao");
                List linhasResultado = exame.getValor("linhasResultado", List.class);
                if (linhasResultado == null || linhasResultado.size() <= 0) break block9;
                for (Registro linha : linhasResultado) {
                    String codigo = linha.getString("idLinhaResultado");
                    String descricao = linha.getString("descricao");
                    String unidade = this.trocaCaracter(linha.getString("unidade"));
                    String possuiCurva = exame.getString("possuiCurva");
                    if (!Funcoes.textoVazio(possuiCurva)) {
                        this.carregaTemposLinhas(codigo, descricao, xmlExameLabApoio, possuiCurva);
                        continue;
                    }
                    this.linhas.put(codigo, Funcoes.textoVazio(unidade) ? descricao : String.format("%s (%s)", descricao, unidade));
                }
                break block9;
            }
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(xmlAtitude)));
                Element elem = doc.getDocumentElement();
                NodeList nl = elem.getElementsByTagName("exame");
                String tempExame = StringUtil.getValor(xmlExameLabApoio, "codigo");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element tagExame = (Element)nl.item(i);
                    this.codigoExame = tagExame.getAttribute("codigo");
                    if (!this.codigoExame.equalsIgnoreCase(tempExame)) continue;
                    this.versao = tagExame.getAttribute("data_alteracao");
                    List<Element> childs = XMLUtil.getElementosFilhos(tagExame);
                    for (Element c : childs) {
                        if (!c.getNodeName().equalsIgnoreCase("linhasResultado")) continue;
                        List<Element> l = XMLUtil.getElementosFilhos(c);
                        for (Element e : l) {
                            String linhaCodigo = e.getAttribute("codigo");
                            String linhaDescricao = e.getAttribute("descricao");
                            String possuiCurva = StringUtil.getValor(xmlExameLabApoio, "possuiCurva");
                            if (!Funcoes.textoVazio(possuiCurva)) {
                                this.carregaTemposLinhas(linhaCodigo, linhaDescricao, xmlExameLabApoio, possuiCurva);
                                continue;
                            }
                            this.linhas.put(linhaCodigo, linhaDescricao);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String trocaCaracter(String vlr) {
        String sup = StringUtil.getValor(vlr, "sup");
        if (!Funcoes.textoVazio(sup)) {
            return StringUtil.xmlToTexto(String.format("%s&sup%s;", vlr.substring(0, vlr.indexOf("<sup>")), sup));
        }
        return vlr;
    }

    private void carregaTemposLinhas(String linha, String descricao, String xml, String possuiCurva) {
        String[] xmlLinhas;
        for (String s : xmlLinhas = StringUtil.getValores(StringUtil.getValor(xml, "linhasResultado"), "linhaResultado")) {
            if (StringUtil.getValor(s, "preDigitado").equals("S")) continue;
            String codigoLinha = StringUtil.getValor(s, "idLinhaResultado");
            this.linhas.put(codigoLinha, descricao);
            if (!codigoLinha.equalsIgnoreCase(linha)) continue;
            int intervalos = Integer.parseInt(possuiCurva);
            for (int i = 1; i <= intervalos; ++i) {
                String desc = String.format("%s intervalo %s", descricao, String.valueOf(i));
                String cod = String.format("%s_intervalo_%s", codigoLinha, String.valueOf(i));
                this.linhas.put(cod, desc);
            }
        }
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPaiDesm;
    }
}

