/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.atitude;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.excel.Excel;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParserImportacaoAtitude {
    public static final String VERSAO = "20110901";
    public static final String TAG_DADO = "dado";
    private static final String TAG_ALTURA = "ALTURA";
    private static final String TAG_PESO = "PESO";
    private static final String TAG_VOLUME = "VOLUME";
    public static final String TAG_ATITUDE = "atitude";
    public static final String TAG_XML = "xml";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_MATERIAL = "material";
    public static final String TAG_MATERIAL_DESCRICAO = "material_descricao";
    public static final String TAG_DATA_ALTERACAO = "data_alteracao";
    public static final String TAG_MATERIAL_COMPOSTO = "material_composto";
    public static final String TAG_SELECIONADO = "selecionado";
    public static final String TAG_LINHA_RESULTADO = "linhaResultado";
    public static final String TAG_LINHAS_RESULTADO = "linhasResultado";
    public static final String TAG_EXAME_JALIS = "exa_codigo";
    public static final String TAG_MATERIAL_JALIS = "mco_codigo";
    public static final String TAG_PLANILHA_MATERIAIS = "Material";
    public static final String TAG_PLANILHA_EXAMES = "Exame";
    public static final String TAG_PLANILHA_LINHAS_DE_RESULTADO = "Linha de Resultado";
    public static final int COL_EXAME_CODIGO = 0;
    public static final int COL_EXAME_DESRICAO = 1;
    public static final int COL_ID_MATERIAL = 2;
    public static final int COL_EXAME_DATA_ULTIMA_ALTERACAO_EXAME = 3;
    public static final int COL_EXAME_METODO = 4;
    public static final int COL_MAT_CODIGO_MATERIAL = 0;
    public static final int COL_MAT_DESRICAO_MATERIAL = 1;
    public static final int COL_MAT_DATA_ULTIMA_ALTERACAO_MATERIAL = 2;
    public static final int COL_MAT_COMPOSTO = 3;
    public static final int COL_LINHA_ID_EXAME = 0;
    public static final int COL_LINHA_ID_LINHA_RESULTADO = 1;
    public static final int COL_LINHA_EXAME = 2;
    public static final int COL_LINHA_MNEMONICO = 3;
    public static final int COL_LINHA_DESCRICAO_LINHA = 4;
    public static final int COL_LINHA_ID_MATERIAL = 5;
    public static final int COL_LINHA_UNIDADE = 6;
    public static final int COL_LINHA_CASAS_DECIMAIS = 7;
    public static final int COL_LINHA_PRE_DIGITADO = 8;
    public static final int COL_LINHA_RESULTADO_COMPLEMENTAR = 9;
    public static final int COL_LINHA_DATA_ULTIMA_ALTERACAO_LINHA = 10;
    public static final String TAG_ID_LINHA_RESULTADO = "idLinhaResultado";
    public static final String TAG_UNIDADE = "unidade";
    public static final String TAG_CASAS_DECIMAIS = "casasDescimais";
    public static final String TAG_PRE_DIGITADO = "preDigitado";
    public static final String TAG_RESULTADO_COMPLEMENTAR = "resultadoComplementar";
    public static final String TAG_DADOS_ADICIONAIS = "dadosAdicionais";
    public static final String TAG_POSSUI_CURVA = "possuiCurva";
    public static final String TAG_AMOSTRAS = "amostras";
    public static final String TAG_AMOSTRA = "amostra";
    public static final String TAG_MEDICO = "medico";
    public static final String TAG_PACIENTE = "paciente";
    public static final String TAG_INTEGRACAO = "integracao";
    public static final String TAG_ESTRUTURA = "estrutura";
    public static final String TAG_RESULTADOS = "resultados";
    public static final String TAG_RESULTADO = "resultado";
    public static final String TAG_MATERIAIS = "materiais";
    public static final String TAG_EXAMES = "exames";
    public static final String TAG_REQUISICOES = "requisicoes";
    public static final String TAG_OBSERVACAO = "observacao";
    public static final String TAG_VALOR_REFERENCIA = "valorReferencia";
    public static final String TAG_RECIPIENTES = "recipientes";
    public static final String ATRIBUTO_CODIGO = "codigo";
    public static final String ATRIBUTO_DESCRICAO_EXAME = "descricao";
    public static final String ATRIBUTO_EXAME_METODO = "metodo";
    public static final String ATRIBUTO_DESCRICAO_LINHA = "descricao";
    public static final String ATRIBUTO_DESCRICAO_AMOSTRA = "descricao";
    public static final String ATRIBUTO_DATA_RESULTADO = "dataResultado";
    public static final String ATRIBUTO_ID_APOIO = "idApoio";
    public static final String ATRIBUTO_ID_AMOSTRA = "idAmostra";
    public static final String ATRIBUTO_ID_EXAME = "idExame";
    public static final String ATRIBUTO_ID_LIS = "idLis";
    public static final String ATRIBUTO_COD_BARRAS = "codBarras";
    public static final String ATRIBUTO_ID = "id";
    public static final String ATRIBUTO_DATA_NASCIMENTO = "dataNasc";
    public static final String ATRIBUTO_DESCRICAO = "descricao";
    public static final String ATRIBUTO_VERSAO = "versao";
    public static final String ATRIBUTO_NOME = "nome";
    public static final String ATRIBUTO_SEXO = "sexo";
    public static final String ATRIBUTO_RESULTADO = "resultado";
    public static final String ATRIBUTO_COMPLEMENTAR = "complementar";
    public static final String ATRIBUTO_DATA_ULT_ALTERACAO = "dataUltAlteracao";
    private static final String ATRIBUTO_ID_MATERIAL = "idMaterial";

    public static Map<String, Registro> importarExamesAtitude(JFileChooser chooser, int codigoLabExterno, JProgressBar progress) throws IOException {
        HashMap<String, Registro> examesNovos = new HashMap<String, Registro>();
        HashMap<String, Registro> examesExcluidos = new HashMap<String, Registro>();
        File file = new File(chooser.getSelectedFile().getPath());
        List<List<Object>> materiaisSheet = null;
        boolean arquivoResultado = false;
        if (file.getName().substring(file.getName().length() - 3).equalsIgnoreCase(TAG_XML)) {
            examesNovos.putAll(ParserImportacaoAtitude.parseXml(chooser, codigoLabExterno));
            arquivoResultado = true;
        } else if (Excel.getNumeroDePlanilhas(file) == 3) {
            materiaisSheet = Excel.ler(file, TAG_PLANILHA_MATERIAIS);
            List<List<Object>> examesSheet = Excel.ler(file, TAG_PLANILHA_EXAMES);
            List<List<Object>> linhasResultadoSheet = Excel.ler(file, TAG_PLANILHA_LINHAS_DE_RESULTADO);
            if (!(materiaisSheet.isEmpty() || examesSheet.isEmpty() || linhasResultadoSheet.isEmpty())) {
                examesSheet.remove(0);
                materiaisSheet.remove(0);
                linhasResultadoSheet.remove(0);
                Map<String, Registro> materiais = ParserImportacaoAtitude.getMateriais(materiaisSheet);
                Map<String, List<Registro>> linhasResultado = ParserImportacaoAtitude.getLinhasResultado(linhasResultadoSheet);
                for (List<Object> list : examesSheet) {
                    int codMaterialApoio;
                    Registro exame = new Registro();
                    if (list.size() == 1) continue;
                    if (list.size() == 4) {
                        list.add(4, "");
                    }
                    String id = "";
                    String codExameApoio = ParserImportacaoAtitude.getCelula(list.get(0), String.class);
                    if (linhasResultado.get(ParserImportacaoAtitude.getCodExame(codExameApoio, String.valueOf(codMaterialApoio = ParserImportacaoAtitude.getCelulaInt(list.get(2))))) != null && ((List)linhasResultado.get(ParserImportacaoAtitude.getCodExame(codExameApoio, String.valueOf(codMaterialApoio)))).size() > 0) {
                        id = ((Registro)((List)linhasResultado.get(ParserImportacaoAtitude.getCodExame(codExameApoio, String.valueOf(codMaterialApoio)))).get(0)).getString(ATRIBUTO_ID_EXAME);
                    }
                    if (Funcoes.textoVazio(id)) continue;
                    exame.setValor(ATRIBUTO_CODIGO, ParserImportacaoAtitude.getCelula(list.get(0), String.class));
                    exame.setValor(ATRIBUTO_ID, id);
                    exame.setValor("descricao", ParserImportacaoAtitude.getCelula(list.get(1), String.class));
                    exame.setValor(TAG_MATERIAL, codMaterialApoio);
                    exame.setValor(TAG_DATA_ALTERACAO, ParserImportacaoAtitude.getCelula(list.get(3), String.class));
                    exame.setValor(ATRIBUTO_EXAME_METODO, ParserImportacaoAtitude.getCelula(list.get(4), String.class));
                    exame.setValor(TAG_MATERIAL_DESCRICAO, materiais.get(String.valueOf(ParserImportacaoAtitude.getCelulaInt(list.get(2)))).getString(TAG_MATERIAL_DESCRICAO));
                    exame.setValor(TAG_MATERIAL_COMPOSTO, materiais.get(String.valueOf(ParserImportacaoAtitude.getCelulaInt(list.get(2)))).getString(TAG_MATERIAL_COMPOSTO));
                    exame.setValor(TAG_XML, ParserImportacaoAtitude.getXml(exame, materiais, linhasResultado));
                    exame.setValor(TAG_LINHAS_RESULTADO, linhasResultado.get(ParserImportacaoAtitude.getCodExame(exame)));
                    exame.setValor(TAG_DADOS_ADICIONAIS, ParserImportacaoAtitude.getDadosAdicionais((List)linhasResultado.get(ParserImportacaoAtitude.getCodExame(exame))));
                    examesNovos.put(ParserImportacaoAtitude.getCodExame(exame.getString(ATRIBUTO_CODIGO), String.valueOf(codMaterialApoio)), exame);
                }
            }
        } else {
            materiaisSheet = Excel.ler(file, 0, new Integer[0]);
        }
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                Registro exAntigo;
                HashSet examesNovosRel;
                Map<String, Registro> examesAntigosRelac = ParserImportacaoAtitude.getExamesRelacionados(codigoLabExterno);
                Map<String, Registro> examesAntigos = ParserImportacaoAtitude.loadExamesAtitude(st, codigoLabExterno);
                if (arquivoResultado) {
                    for (String string : examesNovos.keySet()) {
                        if (!Funcoes.isNumeric(((Registro)examesNovos.get(string)).getString(TAG_MATERIAL)) && examesAntigos.containsKey(((Registro)examesNovos.get(string)).getString(ATRIBUTO_CODIGO))) {
                            ((Registro)examesNovos.get(string)).setValor(TAG_MATERIAL, examesAntigos.get(((Registro)examesNovos.get(string)).getString(ATRIBUTO_CODIGO)).getInt(TAG_MATERIAL));
                        }
                        IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 7, ((Registro)examesNovos.get(string)).getString(ATRIBUTO_CODIGO), ((Registro)examesNovos.get(string)).getString(TAG_MATERIAL));
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    for (String string : examesAntigos.keySet()) {
                        if (!examesNovos.containsKey(string)) continue;
                        ((Registro)examesNovos.get(string)).setValor(TAG_MATERIAIS, examesAntigos.get(string).getValor(TAG_MATERIAIS));
                    }
                    ParserImportacaoAtitude.inserirExamesAtitude(examesNovos, st, codigoLabExterno, progress);
                    examesNovosRel = new HashSet();
                    for (String key : examesAntigosRelac.keySet()) {
                        if (!examesNovos.containsKey(key)) continue;
                        examesNovosRel.add(examesNovos.get(key));
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (Iterator ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        exAntigo = examesAntigosRelac.get(ParserImportacaoAtitude.getCodExame(((Registro)((Object)ex)).getString(ATRIBUTO_CODIGO), ((Registro)((Object)ex)).getString(TAG_MATERIAL)));
                        ((Registro)((Object)ex)).setValor(TAG_EXAME_JALIS, exAntigo.getString(TAG_EXAME_JALIS));
                        ((Registro)((Object)ex)).setValor(TAG_MATERIAL_JALIS, exAntigo.getString(TAG_MATERIAL_JALIS));
                        ((Registro)((Object)ex)).setValor(TAG_MATERIAIS, exAntigo.getString(TAG_MATERIAIS));
                        ((Registro)((Object)ex)).setValor(TAG_RECIPIENTES, exAntigo.getString(TAG_RECIPIENTES));
                        if (!(!Funcoes.textoVazio(((Registro)((Object)ex)).getString(TAG_MATERIAL_JALIS)) && Funcoes.isNumeric(((Registro)((Object)ex)).getString(TAG_MATERIAL_JALIS)) || Funcoes.textoVazio(exAntigo.getString(TAG_MATERIAL_JALIS)))) {
                            ((Registro)((Object)ex)).setValor(TAG_MATERIAL, exAntigo.getInt(TAG_MATERIAL));
                        }
                        if (Funcoes.textoVazio(((Registro)((Object)ex)).getString(TAG_VALOR_REFERENCIA)) && !Funcoes.textoVazio(exAntigo.getString(TAG_VALOR_REFERENCIA))) {
                            ((Registro)((Object)ex)).setValor(TAG_VALOR_REFERENCIA, exAntigo.getString(TAG_VALOR_REFERENCIA));
                        }
                        ((Registro)((Object)ex)).setValor(TAG_POSSUI_CURVA, exAntigo.getString(TAG_POSSUI_CURVA));
                        ParserImportacaoAtitude.trataDadosAdicionais(ex, exAntigo);
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((Registro)((Object)ex)).getString(TAG_EXAME_JALIS), Integer.parseInt(((Registro)((Object)ex)).getString(TAG_MATERIAL_JALIS)), ParserImportacaoAtitude.getXml(ex));
                    }
                } else {
                    IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 7, new Object[0]);
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    examesNovosRel = new HashSet();
                    for (String key : examesAntigos.keySet()) {
                        if (!examesNovos.containsKey(key)) continue;
                        ((Registro)examesNovos.get(key)).setValor(TAG_MATERIAIS, examesAntigos.get(key).getValor(TAG_MATERIAIS));
                    }
                    ParserImportacaoAtitude.inserirExamesAtitude(examesNovos, st, codigoLabExterno, progress);
                    for (String key : examesAntigosRelac.keySet()) {
                        if (!examesNovos.containsKey(key)) continue;
                        examesNovosRel.add(examesNovos.get(key));
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (Iterator ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        exAntigo = examesAntigosRelac.get(ParserImportacaoAtitude.getCodExame(((Registro)((Object)ex)).getString(ATRIBUTO_CODIGO), ((Registro)((Object)ex)).getString(TAG_MATERIAL)));
                        ((Registro)((Object)ex)).setValor(TAG_EXAME_JALIS, exAntigo.getString(TAG_EXAME_JALIS));
                        ((Registro)((Object)ex)).setValor(TAG_MATERIAL_JALIS, exAntigo.getString(TAG_MATERIAL_JALIS));
                        ((Registro)((Object)ex)).setValor(TAG_VALOR_REFERENCIA, exAntigo.getString(TAG_VALOR_REFERENCIA));
                        ((Registro)((Object)ex)).setValor(TAG_POSSUI_CURVA, exAntigo.getString(TAG_POSSUI_CURVA));
                        ((Registro)((Object)ex)).setValor(TAG_MATERIAIS, exAntigo.getString(TAG_MATERIAIS));
                        ((Registro)((Object)ex)).setValor(TAG_RECIPIENTES, exAntigo.getString(TAG_RECIPIENTES));
                        ParserImportacaoAtitude.trataDadosAdicionais(ex, exAntigo);
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((Registro)((Object)ex)).getString(TAG_EXAME_JALIS), Integer.parseInt(((Registro)((Object)ex)).getString(TAG_MATERIAL_JALIS)), ParserImportacaoAtitude.getXml(ex).replace("'", ""));
                    }
                    HashSet<Registro> hashSet = new HashSet<Registro>();
                    for (String key : examesAntigos.keySet()) {
                        if (examesNovos.containsKey(key)) continue;
                        examesExcluidos.put(key, examesAntigos.get(key));
                        if (!examesAntigosRelac.containsKey(key)) continue;
                        hashSet.add(examesAntigos.get(key));
                    }
                    for (Registro ex : hashSet) {
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getString(TAG_EXAME_JALIS), Integer.parseInt(ex.getString(TAG_MATERIAL_JALIS)), null);
                    }
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoAtitude: 293");
            }
        } else if (st != null && materiaisSheet != null) {
            try {
                Map<String, Registro> examesRelac = ParserImportacaoAtitude.getExamesRelacionados(codigoLabExterno);
                Map<String, Registro> exames = ParserImportacaoAtitude.loadExamesAtitude(st, codigoLabExterno);
                materiaisSheet.remove(0);
                for (List<Object> list : materiaisSheet) {
                    String[] materiais = String.valueOf(list.get(1)).split(",");
                    if (materiais.length <= 1) continue;
                    String exa = String.valueOf(list.get(0));
                    Registro exame = ParserImportacaoAtitude.getExame(codigoLabExterno, exa);
                    String material = String.valueOf(exame.getValor(TAG_MATERIAL));
                    exames.get(ParserImportacaoAtitude.getCodExame(exa, material));
                    exame.setValor(TAG_MATERIAIS, list.get(1));
                    if (examesRelac.containsKey(ParserImportacaoAtitude.getCodExame(exa, material))) {
                        Registro e = examesRelac.get(ParserImportacaoAtitude.getCodExame(exa, material));
                        e.setValor(TAG_MATERIAIS, list.get(1));
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, e.getString(TAG_EXAME_JALIS), Integer.parseInt(e.getString(TAG_MATERIAL_JALIS)), ParserImportacaoAtitude.getXml(e));
                    }
                    IntegracaoLabExternoUtil.updateExame(st, Variaveis.filialPadrao, codigoLabExterno, 7, exame.getValor(ATRIBUTO_CODIGO), exame.getValor(TAG_MATERIAL), exame.getValor("descricao"), exame.getValor(TAG_MATERIAL_DESCRICAO), ParserImportacaoAtitude.getXml(exame));
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoAtitude: 336");
            }
        }
        return examesExcluidos;
    }

    private static void trataDadosAdicionais(Registro ex, Registro exAntigo) {
        List dadosAdAnt = exAntigo.getValor(TAG_DADOS_ADICIONAIS, List.class);
        List dadosAdNew = ex.getValor(TAG_DADOS_ADICIONAIS, List.class);
        if (ex.getString(ATRIBUTO_CODIGO).equals("17OH")) {
            System.out.println("");
        }
        if (dadosAdAnt != null && dadosAdNew != null) {
            for (Registro r : dadosAdAnt) {
                if (!r.getString(TAG_SELECIONADO).equals("false")) continue;
                for (Registro rNew : dadosAdNew) {
                    if (!rNew.getString(ATRIBUTO_CODIGO).equals(r.getString(ATRIBUTO_CODIGO))) continue;
                    rNew.setValor(TAG_SELECIONADO, "false");
                }
            }
        } else if (dadosAdAnt != null && dadosAdNew == null) {
            ex.setValor(TAG_DADOS_ADICIONAIS, dadosAdAnt);
        }
    }

    private static Map<String, List<Registro>> getLinhasResultado(List<List<Object>> linhasResultadoSheet) {
        HashMap<String, List<Registro>> linhasResultado = new HashMap<String, List<Registro>>();
        for (List<Object> list : linhasResultadoSheet) {
            if (list.size() == 9) {
                list.add(4, "");
            }
            if (list.size() < 11) {
                list.add(6, "");
            }
            Registro linha = new Registro();
            linha.setValor(ATRIBUTO_ID_EXAME, ParserImportacaoAtitude.getCelulaInt(list.get(0)));
            linha.setValor(TAG_ID_LINHA_RESULTADO, ParserImportacaoAtitude.getCelulaInt(list.get(1)));
            linha.setValor(TAG_EXAME, ParserImportacaoAtitude.getCelula(list.get(2), String.class));
            linha.setValor(ATRIBUTO_CODIGO, ParserImportacaoAtitude.getCelula(list.get(3), String.class));
            linha.setValor("descricao", ParserImportacaoAtitude.getCelula(list.get(4), String.class));
            linha.setValor(TAG_MATERIAL, ParserImportacaoAtitude.getCelulaInt(list.get(5)));
            linha.setValor(TAG_UNIDADE, ParserImportacaoAtitude.getCelula(list.get(6), String.class));
            linha.setValor(TAG_CASAS_DECIMAIS, ParserImportacaoAtitude.getCelulaInt(list.get(7)));
            linha.setValor(TAG_PRE_DIGITADO, ParserImportacaoAtitude.getCelula(list.get(8), String.class));
            linha.setValor(TAG_RESULTADO_COMPLEMENTAR, ParserImportacaoAtitude.getCelula(list.get(9), String.class));
            linha.setValor(TAG_DATA_ALTERACAO, ParserImportacaoAtitude.getCelula(list.get(10), String.class));
            String codExame = ParserImportacaoAtitude.getCodExame(ParserImportacaoAtitude.getCelula(list.get(2), String.class), String.valueOf(ParserImportacaoAtitude.getCelulaInt(list.get(5))));
            if (linhasResultado.containsKey(codExame)) {
                ((List)linhasResultado.get(codExame)).add(linha);
                continue;
            }
            ArrayList<Registro> linhas = new ArrayList<Registro>();
            linhas.add(linha);
            linhasResultado.put(codExame, linhas);
        }
        return linhasResultado;
    }

    private static String getCodExame(String mnemonicoExame, String codigoMaterial) {
        return String.format("%s|%s", mnemonicoExame, codigoMaterial);
    }

    public static String getCodExame(Registro exame) {
        return ParserImportacaoAtitude.getCodExame(exame.getString(ATRIBUTO_CODIGO), exame.getString(TAG_MATERIAL));
    }

    private static Map<String, Registro> getMateriais(List<List<Object>> materiaisSheet) {
        HashMap<String, Registro> materiais = new HashMap<String, Registro>();
        for (List<Object> list : materiaisSheet) {
            Registro material = new Registro();
            material.setValor(ATRIBUTO_CODIGO, ParserImportacaoAtitude.getCelula(list.get(0), String.class));
            material.setValor(TAG_MATERIAL_DESCRICAO, ParserImportacaoAtitude.getCelula(list.get(1), String.class));
            material.setValor(TAG_DATA_ALTERACAO, ParserImportacaoAtitude.getCelula(list.get(2), String.class));
            material.setValor(TAG_MATERIAL_COMPOSTO, ParserImportacaoAtitude.getCelula(list.get(3), String.class));
            materiais.put(String.valueOf(ParserImportacaoAtitude.getCelulaInt(list.get(0))), material);
        }
        return materiais;
    }

    public static String getXml(Registro exame, Map<String, Registro> materiais, Map<String, List<Registro>> linhasResultado) {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            List dados;
            xml.abrir(TAG_ATITUDE);
            xml.abrir(TAG_EXAME);
            xml.escrever(ATRIBUTO_CODIGO, exame.getString(ATRIBUTO_CODIGO));
            xml.escrever("descricao", exame.getString("descricao"));
            xml.escrever(ATRIBUTO_ID, exame.getString(ATRIBUTO_ID));
            xml.escrever(TAG_MATERIAL, exame.getString(TAG_MATERIAL));
            xml.escrever(TAG_DATA_ALTERACAO, exame.getString(TAG_DATA_ALTERACAO));
            xml.escrever(TAG_MATERIAL_DESCRICAO, materiais.get(exame.getString(TAG_MATERIAL)).getString(TAG_MATERIAL_DESCRICAO));
            xml.escrever(TAG_MATERIAL_COMPOSTO, materiais.get(exame.getString(TAG_MATERIAL)).getString(TAG_MATERIAL_COMPOSTO));
            if (exame.getString(TAG_MATERIAIS) != null) {
                xml.escrever(TAG_MATERIAIS, exame.getString(TAG_MATERIAIS));
            }
            if (exame.getString(TAG_RECIPIENTES) != null) {
                xml.escrever(TAG_RECIPIENTES, exame.getString(TAG_RECIPIENTES));
            }
            if (linhasResultado.get(ParserImportacaoAtitude.getCodExame(exame)) != null && linhasResultado.get(ParserImportacaoAtitude.getCodExame(exame)).size() > 0) {
                xml.abrir(TAG_LINHAS_RESULTADO);
                for (Registro l : linhasResultado.get(ParserImportacaoAtitude.getCodExame(exame))) {
                    xml.abrir(TAG_LINHA_RESULTADO);
                    for (String key : l.getKeySet()) {
                        xml.escrever(key, l.getString(key));
                    }
                    xml.fechar(TAG_LINHA_RESULTADO);
                }
                xml.fechar(TAG_LINHAS_RESULTADO);
            }
            if (exame.getValor(TAG_VALOR_REFERENCIA) != null) {
                xml.escrever(TAG_VALOR_REFERENCIA, exame.getString(TAG_VALOR_REFERENCIA));
            }
            if ((dados = exame.getValor(TAG_DADOS_ADICIONAIS, List.class)) != null && dados.size() > 0) {
                xml.abrir(TAG_DADOS_ADICIONAIS);
                for (Registro registro : dados) {
                    xml.abrir(TAG_DADO);
                    xml.escrever(ATRIBUTO_CODIGO, registro.getString(ATRIBUTO_CODIGO));
                    xml.escrever("descricao", registro.getString("descricao"));
                    xml.escrever(TAG_UNIDADE, registro.getString(TAG_UNIDADE));
                    xml.escrever(TAG_SELECIONADO, registro.getString(TAG_SELECIONADO));
                    xml.fechar(TAG_DADO);
                }
                xml.fechar(TAG_DADOS_ADICIONAIS);
            }
            if (exame.getValor(TAG_POSSUI_CURVA) != null) {
                xml.escrever(TAG_POSSUI_CURVA, exame.getString(TAG_POSSUI_CURVA));
            }
            xml.fechar(TAG_EXAME);
            xml.fechar(TAG_ATITUDE);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoAtitude: 406");
        }
        return xml.getXML();
    }

    public static String getXml(Registro exame) {
        HashMap<String, Registro> materiais = new HashMap<String, Registro>();
        Registro material = new Registro();
        material.setValor(ATRIBUTO_CODIGO, exame.getString(TAG_MATERIAL));
        material.setValor(TAG_MATERIAL_DESCRICAO, exame.getString(TAG_MATERIAL_DESCRICAO));
        material.setValor(TAG_DATA_ALTERACAO, exame.getString(TAG_DATA_ALTERACAO));
        material.setValor(TAG_MATERIAL_COMPOSTO, exame.getString(TAG_MATERIAL_COMPOSTO));
        materiais.put(exame.getString(TAG_MATERIAL), material);
        HashMap<String, List<Registro>> linhasRes = new HashMap<String, List<Registro>>();
        linhasRes.put(ParserImportacaoAtitude.getCodExame(exame.getString(ATRIBUTO_CODIGO), exame.getString(TAG_MATERIAL)), exame.getValor(TAG_LINHAS_RESULTADO, List.class));
        return ParserImportacaoAtitude.getXml(exame, materiais, linhasRes);
    }

    private static <T> T getCelula(Object campo, Class<T> tipo) {
        T ret = null;
        if (tipo.isInstance(campo)) {
            ret = tipo.cast(campo);
        }
        return ret;
    }

    private static int getCelulaInt(Object campo) {
        return new Double(Double.parseDouble(campo.toString())).intValue();
    }

    private static void inserirExamesAtitude(Map<String, Registro> examesNovos, Statement st, int codigoLabExterno, JProgressBar progress) throws SalvaDadosException, SQLException {
        for (Registro ex : examesNovos.values()) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            if (Funcoes.textoVazio(ex.getString(ATRIBUTO_CODIGO)) || Funcoes.textoVazio(ex.getString(TAG_MATERIAL))) continue;
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 7, ex.getString(ATRIBUTO_CODIGO), ex.getString(TAG_MATERIAL), StringUtil.textoDB(ex.getString("descricao")), StringUtil.textoDB(ex.getString(TAG_MATERIAL_DESCRICAO)), ParserImportacaoAtitude.getXml(ex).replace("'", ""));
        }
    }

    private static Map<String, Registro> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno).append(" and \n");
                bui.append("  a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ParserImportacaoAtitude.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ParserImportacaoAtitude: 401");
            }
        }
        return new HashMap<String, Registro>();
    }

    private static Registro getExame(int codigoLabExterno, String exame, String idMaterial) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append(" fil_codigo, lae_codigo, ati_codexame, ati_codmaterial, ati_descricaoexame, ati_descricaomaterial, ati_xml ");
                bui.append(" from examesatitude ");
                bui.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append(" and lae_codigo = ").append(codigoLabExterno);
                bui.append(" and ati_codexame = '").append(exame).append("' ");
                bui.append(" and ati_codmaterial = '").append(idMaterial).append("' ");
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                if (rs.next()) {
                    return ParserImportacaoAtitude.getExame(rs.getString("ati_xml"), null, null);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoAtitude: 498");
            }
        }
        return null;
    }

    private static Registro getExame(int codigoLabExterno, String exame) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append(" fil_codigo, lae_codigo, ati_codexame, ati_codmaterial, ati_descricaoexame, ati_descricaomaterial, ati_xml ");
                bui.append(" from examesatitude ");
                bui.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append(" and lae_codigo = ").append(codigoLabExterno);
                bui.append(" and ati_codexame = '").append(exame).append("' ");
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                int reg = 0;
                while (rs.next()) {
                    ++reg;
                }
                rs.beforeFirst();
                if (rs.next() && reg == 1) {
                    return ParserImportacaoAtitude.getExame(rs.getString("ati_xml"), null, null);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoAtitude: 498");
            }
        }
        return null;
    }

    private static Map<String, Registro> getExames(ResultSet rs) throws SQLException {
        HashMap<String, Registro> list = new HashMap<String, Registro>();
        if (rs.first()) {
            do {
                Registro ex = ParserImportacaoAtitude.getExame(rs);
                list.put(ParserImportacaoAtitude.getCodExame(ex.getString(ATRIBUTO_CODIGO), ex.getString(TAG_MATERIAL)), ex);
            } while (rs.next());
        }
        return list;
    }

    public static Registro getExame(ResultSet rs) throws SQLException {
        return ParserImportacaoAtitude.getExame(rs.getString("ele_xmllabexterno"), rs.getString(TAG_EXAME_JALIS), rs.getString(TAG_MATERIAL_JALIS));
    }

    public static Registro getExame(String xml, String exameJalis, String materialJalis) {
        Registro exame = new Registro();
        if (!Funcoes.textoVazio(exameJalis) && !Funcoes.textoVazio(materialJalis)) {
            exame.setValor(TAG_EXAME_JALIS, exameJalis);
            exame.setValor(TAG_MATERIAL_JALIS, materialJalis);
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, TAG_ATITUDE))) {
            String xmlExame = StringUtil.getValor(xml, TAG_ATITUDE);
            exame.setValor(ATRIBUTO_CODIGO, StringUtil.getValor(xmlExame, ATRIBUTO_CODIGO));
            exame.setValor(ATRIBUTO_ID, StringUtil.getValor(xmlExame, ATRIBUTO_ID));
            exame.setValor("descricao", StringUtil.getValor(xmlExame, "descricao"));
            exame.setValor(TAG_MATERIAL, Integer.parseInt(StringUtil.getValor(xmlExame, TAG_MATERIAL)));
            exame.setValor(TAG_DATA_ALTERACAO, StringUtil.getValor(xmlExame, TAG_DATA_ALTERACAO));
            exame.setValor(TAG_MATERIAL_DESCRICAO, StringUtil.getValor(xmlExame, TAG_MATERIAL_DESCRICAO));
            exame.setValor(TAG_MATERIAL_COMPOSTO, StringUtil.getValor(xmlExame, TAG_MATERIAL_COMPOSTO));
            exame.setValor(TAG_MATERIAIS, StringUtil.getValor(xmlExame, TAG_MATERIAIS));
            exame.setValor(TAG_RECIPIENTES, StringUtil.getValor(xmlExame, TAG_RECIPIENTES));
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, TAG_LINHAS_RESULTADO)) && !Funcoes.textoVazio(StringUtil.getValor(xml, TAG_LINHA_RESULTADO))) {
                String[] linhas = StringUtil.getValores(xml, TAG_LINHA_RESULTADO);
                ArrayList<Registro> dadosAd = new ArrayList<Registro>();
                ArrayList<Registro> linhasResultado = new ArrayList<Registro>();
                for (String l : linhas) {
                    Registro linha = new Registro();
                    linha.setValor(TAG_ID_LINHA_RESULTADO, StringUtil.getValor(l, TAG_ID_LINHA_RESULTADO));
                    linha.setValor(ATRIBUTO_ID, StringUtil.getValor(l, TAG_ID_LINHA_RESULTADO));
                    linha.setValor(TAG_EXAME, StringUtil.getValor(l, TAG_EXAME));
                    linha.setValor(ATRIBUTO_CODIGO, StringUtil.getValor(l, ATRIBUTO_CODIGO));
                    linha.setValor("descricao", StringUtil.getValor(l, "descricao"));
                    linha.setValor(TAG_MATERIAL, StringUtil.getValor(l, TAG_MATERIAL));
                    linha.setValor(TAG_UNIDADE, StringUtil.getValor(l, TAG_UNIDADE));
                    linha.setValor(TAG_CASAS_DECIMAIS, StringUtil.getValor(l, TAG_CASAS_DECIMAIS));
                    linha.setValor(TAG_PRE_DIGITADO, StringUtil.getValor(l, TAG_PRE_DIGITADO));
                    linha.setValor(TAG_RESULTADO_COMPLEMENTAR, StringUtil.getValor(l, TAG_RESULTADO_COMPLEMENTAR));
                    linha.setValor(TAG_DATA_ALTERACAO, StringUtil.getValor(l, TAG_DATA_ALTERACAO));
                    linhasResultado.add(linha);
                    if (!Funcoes.textoVazio(StringUtil.getValor(xmlExame, TAG_DADOS_ADICIONAIS)) || !StringUtil.getValor(l, TAG_PRE_DIGITADO).equals("S")) continue;
                    Registro r = new Registro();
                    r.setValor(ATRIBUTO_CODIGO, StringUtil.getValor(l, ATRIBUTO_CODIGO));
                    r.setValor("descricao", StringUtil.getValor(l, "descricao"));
                    r.setValor(TAG_UNIDADE, StringUtil.getValor(l, TAG_UNIDADE));
                    r.setValor(TAG_SELECIONADO, StringUtil.getValor(l, TAG_SELECIONADO).equals("false") ? "false" : "true");
                    dadosAd.add(r);
                }
                exame.setValor(TAG_LINHAS_RESULTADO, linhasResultado);
                if (dadosAd.size() > 0) {
                    exame.setValor(TAG_DADOS_ADICIONAIS, dadosAd);
                }
                if (!Funcoes.textoVazio(StringUtil.getValor(xmlExame, TAG_DADOS_ADICIONAIS))) {
                    String[] dados;
                    for (String dado : dados = StringUtil.getValores(xmlExame, TAG_DADO)) {
                        boolean selecionado = false;
                        if (dadosAd.size() > 0) {
                            for (Registro reg : dadosAd) {
                                if (!StringUtil.getValor(dado, ATRIBUTO_CODIGO).equals(reg.getString(ATRIBUTO_CODIGO))) continue;
                                selecionado = true;
                            }
                        }
                        if (selecionado) continue;
                        Registro r = new Registro();
                        r.setValor(ATRIBUTO_CODIGO, StringUtil.getValor(dado, ATRIBUTO_CODIGO));
                        r.setValor("descricao", StringUtil.getValor(dado, "descricao"));
                        r.setValor(TAG_UNIDADE, StringUtil.getValor(dado, TAG_UNIDADE));
                        r.setValor(TAG_SELECIONADO, StringUtil.getValor(dado, TAG_SELECIONADO).equals("false") ? "false" : "true");
                        dadosAd.add(r);
                    }
                    exame.setValor(TAG_DADOS_ADICIONAIS, dadosAd);
                }
                if (!Funcoes.textoVazio(StringUtil.getValor(xmlExame, TAG_POSSUI_CURVA))) {
                    exame.setValor(TAG_POSSUI_CURVA, StringUtil.getValor(xmlExame, TAG_POSSUI_CURVA));
                }
                if (!Funcoes.textoVazio(StringUtil.getValor(xmlExame, TAG_VALOR_REFERENCIA))) {
                    exame.setValor(TAG_VALOR_REFERENCIA, StringUtil.getValor(xmlExame, TAG_VALOR_REFERENCIA));
                }
            }
        }
        return exame;
    }

    private static Map<String, Registro> loadExamesAtitude(Statement st, int codigoLabExterno) throws SQLException {
        HashMap<String, Registro> exames = new HashMap<String, Registro>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, lae_codigo, ati_codexame, ati_codmaterial, ati_descricaoexame, ati_descricaomaterial, ati_xml ");
        sql.append(" from examesatitude ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            Registro e = ParserImportacaoAtitude.getExame(rs.getString("ati_xml"), null, null);
            exames.put(ParserImportacaoAtitude.getCodExame(rs.getString("ati_codexame"), rs.getString("ati_codmaterial")), e);
        }
        return exames;
    }

    public static String retornaBase36(int numero, int tamanho) {
        return Integer.toString(numero, 36);
    }

    public static boolean isXmlValido(String xml) {
        String xmlExame;
        String xmlAtitude = StringUtil.getValor(xml, TAG_ATITUDE);
        return xmlAtitude != null && xmlAtitude.trim().length() > 0 && (xmlExame = StringUtil.getValor(xmlAtitude, TAG_EXAME)) != null && xmlExame.trim().length() > 0;
    }

    public static List<Registro> getExamesImportados(String codigoLabExterno) {
        ArrayList<Registro> exames = new ArrayList<Registro>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select * \n");
                bui.append("from examesatitude \n");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("      lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("order by ati_descricaoexame");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    exames.add(ParserImportacaoAtitude.getExame(res.getString("ati_xml"), null, null));
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ParserImportacaoAtitude: 527");
            }
        }
        return exames;
    }

    private static List<Registro> getDadosAdicionais(List<Registro> linhasResultado) {
        ArrayList<Registro> dadosAdicionais = new ArrayList<Registro>();
        for (Registro l : linhasResultado) {
            if (!l.getString(TAG_PRE_DIGITADO).equals("S")) continue;
            Registro r = new Registro();
            r.setValor(ATRIBUTO_CODIGO, l.getString(ATRIBUTO_CODIGO));
            r.setValor("descricao", l.getString("descricao"));
            r.setValor(TAG_UNIDADE, l.getString(TAG_UNIDADE));
            r.setValor(TAG_SELECIONADO, l.getString(TAG_SELECIONADO).equals("false") ? "false" : "true");
            dadosAdicionais.add(r);
        }
        return dadosAdicionais;
    }

    private static Map<String, Registro> parseXml(JFileChooser chooser, int codigoLabExterno) {
        Document doc = ParserImportacaoAtitude.analisarXML(chooser.getSelectedFile());
        if (doc == null) {
            return null;
        }
        Element raiz = doc.getDocumentElement();
        return ParserImportacaoAtitude.parse(XMLUtil.getElementosFilhos(raiz), codigoLabExterno);
    }

    private static Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    private static Map<String, Registro> parse(List<Element> elements, int codigoLabExterno) {
        HashMap<String, Registro> materiaisCadastro = new HashMap<String, Registro>();
        HashMap<String, Registro> examesCadastro = new HashMap<String, Registro>();
        for (Element e : elements) {
            if (e.getNodeName().equalsIgnoreCase(TAG_INTEGRACAO)) {
                if (e.getAttribute(ATRIBUTO_VERSAO).equalsIgnoreCase(VERSAO)) continue;
                return null;
            }
            if (!e.getNodeName().equalsIgnoreCase(TAG_ESTRUTURA) || !e.hasChildNodes()) continue;
            List<Element> estrutura = XMLUtil.getElementosFilhos(e);
            for (Element ele : estrutura) {
                if (ele.getNodeName().equalsIgnoreCase(TAG_MATERIAIS) && ele.hasChildNodes()) {
                    materiaisCadastro.putAll(ParserImportacaoAtitude.parseMateriais(XMLUtil.getElementosFilhos(ele)));
                    continue;
                }
                if (!ele.getNodeName().equalsIgnoreCase(TAG_EXAMES) || !ele.hasChildNodes()) continue;
                examesCadastro.putAll(ParserImportacaoAtitude.parseExames(XMLUtil.getElementosFilhos(ele), materiaisCadastro, codigoLabExterno));
            }
        }
        return examesCadastro;
    }

    public static Map<String, Registro> parseMateriais(List<Element> elementosFilhos) {
        HashMap<String, Registro> materiaisCadastro = new HashMap<String, Registro>();
        for (Element element : elementosFilhos) {
            Registro material = new Registro();
            material.setValor(ATRIBUTO_ID, element.getAttribute(ATRIBUTO_ID));
            material.setValor(TAG_MATERIAL_DESCRICAO, element.getAttribute("descricao"));
            materiaisCadastro.put(element.getAttribute(ATRIBUTO_ID), material);
        }
        return materiaisCadastro;
    }

    public static Map<String, Registro> parseExames(List<Element> elementosFilhos, Map<String, Registro> materiaisCadastro, int codigoLabExterno) {
        HashMap<String, Registro> examesCadastro = new HashMap<String, Registro>();
        for (Element element : elementosFilhos) {
            Registro exameAntigo = ParserImportacaoAtitude.getExame(codigoLabExterno, element.getAttribute(ATRIBUTO_CODIGO), element.getAttribute(ATRIBUTO_ID_MATERIAL));
            if (exameAntigo == null || !materiaisCadastro.containsKey(element.getAttribute(ATRIBUTO_ID_MATERIAL))) continue;
            Registro exame = new Registro();
            exame.setValor(ATRIBUTO_CODIGO, element.getAttribute(ATRIBUTO_CODIGO));
            exame.setValor(ATRIBUTO_ID, element.getAttribute(ATRIBUTO_ID));
            exame.setValor("descricao", element.getAttribute("descricao"));
            exame.setValor(TAG_DATA_ALTERACAO, element.getAttribute(ATRIBUTO_DATA_ULT_ALTERACAO));
            exame.setValor(ATRIBUTO_EXAME_METODO, element.getAttribute(ATRIBUTO_EXAME_METODO));
            exame.setValor(TAG_MATERIAL, element.getAttribute(ATRIBUTO_ID_MATERIAL));
            exame.setValor(TAG_MATERIAL_DESCRICAO, materiaisCadastro.get(element.getAttribute(ATRIBUTO_ID_MATERIAL)).getString(TAG_MATERIAL_DESCRICAO));
            List<Element> list = XMLUtil.getElementosFilhos(element);
            for (Element e : list) {
                if (e.getNodeName().equalsIgnoreCase(TAG_LINHAS_RESULTADO)) {
                    ArrayList<Registro> linhas = new ArrayList<Registro>();
                    for (Element l : XMLUtil.getElementosFilhos(e)) {
                        Registro linha = new Registro();
                        linha.setValor(TAG_ID_LINHA_RESULTADO, l.getAttribute(ATRIBUTO_ID));
                        linha.setValor(ATRIBUTO_ID, l.getAttribute(ATRIBUTO_ID));
                        linha.setValor(ATRIBUTO_COMPLEMENTAR, l.getAttribute(ATRIBUTO_COMPLEMENTAR));
                        linha.setValor(TAG_UNIDADE, l.getAttribute(TAG_UNIDADE));
                        linha.setValor("descricao", l.getAttribute("descricao"));
                        linhas.add(linha);
                    }
                    exame.setValor(TAG_LINHAS_RESULTADO, linhas);
                    continue;
                }
                if (e.getNodeName().equalsIgnoreCase(TAG_VALOR_REFERENCIA)) {
                    exame.setValor(TAG_VALOR_REFERENCIA, StringUtil.textoXML(e.getTextContent()));
                    continue;
                }
                if (!e.getNodeName().equalsIgnoreCase(TAG_DADOS_ADICIONAIS)) continue;
            }
            if (exameAntigo.possuiCampo(TAG_DADOS_ADICIONAIS)) {
                exame.setValor(TAG_DADOS_ADICIONAIS, exameAntigo.getValor(TAG_DADOS_ADICIONAIS, List.class));
            }
            if (exameAntigo.possuiCampo(TAG_POSSUI_CURVA)) {
                exame.setValor(TAG_POSSUI_CURVA, exameAntigo.getString(TAG_POSSUI_CURVA));
            }
            if (!exame.possuiCampo(TAG_VALOR_REFERENCIA) && exameAntigo.possuiCampo(TAG_VALOR_REFERENCIA)) {
                exame.setValor(TAG_VALOR_REFERENCIA, exameAntigo.getString(TAG_VALOR_REFERENCIA));
            }
            examesCadastro.put(ParserImportacaoAtitude.getCodExame(element.getAttribute(ATRIBUTO_CODIGO), element.getAttribute(ATRIBUTO_ID_MATERIAL)), exame);
        }
        return examesCadastro;
    }

    public static String decompress(String base64, String charSetName) throws UnsupportedEncodingException, DataFormatException, IOException {
        return ParserImportacaoAtitude.decompress(new Base64().decode(base64), charSetName);
    }

    private static String decompress(byte[] output, String charSetName) throws DataFormatException, UnsupportedEncodingException {
        Inflater decompresser = new Inflater();
        decompresser.setInput(output);
        byte[] result = new byte[2048];
        int resultLength = 0;
        resultLength = decompresser.inflate(result);
        decompresser.end();
        String outputString = new String(result, 0, resultLength, charSetName);
        return outputString;
    }
}

