/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.atitude;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.atitude.ParserImportacaoAtitude;
import jalis.laboratorio.util.parsers.atitude.resultado.CamposRelacionamentoAtitudeUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ImportacaoResultadoAtitude
extends AbstractImportadorResultadoLabExterno {
    private static final String FORMATO = "formato";
    private static final String FORMATO_TEXTO = "formatotexto";
    private static final String CODIGO_LAYOUT = "codigo-layout";
    private static final String CABECALHO = "cabecalho";
    private static final String FORMATACAO = "formatacao";
    private ArrayList<Registro> pacientes = new ArrayList();
    private ArrayList<Registro> requisicoes = new ArrayList();
    private Map<String, Registro> examesCadastro = new HashMap<String, Registro>();
    private Map<String, Registro> materiaisCadastro = new HashMap<String, Registro>();
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    private ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private boolean conferirAutomatico = false;
    private String codigoUsuarioConferenciaAutomatica = null;

    public ImportacaoResultadoAtitude(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio Atitude a partir de arquivo XML", codigoLabExterno, null, new JPanel(new FlowLayout(2)));
        this.getPanelAdicional().add(this.buttonImprimir);
        this.pegaDadosConferencia(codigoLabExterno);
    }

    public ImportacaoResultadoAtitude(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo) {
        super(titulo, descricao, codigoLabExterno, protocolo);
        this.getPanelAdicional().add(this.buttonImprimir);
        this.pegaDadosConferencia(codigoLabExterno);
    }

    public ImportacaoResultadoAtitude(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo, JPanel panelAdicional) {
        super(titulo, descricao, codigoLabExterno, protocolo, panelAdicional);
        this.getPanelAdicional().add(this.buttonImprimir);
        this.pegaDadosConferencia(codigoLabExterno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pegaDadosConferencia(int codigoLabExterno) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAtitude (118)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importarResultado() {
        block37: {
            if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
                return;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Atitude (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) != 0) break block37;
            Document doc = this.analisarXML(chooser.getSelectedFile());
            if (doc == null) {
                this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo: " + chooser.getSelectedFile().getPath());
                return;
            }
            Element raiz = doc.getDocumentElement();
            try {
                this.parse(XMLUtil.getElementosFilhos(raiz));
            }
            catch (DOMException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ImportacaoResultadoAtitude: 124");
            }
            catch (IOException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ImportacaoResultadoAtitude: 127");
            }
            catch (DataFormatException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ImportacaoResultadoAtitude: 130");
            }
            if (this.requisicoes == null || this.requisicoes.size() == 0) {
                this.setTextoInformacoes("O arquivo informado n\u00e3o possui requisi\u00e7\u00f5es a serem importadas!");
                return;
            }
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            if (st == null) {
                return;
            }
            try {
                Registro reg;
                List exames;
                this.progress.setValue(0);
                this.progress.setMaximum(this.requisicoes.size());
                this.progress.setVisible(true);
                for (Registro requisicao : this.requisicoes) {
                    this.progress.setValue(this.progress.getValue() + 1);
                    exames = requisicao.getValor("exames", List.class);
                    for (Registro exResultado : exames) {
                        Object amostra2;
                        Registro formatacao;
                        reg = this.localizaExameRequisicao(requisicao, exResultado, st);
                        if (reg == null) continue;
                        if (this.exameLancado(reg)) {
                            this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do Atitude: %s exame %s %s", requisicao.getString("idApoio"), exResultado.getString("idLis"), Situacao.JA_LANCADO.descricao), false);
                            this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.JA_LANCADO);
                            continue;
                        }
                        if (!this.exameColetado(reg)) {
                            this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do Atitude: %s exame %s %s", requisicao.getString("idApoio"), exResultado.getString("idLis"), Situacao.SEM_MATERIAL.descricao), false);
                            this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.SEM_MATERIAL);
                            continue;
                        }
                        if (!this.exameRelacionado(reg)) {
                            this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.SEM_RELACIONAMENTO);
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento", false);
                            continue;
                        }
                        boolean salvoParcial = reg.getString("exr_situacao").equals("P");
                        Registro registro = formatacao = salvoParcial ? (Registro)reg.getValor(FORMATACAO) : this.localizarFormatacao(reg);
                        if (formatacao == null) {
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Formata\u00e7\u00e3o n\u00e3o encontrada", false);
                            continue;
                        }
                        String fil_codigo = requisicao.getString("idLis").substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String req_codigo = requisicao.getString("idLis").substring(ParametrosGerais.getDigitosTuboFilial());
                        Registro exameSalvo = ParserImportacaoAtitude.getExame(reg.getString("ele_xmllabexterno"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                        Registro exameNovo = this.examesCadastro.get(ParserImportacaoAtitude.getCodExame(exameSalvo));
                        Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                        List amostras = exResultado.getValor("amostras", List.class);
                        ArrayList<String> curvas = new ArrayList<String>();
                        for (Object amostra2 : amostras) {
                            Registro am = (Registro)requisicao.getValor("amostras", Map.class).get(((Registro)amostra2).getString("id"));
                            if (am.getString("descricao").equalsIgnoreCase("basal")) continue;
                            curvas.add(((Registro)amostra2).getString("idLis"));
                        }
                        boolean curva = false;
                        Collections.sort(curvas);
                        amostra2 = amostras.iterator();
                        while (amostra2.hasNext()) {
                            Registro amostra3 = (Registro)amostra2.next();
                            List linhasResultado = amostra3.getValor("linhasResultado", List.class);
                            for (Registro linha : linhasResultado) {
                                Registro linhaEstrutura = this.getLinha(linha, exameSalvo.getValor("linhasResultado", List.class));
                                String possuiCurva = exameSalvo.getString("possuiCurva");
                                Registro am = (Registro)requisicao.getValor("amostras", Map.class).get(amostra3.getString("id"));
                                if (!am.getString("descricao").equalsIgnoreCase("basal") && !Funcoes.textoVazio(possuiCurva) && curvas.size() > 0) {
                                    int intervalos = Integer.parseInt(possuiCurva);
                                    int intervaloAmostra = curvas.indexOf(amostra3.getString("idLis"));
                                    if (intervaloAmostra <= -1 || intervaloAmostra + 1 > intervalos) continue;
                                    String cod = String.format("%s_intervalo_%s", linha.getString("id"), String.valueOf(intervaloAmostra + 1));
                                    String vlrResultado = linha.getString("resultado");
                                    dados.put(cod, vlrResultado);
                                    curva = true;
                                    continue;
                                }
                                String vlrResultado = linha.getString("resultado");
                                dados.put(linha.getString("id"), vlrResultado);
                            }
                        }
                        dados.put(CamposRelacionamentoAtitudeUtil.REQUISICAO_ATITUDE, requisicao.getString("idApoio"));
                        dados.put(CamposRelacionamentoAtitudeUtil.OBSERVACAO_EXAME, exameNovo.getString("observacao"));
                        dados.put(CamposRelacionamentoAtitudeUtil.METODOLOGIA, exameNovo.getString("metodo"));
                        dados.put(CamposRelacionamentoAtitudeUtil.DESCRICAO_EXAME, exameSalvo.getString("descricao"));
                        dados.put(CamposRelacionamentoAtitudeUtil.CODIGO_EXAME_ATITUDE, exameSalvo.getString("codigo"));
                        dados.put(CamposRelacionamentoAtitudeUtil.DATA_ALTERACAO, exameSalvo.getString("data_alteracao"));
                        dados.put(CamposRelacionamentoAtitudeUtil.VALOR_REFERENCIA, exameSalvo.getString("valorReferencia"));
                        dados.put(CamposRelacionamentoAtitudeUtil.CODIGO_MAT_ATITUDE, exameSalvo.getString("material"));
                        Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(fil_codigo, req_codigo, reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                        dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                        Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                        if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                            historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                        }
                        Resultado res = new Resultado(formatacao.getString(FORMATO), dados, resAnterior, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"));
                        res.atualizarComponentes();
                        if (!res.verificarCondicao()) {
                            this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.CONDICAO_INSATISFEITA);
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                            continue;
                        }
                        if (!this.verificarVersao(reg, requisicao, exResultado, exameSalvo, exameNovo, curva)) continue;
                        boolean completo = true;
                        if (reg.getBoolean("exa_salvaparcial")) {
                            completo = res.resultadoCompleto(true);
                        }
                        String novaSituacao = completo ? "L" : "P";
                        String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                        Util.gravaAlteracaoExameRequisicao(st, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                        boolean marcarConferido = false;
                        if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null) {
                            int verificacao = res.verificarValidacao();
                            boolean bl = marcarConferido = verificacao == 1;
                            if (!marcarConferido && verificacao != 2) {
                                this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.VALIDACAO_INSATISFEITA);
                                this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                            }
                        }
                        if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), requisicao.getString("idApoio"))) {
                            this.inserirDadosRequisicao(st, this.codigoLabExterno, requisicao.getString("idApoio"), reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                        }
                        boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                        boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                        this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                        if (this.exportarBaseWeb(fil_codigo)) {
                            Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, fil_codigo, req_codigo, reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                            this.exportarParaWeb(st, this.getCodigoBaseWeb(fil_codigo), novaSituacao, reg, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                            if (ExportaWeb.isGerarPdfResultado(st2, fil_codigo)) {
                                ExportaWeb.enviarResultadoPDF(st2, fil_codigo, req_codigo, this.getCodigoBaseWeb(fil_codigo));
                            }
                        }
                        this.adicionarAoModeloRelatorio(requisicao, exResultado, completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE);
                        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                        ExportaWeb.atualizaPaginaOrdemExameWeb(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), Variaveis.codigoBaseWeb);
                        this.editarRequisicaoExportaFiliais(reg);
                        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
                        this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE)), false);
                    }
                }
                for (Registro requisicao : this.requisicoes) {
                    exames = requisicao.getValor("exames", List.class);
                    for (Registro exResultado : exames) {
                        reg = this.localizaExameRequisicao(requisicao, exResultado, st);
                        if (reg == null) continue;
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            SMSUtil.criaLogSmsComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, st, st2);
                        }
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            EmailUtil.criaLogEmail(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                        }
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            PushUtil.criaLogPushComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoPush.RESULTADO, st, st2);
                        }
                        if (!this.conferirAutomatico || Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) || WhatsAppUtil.isBloquearWhatsappExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) continue;
                        WhatsAppUtil.criaLogWhatsappComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoWhatsapp.RESULTADO, st, st2);
                    }
                }
                Conexao.arquivaSQL();
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAtitude: 286");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
            Conexao.fecharStatement(st, st2);
            this.progress.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    private void parse(List<Element> elements) throws DOMException, IOException, DataFormatException {
        this.materiaisCadastro.clear();
        this.examesCadastro.clear();
        for (Element e : elements) {
            if (e.getNodeName().equalsIgnoreCase("integracao")) {
                if (e.getAttribute("versao").equalsIgnoreCase("20110901")) continue;
                this.setTextoInformacoes("O arquivo selecionado n\u00e3o \u00e9 um XML de resultado v\u00e1lido");
                return;
            }
            if (e.getNodeName().equalsIgnoreCase("estrutura") && e.hasChildNodes()) {
                List<Element> estrutura = XMLUtil.getElementosFilhos(e);
                for (Element ele : estrutura) {
                    if (ele.getNodeName().equalsIgnoreCase("materiais") && ele.hasChildNodes()) {
                        this.materiaisCadastro.putAll(ParserImportacaoAtitude.parseMateriais(XMLUtil.getElementosFilhos(ele)));
                        continue;
                    }
                    if (!ele.getNodeName().equalsIgnoreCase("exames") || !ele.hasChildNodes()) continue;
                    this.examesCadastro.putAll(ParserImportacaoAtitude.parseExames(XMLUtil.getElementosFilhos(ele), this.materiaisCadastro, this.codigoLabExterno));
                }
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("resultados") || !e.hasChildNodes()) continue;
            List<Element> resultados = XMLUtil.getElementosFilhos(e);
            for (Element ele : resultados) {
                if (!ele.getNodeName().equalsIgnoreCase("requisicoes")) continue;
                this.parseRequisicoes(XMLUtil.getElementosFilhos(ele));
            }
        }
    }

    private void parseRequisicoes(List<Element> elementosFilhos) throws DOMException, IOException, DataFormatException {
        for (Element e : elementosFilhos) {
            this.parseRequisicao(e);
        }
    }

    private void parseRequisicao(Element element) throws DOMException, IOException, DataFormatException {
        Registro requisicao = new Registro();
        requisicao.setValor("idLis", element.getAttribute("idLis"));
        requisicao.setValor("idApoio", element.getAttribute("idApoio"));
        requisicao.setValor("id", element.getAttribute("id"));
        requisicao.setValor("exames", new ArrayList());
        requisicao.setValor("amostras", new HashMap());
        if (!Funcoes.isNumeric(requisicao.getString("idLis"))) {
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: C\u00f3digo incorreto da requisi\u00e7\u00e3o Jalis. C\u00f3digo Atitude: " + requisicao.getString("idApoio"), false);
            return;
        }
        HashMap<String, String> examesJalis = this.localizaExameJalis(requisicao);
        if (element.hasChildNodes()) {
            List<Element> filhos = XMLUtil.getElementosFilhos(element);
            for (Element e : filhos) {
                if (e.getNodeName().equalsIgnoreCase("paciente")) {
                    this.parsePaciente(e, requisicao);
                    continue;
                }
                if (e.getNodeName().equalsIgnoreCase("medico")) {
                    this.parseMedico(e, requisicao);
                    continue;
                }
                if (e.getNodeName().equalsIgnoreCase("amostras")) {
                    this.parseAmostras(XMLUtil.getElementosFilhos(e), requisicao);
                    continue;
                }
                if (!e.getNodeName().equalsIgnoreCase("exame")) continue;
                this.parseExame(e, requisicao);
            }
        }
        this.requisicoes.add(requisicao);
    }

    private void parseAmostras(List<Element> elementosFilhos, Registro requisicao) {
        for (Element e : elementosFilhos) {
            if (!e.getNodeName().equalsIgnoreCase("amostra")) continue;
            this.parseAmostra(e, requisicao);
        }
    }

    private void parseAmostra(Element e, Registro requisicao) {
        Registro r = new Registro();
        NamedNodeMap att = e.getAttributes();
        r.setValor("idApoio", e.getAttribute("idApoio"));
        r.setValor("idAmostra", e.getAttribute("idAmostra"));
        r.setValor("idLis", e.getAttribute("idLis"));
        r.setValor("codBarras", e.getAttribute("codBarras"));
        r.setValor("id", e.getAttribute("id"));
        r.setValor("descricao", e.getAttribute("descricao"));
        requisicao.getValor("amostras", Map.class).put(e.getAttribute("idApoio"), r);
    }

    private void parseExame(Element e, Registro requisicao) throws DOMException, IOException, DataFormatException {
        Registro exame = new Registro();
        exame.setValor("idExame", e.getAttribute("idExame"));
        exame.setValor("idLis", e.getAttribute("idLis"));
        String idLis = e.getAttribute("idLis");
        String idExameJalis = idLis.substring(idLis.indexOf("|") + 1);
        exame.setValor("exa_codigo", idExameJalis.substring(0, idExameJalis.indexOf("|")));
        exame.setValor("mco_codigo", idExameJalis.substring(idExameJalis.indexOf("|") + 1));
        exame.setValor("idApoio", e.getAttribute("idApoio"));
        exame.setValor("dataResultado", e.getAttribute("dataResultado"));
        exame.setValor("id", e.getAttribute("id"));
        exame.setValor("amostras", new ArrayList());
        if (e.hasChildNodes()) {
            List<Element> resultados = XMLUtil.getElementosFilhos(e);
            for (Element element : resultados) {
                if (!element.getNodeName().equalsIgnoreCase("resultado") || !element.hasChildNodes()) continue;
                List<Element> filhos = XMLUtil.getElementosFilhos(element);
                for (Element filho : filhos) {
                    if (filho.getNodeName().equalsIgnoreCase("observacao") || !filho.getNodeName().equalsIgnoreCase("amostra")) continue;
                    Registro amostra = new Registro();
                    amostra.setValor("idLis", filho.getAttribute("idLis"));
                    amostra.setValor("id", filho.getAttribute("id"));
                    amostra.setValor("linhasResultado", new ArrayList());
                    if (filho.hasChildNodes()) {
                        List<Element> linhas = XMLUtil.getElementosFilhos(filho);
                        for (Element linha : linhas) {
                            Registro l = new Registro();
                            if (!Funcoes.textoVazio(linha.getAttribute("resultado"))) {
                                l.setValor("resultado", linha.getAttribute("resultado"));
                            } else {
                                l.setValor("resultado", ParserImportacaoAtitude.decompress(linha.getTextContent(), "ISO-8859-1"));
                            }
                            l.setValor("id", linha.getAttribute("id"));
                            l.setValor("complementar", linha.getAttribute("complementar"));
                            amostra.getValor("linhasResultado", List.class).add(l);
                        }
                    }
                    exame.getValor("amostras", List.class).add(amostra);
                }
            }
        }
        requisicao.getValor("exames", List.class).add(exame);
    }

    private void parsePaciente(Element e, Registro requisicao) {
        Registro r = new Registro();
        r.setValor("nome", e.getAttribute("nome"));
        r.setValor("idApoio", e.getAttribute("idApoio"));
        r.setValor("sexo", e.getAttribute("sexo"));
        r.setValor("dataNasc", e.getAttribute("dataNasc"));
        r.setValor("idLis", e.getAttribute("idLis"));
        r.setValor("id", e.getAttribute("id"));
        requisicao.setValor("paciente", r);
    }

    private void parseMedico(Element e, Registro requisicao) {
        Registro r = new Registro();
        r.setValor("idLis", e.getAttribute("idLis"));
        r.setValor("idApoio", e.getAttribute("idApoio"));
        r.setValor("id", e.getAttribute("id"));
        r.setValor("nome", e.getAttribute("nome"));
        requisicao.setValor("medico", r);
    }

    private HashMap<String, String> localizaExameJalis(Registro requisicao) {
        String fil = Funcoes.getFilialRequisicao(requisicao.getString("idLis"))[0];
        String req = Funcoes.getFilialRequisicao(requisicao.getString("idLis"))[1];
        Statement st = Conexao.getStatement();
        HashMap<String, String> retorno = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  f.ele_xmllabexterno , b.exa_codigo, b.mco_codigo \n");
        sql.append("from requisicao a \n");
        sql.append(" join examerequisicao b  on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append(" join loteexternoexamerequisicao c  on a.fil_codigo = c.fil_kodigo and a.req_codigo = c.req_codigo and b.exa_codigo = c.exa_codigo and b.mco_codigo = c.mco_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join examematcoletalabexterno f on e.fil_codigo = f.fil_codigo and e.exa_codigo = f.exa_codigo and e.mco_codigo = f.mco_codigo and c.lae_codigo = f.lae_codigo ");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        sql.append("  c.lae_codigo = ").append(this.codigoLabExterno).append(" and \n");
        sql.append("  a.req_excluida = false and b.exr_excluido = false and \n");
        sql.append("  f.ele_xmllabexterno is not null and f.ele_xmllabexterno <> '' ");
        try {
            ResultSet res = Conexao.executeQuery(st, sql.toString());
            StringBuilder buf = new StringBuilder();
            while (res.next()) {
                buf.setLength(0);
                String exameAtitude = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(res.getString("ele_xmllabexterno"), "atitude"), "exame"), "codigo");
                buf.append(res.getString("exa_codigo")).append("|").append(res.getString("mco_codigo"));
                if (Funcoes.textoVazio(exameAtitude)) continue;
                retorno.put(exameAtitude, buf.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    private boolean verificarVersao(Registro reg, Registro requisicao, Registro exResultado, Registro exameSalvo, Registro exameNovo, boolean curva) {
        boolean mesmaVersao = exameSalvo.getString("data_alteracao").equals(exameNovo.getString("data_alteracao"));
        boolean mesmaVersaoEstrutura = true;
        if (exameSalvo.getValor("linhasResultado") != null && exameNovo.getValor("linhasResultado") != null || exameSalvo.getValor("linhasResultado", List.class).size() != exameNovo.getValor("linhasResultado", List.class).size()) {
            List linhas = exameSalvo.getValor("linhasResultado", List.class);
            for (Registro linhaAntiga : linhas) {
                Registro linhaNova = this.getLinha(linhaAntiga, exameNovo.getValor("linhasResultado", List.class));
                if (linhaNova != null && linhaNova.getString("descricao").equalsIgnoreCase(linhaAntiga.getString("descricao"))) continue;
                mesmaVersaoEstrutura = false;
                break;
            }
        }
        if (!mesmaVersao && !mesmaVersaoEstrutura) {
            this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.VERSAO_INCOMPATIVEL);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Vers\u00e3o incorreta (data da vers\u00e3o diferente)", false);
            return false;
        }
        if (mesmaVersao && !mesmaVersaoEstrutura) {
            this.adicionarAoModeloRelatorio(requisicao, exResultado, Situacao.VERSAO_INCOMPATIVEL);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Vers\u00e3o incorreta (estrutura diferente)", false);
            return false;
        }
        if (!mesmaVersao && mesmaVersaoEstrutura && !curva) {
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Estrutura diferente importar resultado para atualizar Layout do exame", false);
            return false;
        }
        return true;
    }

    private Registro getLinha(Registro linhaAntiga, List<Registro> linhasNovas) {
        Registro linhaNova = null;
        for (Registro linha : linhasNovas) {
            if (linha.getString("id") == null || !linha.getString("id").equals(linhaAntiga.getString("id"))) continue;
            linhaNova = linha;
        }
        return linhaNova;
    }

    private void adicionarAoModeloRelatorio(Registro requisicao, Registro exame, Situacao situacao) {
        if (requisicao.getString("idLis").length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboFilial()) {
            return;
        }
        String fil_codigo = requisicao.getString("idLis").substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = requisicao.getString("idLis").substring(ParametrosGerais.getDigitosTuboFilial());
        if (exame != null && !Funcoes.textoVazio(exame.getString("exa_codigo")) && !Funcoes.textoVazio(exame.getString("mco_codigo"))) {
            RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, fil_codigo, req_codigo, exame.getString("exa_codigo"), Integer.parseInt(exame.getString("mco_codigo")), situacao.descricao);
        }
    }

    private Registro localizaExameRequisicao(Registro requisicao, Registro exame, Statement st) throws SQLException {
        String fil = "";
        String req = requisicao.getString("idLis");
        String exa = exame.getString("exa_codigo");
        String mco = exame.getString("mco_codigo");
        if (Funcoes.textoVazio(req) || req.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Sem c\u00f3digo de requisi\u00e7\u00e3o no Jalis. C\u00f3digo \u00c1lvaro: " + requisicao.getString("idApoio"), false);
            return null;
        }
        if (Funcoes.textoVazio(exa) || Funcoes.textoVazio(mco)) {
            this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis. C\u00f3digo \u00c1lvaro: " + requisicao.getString("idApoio"), false);
            return null;
        }
        fil = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
        req = req.substring(ParametrosGerais.getDigitosTuboFilial());
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append("  b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, g.met_codigo, \n");
        sql.append("  c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, a.req_guia as req_guia, b.exr_solicitadotiss as exr_solicitadotiss, b.exr_codautorizacao as exr_codautorizacao \n");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo \n");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        sql.append("  b.exa_codigo = '").append(exa).append("' and \n");
        sql.append("  b.mco_codigo = ").append(mco);
        sql.append("  and a.req_excluida = false and b.exr_excluido = false and \n");
        sql.append("  g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' ");
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        if (res.next()) {
            Registro reg = new Registro(res);
            reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(fil, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(fil, reg.getString(CODIGO_LAYOUT)));
            Registro formatacao = new Registro();
            formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor(FORMATACAO, formatacao);
            return reg;
        }
        this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis Fil.: %s Req.: %s. C\u00f3digo \u00c1lvaro:%s ", fil, req, requisicao.getString("idApoio")), false);
        this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.NAO_LOCALIZADO);
        return null;
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next() && rs.getInt("lae_codigo") == this.codigoLabExterno) {
                String xml = rs.getString("ele_xmllabexterno");
                reg.setValor("ele_xmllabexterno", xml);
                exa = StringUtil.getValor(xml, "codigo");
                mco = StringUtil.getValor(xml, "material");
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("select ati_xml from examesatitude where fil_codigo = ").append(fil);
                sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                sqlBuilder.append(" and ati_codexame = '").append(exa).append("' and ati_codmaterial = '").append(mco).append("' ");
                rs = st.executeQuery(sqlBuilder.toString());
                if (rs.next()) {
                    reg.setValor("ati_xml", rs.getString("ati_xml"));
                }
                return true;
            }
        }
        return false;
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAtitude 784");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizaVersaoLayoutExame(Registro reg, Registro exame) {
        Statement st = Conexao.getStatement();
        try {
            Registro exaAtitude = ParserImportacaoAtitude.getExame(reg.getString("ele_xmllabexterno"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
            exaAtitude.setValor("data_alteracao", exame.getString("data_alteracao"));
            String exa = StringUtil.getValor(reg.getString("ele_xmllabexterno"), "codigo");
            String mco = StringUtil.getValor(reg.getString("ele_xmllabexterno"), "material");
            StringBuilder bui = new StringBuilder("");
            bui.append("update examematcoletalabexterno set \n");
            bui.append("  ele_xmllabexterno = '").append(ParserImportacaoAtitude.getXml(exaAtitude)).append("' \n");
            bui.append("where \n");
            bui.append("  fil_codigo = ").append(reg.getString("fil_codigo")).append(" and \n");
            bui.append("  exa_codigo = '").append(exaAtitude.getString("exa_codigo")).append("' and \n");
            bui.append("  mco_codigo = ").append(exaAtitude.getString("mco_codigo")).append(" and \n");
            bui.append("  lae_codigo = ").append(this.codigoLabExterno).append(" \n");
            Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
            exaAtitude = null;
            exaAtitude = ParserImportacaoAtitude.getExame(reg.getString("ati_xml"), null, null);
            exaAtitude.setValor("data_alteracao", exame.getString("data_alteracao"));
            bui.setLength(0);
            bui.append("update examesatitude set ati_xml = '").append(ParserImportacaoAtitude.getXml(exaAtitude)).append("' ");
            bui.append(" where fil_codigo = ").append(reg.getString("fil_codigo"));
            bui.append(" and lae_codigo = ").append(this.codigoLabExterno);
            bui.append(" and ati_codexame = '").append(exa).append("'");
            bui.append(" and ati_codmaterial = '").append(mco).append("' ");
            Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAtitude: 824");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_RELACIONAMENTO("Sem relacionamento"),
        SEM_MATERIAL("Sem material"),
        LAYOUT_ATUALIZADO("Layout atualizado, mas n\u00e3o relacionado");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

