/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.atitude;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.EditorTermica;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloAtitude
extends AbstractConfiguradorProtocolo
implements ActionListener {
    protected JTextField textAutorizacao = new TTextField(32, 3);
    private String modeloEtq = "";

    public ConfiguradorProtocoloAtitude(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloAtitude(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloAtitude((Frame)pai, "Laborat\u00f3rio Atitude", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloAtitude((Dialog)pai, "Laborat\u00f3rio Atitude", codigoLaboratorio);
        }
        return null;
    }

    @Override
    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append("atitude").append(">");
        xml.append("<lote>").append(this.textLote.getText()).append("</lote>");
        xml.append("<autorizacao>").append(this.textAutorizacao.getText()).append("</autorizacao>");
        xml.append("<etiquetaAtitude>false</etiquetaAtitude>");
        xml.append("<modeloEtiqueta>").append(this.modeloEtq).append("</modeloEtiqueta>");
        return xml.append("</").append("atitude").append(">").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "atitude");
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
            this.textAutorizacao.setText(StringUtil.getValor(xml, "autorizacao"));
            this.modeloEtq = StringUtil.getValor(xml, "modeloEtiqueta");
        }
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        Dimension dlbl = new Dimension(20, 20);
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        JLabel lblChave = ComponenteFactory.novoJLabel("Autorizador:", dlbl);
        lblChave.setMinimumSize(dlbl);
        this.getPanelCentral().add((Component)lblChave, cons);
        cons.gridx = 1;
        this.textAutorizacao = new TTextField(32, 3);
        this.textAutorizacao.setPreferredSize(new Dimension(210, 20));
        this.textAutorizacao.setMinimumSize(new Dimension(210, 20));
        this.getPanelCentral().add((Component)this.textAutorizacao, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", dlbl);
        lblLote.setMinimumSize(dlbl);
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        this.textLote.setPreferredSize(new Dimension(150, 20));
        this.textLote.setMinimumSize(new Dimension(150, 20));
        this.getPanelCentral().add((Component)this.textLote, cons);
        this.pack();
        this.setSize(new Dimension(380, 135));
        ScreenUtil.centralizar(this);
    }

    private void configuraEtq() {
        EditorTermica termica = new EditorTermica(Laboratorio.getInstancia(), "Configurando ", true);
        termica.setCamposBanco(new String[]{"requisicao", "nomePaciente", "material", "examesRede", "codEtiquetaAtitude"});
        termica.setDocumento(this.modeloEtq);
        termica.setVisible(true);
        if (termica.ok()) {
            this.modeloEtq = termica.getDocumento();
        }
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textAutorizacao.getText()) || this.textAutorizacao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado uma chave v\u00e1lida", 1);
        } else if (!this.textLote.getText().matches("\\d+")) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um c\u00f3digo de lote v\u00e1lido", 1);
        } else {
            return true;
        }
        return false;
    }
}

