/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.atitude;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.atitude.Item;
import jalis.laboratorio.util.parsers.atitude.ParserImportacaoAtitude;
import jalis.laboratorio.util.parsers.atitude.SelecionaRecipiente;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorAtitude
extends AbstractConfigurador
implements ListSelectionListener,
KeyListener,
MouseListener {
    private static final String RECIPIENTE = "rec";
    private static final String DESCRICAO_MAT = "descricaoMat";
    private static final String MAT_ATITUDE = "matAtitude";
    private static final String TAG_DADO_ADICIONAL = "dadoAdicional";
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String MATERIAL = "material";
    private static final String OBJ_EXAME_ATITUDE = "objExameAtitude";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "material");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 100, 0, 170);
    private JTextField textLocalizar = new JTextField();
    private ModeloResultSet modDadosAdicionais = new ModeloResultSet("Dado Adicional", "dadoAdicional", "Sel", "selecionado");
    private ModeloResultSet modRecipientes = new ModeloResultSet("Material", "matAtitude", "Descri\u00e7\u00e3o Material", "descricaoMat", "Recipiente no Jalis", "rec");
    private JTable tableDadosAdicionais = ComponenteFactory.novoJTable((TableModel)this.modDadosAdicionais, null, 0, 40);
    private JTable tableRecipientes = ComponenteFactory.novoJTable((TableModel)this.modRecipientes, null, 60, 0, 200);
    private JScrollPane scrollDadosAdicionais = new JScrollPane(this.tableDadosAdicionais);
    private JScrollPane scrollRecipientes = new JScrollPane(this.tableRecipientes);
    private JCheckBox checkUtilizarCurva = ComponenteFactory.novoJCheckBox("Informar qtde de tempos para curva", 'c', this);
    private JTextField textTemposCurva = ComponenteFactory.novoTTextField(1, 1);
    private String xmlSelecionado = "";
    private Map<String, String> materiais = new HashMap<String, String>();

    public ConfiguradorAtitude(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Atitude", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorAtitude(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Atitude", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorAtitude(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorAtitude(Dialog pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ParserImportacaoAtitude.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            Registro exa = ParserImportacaoAtitude.getExame(xml, null, null);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.getString("codigo").equals(reg.getValor(OBJ_EXAME_ATITUDE, Registro.class).getString("codigo"))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                if (exa.getValor("possuiCurva") != null) {
                    this.textTemposCurva.setText(exa.getString("possuiCurva"));
                    this.checkUtilizarCurva.setSelected(true);
                    break;
                }
                this.textTemposCurva.setText("");
                this.checkUtilizarCurva.setSelected(false);
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.checkUtilizarCurva) {
            this.textTemposCurva.setEnabled(this.checkUtilizarCurva.isSelected());
        } else {
            super.actionPerformed(e);
        }
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null) {
            String exame = StringUtil.getValor(xml, "exame");
            return StringUtil.getValor(exame, "descricao");
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            String exa = StringUtil.getValor(xml, "exame");
            return StringUtil.getValor(exa, MATERIAL) + "|" + StringUtil.getValor(exa, "codigo") + "|1";
        }
        return "";
    }

    public static ConfiguradorAtitude novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorAtitude((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorAtitude((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 170));
        this.scrollDadosAdicionais.setPreferredSize(new Dimension(650, 100));
        this.scrollRecipientes.setPreferredSize(new Dimension(650, 100));
        this.modDadosAdicionais.setColunaEditavel("selecionado");
        TableColumn col = this.tableDadosAdicionais.getColumnModel().getColumn(1);
        col.setMinWidth(30);
        col.setMaxWidth(30);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        JPanel p = ComponenteFactory.novoJPanelBorderLayout("", null, (Component)ComponenteFactory.novoJPanelBorderLayout("Dados Adicionais", (Component)this.scrollDadosAdicionais, null, null, null, null), (Component)ComponenteFactory.novoJPanelBorderLayout("Recipientes", (Component)this.scrollRecipientes, null, null, null, null), null, null);
        this.getPanelCentral().add((Component)p, "Center");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Curva", (Component)this.montarPainelCurva(), null, null, null, null), "South");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        this.tableRecipientes.addKeyListener(this);
        this.tableRecipientes.addMouseListener(this);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorAtitude.this.modExa.filtrar(ConfiguradorAtitude.DESC_EXA, ConfiguradorAtitude.this.textLocalizar.getText());
                if (ConfiguradorAtitude.this.modExa.getRowCount() > 0) {
                    ConfiguradorAtitude.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private JPanel montarPainelCurva() {
        JPanel panelAdicional = new JPanel();
        this.textTemposCurva.setEnabled(this.checkUtilizarCurva.isSelected());
        panelAdicional.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints(0, 0, 1, 0, 0.5, 0.5, 17, 0, new Insets(0, 0, 4, 0), 0, 0);
        cons.insets = new Insets(0, 1, 4, 1);
        this.checkUtilizarCurva.setPreferredSize(new Dimension(249, 20));
        panelAdicional.add((Component)this.checkUtilizarCurva, cons);
        cons.weightx = 12.0;
        ++cons.gridx;
        this.textTemposCurva.setPreferredSize(new Dimension(30, 20));
        panelAdicional.add((Component)this.textTemposCurva, cons);
        return panelAdicional;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorAtitude.this.tableExa.hasFocus() && (row = ConfiguradorAtitude.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorAtitude.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorAtitude.this.tableExa.scrollRectToVisible(ConfiguradorAtitude.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorAtitude.this.tableExa.hasFocus() && (row = ConfiguradorAtitude.this.tableExa.getSelectedRow()) < ConfiguradorAtitude.this.tableExa.getRowCount() - 1) {
                    ConfiguradorAtitude.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorAtitude.this.tableExa.scrollRectToVisible(ConfiguradorAtitude.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        for (Registro exame : ParserImportacaoAtitude.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getString("codigo"));
            reg.setValor(DESC_EXA, exame.getString("descricao"));
            reg.setValor(MATERIAL, exame.getString("material_descricao"));
            reg.setValor(OBJ_EXAME_ATITUDE, exame);
            this.modExa.addRegistro(reg);
            this.materiais.put(exame.getString(MATERIAL).trim(), exame.getString("material_descricao"));
        }
    }

    @Override
    public boolean acaoOk() {
        Registro exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private boolean atualizarXMLSelecionado() {
        Registro exa = this.getExameSelecionado();
        if (exa != null) {
            ArrayList<Registro> dados = new ArrayList<Registro>();
            for (int i = 0; i < this.modDadosAdicionais.getRowCount(); ++i) {
                Registro r = this.modDadosAdicionais.getRegistro(i);
                if (r.contemValor("selecionado", Boolean.TRUE)) {
                    r.getValor("dado", Registro.class).setValor("selecionado", "true");
                } else {
                    r.getValor("dado", Registro.class).setValor("selecionado", "false");
                }
                dados.add(r.getValor("dado", Registro.class));
            }
            if (this.checkUtilizarCurva.isSelected()) {
                exa.setValor("possuiCurva", this.textTemposCurva.getText());
            }
            exa.setValor("dadosAdicionais", dados);
            StringBuilder xml = new StringBuilder(ParserImportacaoAtitude.getXml(exa));
            StringBuilder bufItens = new StringBuilder("");
            for (int i = 0; i < this.tableRecipientes.getRowCount(); ++i) {
                Object obj = this.tableRecipientes.getValueAt(i, 2);
                if (obj == null || !(obj instanceof Item)) {
                    Funcoes.mensagem(this, "Associe os recipientes do Jalis para os materiais", 1);
                    return false;
                }
                bufItens.append(((Item)obj).codigo).append(", ");
            }
            xml.append(this.xmlSelecionado);
            if (!Funcoes.textoVazio(bufItens.toString())) {
                StringUtil.setValor(xml, "recipientes", bufItens.delete(bufItens.length() - 2, bufItens.length() - 1).toString().trim());
            }
            this.xmlSelecionado = xml.toString();
            return true;
        }
        return false;
    }

    private Registro getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return reg.getValor(OBJ_EXAME_ATITUDE, Registro.class);
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.atualizarDadosAdicionais(reg.getValor(OBJ_EXAME_ATITUDE, Registro.class));
            this.atualizarLinhasResultados(reg.getValor(OBJ_EXAME_ATITUDE, Registro.class));
        }
    }

    private void atualizarDadosAdicionais(Registro exame) {
        this.modDadosAdicionais.limpar();
        List dadosAd = exame.getValor("dadosAdicionais", List.class);
        String xmlMateriais = exame.getString("materiais");
        if (dadosAd != null && dadosAd.size() > 0) {
            for (Registro dado : dadosAd) {
                String[] dados;
                Registro r = new Registro();
                r.setValor(TAG_DADO_ADICIONAL, String.format("%s (%s)", dado.getString("descricao"), dado.getString("unidade")));
                r.setValor("codigo", dado.getString("codigo"));
                String xmlExame = StringUtil.getValor(this.xmlSelecionado, "dadosAdicionais");
                for (String xmlDado : dados = StringUtil.getValores(this.xmlSelecionado, "dado")) {
                    if (StringUtil.getValor(xmlDado, "descricao").equals(dado.getString("descricao")) && StringUtil.getValor(xmlDado, "unidade").equals(dado.getString("unidade"))) {
                        r.setValor("selecionado", StringUtil.getBoolean(xmlDado, "selecionado") ? Boolean.TRUE : Boolean.FALSE);
                        break;
                    }
                    r.setValor("selecionado", Boolean.FALSE);
                }
                if (Funcoes.textoVazio(xmlExame)) {
                    r.setValor("selecionado", Boolean.FALSE);
                }
                r.setValor("dado", dado);
                this.modDadosAdicionais.addRegistro(r);
            }
        }
        this.modRecipientes.limpar();
        String xmlRecipientes = StringUtil.getValor(this.xmlSelecionado, "recipientes");
        if (!Funcoes.textoVazio(xmlMateriais)) {
            String[] idMat = xmlMateriais.split(",");
            String[] idRec = xmlRecipientes.split(", ");
            for (int i = 0; i < idMat.length; ++i) {
                Registro mat = new Registro();
                mat.setValor(MAT_ATITUDE, idMat[i]);
                mat.setValor(DESCRICAO_MAT, this.materiais.get(idMat[i]));
                if (idMat.length == idRec.length && this.getRecipientes().containsKey(idRec[i].trim())) {
                    mat.setValor(RECIPIENTE, new Item(idRec[i], this.getRecipientes().get(idRec[i].trim())));
                }
                this.modRecipientes.addRegistro(mat);
            }
        }
    }

    private void atualizarLinhasResultados(Registro exame) {
        boolean possuiCurva = !Funcoes.textoVazio(StringUtil.getValor(this.xmlSelecionado, "possuiCurva"));
        this.checkUtilizarCurva.setSelected(possuiCurva);
        this.textTemposCurva.setEnabled(possuiCurva);
        this.textTemposCurva.setText(StringUtil.getValor(this.xmlSelecionado, "possuiCurva"));
    }

    private void selecionaRecipiente() {
        int row = this.tableRecipientes.getSelectedRow();
        if (row > -1) {
            Item[] itens = new Item[this.getRecipientes().size()];
            int pos = 0;
            for (String key : this.getRecipientes().keySet()) {
                itens[pos++] = new Item(key, this.getRecipientes().get(key));
            }
            SelecionaRecipiente selRec = new SelecionaRecipiente(null, itens);
            selRec.setVisible(true);
            if (selRec.isOk()) {
                this.tableRecipientes.setValueAt(selRec.getSelectedItem(), row, 2);
                this.tableRecipientes.repaint();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.selecionaRecipiente();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == ' ') {
            this.selecionaRecipiente();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

