/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro.resultado;

import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.rede.ws.ImportacaoResultadoRedeWSDao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InformaPeriodoImportacaoAlvaro
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Importa\u00e7\u00e3o via Webservice";
    private static final String FILTRO_DATA_INICIAL = "dataInicial";
    private static final String FILTRO_DATA_FINAL = "dataFinal";
    private static final String FILTRO_HORA_INICIAL = "horaInicial";
    private static final String FILTRO_HORA_FINAL = "horaFinal";
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JLabel labelHoraInicial = new JLabel("Hora Inicial:");
    private JLabel labelHoraFinal = new JLabel("Hora Final:");
    private JLabel labelFilial = new JLabel("C\u00f3d. Filial:");
    private JLabel labelRequisicao = new JLabel("C\u00f3d. Requisi\u00e7\u00e3o:");
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textFilial = new TTextField(10, 1);
    private TTextField textRequisicao = new TTextField(10, 1);
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private TTextField textLote = new TTextField(20, 1);
    private JCheckBox checkBoxPeriodo = new JCheckBox("Periodo: ");
    private JCheckBox checkBoxRequisicao = new JCheckBox("Requisi\u00e7\u00e3o: ");
    private JCheckBox checkBoxValorReferencia = new JCheckBox("Solicitar valor de refer\u00eancia", true);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonRequisicao = ComponenteFactory.novoJButton(this, true);
    private boolean isOk = false;
    private String dataInicial = null;
    private String dataFinal = null;
    private String horaInicial = null;
    private String horaFinal = null;
    private int codigoLabExterno;

    public static InformaPeriodoImportacaoAlvaro novaInstancia(Object pai, int codigoLabExterno) {
        if (pai instanceof Dialog) {
            return new InformaPeriodoImportacaoAlvaro((Dialog)pai, codigoLabExterno);
        }
        return new InformaPeriodoImportacaoAlvaro((Frame)pai, codigoLabExterno);
    }

    public InformaPeriodoImportacaoAlvaro(Dialog pai, int codigoLabExterno) {
        super(pai, TITULO);
        this.codigoLabExterno = codigoLabExterno;
        this.setPeriodo();
        this.montaTela();
    }

    public InformaPeriodoImportacaoAlvaro(Frame pai, int codigoLabExterno) {
        super(pai, TITULO);
        this.codigoLabExterno = codigoLabExterno;
        this.setPeriodo();
        this.montaTela();
    }

    private void setPeriodo() {
        String periodoFiltro = ParametrosLocais.getParametro("filtroImportacaoRedeWS");
        Date dataHoraServidor = Funcoes.getDataHoraServidor();
        this.dataInicial = !Funcoes.textoVazio(periodoFiltro) ? StringUtil.getValor(periodoFiltro, FILTRO_DATA_FINAL) : "";
        this.horaInicial = !Funcoes.textoVazio(periodoFiltro) ? StringUtil.getValor(periodoFiltro, FILTRO_HORA_INICIAL) : "";
        this.dataFinal = Funcoes.formataData(dataHoraServidor);
        this.horaFinal = Funcoes.formataHora(dataHoraServidor, false);
    }

    private void montaTela() {
        this.setSize(new Dimension(370, 300));
        this.setResizable(false);
        this.setModal(true);
        this.definirTamanhoComponentes();
        this.desabilitarComponentes();
        this.buttonOK.setText("Importar");
        this.textDataInicial.setText(!Funcoes.textoVazio(this.dataInicial) ? this.dataInicial : "");
        this.textDataFinal.setText(!Funcoes.textoVazio(this.dataFinal) ? this.dataFinal : "");
        this.textHoraInicial.setText(!Funcoes.textoVazio(this.horaInicial) ? this.horaInicial : "");
        this.textHoraFinal.setText(!Funcoes.textoVazio(this.horaFinal) ? this.horaFinal : "");
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        JPanel panelInicial = this.posicionarComponentes();
        JPanel aux = new JPanel(new BorderLayout());
        aux.add((Component)panelInicial, "North");
        panel.add((Component)aux, "West");
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textDataInicial);
        this.listener();
    }

    private void definirTamanhoComponentes() {
        int alturaPadrao = 20;
        int larguraText = 100;
        int larguraButton = 20;
        this.textDataInicial.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textDataInicial.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraInicial.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraInicial.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textDataFinal.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textDataFinal.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraFinal.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraFinal.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textLote.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textLote.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.buttonDataInicial.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataInicial.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataFinal.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataFinal.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonRequisicao.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonRequisicao.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonFilial.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonFilial.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
    }

    private JPanel posicionarComponentes() {
        JPanel panelInicial = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.insets = new Insets(1, 1, 0, 0);
        c1.fill = 1;
        c1.anchor = 16;
        panelInicial.add((Component)this.checkBoxPeriodo, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.labelDataInicial, c1);
        c1.insets = new Insets(0, 10, 0, 0);
        c1.gridx += 3;
        panelInicial.add((Component)this.labelHoraInicial, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.textDataInicial, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonDataInicial, c1);
        c1.insets = new Insets(0, 10, 0, 0);
        c1.gridx += 2;
        panelInicial.add((Component)this.textHoraInicial, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.labelDataFinal, c1);
        c1.insets = new Insets(0, 10, 0, 0);
        c1.gridx += 3;
        panelInicial.add((Component)this.labelHoraFinal, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.textDataFinal, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonDataFinal, c1);
        c1.insets = new Insets(0, 10, 0, 0);
        c1.gridx += 2;
        panelInicial.add((Component)this.textHoraFinal, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 0;
        panelInicial.add((Component)this.checkBoxRequisicao, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.labelFilial, c1);
        ++c1.gridy;
        panelInicial.add((Component)this.textFilial, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonFilial, c1);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.labelRequisicao, c1);
        ++c1.gridy;
        panelInicial.add((Component)this.textRequisicao, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonRequisicao, c1);
        c1.gridx = 0;
        ++c1.gridy;
        JPanel p = new JPanel(new FlowLayout(0, 0, 20));
        p.add(this.checkBoxValorReferencia);
        c1.anchor = 256;
        c1.gridwidth = 5;
        c1.gridx = 0;
        ++c1.gridy;
        c1.weightx = 1.0;
        c1.weighty = 1.0;
        c1.fill = 1;
        panelInicial.add((Component)p, c1);
        return panelInicial;
    }

    private void desabilitarComponentes() {
        this.textFilial.setEnabled(false);
        this.textRequisicao.setEnabled(false);
        this.buttonFilial.setEnabled(false);
        this.buttonRequisicao.setEnabled(false);
        this.textLote.setEnabled(false);
        this.checkBoxPeriodo.setSelected(true);
    }

    private void listener() {
        this.checkBoxPeriodo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                if (this.checkBoxRequisicao.isSelected()) {
                    this.checkBoxRequisicao.setSelected(!this.checkBoxRequisicao.isSelected());
                }
                this.habilitarDesabilitarComponentesDataHora(true);
                this.habilitarDesabilitarComponentesRequisicao(false);
                this.habilitarDesabilitarComponentesLote(false);
            }
        });
        this.checkBoxRequisicao.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                if (this.checkBoxPeriodo.isSelected()) {
                    this.checkBoxPeriodo.setSelected(!this.checkBoxPeriodo.isSelected());
                }
                this.habilitarDesabilitarComponentesDataHora(false);
                this.habilitarDesabilitarComponentesRequisicao(true);
                this.habilitarDesabilitarComponentesLote(false);
            }
        });
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    InformaPeriodoImportacaoAlvaro.this.buscaFilial();
                    return;
                }
                super.keyPressed(e);
            }
        });
        this.textRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    InformaPeriodoImportacaoAlvaro.this.buscaRequisicao();
                    return;
                }
                super.keyPressed(e);
            }
        });
    }

    private void habilitarDesabilitarComponentesDataHora(boolean habilitaComponentes) {
        this.textDataInicial.setText(habilitaComponentes ? this.dataInicial : "");
        this.textDataFinal.setText(habilitaComponentes ? this.dataFinal : "");
        this.textHoraInicial.setText(habilitaComponentes ? this.horaInicial : "");
        this.textHoraFinal.setText(habilitaComponentes ? this.horaFinal : "");
        this.textDataInicial.setEnabled(habilitaComponentes);
        this.textDataFinal.setEnabled(habilitaComponentes);
        this.textHoraInicial.setEnabled(habilitaComponentes);
        this.textHoraFinal.setEnabled(habilitaComponentes);
        this.buttonDataFinal.setEnabled(habilitaComponentes);
        this.buttonDataInicial.setEnabled(habilitaComponentes);
    }

    private void habilitarDesabilitarComponentesRequisicao(boolean habilitaComponentes) {
        if (!habilitaComponentes) {
            this.textFilial.setText("");
            this.textRequisicao.setText("");
        }
        this.textFilial.setEnabled(habilitaComponentes);
        this.textRequisicao.setEnabled(habilitaComponentes);
        this.buttonFilial.setEnabled(habilitaComponentes);
        this.buttonRequisicao.setEnabled(habilitaComponentes);
    }

    private void habilitarDesabilitarComponentesLote(boolean habilitaComponentes) {
        if (!habilitaComponentes) {
            this.textLote.setText("");
        }
        this.textLote.setEnabled(habilitaComponentes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.textDataInicial.getParent(), true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.textDataFinal.getParent(), true);
        } else if (e.getSource() == this.buttonFilial) {
            this.buscaFilial();
        } else if (e.getSource() == this.buttonRequisicao) {
            this.buscaRequisicao();
        } else if (e.getSource() == this.buttonOK) {
            if (this.preenchimentoValido()) {
                this.isOk = true;
                this.setVisible(false);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean preenchimentoValido() {
        if (this.filtroPeriodoSelecionado()) {
            if (Funcoes.textoVazio(this.textDataInicial.getText())) {
                Funcoes.mensagem(this, "Data inicial deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textDataInicial);
                return false;
            }
            if (Funcoes.textoVazio(this.textDataFinal.getText())) {
                Funcoes.mensagem(this, "Data final deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textDataFinal);
                return false;
            }
            if (Funcoes.textoVazio(this.textHoraInicial.getText())) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Hora inicial n\u00e3o informada", 2);
                ScreenUtil.requisitarFoco(this.textHoraInicial);
                return false;
            }
            if (Funcoes.textoVazio(this.textHoraFinal.getText())) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Hora final n\u00e3o informada", 2);
                ScreenUtil.requisitarFoco(this.textHoraFinal);
                return false;
            }
            int intervalo = Funcoes.diasPorPeriodo(this.textDataInicial.getText(), this.textDataFinal.getText());
            if (intervalo < 0) {
                Funcoes.mensagem(this, "A data final n\u00e3o pode ser menor que a data inicial.", 2);
                ScreenUtil.requisitarFoco(this.textDataFinal);
                return false;
            }
            if (intervalo > 7) {
                Funcoes.mensagem(this, "O per\u00edodo informado, excede a quantidade m\u00e1xima de dias permitida para a Importa\u00e7\u00e3o (7 dias)", 2);
                ScreenUtil.requisitarFoco(this.textDataInicial);
                return false;
            }
        }
        if (this.filtroRequisicaoSelecionado()) {
            ImportacaoResultadoRedeWSDao dao = new ImportacaoResultadoRedeWSDao();
            if (Funcoes.textoVazio(this.textFilial.getText())) {
                Funcoes.mensagem(this, "Filial deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textFilial);
                return false;
            }
            if (Funcoes.textoVazio(this.textRequisicao.getText())) {
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textRequisicao);
                return false;
            }
            if (!dao.requisicaoValida(this.textFilial.getText(), this.textRequisicao.getText())) {
                Funcoes.mensagem(this, "C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o encontrado no sistema", 2);
                ScreenUtil.requisitarFoco(this.textRequisicao);
                return false;
            }
        }
        return true;
    }

    private void buscaRequisicao() {
        if (!Funcoes.textoVazio(this.textFilial)) {
            Hashtable resultado = Pesquisas.requisicao(Laboratorio.getInstancia(), this.textFilial.getText(), true, false, false);
            if (resultado != null) {
                this.textRequisicao.setText(resultado.get("req_codigo").toString());
            }
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return;
        }
        Funcoes.mensagem(this, "Filial deve ser informada.", 2);
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(Laboratorio.getInstancia(), false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    public boolean isOk() {
        if (this.isOk) {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("filtro");
            if (!Funcoes.textoVazio(this.textDataInicial.getText())) {
                this.dataInicial = this.textDataInicial.getText();
            }
            if (!Funcoes.textoVazio(this.textDataFinal.getText())) {
                this.dataFinal = this.textDataFinal.getText();
            }
            if (!Funcoes.textoVazio(this.textHoraInicial.getText())) {
                this.horaInicial = this.textHoraInicial.getText();
            }
            if (!Funcoes.textoVazio(this.textHoraFinal.getText())) {
                this.horaFinal = this.textHoraFinal.getText();
            }
            xml.escrever(FILTRO_DATA_INICIAL, this.dataInicial);
            xml.escrever(FILTRO_DATA_FINAL, this.dataFinal);
            xml.escrever(FILTRO_HORA_INICIAL, this.horaInicial);
            xml.escrever(FILTRO_HORA_FINAL, this.horaFinal);
            try {
                xml.fechar("filtro");
            }
            catch (XMLStringBuilderException xMLStringBuilderException) {
                // empty catch block
            }
            ParametrosLocais.setParametro("filtroImportacaoRedeWS", xml.toString());
            ParametrosLocais.salvaParametros();
            ParametrosLocais.carregaParametros();
        }
        return this.isOk;
    }

    public String getDataInicial() {
        return this.textDataInicial.getText();
    }

    public String getDataFinal() {
        return this.textDataFinal.getText();
    }

    public String getHoraInicial() {
        return this.textHoraInicial.getText();
    }

    public String getHoraFinal() {
        return this.textHoraFinal.getText();
    }

    public String getFiltroRequisicao() {
        return this.textRequisicao.getText();
    }

    public String getFiltroFilial() {
        return this.textFilial.getText();
    }

    public String getFiltroLote() {
        return this.textLote.getText();
    }

    public boolean filtroRequisicaoSelecionado() {
        return this.checkBoxRequisicao.isSelected();
    }

    public boolean filtroPeriodoSelecionado() {
        return this.checkBoxPeriodo.isSelected();
    }

    public int getCodigoLabExterno() {
        return this.codigoLabExterno;
    }

    public boolean isSolicitarValorReferencia() {
        return this.checkBoxValorReferencia.isSelected();
    }
}

