/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro.resultado;

import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElementoAlvaro {
    private ElementoAlvaro pai;
    private String nome;
    private String valor;
    private String atributoID;
    private Map<String, String> atrs;
    private List<ElementoAlvaro> filhos;

    public ElementoAlvaro(ElementoAlvaro pai, String nome, String valor) {
        this.pai = pai;
        Funcoes.validarNaoNull(nome, "nome");
        this.nome = nome;
        this.valor = valor;
        this.atrs = new HashMap<String, String>();
        this.filhos = new ArrayList<ElementoAlvaro>();
        this.atributoID = null;
    }

    public ElementoAlvaro(ElementoAlvaro pai, String nome) {
        this(pai, nome, null);
    }

    public ElementoAlvaro getPai() {
        return this.pai;
    }

    public void setNome(String nome) {
        Funcoes.validarNaoNull(nome, "nome");
        this.nome = nome;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public void setAtributo(String atr, String valor) {
        Funcoes.validarNaoNull(atr, "atr");
        Funcoes.validarNaoNull(valor, "valor");
        this.atrs.put(atr, valor);
    }

    public void setAtributoID(String atr, String valor) {
        Funcoes.validarNaoNull(atr, "valor");
        Funcoes.validarNaoNull(valor, "valor");
        this.atributoID = atr;
        this.atrs.put(this.atributoID, valor);
    }

    public void addFilho(ElementoAlvaro filho) {
        Funcoes.validarNaoNull(filho, "filho");
        this.filhos.add(filho);
    }

    public boolean contemAtributo(String atributo) {
        return this.atrs.containsKey(atributo);
    }

    public boolean contemAtributoID() {
        return this.atributoID != null && this.atrs.containsKey(this.atributoID);
    }

    public boolean contemAtributos() {
        return !this.atrs.isEmpty();
    }

    public boolean contemFilho(String nome) {
        for (ElementoAlvaro filho : this.filhos) {
            if (!filho.getNome().equals(nome)) continue;
            return true;
        }
        return false;
    }

    public boolean contemFilhos() {
        return !this.filhos.isEmpty();
    }

    public Set<String> getAtributos() {
        return new HashSet<String>(this.atrs.keySet());
    }

    public Map<String, String> getMapaAtributos() {
        return new HashMap<String, String>(this.atrs);
    }

    public ElementoAlvaro getFilho(String nome) {
        for (ElementoAlvaro filho : this.filhos) {
            if (!filho.getNome().equals(nome)) continue;
            return filho;
        }
        return null;
    }

    public List<ElementoAlvaro> getFilhos() {
        return new ArrayList<ElementoAlvaro>(this.filhos);
    }

    public List<ElementoAlvaro> getFilhos(String nome) {
        ArrayList<ElementoAlvaro> temp = new ArrayList<ElementoAlvaro>();
        for (ElementoAlvaro filho : this.filhos) {
            if (!filho.getNome().equals(nome)) continue;
            temp.add(filho);
        }
        return temp;
    }

    public String getNome() {
        return this.nome;
    }

    public String getNomeAtributoID() {
        return this.atributoID;
    }

    public String getValor() {
        return this.valor;
    }

    public String getValorAtributo(String atributo) {
        return this.atrs.get(atributo);
    }

    public String getValorAtributoID() {
        return this.atrs.get(this.atributoID);
    }
}

