/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro.resultado;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.alvaro.CampoComplementar;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.util.StringUtil;
import jalis.util.xml.XMLUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CamposImportacaoAlvaro
implements CamposImportacao {
    LinkedHashMap<String, String> linhas;
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    public CamposImportacaoAlvaro(String xmlAlvaro, String xmlExameLabApoio, String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPai) {
        block12: {
            block11: {
                this.linhas = new LinkedHashMap();
                this.codigoExamePai = codigoExamePai;
                this.codigoMaterialPai = codigoMaterialPai;
                this.linhas.put("", "Nenhum");
                this.linhas.put("codigo_aol", "C\u00f3digo da requisi\u00e7\u00e3o no \u00c1lvaro On-Line");
                this.linhas.put("codigo", "C\u00f3digo da requisi\u00e7\u00e3o no \u00c1lvaro");
                this.linhas.put("observacao", "Observa\u00e7\u00e3o do Exame");
                this.linhas.put("cod_exame_alv", "C\u00f3digo do exame no \u00c1lvaro");
                this.linhas.put("desc_exame", "Descri\u00e7\u00e3o do exame no \u00c1lvaro");
                this.linhas.put("cod_mat_alv", "C\u00f3digo do material no \u00c1lvaro");
                this.linhas.put("data_alt", "Data de altera\u00e7\u00e3o do layout do exame no \u00c1lvaro");
                this.linhas.put("valor_ref", "Valores de refer\u00eancia");
                this.linhas.put("metodologia", "Metodologia");
                this.linhas.put("antibiogramas", "Resultados do antibiograma, quando dispon\u00edvel.");
                this.linhas.put("grafico", "Gr\u00e1fico do exame, quando dispon\u00edvel.");
                this.linhas.put("data_rst", "Data de resultado do exame.");
                this.linhas.put("codigo_tecnico_responsavel", "Conselho do T\u00e9cnico Respons\u00e1vel.");
                this.linhas.put("assinatura_tecnico_responsavel", "Assinatura do T\u00e9cnico Respons\u00e1vel.");
                this.linhas.put("nome_tecnico_responsavel", "Nome do Respons\u00e1vel T\u00e9cnico.");
                this.linhas.put("CNES", "C\u00f3digo CNES do laborat\u00f3rio.");
                ExameAlvaro exame = new ExameAlvaro(xmlExameLabApoio);
                if (xmlAlvaro.indexOf("?xml version") >= 0) break block11;
                this.codigoExame = StringUtil.getValor(xmlAlvaro, "codigo");
                this.versao = StringUtil.getValor(xmlAlvaro, "data_alteracao");
                if (exame.getLinhasResultado().size() <= 0) break block12;
                for (LinhaResultado linha : exame.getLinhasResultado()) {
                    String codigo = linha.getCodigo();
                    String descricao = linha.getDescricao();
                    if (exame.getLinhasResultado().size() > 1) {
                        this.linhas.put("unidade_" + codigo, "Unidade de " + descricao);
                    } else {
                        this.linhas.put("unidade", "Unidade de medida do exame.");
                    }
                    if (descricao.indexOf("$$") >= 0) {
                        this.carregaTemposLinhas(codigo, descricao, xmlExameLabApoio);
                        continue;
                    }
                    this.linhas.put("valorRef_" + codigo, "Vlr. ref. p/ " + descricao);
                    this.linhas.put("metodologia_" + codigo, "Metodologia de p/  " + descricao);
                    this.linhas.put(codigo, descricao);
                    for (CampoComplementar campo : exame.getCamposComplementares()) {
                        this.linhas.put(codigo + "_" + String.valueOf(campo.getCodigo()), descricao + " - " + campo.getLabel());
                    }
                }
                break block12;
            }
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(xmlAlvaro)));
                Element elem = doc.getDocumentElement();
                NodeList nl = elem.getElementsByTagName("exame");
                String tempExame = StringUtil.getValor(xmlExameLabApoio, "codigo");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element tagExame = (Element)nl.item(i);
                    this.codigoExame = tagExame.getAttribute("codigo");
                    if (!this.codigoExame.equalsIgnoreCase(tempExame)) continue;
                    this.versao = tagExame.getAttribute("dataalteracao");
                    List<Element> childs = XMLUtil.getElementosFilhos(tagExame);
                    for (Element c : childs) {
                        if (!c.getNodeName().equalsIgnoreCase("linhasresultado")) continue;
                        List<Element> l = XMLUtil.getElementosFilhos(c);
                        for (Element e : l) {
                            String linhaCodigo = e.getAttribute("codigo");
                            String linhaDescricao = e.getAttribute("descricao");
                            if (linhaDescricao.indexOf("$$") >= 0) {
                                this.carregaTemposLinhas(linhaCodigo, linhaDescricao, xmlExameLabApoio);
                                continue;
                            }
                            this.linhas.put(linhaCodigo, linhaDescricao);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void carregaTemposLinhas(String linha, String descricao, String xml) {
        String[] xmlLinhas;
        String xmlExame = StringUtil.getValor(xml, "exame");
        for (String s : xmlLinhas = StringUtil.getValores(StringUtil.getValor(xmlExame, "linhas_resultado"), "linha_resultado")) {
            String codigoLinha = StringUtil.getValor(s, "codigo");
            if (!codigoLinha.equalsIgnoreCase(linha)) continue;
            String[] tempos = this.carregaTempos(StringUtil.getValor(s, "tempos"));
            int i = 1;
            for (String tempo : tempos) {
                String desc = descricao.substring(0, descricao.indexOf("$$")) + tempo;
                this.linhas.put(codigoLinha + "_tempo_" + tempo, desc);
                ++i;
            }
        }
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    public String[] carregaTempos(String tempos) {
        String[] tmps;
        String[] retorno = tmps = tempos.split(",");
        ArrayList<String> temp = new ArrayList<String>();
        for (String t : tmps) {
            temp.add(t);
        }
        Collections.sort(temp);
        for (int i = 0; i < tmps.length; ++i) {
            retorno[i] = ((String)temp.get(i)).toString();
        }
        return retorno;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }
}

