/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.alvaro.DadoAdicional;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.laboratorio.util.parsers.alvaro.Solicitacao;
import jalis.laboratorio.util.parsers.alvaro.SolicitacaoExame;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.excel.Excel;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParserImportacaoAlvaro {
    public static final String EXAMES_EXCLUIDOS = "examesExcluidos";
    public static final String EXAMES_NAO_ENCONTRADOS = "naoEncontrados";
    private static final int PLAN_EXAMES = 0;
    private static final int PLAN_LINHAS_RESULTADO = 1;
    private static final int PLAN_MATERIAIS = 2;
    private static final int PLAN_DADOS_OBRIGATORIOS = 3;
    private static final int XLS_CODIGO = 0;
    private static final int XLS_NOME = 1;
    private static final int XLS_SINONIMO = 2;
    private static final int XLS_MATERIAL = 3;
    private static final int XLS_CODIGO_AMB = 5;
    private static final int XLS_EXA_DT_ULT_ALT = 6;
    private static final int XLS_EH_CURVA = 7;
    private static final int XLS_MAT_SID = 0;
    private static final int XLS_MAT_NOME = 1;
    private static final int XLS_EXAME = 0;
    private static final int XLS_DADO_OBRIGATORIO = 1;
    private static final int XLS_UNIDADE = 2;
    private static final int XLS_ID_CRITICA = 1;
    private static final int XLS_LINHA = 2;
    private static final int XLS_CAMPO_RESULTADO_NOME = 3;
    private static final int XLS_CAMPO_RESULTADO_UNIDADE = 4;
    private static final int XLS_DECIMAIS = 5;
    private static final int XLS_NUMERICO_ALFA = 6;

    private static Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    public static Map<String, Set<ExameAlvaro>> importarExamesAlvaro(File xml, int codigoLabExterno) throws Exception {
        return ParserImportacaoAlvaro.importarExamesAlvaro(xml, codigoLabExterno, null);
    }

    public static Map<String, Set<ExameAlvaro>> importarExamesAlvaro(File xml, int codigoLabExterno, JProgressBar progress) throws Exception {
        HashMap<String, Set<ExameAlvaro>> mapExames = new HashMap<String, Set<ExameAlvaro>>();
        Hashtable<String, String> materiais = null;
        HashSet<Object> examesNovos = new HashSet<ExameAlvaro>();
        ArrayList<Solicitacao> solicitacoes = new ArrayList<Solicitacao>();
        HashSet<ExameAlvaro> examesExcluidos = new HashSet<ExameAlvaro>();
        HashSet<Object> examesNaoEncontrados = new HashSet<Object>();
        boolean arquivoResultado = false;
        if (xml.getName().toLowerCase().endsWith("xml")) {
            Document doc = ParserImportacaoAlvaro.analisarXML(xml);
            if (doc != null) {
                Element raiz = doc.getDocumentElement();
                if (!raiz.getNodeName().equalsIgnoreCase("resultados") && !raiz.getNodeName().equalsIgnoreCase("cadastros")) {
                    return mapExames;
                }
                List<Element> filhos = XMLUtil.getElementosFilhos(raiz);
                if (raiz.getNodeName().equalsIgnoreCase("resultados")) {
                    arquivoResultado = true;
                    for (Element element : filhos) {
                        if (element.getNodeName().equalsIgnoreCase("cadastros")) {
                            filhos = XMLUtil.getElementosFilhos(element);
                            continue;
                        }
                        if (!element.getNodeName().equalsIgnoreCase("solicitacao")) continue;
                        solicitacoes.add(Solicitacao.parse(element));
                    }
                }
                for (Element element : filhos) {
                    if (element.getNodeName().equalsIgnoreCase("materiais")) {
                        materiais = ParserImportacaoAlvaro.getMateriais(XMLUtil.getElementosFilhos(element));
                        continue;
                    }
                    if (element.getNodeName().equalsIgnoreCase("exames")) {
                        examesNovos = ParserImportacaoAlvaro.getExames(XMLUtil.getElementosFilhos(element), materiais);
                        continue;
                    }
                    if (!element.getNodeName().equalsIgnoreCase("exame")) continue;
                    List<ExameAlvaro> examesAlvaro = ExameAlvaro.getExames(element, materiais);
                    for (Solicitacao s : solicitacoes) {
                        Iterator<SolicitacaoExame> iterator = s.exames.iterator();
                        if (!iterator.hasNext()) continue;
                        SolicitacaoExame se = iterator.next();
                        boolean achouExame = examesAlvaro.stream().anyMatch(f -> f.getCodigo().equalsIgnoreCase(se.exame));
                        if (!achouExame) break;
                        for (ExameAlvaro exaAlvaro : examesAlvaro) {
                            if (!se.exame.equalsIgnoreCase(exaAlvaro.getCodigo())) continue;
                            exaAlvaro.setMaterial(se.material);
                        }
                    }
                    examesNovos.addAll(examesAlvaro);
                }
            }
        } else {
            try {
                List<List<Object>> examesPlan = Excel.ler(xml, 0, 6);
                List<List<Object>> materiaisPlan = Excel.ler(xml, 2, new Integer[0]);
                List<List<Object>> camposResultado = Excel.ler(xml, 1, new Integer[0]);
                List<List<Object>> dadosObrigatorios = Excel.ler(xml, 3, new Integer[0]);
                examesNovos = ParserImportacaoAlvaro.getExames(examesPlan, materiaisPlan, camposResultado, dadosObrigatorios);
            }
            catch (IOException e) {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        Statement st = Conexao.getStatement();
        if (st != null && !examesNovos.isEmpty()) {
            try {
                ExameAlvaro exAntigo;
                Map<String, ExameAlvaro> examesAntigosRelac = ParserImportacaoAlvaro.examesMap(ParserImportacaoAlvaro.getExamesRelacionados(codigoLabExterno));
                Set<ExameAlvaro> examesAntigos = ParserImportacaoAlvaro.loadExamesAlvaro(st, codigoLabExterno);
                Map<String, ExameAlvaro> dadosAdicionais = ParserImportacaoAlvaro.getDadosAdicionais(examesAntigos);
                if (arquivoResultado) {
                    for (Object ex22 : examesNovos) {
                        if (!Funcoes.isNumeric(((ExameAlvaro)ex22).getMaterial()) && examesAntigos.contains(ex22)) {
                            for (ExameAlvaro exAnt : examesAntigos) {
                                if (!exAnt.equals(ex22)) continue;
                                ((ExameAlvaro)ex22).setMaterial(exAnt.getMaterial());
                            }
                        }
                        IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 1, ((ExameAlvaro)ex22).getCodigo(), ((ExameAlvaro)ex22).getMaterial());
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    ParserImportacaoAlvaro.atualizaDadosAdicionais(examesNovos, dadosAdicionais);
                    ParserImportacaoAlvaro.inserirExamesAlvaro(examesNovos, st, codigoLabExterno, progress);
                    HashSet<Object> hashSet = new HashSet<Object>(examesNovos);
                    hashSet.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(hashSet.size() * 2);
                        progress.setValue(0);
                    }
                    for (Object ex : hashSet) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        if ((exAntigo = examesAntigosRelac.get(((ExameAlvaro)ex).getCodigo())) == null) {
                            examesNaoEncontrados.add(ex);
                            continue;
                        }
                        ((ExameAlvaro)ex).setExameJalis(exAntigo.getExameJalis());
                        ((ExameAlvaro)ex).setMaterialJalis(exAntigo.getMaterialJalis());
                        if (!(!Funcoes.textoVazio(((ExameAlvaro)ex).getMaterial()) && Funcoes.isNumeric(((ExameAlvaro)ex).getMaterial()) || Funcoes.textoVazio(exAntigo.getMaterial()))) {
                            ((ExameAlvaro)ex).setMaterial(exAntigo.getMaterial());
                        }
                        if (Funcoes.textoVazio(((ExameAlvaro)ex).getMaterialDescricao()) && !Funcoes.textoVazio(exAntigo.getMaterialDescricao())) {
                            ((ExameAlvaro)ex).setMaterialDescricao(exAntigo.getMaterialDescricao());
                        }
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((ExameAlvaro)ex).getExameJalis(), Integer.parseInt(((ExameAlvaro)ex).getMaterialJalis()), ((ExameAlvaro)ex).getXml());
                    }
                } else {
                    IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 1, new Object[0]);
                    for (Object ex : examesNovos) {
                        if (!examesAntigos.contains(ex)) continue;
                        for (Map.Entry<String, ExameAlvaro> newList : examesAntigosRelac.entrySet()) {
                            if (!newList.getValue().getCodigo().equals(((ExameAlvaro)ex).getCodigo()) || !newList.getValue().getMaterial().equals(((ExameAlvaro)ex).getMaterial())) continue;
                            ((ExameAlvaro)ex).setFormatoPDF(newList.getValue().isFormatoPDF());
                        }
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    ParserImportacaoAlvaro.atualizaDadosAdicionais(examesNovos, dadosAdicionais);
                    ParserImportacaoAlvaro.inserirExamesAlvaro(examesNovos, st, codigoLabExterno, progress);
                    for (Object ex : examesNovos) {
                        ExameAlvaro exAntigo2 = examesAntigosRelac.get(((ExameAlvaro)ex).getCodigo());
                        if (exAntigo2 == null) continue;
                        ((ExameAlvaro)ex).setExameJalis(exAntigo2.getExameJalis());
                        ((ExameAlvaro)ex).setMaterialJalis(exAntigo2.getMaterialJalis());
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((ExameAlvaro)ex).getExameJalis(), Integer.parseInt(((ExameAlvaro)ex).getMaterialJalis()), ((ExameAlvaro)ex).getXml());
                    }
                    HashSet<ExameAlvaro> hashSet = new HashSet<ExameAlvaro>(examesAntigosRelac.values());
                    hashSet.retainAll(examesNovos);
                    if (progress != null) {
                        progress.setMaximum(hashSet.size());
                        progress.setValue(0);
                    }
                    for (Object ex : hashSet) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        if ((exAntigo = examesAntigosRelac.get(((ExameAlvaro)ex).getCodigo())) != null) continue;
                        examesNaoEncontrados.add(ex);
                    }
                    examesExcluidos.addAll(examesAntigos);
                    examesExcluidos.removeAll(examesNovos);
                    HashSet<ExameAlvaro> examesExcluidosRel = new HashSet<ExameAlvaro>(examesAntigosRelac.values());
                    examesExcluidosRel.removeAll(examesNovos);
                    for (ExameAlvaro ex3 : examesExcluidosRel) {
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex3.getExameJalis(), Integer.parseInt(ex3.getMaterialJalis()), null);
                    }
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImportaExames: 135");
            }
        }
        mapExames.put(EXAMES_NAO_ENCONTRADOS, examesNaoEncontrados);
        mapExames.put(EXAMES_EXCLUIDOS, examesExcluidos);
        return mapExames;
    }

    private static HashSet<ExameAlvaro> getExames(List<List<Object>> examesPlan, List<List<Object>> materiaisPlan, List<List<Object>> camposResultado, List<List<Object>> dadosObrigatorios) {
        examesPlan.remove(0);
        materiaisPlan.remove(0);
        camposResultado.remove(0);
        dadosObrigatorios.remove(0);
        HashSet<ExameAlvaro> exames = new HashSet<ExameAlvaro>();
        for (List<Object> e : examesPlan) {
            ExameAlvaro exa = new ExameAlvaro();
            exa.setCodigo(e.get(0).toString());
            exa.setDescricao(e.get(1).toString());
            if (e.get(6) != null) {
                exa.setDataAlteracao(Funcoes.formataData("dd/MM/yyyy k:m", (Date)e.get(6)));
            }
            String codigoMaterial = ParserImportacaoAlvaro.getXlsCodigo(e, 3);
            exa.setMaterial(codigoMaterial);
            String materialDescricao = ParserImportacaoAlvaro.getMateriailDescricao(materiaisPlan, e.get(3).toString());
            exa.setMaterialDescricao(materialDescricao);
            ParserImportacaoAlvaro.getMateriailDescricao(materiaisPlan, e.get(3).toString());
            List<DadoAdicional> dadosAdicionais = ParserImportacaoAlvaro.getDadosAdicionais(e, dadosObrigatorios);
            exa.setDadosAdicionais(dadosAdicionais);
            ArrayList<LinhaResultado> linhasResultado = ParserImportacaoAlvaro.getLinhasResultado(e, camposResultado);
            exa.setLinhasResultado(linhasResultado);
            exames.add(exa);
        }
        return exames;
    }

    private static String getXlsCodigo(List<Object> e, int pos) {
        String codigo = e.get(pos).toString();
        if (codigo.indexOf(".") > 0) {
            codigo = codigo.substring(0, codigo.indexOf("."));
        }
        return codigo;
    }

    private static ArrayList<LinhaResultado> getLinhasResultado(List<Object> e, List<List<Object>> camposResultado) {
        ArrayList<LinhaResultado> linhas = new ArrayList<LinhaResultado>();
        for (List<Object> campos : camposResultado) {
            if (!e.get(0).toString().equalsIgnoreCase(campos.get(0).toString())) continue;
            LinhaResultado linhaResultado = new LinhaResultado();
            linhaResultado.setCodigo(ParserImportacaoAlvaro.getXlsCodigo(campos, 2));
            linhaResultado.setDescricao(campos.get(3).toString());
            linhas.add(linhaResultado);
        }
        return linhas;
    }

    private static List<DadoAdicional> getDadosAdicionais(List<Object> e, List<List<Object>> dadosObrigatorios) {
        ArrayList<DadoAdicional> dadosAdicionais = new ArrayList<DadoAdicional>();
        for (List<Object> dadoObrigatorio : dadosObrigatorios) {
            if (!dadoObrigatorio.get(0).toString().equalsIgnoreCase(e.get(0).toString())) continue;
            DadoAdicional dadoAdicional = new DadoAdicional();
            dadoAdicional.setDescricao(dadoObrigatorio.get(1).toString());
            dadoAdicional.setUnidade(dadoObrigatorio.get(2).toString());
            dadosAdicionais.add(dadoAdicional);
        }
        return dadosAdicionais;
    }

    private static String getMateriailDescricao(List<List<Object>> materiaisPlan, String matCodigo) {
        for (List<Object> e : materiaisPlan) {
            if (!e.get(0).toString().equals(matCodigo)) continue;
            return e.get(1).toString();
        }
        return "";
    }

    private static void atualizaDadosAdicionais(HashSet<ExameAlvaro> examesNovos, Map<String, ExameAlvaro> dadosAdicionais) {
        for (ExameAlvaro exameNew : examesNovos) {
            if (exameNew.getDadosAdicionais() != null && !exameNew.getDadosAdicionais().isEmpty() || !dadosAdicionais.containsKey(exameNew.getCodigo())) continue;
            exameNew.setDadosAdicionais(dadosAdicionais.get(exameNew.getCodigo()).getDadosAdicionais());
        }
    }

    private static Map<String, ExameAlvaro> getDadosAdicionais(Set<ExameAlvaro> examesAntigos) {
        Map<String, ExameAlvaro> dadosAdicionais = ParserImportacaoAlvaro.examesMap(examesAntigos);
        ArrayList<String> list = new ArrayList<String>();
        for (ExameAlvaro exameAlvaro : examesAntigos) {
            if (exameAlvaro.getDadosAdicionais() != null && !exameAlvaro.getDadosAdicionais().isEmpty()) continue;
            list.add(exameAlvaro.getCodigo());
        }
        for (String key : list) {
            dadosAdicionais.remove(key);
        }
        return dadosAdicionais;
    }

    private static Map<String, ExameAlvaro> examesMap(Collection<ExameAlvaro> exames) {
        HashMap<String, ExameAlvaro> examesMap = new HashMap<String, ExameAlvaro>();
        for (ExameAlvaro ex : exames) {
            examesMap.put(ex.getCodigo(), ex);
        }
        return examesMap;
    }

    private static boolean mesmaVersao(ExameAlvaro exaOld, ExameAlvaro exaNew) {
        try {
            Date dataAlteracao;
            if (Funcoes.textoVazio(exaOld.getDataAlteracao()) || Funcoes.textoVazio(exaNew.getDataAlteracao())) {
                return false;
            }
            Date dataExame = Funcoes.stringToDate("dd/MM/yyyy HH:mm:ss", exaOld.getDataAlteracao());
            return dataExame.compareTo(dataAlteracao = Funcoes.stringToDate("dd/MM/yyyy HH:mm:ss", exaNew.getDataAlteracao())) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean mesmaVersaoEstrutura(ExameAlvaro exaOld, ExameAlvaro exaNew) {
        try {
            if (exaOld.getLinhasResultado() != null && exaNew.getLinhasResultado() != null || exaOld.getLinhasResultado().size() != exaNew.getLinhasResultado().size()) {
                for (LinhaResultado lOld : exaOld.getLinhasResultado()) {
                    boolean aux = false;
                    for (LinhaResultado lNew : exaNew.getLinhasResultado()) {
                        if (!lOld.getCodigo().equalsIgnoreCase(lNew.getCodigo()) || !lOld.getDescricao().equalsIgnoreCase(lNew.getDescricao())) continue;
                        aux = true;
                        break;
                    }
                    if (aux) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Hashtable<String, String> getMateriais(List<Element> elements) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (Element e : elements) {
            hash.put(e.getAttribute("codigo"), e.getAttribute("descricao"));
        }
        return hash;
    }

    private static HashSet<ExameAlvaro> getExames(List<Element> elements, Hashtable<String, String> materiais) throws Exception {
        HashSet<ExameAlvaro> exames = new HashSet<ExameAlvaro>();
        for (Element e : elements) {
            exames.addAll(ExameAlvaro.getExames(e, materiais));
        }
        return exames;
    }

    private static Set<ExameAlvaro> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno).append(" and \n");
                bui.append("  a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameAlvaro.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameAlvaro>();
    }

    private static void inserirExamesAlvaro(Set<ExameAlvaro> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws SalvaDadosException, SQLException {
        for (ExameAlvaro ep : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            if (Funcoes.textoVazio(ep.getCodigo()) || Funcoes.textoVazio(ep.getMaterial())) continue;
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 1, ep.getCodigo(), ep.getMaterial(), ep.getDescricao(), StringUtil.textoDB(ep.getMaterialDescricao() != null ? ep.getMaterialDescricao() : ""), ep.getXml().replace("'", ""));
        }
    }

    public static ArrayList<ExameAlvaro> importarDadosAdicionais(File fileDadosAdicionais, int codigoLabExterno, JProgressBar progress, boolean padraoAlvaro) {
        try {
            Map<String, List<DadoAdicional>> dadosAdicionais = ParserImportacaoAlvaro.loadDadosAdicionais(fileDadosAdicionais, padraoAlvaro);
            HashMap dadosNaoImportados = new HashMap();
            Statement st = Conexao.getStatement();
            if (dadosAdicionais.size() > 0) {
                Set<ExameAlvaro> examesAlvaro = ParserImportacaoAlvaro.loadExamesAlvaro(st, codigoLabExterno);
                Set<ExameAlvaro> examesRelacionados = ParserImportacaoAlvaro.getExamesRelacionados(codigoLabExterno);
                ArrayList<ExameAlvaro> examesAtualizados = new ArrayList<ExameAlvaro>();
                ArrayList<ExameAlvaro> examesAtualizar = new ArrayList<ExameAlvaro>();
                if (progress != null) {
                    progress.setMaximum(examesAlvaro.size() * 2);
                    progress.setValue(0);
                }
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 1, new Object[0]);
                for (ExameAlvaro exAlvaro : examesAlvaro) {
                    progress.setValue(progress.getValue() + 1);
                    List<DadoAdicional> listDados = dadosAdicionais.get(exAlvaro.getCodigo().trim());
                    if (listDados == null) continue;
                    examesAtualizar.add(exAlvaro);
                    exAlvaro.setDadosAdicionais(listDados);
                }
                for (ExameAlvaro a : examesAtualizar) {
                    for (ExameAlvaro ea : examesRelacionados) {
                        if (!ea.equals(a)) continue;
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ea.getExameJalis(), Integer.parseInt(ea.getMaterialJalis()), a.getXml());
                    }
                    examesAtualizados.add(a);
                }
                ParserImportacaoAlvaro.inserirExamesAlvaro(examesAlvaro, st, codigoLabExterno, progress);
                Conexao.arquivaSQL();
                return examesAtualizados;
            }
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e2) {
                e.printStackTrace();
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoAlvaro: 303");
            return null;
        }
        catch (SalvaDadosException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoAlvaro");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, List<DadoAdicional>> loadDadosAdicionais(File file, boolean padraoAlvaro) {
        HashMap<String, List<DadoAdicional>> dadosAdicionais = new HashMap<String, List<DadoAdicional>>();
        String dados = null;
        try {
            dados = file.getAbsolutePath().contains(".csv") ? StringUtil.lerArquivoTexto(file) : StringUtil.lerArquivoXls(file, true);
        }
        catch (Exception e) {
            Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel ler o arquivo de dados adicionais", 1);
        }
        String[] linhas = dados.split("\n");
        if (linhas.length > 0) {
            String[] cabec = linhas[0].replaceAll("[\"]", "").split(";");
            if (file.getAbsolutePath().contains(".csv")) {
                if (!ParserImportacaoAlvaro.validaTamanhoLinha(cabec, 3)) return dadosAdicionais;
                if (!(cabec[0].equalsIgnoreCase("exame") || cabec[1].equalsIgnoreCase("dado") || cabec[2].equalsIgnoreCase("unidade"))) {
                    return dadosAdicionais;
                }
            } else {
                if (!ParserImportacaoAlvaro.validaTamanhoLinha(cabec, 4)) return dadosAdicionais;
                if (!(cabec[0].equalsIgnoreCase("Exame") || cabec[1].equalsIgnoreCase("DadoObrigatorio") || cabec[2].equalsIgnoreCase("DadoObrigatorioAOL2") || cabec[3].equalsIgnoreCase("Unidade"))) {
                    return dadosAdicionais;
                }
            }
        }
        for (String s : linhas) {
            String descricao;
            DadoAdicional dado;
            String codigo;
            String[] linha = s.split(";");
            if (ParserImportacaoAlvaro.validaTamanhoLinha(linha, 3)) {
                codigo = StringUtil.removeCaractere(linha[0], '\"');
                if (Funcoes.textoVazio(codigo)) continue;
                if (dadosAdicionais.get(codigo) == null) {
                    dadosAdicionais.put(codigo, new ArrayList());
                }
                dado = new DadoAdicional();
                descricao = StringUtil.removeCaractere(linha[linha.length - 2], '\"');
                descricao = descricao.trim();
                dado.setDescricao(descricao);
                dado.setUnidade(StringUtil.removeCaractere(linha[linha.length - 1], '\"'));
                ((List)dadosAdicionais.get(codigo)).add(dado);
                continue;
            }
            if (!ParserImportacaoAlvaro.validaTamanhoLinha(linha, 4) || Funcoes.textoVazio(codigo = StringUtil.removeCaractere(linha[0], '\"'))) continue;
            if (dadosAdicionais.get(codigo) == null) {
                dadosAdicionais.put(codigo, new ArrayList());
            }
            dado = new DadoAdicional();
            descricao = StringUtil.removeCaractere(linha[linha.length - 3], '\"');
            descricao = descricao.trim();
            dado.setDescricao(descricao);
            dado.setUnidade(StringUtil.removeCaractere(linha[linha.length - 1], '\"'));
            dado.setDadoObrigatorioAOL2(StringUtil.removeCaractere(linha[linha.length - 2], '\"'));
            ((List)dadosAdicionais.get(codigo)).add(dado);
        }
        return dadosAdicionais;
    }

    private static boolean validaTamanhoLinha(String[] linha, int i) {
        return linha.length == i;
    }

    private static Set<ExameAlvaro> loadExamesAlvaro(Statement st, int codigoLabExterno) throws SQLException {
        HashSet<ExameAlvaro> exames = new HashSet<ExameAlvaro>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, lae_codigo, alv_codexame, alv_codmaterial, alv_descricaoexame, alv_descricaomaterial, alv_xml ");
        sql.append(" from examesalvaro ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ExameAlvaro e = new ExameAlvaro(rs.getString("alv_xml"));
            e.setCodigo(rs.getString("alv_codexame"));
            e.setDescricao(rs.getString("alv_descricaoexame"));
            e.setMaterial(rs.getString("alv_codmaterial"));
            e.setMaterialDescricao(rs.getString("alv_descricaomaterial"));
            exames.add(e);
        }
        return exames;
    }
}

