/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro;

import br.com.thread.pdfbox.util.Charsets;
import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.alvaro.AmostraAlvaro;
import jalis.laboratorio.util.parsers.alvaro.Antibiograma;
import jalis.laboratorio.util.parsers.alvaro.CampoResultadoAlvaro;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.ExameResultadoAlvaro;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultadoAlvaro;
import jalis.laboratorio.util.parsers.alvaro.PacienteAlvaro;
import jalis.laboratorio.util.parsers.alvaro.RequisicaoAlvaro;
import jalis.laboratorio.util.parsers.alvaro.ResponsavelTecnico;
import jalis.laboratorio.util.parsers.alvaro.resultado.InformaPeriodoImportacaoAlvaro;
import jalis.model.vo.consultas.ConfiguracaoExameAlvaroVO;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.service.util.parsers.alvaro.ImportacaoResultadoAlvaroService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImportacaoResultadoAlvaro
extends AbstractImportadorResultadoLabExterno {
    private static String VERSAO = "20060809";
    private static final String FORMATO = "formato";
    private static final String FORMATACAO = "formatacao";
    private static final String CODIGO_LAYOUT = "codigo-layout";
    private static final String CABECALHO = "cabecalho";
    private static final String FORMATO_TEXTO = "formatotexto";
    private static final String VERSAO_EXAME = "versaoExameLabExterno";
    private LaboratorioExterno labExterno = null;
    private ArrayList<PacienteAlvaro> pacientes = new ArrayList();
    protected ArrayList<RequisicaoAlvaro> requisicoes = new ArrayList();
    private HashMap<String, String> requisicoesNotificar = new HashMap();
    private Map<String, ResponsavelTecnico> responsaveisTecnicos = new HashMap<String, ResponsavelTecnico>();
    private Map<String, ExameAlvaro> examesCadastro = new HashMap<String, ExameAlvaro>();
    private List<ConfiguracaoExameAlvaroVO> examesComLote;
    private List<ConfiguracaoExameAlvaroVO> examesImportarPDF;
    private int qtdeExamesImportados;
    public LoteExternoExameRequisicaoService loteExternoExameRequisicaoService = new LoteExternoExameRequisicaoService();
    protected JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    protected JButton buttonImportarWS = ComponenteFactory.novoJButton("Importar Webservice", 'W', this);
    protected ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private final ImportacaoResultadoAlvaroService service;
    protected boolean adicionarEnterNaTagResultado = false;
    private boolean conferirAutomatico = false;
    private boolean enviarUsandoWS = false;
    private String codigoUsuarioConferenciaAutomatica = null;
    protected Protocolo protocolo = Protocolo.Alvaro;
    public int codigoLabExterno;
    private List<String> examesRequisicaoImportadosPDF;
    private HashMap<String, List<String>> requisicoesImportadas;
    private List<String> examesRequisicaoImportadosTexto;
    private Map<String, Map<String, Map<String, String>>> historicosExame = null;
    private Map<String, Map<String, Map<String, String>>> historicosExameFilial = null;

    public ImportacaoResultadoAlvaro(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio Alvaro a partir de arquivo XML", codigoLabExterno, Protocolo.Alvaro, new JPanel(new FlowLayout(2)));
        this.service = new ImportacaoResultadoAlvaroService();
        this.codigoLabExterno = codigoLabExterno;
        this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
        this.historicosExame = null;
        this.historicosExameFilial = null;
        this.jbInit(codigoLabExterno);
    }

    public ImportacaoResultadoAlvaro(int codigoLabExterno, String titulo, String descricao, Protocolo protocolo) {
        super(titulo, descricao, codigoLabExterno, protocolo, new JPanel(new FlowLayout(2)));
        this.codigoLabExterno = codigoLabExterno;
        this.protocolo = protocolo;
        this.service = new ImportacaoResultadoAlvaroService();
        this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
        this.historicosExame = null;
        this.historicosExameFilial = null;
        this.jbInit(codigoLabExterno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jbInit(int codigoLabExterno) {
        Statement st;
        block6: {
            this.getPanelAdicional().add(this.buttonImprimir);
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (rs.next()) {
                    if (!DBUtil.campoNull(rs.getString("lae_configuracao")) && StringUtil.getValor(rs.getString("lae_configuracao"), "processarEnter").trim().length() > 0) {
                        this.adicionarEnterNaTagResultado = StringUtil.getBoolean(rs.getString("lae_configuracao"), "processarEnter");
                    }
                    this.enviarUsandoWS = StringUtil.getBoolean(rs.getString("lae_configuracao"), "enviarLoteWebService");
                    this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                    this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
                    this.service.setConferirAutomatico(this.conferirAutomatico);
                    this.service.setCodigoUsuarioConferenciaAutomatica(this.codigoUsuarioConferenciaAutomatica);
                }
                if (!this.enviarUsandoWS) break block6;
                this.getPanelAdicional().add(this.buttonImportarWS);
                this.getPanelAdicional().remove(this.buttonImportar);
                this.buttonImportar.setText("Importar Arquivo");
                this.getPanelAdicional().add(this.buttonImportar);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro (128)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    protected void importarResultadoWs() {
        String urlResultados = StringUtil.getValor(this.labExterno.configuracao, "enderecoResultado");
        if (Funcoes.textoVazio(urlResultados)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Web Service Resultado n\u00e3o configurado no Laborat\u00f3rio Externo.", 2);
            return;
        }
        InformaPeriodoImportacaoAlvaro periodoImportacao = InformaPeriodoImportacaoAlvaro.novaInstancia(this.getTopLevelAncestor(), this.codigoLabExterno);
        periodoImportacao.setVisible(true);
        if (periodoImportacao.isOk()) {
            this.setTextoInformacoes("Aguarde... Consultando resultados\n");
            try {
                this.examesComLote = new ArrayList<ConfiguracaoExameAlvaroVO>();
                this.examesImportarPDF = new ArrayList<ConfiguracaoExameAlvaroVO>();
                this.qtdeExamesImportados = 0;
                boolean todosEmpdf = Boolean.valueOf(StringUtil.getValor(this.labExterno.configuracao, "importarResultadoPdf"));
                this.examesComLote = this.service.getExamesPorPeriodo(periodoImportacao, todosEmpdf);
                if (this.examesComLote.isEmpty()) {
                    this.setTextoInformacoes("N\u00e3o h\u00e1 resultados para serem importados\n", false);
                    return;
                }
                this.examesImportarPDF = this.examesComLote.stream().filter(exame -> exame.isResultadoEmPDF()).collect(Collectors.toList());
                String mensagem = periodoImportacao.filtroRequisicaoSelecionado() ? "\nSolicitando resultados da Requisi\u00e7\u00e3o: " + periodoImportacao.getFiltroRequisicao() + "\n" : "\nSolicitando os resultados do Per\u00edodo informado...\n";
                this.setTextoInformacoes(mensagem, false);
                List<File> resultadosImportados = this.getResultadosImportados(this.labExterno, periodoImportacao.isSolicitarValorReferencia());
                this.iniciarBarraDeProgresso(this.qtdeExamesImportados);
                for (File arquivoSalvo : resultadosImportados) {
                    this.processarResultados(arquivoSalvo, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setTextoInformacoes("\nImporta\u00e7\u00e3o Finalizada!", false);
            this.progress.setVisible(false);
        }
    }

    private void iniciarBarraDeProgresso(int totalBarraProgresso) {
        this.progress.setValue(0);
        this.progress.setMaximum(totalBarraProgresso);
        this.progress.setVisible(true);
    }

    private List<File> getResultadosImportados(LaboratorioExterno lab, boolean solicitarValorReferencia) throws Exception {
        List idsAlvaro = this.examesComLote.stream().map(exame -> exame.getCodReqApoio()).distinct().collect(Collectors.toList());
        ArrayList<File> resultadosImportados = new ArrayList<File>();
        for (String idAlvaro : idsAlvaro) {
            String xml;
            byte[] resultado = this.service.solicitarResultadoAlvaro(lab, idAlvaro, false, "", solicitarValorReferencia);
            if (resultado.length <= 0 || !(xml = new String(resultado, Charsets.UTF_8)).startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) continue;
            String[] contExamesXML = xml.split("<exame codigo=");
            this.qtdeExamesImportados += contExamesXML.length / 2;
            File arquivoSalvo = this.service.salvarArquivoResultado(xml, lab);
            resultadosImportados.add(arquivoSalvo);
        }
        return resultadosImportados;
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        this.setTextoInformacoes("");
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. " + this.protocolo.getCodigo() + " (*.xml)", "xml"));
        if (chooser.showOpenDialog(this) == 0) {
            try {
                String novoArquivo = this.service.adicionarEnterNatagResultado(this.adicionarEnterNaTagResultado, chooser);
                if (!Funcoes.textoVazio(novoArquivo)) {
                    StringUtil.escreverArquivoTexto(chooser.getSelectedFile().getPath(), novoArquivo);
                    this.processarResultados(chooser.getSelectedFile(), false);
                }
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel importar os resultados.\nMensagem: " + e.getMessage(), 1);
            }
        }
    }

    @Override
    public void run() {
        if (this.isWebService) {
            this.importarResultadoWs();
        } else {
            this.importarResultado();
        }
        this.isWebService = false;
        this.habilitarBotoes(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    private boolean possuiExameRepetido(String filial, String requisicao, String codExame) {
        boolean retorno = false;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) as resultado from loteexternoexamerequisicaodesm l where fil_codigo = ");
        sql.append(filial);
        sql.append(" and req_codigo = ");
        sql.append(requisicao);
        sql.append(" and exa_kodigo = '");
        sql.append(codExame).append("'");
        Statement st = Conexao.getStatement();
        boolean contador = false;
        try {
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            if (rs.next()) {
                return rs.getInt("resultado") > 1;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processarResultados(File arquivo, boolean importacaoWS) {
        Statement st2;
        Statement st;
        block19: {
            Document doc = this.analisarXML(arquivo);
            if (doc == null) {
                this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo: " + arquivo.getPath());
                return;
            }
            Element raiz = doc.getDocumentElement();
            this.parse(XMLUtil.getElementosFilhos(raiz));
            if (this.requisicoes == null || this.requisicoes.isEmpty()) {
                this.setTextoInformacoes("O arquivo informado n\u00e3o possui requisi\u00e7\u00f5es a serem importadas!");
                return;
            }
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            if (st == null) {
                return;
            }
            if (!importacaoWS) {
                this.iniciarBarraDeProgresso((int)this.requisicoes.stream().map(requisicao -> requisicao.exames).flatMap(a -> a.stream()).count());
            }
            LinkedList<Object> listaRegistros = new LinkedList();
            try {
                for (RequisicaoAlvaro reqAlvaro : this.requisicoes) {
                    this.examesRequisicaoImportadosPDF = new ArrayList<String>();
                    this.examesRequisicaoImportadosTexto = new ArrayList<String>();
                    this.requisicoesImportadas = new HashMap();
                    for (ExameResultadoAlvaro exResultado : reqAlvaro.exames) {
                        this.progress.setValue(this.progress.getValue() + 1);
                        String filCodigo = reqAlvaro.codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String reqCodigo = reqAlvaro.codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial());
                        if (Funcoes.textoVazio(reqCodigo)) {
                            this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: C\u00f3digo incorreto da requisi\u00e7\u00e3o Jalis. C\u00f3digo do \u00c1lvaro: %s", reqAlvaro.codigoAlvaro), false);
                            continue;
                        }
                        String exaCodigo = exResultado.codigoJalis;
                        String matCodigo = exResultado.materialJalis;
                        Integer[] multiguias = this.verificarRequisicaoMultiguia(filCodigo, reqCodigo);
                        String situacaoExame = this.service.pesquisarSituacaoExame(filCodigo, this.labExterno.codigoLab, multiguias, exaCodigo, matCodigo);
                        if (!Funcoes.textoVazio(situacaoExame) && !situacaoExame.equals("P")) {
                            String descricaoSituacao = Tipos.tipoSituacaoExame(situacaoExame);
                            this.setTextoInformacoes(String.format("\nExame %s (%s, %s) %s", exaCodigo, filCodigo, reqCodigo, descricaoSituacao), false);
                            continue;
                        }
                        if (exResultado.temTableNaReferencia()) {
                            this.setTextoInformacoes(String.format("\nExame %s (%s, %s), n\u00e3o ser\u00e1 importado (configura\u00e7\u00e3o HTML no valor de refer\u00eancia)", exaCodigo, filCodigo, reqCodigo), false);
                            continue;
                        }
                        if (this.importouResultadoEmPDF(reqAlvaro, exResultado, importacaoWS) || this.examesRequisicaoImportadosPDF.contains(exResultado.codigoJalis)) continue;
                        listaRegistros = this.processarPaiFilhos(st, reqAlvaro, exResultado, filCodigo, reqCodigo);
                        if (listaRegistros == null || listaRegistros.size() == 0) {
                            this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis Fil.: %s Req.: %s. C\u00f3digo %s:%s ", filCodigo, reqCodigo, this.protocolo.getDescricao(), reqAlvaro.codigoAlvaro), false);
                            this.adicionarAoModeloRelatorio(reqAlvaro.codigoJalis, exResultado.codigoJalis, exResultado.materialJalis, Situacao.NAO_LOCALIZADO);
                            continue;
                        }
                        this.requisicoesImportadas.put(reqCodigo, new ArrayList());
                        for (Registro registro : listaRegistros) {
                            this.salvarResultadoImportado(st, registro, reqAlvaro, exResultado, filCodigo, reqCodigo);
                            ArrayList<String> multiguiasRepetidasTemp = this.validaExameMultiguiaRepetido(multiguias, registro);
                            if (multiguiasRepetidasTemp.isEmpty()) continue;
                            for (String multiguiaRepetida : multiguiasRepetidasTemp) {
                                if (!this.requisicoesImportadas.containsKey(multiguiaRepetida)) {
                                    this.requisicoesImportadas.put(multiguiaRepetida, new ArrayList());
                                }
                                this.salvarResultadoImportado(st, registro, reqAlvaro, exResultado, filCodigo, multiguiaRepetida);
                            }
                        }
                    }
                }
                ResultadosUtil.enviarNotificacoes(this.requisicoesNotificar, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
                Conexao.arquivaSQL();
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
                if (importacaoWS) break block19;
                this.progress.setVisible(false);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 69");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    this.requisicoes = new ArrayList();
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
                this.requisicoes = new ArrayList();
            }
        }
        Conexao.fecharStatement(st, st2);
        this.requisicoes = new ArrayList();
    }

    private void salvarResultadoImportado(Statement st, Registro reg, RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado, String filCodigo, String reqCodigo) throws Exception {
        Registro formatacao;
        String codExame;
        String string = codExame = Funcoes.textoVazio(reg.getString("examePai")) ? reg.getString("exa_codigo") : reg.getString("exa_codigo") + "-" + reg.getString("examePai");
        if (!this.validaSituacaoExame(reg, reqCodigo, codExame, reqAlvaro, exResultado)) {
            return;
        }
        if (reg.getValor("examePai") != null) {
            reg.setValor("exa_codigo", reg.getString("examePai"));
        }
        Registro registro = formatacao = reg.getString("exr_situacao").equals("P") ? (Registro)reg.getValor(FORMATACAO) : this.localizarFormatacao(reg);
        if (!this.validaFormatacaoResultado(reg, formatacao)) {
            return;
        }
        ExameAlvaro exAlvaroSalvo = new ExameAlvaro(reg.getString("ele_xmllabexterno"));
        ExameAlvaro exAlvaroNovo = this.examesCadastro.get(exResultado.codigo);
        Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
        String resultadoAtual = "";
        this.adicionaTempoResultado(reg, reqAlvaro, exResultado, exAlvaroSalvo, dados, resultadoAtual);
        if (!exResultado.antibiograma.isEmpty()) {
            this.adicionaAntibiograma(reg, exResultado, dados, exAlvaroSalvo);
        }
        if (!Funcoes.textoVazio(exResultado.grafico)) {
            this.adicionaGrafico(reg, exResultado, dados);
        }
        if (reg.getValor("examePai") != null) {
            this.adicionaDadosExamePai(reg, reqAlvaro, exResultado, exAlvaroSalvo, exAlvaroNovo, dados);
        } else {
            this.adicionaDadosExame(reqAlvaro, exResultado, exAlvaroSalvo, exAlvaroNovo, dados);
        }
        Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(filCodigo, reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
        dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
        Map<String, Map<String, String>> historicos = this.getHistoricoExame(reg);
        Resultado res = this.getResultadoAtualizado(formatacao, dados, resAnterior, historicos);
        if (!res.verificarCondicao()) {
            this.adicionarAoModeloRelatorio(reqAlvaro.codigoJalis, exResultado.codigoJalis, exResultado.materialJalis, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
            return;
        }
        boolean completo = this.isResultadoCompleto(reg, res);
        String novaSituacao = completo ? "L" : "P";
        String resultado = completo ? res.getResultado() : res.getResultadoParcial();
        Util.gravaAlteracaoExameRequisicao(st, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
        boolean marcarConferido = this.isMarcarConferido(reg, reqAlvaro, exResultado, res, completo);
        if (marcarConferido) {
            novaSituacao = completo ? "C" : "P";
        }
        this.finalizarImportacaoExame(reg, res, reqAlvaro, novaSituacao, resultado, formatacao, exResultado);
    }

    private Map<String, Map<String, String>> getHistoricoExame(Registro reg) {
        Map<String, Map<String, String>> historicos = this.getHistoricosPorExame(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
        if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
            historicos = this.getHistoricosPorFilial(reg.getString("fil_codigo"));
        }
        return historicos;
    }

    private boolean isResultadoCompleto(Registro reg, Resultado res) {
        boolean completo = true;
        if (reg.getBoolean("exa_salvaparcial")) {
            completo = res.resultadoCompleto(true);
        }
        if (!completo && reg.getBoolean("exa_salvaparcial")) {
            completo = res.resultadoCompleto(false);
        }
        return completo;
    }

    private void finalizarImportacaoExame(Registro reg, Resultado res, RequisicaoAlvaro reqAlvaro, String novaSituacao, String resultado, Registro formatacao, ExameResultadoAlvaro exResultado) throws Exception {
        boolean validacaoResultadoCritico;
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        boolean completo = this.isResultadoCompleto(reg, res);
        boolean marcarConferido = this.isMarcarConferido(reg, reqAlvaro, exResultado, res, completo);
        boolean bl = validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
        if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), reqAlvaro.codigoAlvaro)) {
            this.inserirDadosRequisicao(st, this.codigoLabExterno, reqAlvaro.codigoAlvaro, reg.getString("fil_codigo"), reg.getInt("req_codigo"));
        }
        boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
        this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
        if (this.exportarBaseWeb(reg.getString("fil_codigo"))) {
            this.exportarResultado(st, st2, reg, reg.getString("fil_codigo"), formatacao, novaSituacao, resultado);
        }
        this.adicionarAoModeloRelatorio(reqAlvaro.codigoJalis, exResultado.codigoJalis, exResultado.materialJalis, this.getSituacaoExame(marcarConferido, completo));
        if (completo) {
            this.atualizarDataHoraColeta(st, reg, res);
        }
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), this.getCodigoBaseWeb(reg.getString("fil_codigo")));
        this.editarRequisicaoExportaFiliais(reg);
        this.atualizarSituacaoExameInterfaceamento(st, reg);
        this.confirmarRecebimentoResultado(reg, reg.getString("req_codigo"), completo, marcarConferido);
    }

    private Situacao getSituacaoExame(boolean marcarConferido, boolean completo) {
        return completo ? this.isExameConferido(marcarConferido) : Situacao.LANCADO_PARCIALMENTE;
    }

    private boolean isMarcarConferido(Registro reg, RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado, Resultado res, boolean completo) {
        boolean marcarConferido = false;
        if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
            int verificacao = res.verificarValidacao();
            boolean bl = marcarConferido = verificacao == 1;
            if (!marcarConferido && verificacao != 2) {
                this.adicionarAoModeloRelatorio(reqAlvaro.codigoJalis, exResultado.codigoJalis, exResultado.materialJalis, Situacao.VALIDACAO_INSATISFEITA);
                this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
            }
        }
        return marcarConferido;
    }

    private void confirmarRecebimentoResultado(Registro reg, String reqCodigo, boolean completo, boolean marcarConferido) {
        this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)this.getSituacaoExame(marcarConferido, completo)), false);
        this.examesRequisicaoImportadosTexto.add(reg.getString("exa_codigo"));
        this.requisicoesImportadas.put(reqCodigo, this.examesRequisicaoImportadosTexto);
        this.requisicoesNotificar.put(Funcoes.getChaveFilReq(String.valueOf(reg.getString("fil_codigo")), reqCodigo), reqCodigo);
    }

    private void atualizarDataHoraColeta(Statement st, Registro reg, Resultado res) throws ParseException, SQLException {
        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
        Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
        this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
    }

    private void exportarResultado(Statement st, Statement st2, Registro reg, String filCodigo, Registro formatacao, String novaSituacao, String resultado) throws Exception {
        Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, filCodigo, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
        this.exportarParaWeb(st, this.getCodigoBaseWeb(filCodigo), novaSituacao, reg, mapa, resultado, formatacao.getString(FORMATO));
        if (ExportaWeb.isGerarPdfResultado(st2, filCodigo)) {
            ExportaWeb.enviarResultadoPDF(st2, filCodigo, reg.getString("req_codigo"), this.getCodigoBaseWeb(filCodigo));
        }
    }

    private void adicionaGrafico(Registro reg, ExameResultadoAlvaro exResultado, Map<String, Object> dados) {
        if (reg.getValor("examePai") != null) {
            String chave = "grafico@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, this.getGrafico(exResultado.grafico));
        } else {
            dados.put("grafico", this.getGrafico(exResultado.grafico));
        }
    }

    private void adicionaAntibiograma(Registro reg, ExameResultadoAlvaro exResultado, Map<String, Object> dados, ExameAlvaro exameAlvSalvo) {
        String antibioticoCaracteres = !Funcoes.textoVazio(exameAlvSalvo.getAntibiograma().getAntibiotico()) ? exameAlvSalvo.getAntibiograma().getAntibiotico() : "35";
        String resistenciaCaracteres = !Funcoes.textoVazio(exameAlvSalvo.getAntibiograma().getResistencia()) ? exameAlvSalvo.getAntibiograma().getResistencia() : "15";
        String micCaracteres = !Funcoes.textoVazio(exameAlvSalvo.getAntibiograma().getMic()) ? exameAlvSalvo.getAntibiograma().getMic() : "9";
        StringBuilder antibiogramaFormatado = new StringBuilder();
        String format = "%1$-" + StringUtil.removeZerosEsquerda(antibioticoCaracteres) + "s%2$-" + StringUtil.removeZerosEsquerda(resistenciaCaracteres) + "s%3$" + StringUtil.removeZerosEsquerda(micCaracteres) + "s\r\n";
        for (Antibiograma anti : exResultado.antibiograma) {
            antibiogramaFormatado.append(String.format(format, anti.getAntibiotico(), anti.getResistencia(), anti.getMic()));
        }
        if (reg.getValor("examePai") != null) {
            String chave = "antibiogramas@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, antibiogramaFormatado.toString());
        } else {
            dados.put("antibiogramas", antibiogramaFormatado.toString());
        }
    }

    private boolean validaFormatacaoResultado(Registro reg, Registro formatacao) {
        if (formatacao == null) {
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Formata\u00e7\u00e3o n\u00e3o encontrada", false);
            return false;
        }
        return true;
    }

    private void adicionaTempoResultado(Registro reg, RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado, ExameAlvaro exAlvaroSalvo, Map<String, Object> dados, String resultadoAtual) {
        for (LinhaResultadoAlvaro linha : exResultado.linhasResultado) {
            LinhaResultado linhaEstrutura = exAlvaroSalvo.getLinha(linha.codigo);
            if (linhaEstrutura != null && !linhaEstrutura.getTempos().isEmpty()) {
                this.adicionaTempoMuitasLinhas(reg, reqAlvaro, exResultado, dados, linha, linhaEstrutura);
            } else if (!linha.codigoAmostra.equals("0") && reqAlvaro.amostras.get(linha.codigoAmostra) != null && reqAlvaro.amostras.get((Object)linha.codigoAmostra).descricao.equals("basal")) {
                resultadoAtual = this.adicionaTempoBasal(reg, exResultado, dados, resultadoAtual, linha);
                this.adicionaValorExameDesmembrado(reg, dados, linha);
            } else {
                resultadoAtual = this.adicionaTempo(reg, exResultado, dados, resultadoAtual, linha);
                this.adicionaValorExameDesmembrado(reg, dados, linha);
            }
            for (CampoResultadoAlvaro campo : linha.camposCompl) {
                dados.put(linha.codigo + "_" + campo.codigo, campo.resultado);
            }
        }
    }

    private void adicionaTempoMuitasLinhas(Registro reg, RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado, Map<String, Object> dados, LinhaResultadoAlvaro linha, LinhaResultado linhaEstrutura) {
        Iterator<String> iterator = linhaEstrutura.getTempos().iterator();
        while (iterator.hasNext()) {
            String tempo;
            String descricao = tempo = iterator.next();
            AmostraAlvaro amostra = reqAlvaro.amostras.get(linha.codigoAmostra);
            if (amostra == null || !descricao.equals(amostra.descricao)) continue;
            dados.put(linha.codigo + "_tempo_" + tempo, linha.resultado);
            if (this.validaLinhasResultado(exResultado)) {
                dados.put("unidade_" + linha.codigo + "_tempo_" + tempo, linha.unidade);
            } else {
                dados.put("unidade_tempo_" + tempo, linha.unidade);
            }
            this.adicionaValorExameDesmembrado(reg, dados, linha);
            break;
        }
    }

    private String adicionaTempo(Registro reg, ExameResultadoAlvaro exResultado, Map<String, Object> dados, String resultadoAtual, LinhaResultadoAlvaro linha) {
        if (linha.codigoAmostra.equals("0")) {
            dados.put(linha.codigo + "_tempo_" + linha.codigoAmostra, linha.resultado);
        }
        dados.put(linha.codigo, linha.resultado);
        if (this.validaLinhasResultado(exResultado)) {
            dados.put("unidade_" + linha.codigo, linha.unidade);
        } else {
            dados.put("unidade", linha.unidade);
        }
        return this.getXmlResultadoAtual(reg, resultadoAtual, linha);
    }

    private String adicionaTempoBasal(Registro reg, ExameResultadoAlvaro exResultado, Map<String, Object> dados, String resultadoAtual, LinhaResultadoAlvaro linha) {
        dados.put(linha.codigo + "_tempo_0", linha.resultado);
        dados.put(linha.codigo + "_tempo_basal", linha.resultado);
        dados.put(linha.codigo, linha.resultado);
        if (this.validaLinhasResultado(exResultado)) {
            dados.put("unidade_" + linha.codigo, linha.unidade);
        } else {
            dados.put("unidade", linha.unidade);
        }
        return this.getXmlResultadoAtual(reg, resultadoAtual, linha);
    }

    private Situacao isExameConferido(boolean marcarConferido) {
        return marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO;
    }

    private Resultado getResultadoAtualizado(Registro formatacao, Map<String, Object> dados, Map<Integer, String> resAnterior, Map<String, Map<String, String>> historicos) {
        Resultado res = new Resultado(formatacao.getString(FORMATO), dados);
        res.atualizarComponentes();
        res = new Resultado(null, formatacao.getString(FORMATO), dados, null, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
        res.atualizarComponentes();
        return res;
    }

    private boolean validaSituacaoExame(Registro reg, String reqCodigo, String codExame, RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado) throws SQLException {
        if (reg == null || this.requisicoesImportadas.get(reqCodigo).contains(codExame) || this.examesRequisicaoImportadosPDF.contains(reqCodigo)) {
            return false;
        }
        if (this.exameLancado(reg)) {
            this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do %s: %s exame %s %s - requisi\u00e7\u00e3o %s", this.protocolo.getDescricao(), reqAlvaro.codigoAlvaro, exResultado.codigo, Situacao.JA_LANCADO.descricao, reg.getInt("req_codigo")), false);
            this.adicionarAoModeloRelatorio(reqAlvaro.codigoJalis, exResultado.codigoJalis, exResultado.materialJalis, Situacao.JA_LANCADO);
            return false;
        }
        if (!this.exameColetado(reg) && !reg.getString("exr_situacao").equals("P")) {
            this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do %s: %s exame %s %s", this.protocolo.getDescricao(), reqAlvaro.codigoAlvaro, exResultado.codigo, Situacao.SEM_MATERIAL.descricao), false);
            this.adicionarAoModeloRelatorio(reqAlvaro.codigoJalis, exResultado.codigoJalis, exResultado.materialJalis, Situacao.SEM_MATERIAL);
            return false;
        }
        if (!this.exameRelacionado(reg)) {
            this.adicionarAoModeloRelatorio(reqAlvaro.codigoJalis, exResultado.codigoJalis, exResultado.materialJalis, Situacao.SEM_RELACIONAMENTO);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento", false);
            return false;
        }
        return true;
    }

    private void adicionaDadosExamePai(Registro reg, RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado, ExameAlvaro exAlvaroSalvo, ExameAlvaro exAlvaroNovo, Map<String, Object> dados) {
        String chave = "codigo@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, reqAlvaro.codigoAlvaro);
        chave = "codigo_aol@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, reqAlvaro.codigoAOL);
        chave = "observacao@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exResultado.observacao);
        chave = "metodologia@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exResultado.metodo);
        chave = "data_rst@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exResultado.dataResultado);
        chave = "CNES@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, reqAlvaro.cnes);
        chave = "desc_exame@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exAlvaroSalvo.getDescricao());
        chave = "cod_exame_alv@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exAlvaroSalvo.getCodigo());
        chave = "data_alt@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exAlvaroSalvo.getDataAlteracao());
        chave = "valor_ref@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        if (!Funcoes.textoVazio(exResultado.valorReferencia)) {
            dados.put(chave, exResultado.valorReferencia);
        } else {
            dados.put(chave, exAlvaroNovo != null && exAlvaroNovo.getValorReferencia() != null && !exAlvaroNovo.getValorReferencia().equals(exAlvaroSalvo.getValorReferencia()) ? exAlvaroNovo.getValorReferencia() : exAlvaroSalvo.getValorReferencia());
        }
        chave = "cod_mat_alv@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exAlvaroSalvo.getMaterial());
        chave = "assinatura_tecnico_responsavel@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exResultado.assinaturaResponsavelTecnico);
        chave = "nome_tecnico_responsavel@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exResultado.nomeResponsavelTecnico);
        chave = "codigo_tecnico_responsavel@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
        dados.put(chave, exResultado.documentoResponsavelTecnico);
        for (LinhaResultadoAlvaro linhaRes : exResultado.linhasResultado) {
            chave = "metodologia_" + linhaRes.codigo + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linhaRes.metodo);
            chave = "valorRef_" + linhaRes.codigo + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linhaRes.valorReferencia);
            chave = "unidade_" + linhaRes.codigo + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linhaRes.unidade);
        }
    }

    private void adicionaDadosExame(RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado, ExameAlvaro exAlvaroSalvo, ExameAlvaro exAlvaroNovo, Map<String, Object> dados) {
        dados.put("codigo", reqAlvaro.codigoAlvaro);
        dados.put("codigo_aol", reqAlvaro.codigoAOL);
        dados.put("observacao", exResultado.observacao);
        dados.put("metodologia", exResultado.metodo);
        dados.put("data_rst", exResultado.dataResultado);
        dados.put("CNES", reqAlvaro.cnes);
        dados.put("desc_exame", exAlvaroSalvo.getDescricao());
        dados.put("cod_exame_alv", exAlvaroSalvo.getCodigo());
        dados.put("data_alt", exAlvaroSalvo.getDataAlteracao());
        this.atribuiAssinaturaExame(exResultado, dados);
        for (LinhaResultadoAlvaro linhaRes : exResultado.linhasResultado) {
            dados.put("metodologia_" + linhaRes.codigo, linhaRes.metodo);
            dados.put("valorRef_" + linhaRes.codigo, linhaRes.valorReferencia);
        }
        if (!Funcoes.textoVazio(exResultado.valorReferencia)) {
            dados.put("valor_ref", exResultado.valorReferencia);
        } else {
            dados.put("valor_ref", exAlvaroNovo != null && exAlvaroNovo.getValorReferencia() != null && !exAlvaroNovo.getValorReferencia().equals(exAlvaroSalvo.getValorReferencia()) ? exAlvaroNovo.getValorReferencia() : exAlvaroSalvo.getValorReferencia());
        }
        dados.put("cod_mat_alv", exAlvaroSalvo.getMaterial());
    }

    private void atribuiAssinaturaExame(ExameResultadoAlvaro exResultado, Map<String, Object> dados) {
        dados.put("assinatura_tecnico_responsavel@" + exResultado.codigoJalis + "#" + exResultado.materialJalis, exResultado.assinaturaResponsavelTecnico);
        dados.put("nome_tecnico_responsavel@" + exResultado.codigoJalis + "#" + exResultado.materialJalis, exResultado.nomeResponsavelTecnico);
        dados.put("codigo_tecnico_responsavel@" + exResultado.codigoJalis + "#" + exResultado.materialJalis, exResultado.documentoResponsavelTecnico);
        dados.put("assinatura_tecnico_responsavel", exResultado.assinaturaResponsavelTecnico);
        dados.put("nome_tecnico_responsavel", exResultado.nomeResponsavelTecnico);
        dados.put("codigo_tecnico_responsavel", exResultado.documentoResponsavelTecnico);
    }

    private Integer[] verificarRequisicaoMultiguia(String codFilial, String codRequisicao) throws SQLException {
        Integer[] multiguias = null;
        multiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true) : new Integer[]{Integer.parseInt(codRequisicao)};
        return multiguias;
    }

    /*
     * WARNING - void declaration
     */
    private boolean importouResultadoEmPDF(RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado, boolean importacaoWS) throws Exception {
        boolean importouPDF = false;
        if (importacaoWS && null != this.examesImportarPDF && !this.examesImportarPDF.isEmpty() && this.importaEmPDF(reqAlvaro, exResultado)) {
            Situacao situacaoExamePDF = this.conferenciaAutomatica() ? Situacao.CONFERIDO : Situacao.LANCADO;
            List<String> situacoes = this.getSituacoesExamePronto();
            List<Object> examesDesmPDF = new ArrayList();
            Integer codFilial = Integer.valueOf(reqAlvaro.codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial()));
            Integer codRequisicao = Integer.valueOf(reqAlvaro.codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial()));
            String codExame = exResultado.codigoJalis;
            String codMaterial = exResultado.materialJalis;
            boolean exameDesm = false;
            Integer requisicao = codRequisicao;
            examesDesmPDF = this.examesImportarPDF.stream().filter(e -> !Funcoes.textoVazio(e.getCodExameDesm()) && !situacoes.contains(e.getSituacaoExame())).collect(Collectors.toList());
            for (ConfiguracaoExameAlvaroVO configuracaoExameAlvaroVO : examesDesmPDF) {
                Integer[] multiguiasArray = RecepcaoUtil.verificaMultiGuias(String.valueOf(codFilial), String.valueOf(codRequisicao), true);
                if (this.isAgruparMultiguias(String.valueOf(codFilial), multiguiasArray) && this.validaRequisicaoMultiguia(codFilial, codRequisicao, configuracaoExameAlvaroVO)) {
                    requisicao = configuracaoExameAlvaroVO.getCodRequisicao();
                }
                if (!configuracaoExameAlvaroVO.getCodFilial().equals(codFilial) || !configuracaoExameAlvaroVO.getCodRequisicao().equals(requisicao) || !configuracaoExameAlvaroVO.getCodExameDesm().equals(codExame) || !configuracaoExameAlvaroVO.getCodMaterialDesm().equals(codMaterial)) continue;
                exameDesm = true;
                break;
            }
            if (!examesDesmPDF.isEmpty() && exameDesm) {
                HashMap<String, Integer> examesDesmPDfComResultado = this.service.contarExamesDesmembradosComResultado(examesDesmPDF);
                Object var15_16 = null;
                for (Map.Entry<String, Integer> desmPDF : examesDesmPDfComResultado.entrySet()) {
                    Integer contadorConferidos = desmPDF.getValue();
                    String codFilReq = desmPDF.getKey().split("\\|")[0];
                    Integer codFil = Integer.valueOf(codFilReq.substring(0, ParametrosGerais.getDigitosTuboFilial()));
                    Integer codReq = Integer.valueOf(codFilReq.substring(ParametrosGerais.getDigitosTuboFilial()));
                    String codExamePai = desmPDF.getKey().split("\\|")[1];
                    String codMaterialPai = desmPDF.getKey().split("\\|")[2];
                    if (codFilial.equals(codFil) && requisicao.equals(codReq) && !this.examesRequisicaoImportadosPDF.contains(codExamePai)) {
                        void var15_17;
                        for (ConfiguracaoExameAlvaroVO configuracaoExameAlvaroVO : examesDesmPDF) {
                            byte[] resultado;
                            if (!this.validaFilialRequisicao(codFilial, requisicao, codExamePai, codMaterialPai, configuracaoExameAlvaroVO) || (resultado = this.service.solicitarResultadoAlvaro(this.labExterno, configuracaoExameAlvaroVO.getCodReqApoio(), true, configuracaoExameAlvaroVO.getCodExmApoio(), false)).length <= 0) continue;
                            byte[] byArray = ResultadosUtil.concatenarPdfs((byte[])var15_17, resultado, "Resultado");
                            Integer n = contadorConferidos;
                            Integer n2 = contadorConferidos = Integer.valueOf(contadorConferidos - 1);
                        }
                        if (!ResultadosUtil.verificaIntegridadePDFImportado((byte[])var15_17) || contadorConferidos != 0 || !this.service.resultadoSalvoEmPDF(codFil, codReq, codExamePai, codMaterialPai, (byte[])var15_17)) continue;
                        this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato PDF - %s", Funcoes.preencheZero(codFil, ParametrosGerais.getDigitosTuboFilial()), Funcoes.preencheZero(codReq, ParametrosGerais.getDigitosTuboRequisicao()), codExamePai, situacaoExamePDF.descricao), false);
                        this.adicionarAoModeloRelatorio(codFilReq, codExamePai, codMaterialPai, situacaoExamePDF);
                        this.examesRequisicaoImportadosPDF.add(codExamePai);
                        importouPDF = true;
                        continue;
                    }
                    if (!this.examesRequisicaoImportadosPDF.contains(codExamePai)) continue;
                    importouPDF = true;
                }
            }
            if (!this.examesRequisicaoImportadosPDF.contains(codExame)) {
                importouPDF = this.importaResultadoExameSimples(importouPDF, situacaoExamePDF, codFilial, codRequisicao, codExame, codMaterial, false);
            }
        }
        return importouPDF;
    }

    private boolean importaResultadoExameSimples(boolean importouPDF, Situacao situacaoExamePDF, Integer codFilial, Integer codRequisicao, String codExame, String codMaterial, boolean solicitarValorReferencia) throws SQLException, Exception {
        for (ConfiguracaoExameAlvaroVO exame : this.examesImportarPDF) {
            byte[] resultado;
            if (!this.examesImportarPDF.stream().anyMatch(e -> e.getCodExame().equals(codExame))) break;
            if (!this.validaFilialRequisicao(codFilial, codRequisicao, codExame, codMaterial, exame) || !ResultadosUtil.verificaIntegridadePDFImportado(resultado = this.service.solicitarResultadoAlvaro(this.labExterno, exame.getCodReqApoio(), true, exame.getCodExmApoio(), solicitarValorReferencia))) continue;
            Integer[] multiguiasArray = RecepcaoUtil.verificaMultiGuias(String.valueOf(codFilial), String.valueOf(codRequisicao), true);
            if (this.isAgruparMultiguias(String.valueOf(codFilial), multiguiasArray)) {
                codRequisicao = exame.getCodRequisicao();
            }
            if (!this.service.resultadoSalvoEmPDF(codFilial, codRequisicao, codExame, codMaterial, resultado)) continue;
            this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato PDF - %s", Funcoes.preencheZero(codFilial, ParametrosGerais.getDigitosTuboFilial()), Funcoes.preencheZero(codRequisicao, ParametrosGerais.getDigitosTuboRequisicao()), codExame, situacaoExamePDF.descricao), false);
            this.adicionarAoModeloRelatorio(String.valueOf(codFilial), codExame, codMaterial, situacaoExamePDF);
            importouPDF = true;
            this.examesRequisicaoImportadosPDF.add(codExame);
            this.requisicoesNotificar.put(Funcoes.getChaveFilReq(String.valueOf(codFilial), String.valueOf(codRequisicao)), String.valueOf(codRequisicao));
            break;
        }
        return importouPDF;
    }

    private boolean validaFilialRequisicao(Integer codFilial, Integer codRequisicao, String codExamePai, String codMaterialPai, ConfiguracaoExameAlvaroVO exame) throws SQLException {
        return this.validaRequisicaoMultiguia(codFilial, codRequisicao, exame) && exame.getCodExame().equals(codExamePai) && exame.getCodMaterial().equals(codMaterialPai);
    }

    private boolean importaEmPDF(RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado) throws SQLException {
        Integer codFilial = Integer.valueOf(reqAlvaro.codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial()));
        Integer codRequisicao = Integer.valueOf(reqAlvaro.codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial()));
        for (ConfiguracaoExameAlvaroVO exame : this.examesImportarPDF) {
            String codMaterial;
            String codExame = Funcoes.textoVazio(exame.getCodExameDesm()) ? exame.getCodExame() : exame.getCodExameDesm();
            String string = codMaterial = Funcoes.textoVazio(exame.getCodMaterialDesm()) ? exame.getCodMaterial() : exame.getCodMaterialDesm();
            if (!this.validaRequisicaoMultiguia(codFilial, codRequisicao, exame) || !exResultado.codigoJalis.equals(codExame) || !exResultado.materialJalis.equals(codMaterial)) continue;
            return true;
        }
        return false;
    }

    private boolean validaRequisicaoMultiguia(Integer codFilial, Integer codRequisicao, ConfiguracaoExameAlvaroVO exame) throws SQLException {
        Integer[] multiguiasArray = RecepcaoUtil.verificaMultiGuias(String.valueOf(codFilial), String.valueOf(codRequisicao), true);
        if (this.isAgruparMultiguias(String.valueOf(codFilial), multiguiasArray)) {
            List<Integer> multiguias = Arrays.asList(multiguiasArray);
            return multiguias.stream().anyMatch(e -> codFilial.equals(exame.getCodFilial()) && e.equals(exame.getCodRequisicao()));
        }
        return codFilial.equals(exame.getCodFilial()) && codRequisicao.equals(exame.getCodRequisicao());
    }

    private boolean isAgruparMultiguias(String codigoFilial, Integer[] multiguias) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), codigoFilial, multiguias);
    }

    private List<String> getSituacoesExamePronto() {
        ArrayList<String> situacoes = new ArrayList<String>();
        situacoes.add("L");
        situacoes.add("C");
        situacoes.add("I");
        situacoes.add("E");
        situacoes.add("O");
        return situacoes;
    }

    private boolean validaLinhasResultado(ExameResultadoAlvaro exResultado) {
        return exResultado.linhasResultado.size() > 1;
    }

    private String getXmlResultadoAtual(Registro reg, String resultadoAtual, LinhaResultadoAlvaro linha) {
        String tag = reg.getValor("exameFilho") == null ? reg.getValor("exa_codigo").toString() : reg.getValor("exameFilho").toString();
        tag = tag.toLowerCase();
        resultadoAtual = resultadoAtual + "<" + tag + ">";
        resultadoAtual = resultadoAtual + linha.resultado;
        resultadoAtual = resultadoAtual + "</" + tag + ">";
        return resultadoAtual;
    }

    private void adicionaValorExameDesmembrado(Registro reg, Map<String, Object> dados, LinhaResultadoAlvaro linha) {
        if (reg.getValor("examePai") != null) {
            String chave = linha.codigo.trim() + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linha.resultado);
            chave = "unidade".trim() + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linha.unidade);
        }
    }

    private LinkedList<Registro> processarPaiFilhos(Statement st, RequisicaoAlvaro reqAlvaro, ExameResultadoAlvaro exResultado, String fil_codigo, String req_codigo) throws Exception {
        ArrayList<Registro> reqLote;
        boolean agruparMultiguia;
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
        boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias;
        if (!agruparMultiguia) {
            multiguias = new Integer[]{Integer.parseInt(req_codigo)};
        }
        if (!(reqLote = ImportacaoResultadoAlvaro.verificaRequisicoesComLote(null, multiguias, fil_codigo)).isEmpty()) {
            for (Integer multiguia : multiguias) {
                ExameDesmembrado pai;
                String codigoJalisAux = reqAlvaro.codigoJalis;
                reqAlvaro.codigoJalis = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                Registro exameSeparado = this.localizaExameRequisicao(reqAlvaro, exResultado, st);
                if (exameSeparado != null) {
                    retorno.add(exameSeparado);
                }
                if (this.existePai(pai = this.getExamesDesmembrados(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exResultado.codigoJalis, exResultado.materialJalis))) {
                    String codigoJalisTemp = exResultado.codigoJalis;
                    exResultado.codigoJalis = pai.getCodigoExame();
                    Registro reg = this.localizaExameRequisicao(reqAlvaro, exResultado, st);
                    if (reg != null) {
                        reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                        reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                        reg.setValor("examePai", pai.getCodigoExame());
                        reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
                        exResultado.codigoJalis = codigoJalisTemp;
                        retorno.add(reg);
                    }
                }
                reqAlvaro.codigoJalis = codigoJalisAux;
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Registro> verificaRequisicoesComLote(List<Registro> listaRequisicoes, Integer[] multiguias, String filial) {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct lot.leq_retornows as retornoWs, lot.lex_codigo ");
        buf.append("  from loteexternorequisicao lot ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
        buf.append("   and lot.leq_dataestorno is null ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                lista.add(new Registro(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return lista;
    }

    private String getGrafico(String pontos) {
        LinkedList<String[]> coordenadas = new LinkedList<String[]>();
        Double pontoMaisAlto = 0.0;
        for (String hex : pontos.split(";")) {
            Double ponto = this.ponto(hex.substring(1));
            if (ponto > pontoMaisAlto) {
                pontoMaisAlto = ponto;
            }
            coordenadas.add(new String[]{hex.substring(0, 1), String.valueOf(ponto)});
        }
        Image i = Toolkit.getDefaultToolkit().createImage(this.criarImagem(coordenadas, pontoMaisAlto).getSource());
        String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(i));
        return foto64;
    }

    private Double ponto(String ponto) {
        Double ret = 0.0;
        String hex = "0123456789ABCDEF";
        int x = ponto.length();
        for (int i = 0; i < ponto.length(); ++i) {
            int pos = hex.indexOf(String.valueOf(ponto.charAt(i)));
            pos = pos == -1 ? 0 : pos;
            Double d = Math.pow(Double.parseDouble("16"), Double.parseDouble(String.valueOf(x)));
            ret = ret + (double)pos * d;
            --x;
        }
        return ret / 100.0;
    }

    private BufferedImage criarImagem(List<String[]> coordenadas, double pontoMaisAlto) {
        BufferedImage b = new BufferedImage(640, 480, 1);
        Graphics2D g = b.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 640, 480);
        g.setColor(Color.BLACK);
        int px1 = 0;
        int py1 = 480;
        int max = coordenadas.size();
        int pos = 0;
        for (String[] coordenada : coordenadas) {
            int px2 = Math.round(pos * 640 / max);
            int py2 = (int)(480L - Math.round(Double.parseDouble(coordenada[1]) * 480.0 / pontoMaisAlto) - 1L);
            g.drawLine(px1, py1, px2, py2);
            if (coordenada[0].equals("B")) {
                g.drawLine(px1, 480, px2 - 1, py2);
            }
            px1 = px2 + 1;
            py1 = py2;
            ++pos;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameAlvaro getExameAlvaro(String codigoFilial, String codigoExameAlvaro) {
        Statement st;
        block4: {
            ExameAlvaro exameAlvaro;
            st = Conexao.getStatement();
            try {
                String sql = "select alv_xml from examesalvaro where fil_codigo = " + codigoFilial + " and alv_codexame = '" + codigoExameAlvaro + "'";
                ResultSet rs = st.executeQuery(sql);
                if (!rs.next()) break block4;
                exameAlvaro = new ExameAlvaro(rs.getString("alv_xml"));
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 237");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return exameAlvaro;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizaVersaoLayoutExame(Registro reg, ExameResultadoAlvaro exame) {
        Statement st = Conexao.getStatement();
        try {
            ExameAlvaro exaAlvaro = new ExameAlvaro(reg.getString("ele_xmllabexterno"));
            exaAlvaro.setDataAlteracao(exame.dataAlteracao);
            String exa = StringUtil.getValor(reg.getString("ele_xmllabexterno"), "codigo");
            String mco = StringUtil.getValor(reg.getString("ele_xmllabexterno"), "material");
            StringBuilder bui = new StringBuilder("");
            bui.append("update examematcoletalabexterno set \n");
            bui.append("  ele_xmllabexterno = '").append(exaAlvaro.getXml()).append("' \n");
            bui.append("where \n");
            bui.append("  fil_codigo = ").append(reg.getString("fil_codigo")).append(" and \n");
            bui.append("  exa_codigo = '").append(exa).append("' and \n");
            bui.append("  mco_codigo = ").append(mco).append(" and \n");
            bui.append("  lae_codigo = ").append(this.codigoLabExterno).append(" \n");
            Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
            exaAlvaro = null;
            exaAlvaro = new ExameAlvaro(reg.getString("alv_xml"));
            exaAlvaro.setDataAlteracao(exame.dataAlteracao);
            bui.setLength(0);
            bui.append("update examesalvaro set alv_xml = '").append(exaAlvaro.getXml()).append("' ");
            bui.append(" where fil_codigo = ").append(reg.getString("fil_codigo"));
            bui.append(" and lae_codigo = ").append(this.codigoLabExterno);
            bui.append(" and alv_codexame = '").append(exa).append("'");
            bui.append(" and alv_codmaterial = '").append(mco).append("' ");
            Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 268");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    protected void parse(List<Element> elements) {
        for (Element e : elements) {
            if (e.getNodeName().equalsIgnoreCase("resultados")) {
                if (e.getAttribute("versao").equalsIgnoreCase(VERSAO)) continue;
                this.setTextoInformacoes("O arquivo selecionado n\u00e3o \u00e9 um XML de resultado v\u00e1lido");
                return;
            }
            if (e.getNodeName().equalsIgnoreCase("exame")) {
                this.parseExameCadastro(e);
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("pacientes")) {
                this.parsePacientes(XMLUtil.getElementosFilhos(e));
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("responsaveisTecnicosAssinatura")) {
                this.parseResponsaveisTecnicos(XMLUtil.getElementosFilhos(e));
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("solicitacao")) {
                this.parseSolicitacao(e);
                continue;
            }
            if (!e.hasChildNodes()) continue;
            this.parse(XMLUtil.getElementosFilhos(e));
        }
    }

    private void parseResponsaveisTecnicos(List<Element> elements) {
        for (Element e : elements) {
            ResponsavelTecnico responsavel = new ResponsavelTecnico();
            responsavel.setConselho(e.getAttribute("codigo"));
            if (!Funcoes.textoVazio(e.getTextContent())) {
                responsavel.setAssinaturaBase64(e.getTextContent().trim());
            }
            this.responsaveisTecnicos.put(responsavel.getConselho(), responsavel);
        }
    }

    private void parseExameCadastro(Element element) {
        ExameAlvaro exame = new ExameAlvaro();
        String codigoExame = element.getAttribute("codigo");
        exame.setCodigo(codigoExame);
        exame.setDescricao(element.getAttribute("descricao"));
        exame.setDataAlteracao(element.getAttribute("dataalteracao"));
        List<Element> list = XMLUtil.getElementosFilhos(element);
        for (Element e : list) {
            if (e.getNodeName().equalsIgnoreCase("linhasresultado")) {
                for (Element l : XMLUtil.getElementosFilhos(e)) {
                    LinhaResultado linha = new LinhaResultado();
                    linha.setCodigo(l.getAttribute("codigo"));
                    linha.setDescricao(l.getAttribute("descricao"));
                    linha.setUnidade(l.getAttribute("unidade"));
                    exame.getLinhasResultado().add(linha);
                }
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("valorreferencia")) {
                if (Funcoes.textoVazio(e.getTextContent())) continue;
                exame.setValorReferencia(e.getTextContent().trim());
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("antibiograma")) continue;
            Antibiograma anti = new Antibiograma();
            anti.setAntibiotico(e.getAttribute("antibiotico"));
            anti.setResistencia(e.getAttribute("resistencia"));
            anti.setMic(e.getAttribute("mic"));
            exame.setAntibiograma(anti);
        }
        this.examesCadastro.put(codigoExame, exame);
    }

    private void parsePacientes(List<Element> elements) {
        for (Element e : elements) {
            PacienteAlvaro paciente = new PacienteAlvaro();
            paciente.codigoAlvaro = e.getAttribute("codigo");
            paciente.codigoJalis = e.getAttribute("codigo_lis");
            paciente.codigoAOL = e.getAttribute("codigo_aol");
            paciente.dataNascimento = e.getAttribute("datanasc");
            paciente.nome = e.getAttribute("nome");
            paciente.sexo = e.getAttribute("sexo");
            this.pacientes.add(paciente);
        }
    }

    private void parseSolicitacao(Element element) {
        RequisicaoAlvaro requisicao = new RequisicaoAlvaro();
        requisicao.codigoAlvaro = element.getAttribute("codigo");
        requisicao.codigoJalis = element.getAttribute("codigo_lis");
        requisicao.codigoAOL = element.getAttribute("codigo_aol");
        requisicao.paciente = this.locatePaciente(element.getAttribute("paciente"));
        if (!Funcoes.isNumeric(requisicao.codigoJalis) || !this.validaCodigoRequisicao(requisicao.codigoJalis)) {
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: C\u00f3digo incorreto da requisi\u00e7\u00e3o Jalis. " + requisicao.codigoJalis + " C\u00f3digo no \u00c1lvaro: " + requisicao.codigoAlvaro, false);
            return;
        }
        HashMap<String, String> examesJalis = this.localizaExameJalis(requisicao, element.getAttribute("paciente"));
        List<Element> list = XMLUtil.getElementosFilhos(element);
        requisicao.exames = new ArrayList();
        for (Element e : list) {
            if (e.getNodeName().equalsIgnoreCase("amostras")) {
                this.parseAmostras(XMLUtil.getElementosFilhos(e), requisicao);
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("exame")) {
                this.parseExameResultado(e, requisicao, examesJalis);
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("local-CNES") || Funcoes.textoVazio(e.getTextContent())) continue;
            requisicao.cnes = this.trocaCaracteres(e.getTextContent());
        }
        this.requisicoes.add(requisicao);
    }

    private boolean validaCodigoRequisicao(String codigoRequisicao) {
        return !Funcoes.textoVazio(codigoRequisicao) && codigoRequisicao.matches("[0-9]+");
    }

    private ResponsavelTecnico getResponsavelTecnico(String nome, String documento) {
        ResponsavelTecnico responsavelTecnico;
        if (!(this.responsaveisTecnicos == null || this.responsaveisTecnicos.isEmpty() || Funcoes.textoVazio(nome) || Funcoes.textoVazio(documento) || (responsavelTecnico = this.responsaveisTecnicos.get(documento)) == null)) {
            responsavelTecnico.setNome(nome);
            return responsavelTecnico;
        }
        return null;
    }

    private void parseExameResultado(Element e, RequisicaoAlvaro requisicao, HashMap<String, String> examesJalis) {
        String codigoExame = e.getAttribute("codigo");
        if (!this.examesCadastro.containsKey(codigoExame)) {
            return;
        }
        ExameAlvaro exameCadastro = this.examesCadastro.get(codigoExame);
        ExameResultadoAlvaro exame = new ExameResultadoAlvaro();
        exame.codigo = codigoExame;
        exame.dataResultado = e.getAttribute("dataresultado");
        ResponsavelTecnico respTec = this.getResponsavelTecnico(e.getAttribute("responsaveltecnico"), e.getAttribute("responsaveltecnicodocumento"));
        if (respTec != null) {
            exame.assinaturaResponsavelTecnico = respTec.getAssinaturaBase64();
            exame.nomeResponsavelTecnico = respTec.getNome();
            exame.documentoResponsavelTecnico = respTec.getConselho();
        }
        if (!Funcoes.textoVazio(e.getAttribute("metodo"))) {
            exame.metodo = this.removeCaracteresMetodo(e.getAttribute("metodo"));
        }
        exame.normal = e.getAttribute("normal");
        exame.dataAlteracao = exameCadastro.getDataAlteracao();
        exame.descricao = exameCadastro.getDescricao();
        StringBuilder observacao = new StringBuilder();
        if (!Funcoes.textoVazio(e.getAttribute("observacao"))) {
            observacao.append(this.trocaCaracteres(e.getAttribute("observacao") + "\n"));
        }
        List<Element> elements = XMLUtil.getElementosFilhos(e);
        String grafico = null;
        for (Element ele : elements) {
            if (ele.getNodeName().equals("valorreferencia") && !Funcoes.textoVazio(ele.getTextContent())) {
                exame.valorReferencia = this.trocaCaracteres(ele.getTextContent());
            } else if (ele.getNodeName().equals("resultado")) {
                String string;
                int index;
                LinhaResultadoAlvaro linha = new LinhaResultadoAlvaro();
                linha.codigo = ele.getAttribute("linharesultado");
                linha.codigoAmostra = ele.getAttribute("amostra");
                linha.resultado = this.trocaCaracteres(ele.getAttribute("resultado"));
                linha.metodo = ele.getAttribute("metodo");
                for (LinhaResultado b : exameCadastro.getLinhasResultado()) {
                    if (!linha.codigo.equalsIgnoreCase(b.getCodigo())) continue;
                    linha.unidade = b.getUnidade();
                    break;
                }
                if (!Funcoes.textoVazio(ele.getAttribute("observacao"))) {
                    observacao.append(this.trocaCaracteres(ele.getAttribute("observacao") + "\n"));
                }
                if ((index = (string = ele.getAttribute("id_lis")).indexOf("|")) > 0) {
                    exame.codigoJalis = string.substring(0, string.indexOf("|"));
                    exame.materialJalis = string.substring(string.indexOf("|") + 1);
                } else if (examesJalis.containsKey(exame.codigo)) {
                    String string2 = examesJalis.get(exame.codigo);
                    exame.codigoJalis = string2.substring(0, string2.indexOf("|"));
                    exame.materialJalis = string2.substring(string2.indexOf("|") + 1);
                }
                exame.linhasResultado.add(linha);
                if (ele.getChildNodes() != null && ele.getChildNodes().getLength() > 0) {
                    for (int i = 0; i < ele.getChildNodes().getLength(); ++i) {
                        Node no = ele.getChildNodes().item(i);
                        if (!no.getNodeName().equals("valorreferencia")) continue;
                        linha.valorReferencia = no.getTextContent();
                    }
                }
            } else if (ele.getNodeName().equals("camposcomplementares")) {
                for (Element element : XMLUtil.getElementosFilhos(ele)) {
                    CampoResultadoAlvaro campo = new CampoResultadoAlvaro();
                    campo.codigo = element.getAttribute("codigo");
                    campo.resultado = this.trocaCaracteres(element.getAttribute("resultado"));
                    if (exame.linhasResultado.isEmpty()) continue;
                    exame.linhasResultado.get((int)(exame.linhasResultado.size() - 1)).camposCompl.add(campo);
                }
            } else if (ele.getNodeName().equals("antibiograma")) {
                CampoResultadoAlvaro campo = new CampoResultadoAlvaro();
                for (Element element2 : XMLUtil.getElementosFilhos(ele)) {
                    Antibiograma anti = new Antibiograma();
                    anti.setAntibiotico(element2.getAttribute("antibiotico"));
                    anti.setResistencia(campo.getResistencia(element2.getAttribute("resistencia")));
                    anti.setMic(element2.getAttribute("mic"));
                    exame.antibiograma.add(anti);
                }
            } else if (ele.getNodeName().equals("curvas")) {
                for (Element element : XMLUtil.getElementosFilhos(ele)) {
                    grafico = element.getAttribute("pontos");
                }
            }
            if (Funcoes.textoVazio(ele.getAttribute("metodo"))) continue;
            exame.metodo = ele.getAttribute("metodo");
        }
        exame.observacao = observacao.toString();
        exame.grafico = grafico;
        requisicao.exames.add(exame);
    }

    private HashMap<String, String> localizaExameJalis(RequisicaoAlvaro requisicao, String paciente) {
        String fil = Funcoes.getFilialRequisicao(requisicao.codigoJalis)[0];
        String req = Funcoes.getFilialRequisicao(requisicao.codigoJalis)[1];
        Statement st = Conexao.getStatement();
        HashMap<String, String> retorno = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  f.ele_xmllabexterno , b.exa_codigo, b.mco_codigo \n");
        sql.append("from requisicao a \n");
        sql.append(" join examerequisicao b  on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append(" join loteexternoexamerequisicao c  on a.fil_codigo = c.fil_kodigo and a.req_codigo = c.req_codigo and b.exa_codigo = c.exa_codigo and b.mco_codigo = c.mco_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join examematcoletalabexterno f on e.fil_codigo = f.fil_codigo and e.exa_codigo = f.exa_codigo and e.mco_codigo = f.mco_codigo and c.lae_codigo = f.lae_codigo ");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        if (!Funcoes.textoVazio(paciente)) {
            sql.append("  a.pac_codigo = ").append(paciente).append(" and \n");
        } else {
            this.setTextoInformacoes("\nSem o c\u00f3digo do paciente na requisi\u00e7\u00e3o do Jalis. : " + requisicao.codigoJalis, false);
        }
        sql.append("  c.lae_codigo = ").append(this.codigoLabExterno).append(" and \n");
        sql.append("  a.req_excluida = false and b.exr_excluido = false and \n");
        sql.append("  f.ele_xmllabexterno is not null and f.ele_xmllabexterno <> '' ");
        try {
            ResultSet res = Conexao.executeQuery(st, sql.toString());
            StringBuilder buf = new StringBuilder();
            while (res.next()) {
                buf.setLength(0);
                String exameAlvaro = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(res.getString("ele_xmllabexterno"), "alvaro"), "exame"), "codigo");
                buf.append(res.getString("exa_codigo")).append("|").append(res.getString("mco_codigo"));
                if (Funcoes.textoVazio(exameAlvaro)) continue;
                retorno.put(exameAlvaro, buf.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    private String trocaCaracteres(String texto) {
        if (texto == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String[] caracteres = texto.split(";");
        boolean isFim = false;
        for (int i = 0; i < caracteres.length; ++i) {
            if (!isFim && caracteres[i].equals("&#xD") || caracteres[i].equals("&#xA")) {
                if (caracteres[i + 1].equals("&#xD") || caracteres[i + 1].equals("&#xA")) continue;
                isFim = true;
                continue;
            }
            buf.append(caracteres[i]);
        }
        texto = buf.toString();
        texto = texto.replace("&#xD", "\n");
        texto = texto.replace("&#xA", "\n");
        texto = texto.replace("&amp;#xA;", "\n");
        texto = texto.replace("&amp;#xD;", "\n");
        return texto;
    }

    private String removeCaracteresMetodo(String texto) {
        if (texto == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String[] caracteres = texto.split(";");
        for (int i = 0; i < caracteres.length; ++i) {
            if (caracteres[i].equals("&#xD") || caracteres[i].equals("&#xA")) continue;
            buf.append(caracteres[i]);
        }
        texto = buf.toString();
        texto = texto.replace("&#xD", "");
        texto = texto.replace("&#xA", "");
        texto = texto.replace("&amp;#xA;", "");
        texto = texto.replace("&amp;#xD;", "");
        return texto;
    }

    private void parseAmostras(List<Element> elements, RequisicaoAlvaro requisicao) {
        for (Element e : elements) {
            String codigo;
            AmostraAlvaro amostra = new AmostraAlvaro();
            amostra.codigo = codigo = e.getAttribute("codigo");
            amostra.descricao = e.getAttribute("descricao");
            amostra.material = e.getAttribute("material");
            requisicao.amostras.put(codigo, amostra);
        }
    }

    private PacienteAlvaro locatePaciente(String paciente) {
        for (PacienteAlvaro p : this.pacientes) {
            if (!p.codigoAOL.equalsIgnoreCase(paciente)) continue;
            return p;
        }
        return null;
    }

    private Registro localizaExameRequisicao(RequisicaoAlvaro requisicao, ExameResultadoAlvaro exame, Statement st) throws SQLException {
        String fil = "";
        String req = requisicao.codigoJalis;
        String exa = exame.codigoJalis;
        String mco = exame.materialJalis;
        if (Funcoes.textoVazio(req) || req.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            this.adicionarAoModeloRelatorio(requisicao.codigoJalis, exame.codigoJalis, exame.materialJalis, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Sem c\u00f3digo de requisi\u00e7\u00e3o no Jalis. " + this.protocolo.getDescricao() + " : " + requisicao.codigoAlvaro, false);
            return null;
        }
        if (Funcoes.textoVazio(exa) || Funcoes.textoVazio(mco)) {
            this.adicionarAoModeloRelatorio(requisicao.codigoJalis, exame.codigoJalis, exame.materialJalis, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis. " + this.protocolo.getDescricao() + " : " + requisicao.codigoAlvaro, false);
            return null;
        }
        fil = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
        if (!new ExameRequisicaoService().examePossuiExameRequisicao(st, fil, req = req.substring(ParametrosGerais.getDigitosTuboFilial()), exa, mco)) {
            return null;
        }
        StringBuilder sql = this.getSqlLocalizaExame(fil, req, exa, mco);
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        if (res.next()) {
            Registro reg = new Registro(res);
            reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(fil, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(fil, reg.getString(CODIGO_LAYOUT)));
            Registro formatacao = new Registro();
            formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor(FORMATACAO, formatacao);
            return reg;
        }
        this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis Fil.: %s Req.: %s. %s :%s ", fil, req, this.protocolo.getDescricao(), requisicao.codigoAlvaro), false);
        this.adicionarAoModeloRelatorio(requisicao.codigoJalis, exame.codigoJalis, exame.materialJalis, Situacao.NAO_LOCALIZADO);
        return null;
    }

    protected StringBuilder getSqlLocalizaExame(String fil, String req, String exa, String mco) {
        StringBuilder sql = new StringBuilder("select \n");
        sql.append(" a.fil_codigo, a.req_codigo, a.req_guia, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append(" b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(g.met_codigo, b.met_codigo) as met_codigo, \n");
        sql.append(" c.pac_idade, c.pac_anomes, b.exr_datamaterial, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, \n");
        sql.append(" b.exr_solicitadotiss, b.exr_codautorizacao, d.exa_salvaparcial, g.ele_xmllabexterno, h.lae_configuracao, null as examePai \n");
        sql.append(" from requisicao a \n");
        sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
        sql.append(" left join labexterno h on g.fil_codigo = h.fil_codigo and g.lae_codigo = h.lae_codigo \n");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        sql.append("  b.exa_codigo = '").append(exa).append("' and \n");
        sql.append("  b.mco_codigo = ").append(mco).append(" and \n");
        sql.append("  f.lae_codigo = ").append(this.codigoLabExterno);
        sql.append("  and a.req_excluida = false and b.exr_excluido = false \n");
        return sql;
    }

    private boolean validaExameRelacionamento(ExameResultadoAlvaro exame, Statement st, String fil_codigo) throws SQLException {
        ResultSet rs;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(mco_codigo) as count from examematcoleta where fil_codigo = ");
        sql.append(fil_codigo);
        sql.append(" and exa_codigo = '");
        sql.append(exame.codigoJalis);
        sql.append("' and mco_codigo = ");
        sql.append(exame.materialJalis);
        if (!Funcoes.textoVazio(exame.codigoJalis) && !Funcoes.textoVazio(exame.materialJalis) && (rs = Conexao.executeQuery(st, sql.toString())).next()) {
            return rs.getInt("count") == 1;
        }
        return false;
    }

    private void adicionarAoModeloRelatorio(String codigoJalis, String codExameJalis, String codMaterialJalis, Situacao situacao) {
        if (this.validaTamanhoTubo(codigoJalis)) {
            return;
        }
        String fil_codigo = codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial());
        boolean agruparMultiguia = false;
        Integer[] multiguias = new Integer[]{Integer.parseInt(req_codigo)};
        try {
            boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), fil_codigo, req_codigo);
            if (agruparMultiguia) {
                multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), null);
        }
        Statement st = Conexao.getStatement();
        String exames = "";
        for (Integer multiguia : multiguias) {
            try {
                exames = BDUtil.getCodigoExames(fil_codigo, multiguia.toString(), st);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), null);
            }
            if (this.validaExame(codExameJalis, codMaterialJalis) && !exames.contains(codExameJalis)) {
                ExameDesmembrado pai = this.getExamesDesmembrados(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), codExameJalis, codMaterialJalis);
                if (!this.existePai(pai)) continue;
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, fil_codigo, multiguia.toString(), pai.getCodigoExame(), pai.getCodigomaterial(), situacao.descricao, true);
                continue;
            }
            if (!this.validaExame(codExameJalis, codMaterialJalis)) continue;
            RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, fil_codigo, multiguia.toString(), codExameJalis, Integer.parseInt(codMaterialJalis), situacao.descricao, true);
        }
    }

    private boolean existePai(ExameDesmembrado pai) {
        return pai != null;
    }

    private boolean validaExame(String codExameJalis, String codmaterialJalis) {
        return !Funcoes.textoVazio(codExameJalis) && !Funcoes.textoVazio(codmaterialJalis);
    }

    private boolean validaTamanhoTubo(String codigoJalis) {
        return codigoJalis.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboFilial();
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private ArrayList<String> validaExameMultiguiaRepetido(Integer[] multiguias, Registro reg) throws SQLException {
        Statement st = Conexao.getStatement();
        ArrayList<String> multiguiasRepetidas = new ArrayList<String>();
        String requisicaoCodigo = reg.getString("req_codigo");
        String codExame = reg.getString("exa_codigo");
        if (!Funcoes.textoVazio(reg.getString("examePai"))) {
            codExame = reg.getString("examePai");
        }
        StringBuilder sql = new StringBuilder(" select req_codigo, exa_codigo from examerequisicao ");
        sql.append(" where exr_excluido = false ");
        sql.append(" and fil_codigo = ").append(reg.getString("fil_codigo"));
        sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
        sql.append(" and mco_codigo = ").append(reg.getString("mco_codigo"));
        if (multiguias.length == 1) {
            sql.append(" and req_codigo = ").append(requisicaoCodigo);
        } else {
            sql.append(" and req_codigo in ( ");
            for (Integer guia : multiguias) {
                sql.append(guia).append(",");
            }
            sql.replace(sql.length() - 1, sql.length(), "");
            sql.append(")");
        }
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            if (rs.getString("req_codigo").equals(requisicaoCodigo) || rs.getString("exa_codigo").equals(codExame)) continue;
            multiguiasRepetidas.add(rs.getString("req_codigo"));
        }
        Conexao.fecharStatement(st);
        return multiguiasRepetidas;
    }

    public boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "codigo");
                    mco = StringUtil.getValor(xml, "material");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select alv_xml from examesalvaro where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sqlBuilder.append(" and alv_codexame = '").append(exa).append("' and alv_codmaterial = '").append(mco).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("alv_xml", rs.getString("alv_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro 643");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else if (e.getSource() == this.buttonImportarWS) {
            this.isWebService = true;
            new Thread(this).start();
            this.habilitarBotoes(true);
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean conferenciaAutomatica() {
        return this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica);
    }

    private Map<String, Map<String, String>> getHistoricosPorExame(String codigoExame, String codigoFilial) {
        HashMap<String, Map<String, Map<String, String>>> tmp = new HashMap<String, Map<String, Map<String, String>>>();
        String key = codigoFilial + "|" + codigoExame;
        if (this.historicosExame == null || this.historicosExame.isEmpty()) {
            tmp.put(key, ExameUtil.getHistoricos(codigoExame, codigoFilial));
            this.historicosExame = tmp;
        } else if (this.historicosExame.get(key) == null || this.historicosExame.get(key).isEmpty()) {
            tmp.put(key, ExameUtil.getHistoricos(codigoExame, codigoFilial));
            this.historicosExame = tmp;
        }
        return this.historicosExame.get(key);
    }

    private Map<String, Map<String, String>> getHistoricosPorFilial(String codigoFilial) {
        HashMap<String, Map<String, Map<String, String>>> tmp = new HashMap<String, Map<String, Map<String, String>>>();
        if (this.historicosExameFilial == null || this.historicosExameFilial.isEmpty()) {
            tmp.put(codigoFilial, ExameUtil.getHistoricos(null, codigoFilial));
            this.historicosExameFilial = tmp;
        } else if (this.historicosExameFilial.get(codigoFilial) == null || this.historicosExameFilial.get(codigoFilial).isEmpty()) {
            tmp.put(codigoFilial, ExameUtil.getHistoricos(null, codigoFilial));
            this.historicosExameFilial = tmp;
        }
        return this.historicosExameFilial.get(codigoFilial);
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_RELACIONAMENTO("Sem relacionamento"),
        SEM_MATERIAL("Sem material"),
        LAYOUT_ATUALIZADO("Layout atualizado, mas n\u00e3o relacionado");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

