/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.ParserImportacaoAlvaro;
import jalis.service.cadastro.exame.LabExternoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;

public class ImportacaoAlvaro
extends AbstractImportadorLabExterno {
    private JButton buttonImportarDadosAdicionais = ComponenteFactory.novoJButton("Importar Dados Adicionais", 'D', this);

    public ImportacaoAlvaro(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Alvaro a partir de arquivo XML", codigoLabExterno, Protocolo.Alvaro);
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().add((Component)this.buttonImportarDadosAdicionais, 1);
    }

    public ImportacaoAlvaro(int codigoLabExterno, String titulo, Protocolo protocolo) {
        super("Importa\u00e7\u00e3o de Exames", titulo, codigoLabExterno, protocolo);
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().add((Component)this.buttonImportarDadosAdicionais, 1);
    }

    public ImportacaoAlvaro(String titulo, String descricao, int codigoLabExterno, Protocolo solucaov2) {
        super(titulo, descricao, codigoLabExterno, Protocolo.SolucaoV2);
        this.getButtonImportar().setText("Importar Exames");
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
        this.buttonImportarDadosAdicionais.setEnabled(habilitar);
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        LabExternoService les = new LabExternoService();
        try {
            String[] stringArray;
            String descricao;
            String conf = les.xmlConfigEtiquetaHpDirect(Variaveis.filialPadrao, String.valueOf(this.codigoLabExterno));
            String importarListaXls = StringUtil.getValor(conf, "importarListaXls");
            boolean xls = !Funcoes.textoVazio(importarListaXls) ? Boolean.parseBoolean(importarListaXls) : false;
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            String string = descricao = xls ? "Arquivo XML do Lab. Alvaro (*.xml, *.xls, *.xlsx)" : "Arquivo XML do Lab. Alvaro (*.xml)";
            if (xls) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "xml";
                stringArray2[1] = "xls";
                stringArray = stringArray2;
                stringArray2[2] = "xlsx";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "xml";
            }
            String[] extensoes = stringArray;
            chooser.setFileFilter(ComponenteFactory.novoFileFilter(descricao, extensoes));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                StringBuilder bui = new StringBuilder();
                bui.append("Importando exames...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                Map<String, Set<ExameAlvaro>> mapExamesErros = ParserImportacaoAlvaro.importarExamesAlvaro(file, this.codigoLabExterno, this.progress);
                Set<ExameAlvaro> excluidos = mapExamesErros.get("examesExcluidos");
                Set<ExameAlvaro> naoEncontrados = mapExamesErros.get("naoEncontrados");
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (naoEncontrados != null && !naoEncontrados.isEmpty()) {
                    bui.append("\n\nAs mensagens abaixo foram apresentadas: \n");
                    for (ExameAlvaro e : naoEncontrados) {
                        bui.append("\nExame [" + e.getCodigo() + "] - " + e.getDescricao()).append(" - relacionado fora do padr\u00e3o, favor verificar as configura\u00e7\u00f5es de relacionamento no cadastro de exames. ");
                    }
                    this.setTextoInformacoes(bui.toString());
                }
                if (excluidos != null && excluidos.size() > 0) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (ExameAlvaro e : excluidos) {
                        bui.append("\n\t|").append(StringUtil.formatarColuna(e.getDescricao(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getMaterialDescricao(), 50, 'c')).append("|");
                    }
                    bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
                retorno = true;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoAlvaro: 71");
        }
        this.progress.setVisible(false);
        return retorno;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImportarDadosAdicionais) {
            this.habilitarBotoes(false);
            new Thread("Thread de Importa\u00e7\u00e3o de Campos de Resultados"){

                @Override
                public void run() {
                    ImportacaoAlvaro.this.importarDadosAdicionais();
                }
            }.start();
        } else {
            super.actionPerformed(e);
        }
    }

    public void importarDadosAdicionais() {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS do Lab. Alvaro (*.xls), (*.xlsx)", "xls", "xlsx"));
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo CSV do Lab. Alvaro (*.csv)", "csv"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                StringBuilder bui = new StringBuilder();
                bui.append("Importando dados adicionais...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setVisible(true);
                ArrayList<ExameAlvaro> examesAtualizados = ParserImportacaoAlvaro.importarDadosAdicionais(file, this.codigoLabExterno, this.progress, this.protocolo.equals((Object)Protocolo.Alvaro));
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (examesAtualizados != null && examesAtualizados.size() > 0) {
                    bui.append("\n\nOs seguintes exames abaixo foram atualizados: \n\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (ExameAlvaro e : examesAtualizados) {
                        bui.append("\n\t|").append(StringUtil.formatarColuna(e.getDescricao(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getMaterialDescricao(), 50, 'c')).append("|");
                    }
                    bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                } else {
                    this.setTextoInformacoes("O arquivo n\u00e3o cont\u00eam os dados necess\u00e1rios para importar os dados adicionais, verifica se o arquivo n\u00e3o est\u00e1 vazio!");
                    bui.append("\n\nO conte\u00fado do arquivo deve ser gerado como no exemplo abaixo para que seja poss\u00edvel importar os dados adicionais: \n\n");
                    bui.append("\t+--------------+\n");
                    bui.append("\t|Formato antigo|\n");
                    bui.append("\t+--------------+\n");
                    bui.append("\t\"Exame\";\"Dado\";\"Unidade\"\n");
                    bui.append("\t\"ACUR1\";\"Volume\";\"mL\"\n");
                    bui.append("\t\"AMIL2\";\"Volume urin\u00e1rio\";\"mL\"\n");
                    bui.append("\t\"CALCU\";\"Peso\";\n");
                    bui.append("\t\"CALCU\";\"Dimens\u00f5es\";\n");
                    bui.append("\t\"CALCU\";\"Forma\";\n");
                    bui.append("\t\"CALCU\";\"Cor\";\n");
                    bui.append("\t\"CALCU\";\"Superf\u00edcie\";\n");
                    bui.append("\t\"CALCU\";\"Consist\u00eancia\";\n");
                    bui.append("\t\"CISTQ\";\"Volume de 24 horas\";\"mL\"\n");
                    bui.append("\t\"CLEAR\";\"Volume de urina\";\"mL\"\n");
                    bui.append("\t\"CLEAR\";\"Peso\";\"kg\"\n");
                    bui.append("\t\"CLEAR\";\"Altura\";\"cm\"\n");
                    bui.append("\t\"CD483\";\"Linf\u00f3citos Totais\";\"/mm3\"\n");
                    bui.append("\t\"CD483\";\"Leuc\u00f3citos Totais\";\"/mm3\"\n");
                    bui.append("\n\n");
                    bui.append("\t+------------+\n");
                    bui.append("\t|Formato novo|\n");
                    bui.append("\t+------------+\n");
                    bui.append("\tCodigo;Nome;Sinonimo;Material;DadoObrigatorio;CodigoAMB;exaDtUltAltAOL;EhCurva\n");
                    bui.append("\tOXALI;OXALATO (\u00e1cido ox\u00e1lico);Oxalato;3175;Volume;28.01.013.2;14/03/2013 09:35;N\n");
                    bui.append("\tACUR1;\u00c1CIDO \u00daRICO URIN\u00c1RIO - 24h;Uricos\u00faria;738;Volume;28.01.017.5;12/09/2012 10:02;N\n");
                    bui.append("\tVMA;\u00c1CIDO VANIL MAND\u00c9LICO;VMA,;3175;Volume;28.05.001.0;21/09/2012 11:01;N\n");
                    bui.append("\tACTH;ACTH - HORM\u00d4NIO ADRENOCORTICOTR\u00d3FICO;Horm\u00f4nio adrenocorticotr\u00f3fico, corticotrofina;859;;28.05.002.9;12/09/2012 10:01;N\n");
                    bui.append("\tAMIL2;AMILASE URIN\u00c1RIA - 24h;Clearance de amilase;738;Volume urin\u00e1rio;28.01.025.6;06/05/2013 17:18;N\n");
                    bui.append("\tCLEAR;CLEARENCE DE CREATININA;Depura\u00e7\u00e3o de Creatinina;1021;Volume de urina,Peso,Altura;28.01.042.6;12/09/2012 11:19;N\n");
                    bui.append("\tCLEUR;CLEARENCE DE UR\u00c9IA;;1021;Volume de urina,Peso,Altura;28.01.045.0;12/09/2012 11:19;N\n");
                    bui.append("\tCLORU;CLORO URIN\u00c1RIO;Cloretos;738;Volume;28.01.046.9;12/09/2012 11:21;N\n");
                    bui.append("\n\n");
                    bui.append("Verifique como foi gerado o arquivo com os dados adicionais ou por quem forneceu o arquivo com os dados adicionais.");
                    this.setTextoInformacoes(bui.toString());
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoAlvaro: 114");
        }
        this.habilitarBotoes(true);
        this.progress.setVisible(false);
    }
}

