/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.alvaro.Antibiograma;
import jalis.laboratorio.util.parsers.alvaro.CampoComplementar;
import jalis.laboratorio.util.parsers.alvaro.DadoAdicional;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.laboratorio.util.parsers.alvaro.MaterialPossivel;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import jalis.util.xml.XMLUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class ExameAlvaro
implements Cloneable {
    public static final String TAG_NUMERO_AMOSTRA = "numero-amostra";
    public static final String TAG_CODIGO_EXAME = "codigo-exame";
    public static final String TAG_CODIGO_MATERIAL = "codigo-material";
    private String codigo;
    private String descricao;
    private String material;
    private String materialDescricao;
    private ArrayList<LinhaResultado> linhasResultado = new ArrayList();
    private String exameJalis;
    private String materialJalis;
    private String laboratorioExternoJalis;
    private String xmlJalis;
    private String dataAlteracao;
    private String valorReferencia;
    private List<DadoAdicional> dadosAdicionais = new ArrayList<DadoAdicional>();
    private List<CampoComplementar> camposComplementares = new ArrayList<CampoComplementar>();
    private String resultadoAntibiogramas;
    private String requisicao;
    private String unidade;
    private List<String> listaDesmembrados = new ArrayList<String>();
    public static final String TAG_FORMATO_PDF = "formato_pdf";
    private boolean formatoPDF;
    public static final String SIM = "SIM";
    public static final String NAO = "NAO";
    private Antibiograma antibiograma = new Antibiograma();

    public List<String> getListaDesmembrados() {
        return this.listaDesmembrados;
    }

    public void setListaDesmembrados(List<String> listaDesmembrados) {
        this.listaDesmembrados = listaDesmembrados;
    }

    public void setRequisicao(String requisicao) {
        this.requisicao = requisicao;
    }

    public String getRequisicao() {
        return this.requisicao;
    }

    public String getResultadoAntibiogramas() {
        return this.resultadoAntibiogramas;
    }

    public void setResultadoAntibiogramas(String resultadoAntibiogramas) {
        this.resultadoAntibiogramas = resultadoAntibiogramas;
    }

    public ExameAlvaro() {
    }

    public ExameAlvaro(String xml) {
        this.parseXml(xml);
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public String getUnidade() {
        return this.unidade;
    }

    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public String getXmlJalis() {
        return this.xmlJalis;
    }

    public void setXmlJalis(String xmlJalis) {
        this.xmlJalis = xmlJalis;
    }

    public String toString() {
        return this.descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public ArrayList<LinhaResultado> getLinhasResultado() {
        return this.linhasResultado;
    }

    public Antibiograma getAntibiograma() {
        return this.antibiograma;
    }

    public void setAntibiograma(Antibiograma antibiograma) {
        this.antibiograma = antibiograma;
    }

    public LinhaResultado getLinha(String codigo) {
        for (LinhaResultado linha : this.linhasResultado) {
            if (linha.getCodigo() == null || !linha.getCodigo().equals(codigo)) continue;
            return linha;
        }
        return null;
    }

    public void setLinhasResultado(ArrayList<LinhaResultado> linhasResultado) {
        this.linhasResultado = linhasResultado;
    }

    public String getMaterial() {
        return this.material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public String getMaterialDescricao() {
        return this.materialDescricao;
    }

    public void setMaterialDescricao(String materialDescricao) {
        this.materialDescricao = materialDescricao;
    }

    public String getLaboratorioExternoJalis() {
        return this.laboratorioExternoJalis;
    }

    public void setLaboratorioExternoJalis(String laboratorioExternoJalis) {
        this.laboratorioExternoJalis = laboratorioExternoJalis;
    }

    public String getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(String dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public void addDadoAdicional(DadoAdicional dadoAdicional) {
        this.dadosAdicionais.add(dadoAdicional);
    }

    public List<DadoAdicional> getDadosAdicionais() {
        return this.dadosAdicionais;
    }

    public void setDadosAdicionais(List<DadoAdicional> dadosAdicionais) {
        this.dadosAdicionais = dadosAdicionais;
    }

    public String getValorReferencia() {
        return this.valorReferencia;
    }

    public void setValorReferencia(String valorReferencia) {
        this.valorReferencia = valorReferencia;
    }

    public List<CampoComplementar> getCamposComplementares() {
        return this.camposComplementares;
    }

    public static Set<ExameAlvaro> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameAlvaro> list = new HashSet<ExameAlvaro>();
        if (res.first()) {
            do {
                list.add(new ExameAlvaro(res));
            } while (res.next());
        }
        return list;
    }

    public ExameAlvaro(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.exameJalis = res.getString("exa_codigo");
        this.materialJalis = res.getString("mco_codigo");
        this.laboratorioExternoJalis = res.getString("lae_codigo");
        this.parseXml(res.getString("ele_xmllabexterno"));
    }

    private void carregarXMLLinhasResultado(String xml) {
        this.linhasResultado = new ArrayList();
        for (String linha : StringUtil.getValores(xml, "linha_resultado")) {
            LinhaResultado l = new LinhaResultado();
            l.setCodigo(StringUtil.getValor(linha, "codigo"));
            l.setDescricao(StringUtil.getValor(linha, "descricao"));
            l.setUnidade(StringUtil.getValor(linha, "unidade"));
            String stringTempos = StringUtil.getValor(linha, "tempos");
            if (stringTempos != null && !stringTempos.trim().isEmpty()) {
                for (String stringTempo : stringTempos.split(",")) {
                    l.addTempo(stringTempo);
                }
            }
            this.linhasResultado.add(l);
        }
    }

    private void carregarXMLDadosAdicionais(String xml) {
        this.dadosAdicionais = new ArrayList<DadoAdicional>();
        for (String dadoXml : StringUtil.getValores(xml, "dado")) {
            if (Funcoes.textoVazio(dadoXml)) continue;
            String descricao = StringUtil.getValor(dadoXml, "descricao");
            DadoAdicional dado = new DadoAdicional();
            if (Funcoes.textoVazio(descricao)) {
                dado.setDescricao(dadoXml);
            } else {
                dado.setDescricao(descricao);
                dado.setUnidade(StringUtil.getValor(dadoXml, "unidade"));
            }
            this.dadosAdicionais.add(dado);
        }
    }

    private void carregarXMLAntibiograma(String xml) {
        this.antibiograma.setAntibiotico(StringUtil.getValor(xml, "antibiotico"));
        this.antibiograma.setResistencia(StringUtil.getValor(xml, "resistencia"));
        this.antibiograma.setMic(StringUtil.getValor(xml, "mic"));
    }

    private void carregarXMLCamposCompl(String xml) {
        this.camposComplementares = new ArrayList<CampoComplementar>();
        for (String dadoXml : StringUtil.getValores(xml, "campo_compl")) {
            if (Funcoes.textoVazio(dadoXml)) continue;
            int codigo = Integer.valueOf(StringUtil.getValor(dadoXml, "codigo"));
            String label = StringUtil.getValor(dadoXml, "label");
            boolean listaLaudo = Boolean.valueOf(StringUtil.getValor(dadoXml, "lista_laudo"));
            this.camposComplementares.add(new CampoComplementar(codigo, label, listaLaudo));
        }
    }

    public ExameAlvaro(Element element, Hashtable<String, String> materiais) {
        this();
        this.setCodigo(element.getAttribute("codigo"));
        this.setDescricao(element.getAttribute("descricao").replaceAll("\u00b4", ""));
        this.setMaterial(element.getAttribute("materialpadrao"));
        this.setDataAlteracao(element.getAttribute("dataalteracao"));
        if (materiais != null) {
            this.setMaterialDescricao(materiais.get(element.getAttribute("materialpadrao")));
        }
        this.antibiograma.setAntibiotico(element.getAttribute("antibiograma"));
        this.antibiograma.setResistencia(element.getAttribute("resistencia"));
        this.antibiograma.setMic(element.getAttribute("mic"));
        if (element.hasChildNodes()) {
            List<Element> childs = XMLUtil.getElementosFilhos(element);
            for (Element c : childs) {
                if (c.getNodeName().equalsIgnoreCase("linhasresultado")) {
                    this.parseLinhas(c);
                    continue;
                }
                if (c.getNodeName().equalsIgnoreCase("camposcomplementares")) {
                    this.parseCamposCompl(c);
                    continue;
                }
                if (c.getNodeName().equalsIgnoreCase("valorreferencia")) {
                    if (c.getTextContent() == null) continue;
                    this.setValorReferencia(c.getTextContent().trim());
                    continue;
                }
                if (c.getNodeName().equalsIgnoreCase("dadosAdicionais")) {
                    this.parseDadosAdicionais(c);
                    continue;
                }
                if (!c.getNodeName().equalsIgnoreCase("antibiograma")) continue;
                this.parseAntibiograma(c);
            }
        }
    }

    public static List<ExameAlvaro> getExames(Element element, Hashtable<String, String> materiais) throws Exception {
        ArrayList<ExameAlvaro> exames = new ArrayList<ExameAlvaro>();
        List<Object> materiaisPossiveis = new ArrayList();
        ExameAlvaro base = new ExameAlvaro();
        base.setCodigo(element.getAttribute("codigo"));
        base.setDescricao(element.getAttribute("descricao").replaceAll("\u00b4", ""));
        String codigoMaterialPadrao = element.getAttribute("materialpadrao");
        base.setMaterial(codigoMaterialPadrao);
        base.setDataAlteracao(element.getAttribute("dataalteracao"));
        if (materiais != null) {
            base.setMaterialDescricao(materiais.get(element.getAttribute("materialpadrao")));
        }
        if (element.hasChildNodes()) {
            List<Element> childs = XMLUtil.getElementosFilhos(element);
            for (Element c : childs) {
                if (c.getNodeName().equalsIgnoreCase("linhasresultado")) {
                    base.parseLinhas(c);
                    continue;
                }
                if (c.getNodeName().equalsIgnoreCase("camposcomplementares")) {
                    base.parseCamposCompl(c);
                    continue;
                }
                if (c.getNodeName().equalsIgnoreCase("valorreferencia")) {
                    if (c.getTextContent() == null) continue;
                    base.setValorReferencia(c.getTextContent().trim());
                    continue;
                }
                if (c.getNodeName().equalsIgnoreCase("dadosAdicionais")) {
                    base.parseDadosAdicionais(c);
                    continue;
                }
                if (c.getNodeName().equalsIgnoreCase("materiaispossiveis")) {
                    materiaisPossiveis = base.parseMateriaisPossiveis(c);
                    continue;
                }
                if (!c.getNodeName().equalsIgnoreCase("antibiograma")) continue;
                base.parseAntibiograma(c);
            }
        }
        exames.add(base);
        if (!materiaisPossiveis.isEmpty()) {
            for (MaterialPossivel mat : materiaisPossiveis) {
                if (mat.getCodigo().equalsIgnoreCase(codigoMaterialPadrao)) continue;
                ExameAlvaro exameMat = (ExameAlvaro)base.clone();
                exameMat.setMaterial(mat.getCodigo());
                exameMat.setMaterialDescricao(mat.getDescricao());
                exames.add(exameMat);
            }
        }
        return exames;
    }

    private List<MaterialPossivel> parseMateriaisPossiveis(Element c) {
        ArrayList<MaterialPossivel> materiais = new ArrayList<MaterialPossivel>();
        List<Element> l = XMLUtil.getElementosFilhos(c);
        for (Element e : l) {
            MaterialPossivel mat = new MaterialPossivel();
            mat.setCodigo(e.getAttribute("codigo"));
            mat.setDescricao(e.getAttribute("descricao"));
            materiais.add(mat);
        }
        return materiais;
    }

    public ExameAlvaro(Element element) {
        this(element, null);
    }

    private void parseLinhas(Element linhas) {
        List<Element> l = XMLUtil.getElementosFilhos(linhas);
        ArrayList<LinhaResultado> linhasResultado = new ArrayList<LinhaResultado>();
        for (Element e : l) {
            LinhaResultado linha = new LinhaResultado();
            linha.setCodigo(e.getAttribute("codigo"));
            linha.setDescricao(e.getAttribute("descricao"));
            if (e.hasAttribute("unidade")) {
                linha.setUnidade(e.getAttribute("unidade"));
            }
            linhasResultado.add(linha);
            String stringTempos = e.getAttribute("tempos");
            if (stringTempos == null || stringTempos.trim().isEmpty()) continue;
            for (String stringTempo : stringTempos.split(",")) {
                linha.addTempo(stringTempo);
            }
        }
        this.setLinhasResultado(linhasResultado);
    }

    private void parseCamposCompl(Element element) {
        List<Element> filhosElement = XMLUtil.getElementosFilhos(element);
        this.camposComplementares.clear();
        for (Element e : filhosElement) {
            int codigo = Integer.valueOf(e.getAttribute("codigo"));
            String label = e.getAttribute("label");
            boolean listaLaudo = e.getAttribute("lista_laudo").equalsIgnoreCase("s");
            this.camposComplementares.add(new CampoComplementar(codigo, label, listaLaudo));
        }
    }

    private void parseDadosAdicionais(Element element) {
        List<Element> filhosElement = XMLUtil.getElementosFilhos(element);
        this.dadosAdicionais.clear();
        for (Element e : filhosElement) {
            DadoAdicional dado = new DadoAdicional();
            if (e.getAttributes().getLength() == 2) {
                dado.setDescricao(e.getAttribute("descricao"));
                dado.setUnidade(e.getAttribute("unidade"));
            } else {
                dado.setDescricao(e.getNodeValue());
            }
            this.dadosAdicionais.add(dado);
        }
    }

    private void parseAntibiograma(Element element) {
        try {
            this.antibiograma.setAntibiotico(element.getAttribute("antibiotico"));
            this.antibiograma.setResistencia(element.getAttribute("resistencia"));
            this.antibiograma.setMic(element.getAttribute("mic"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseXml(String xml) {
        if (xml != null) {
            String exame = StringUtil.getValor(xml, "exame");
            this.codigo = StringUtil.getValor(exame, "codigo");
            this.descricao = StringUtil.getValor(exame, "descricao");
            this.material = StringUtil.getValor(exame, "material");
            this.materialDescricao = StringUtil.getValor(exame, "material_descricao");
            this.dataAlteracao = StringUtil.getValor(exame, "data_alteracao");
            this.valorReferencia = StringUtil.xmlToTexto(StringUtil.getValor(exame, "valor_referencia"));
            this.formatoPDF = StringUtil.getValor(exame, TAG_FORMATO_PDF).equals(SIM);
            if (this.valorReferencia != null) {
                this.valorReferencia = this.valorReferencia.trim();
            }
            String linhasResultado = StringUtil.getValor(exame, "linhas_resultado");
            String dadosAdicionais = StringUtil.getValor(exame, "dados_adicionais");
            String camposCompl = StringUtil.getValor(exame, "campos_compl");
            String antibiogramaParse = StringUtil.getValor(exame, "antibiograma");
            this.carregarXMLLinhasResultado(linhasResultado);
            this.carregarXMLDadosAdicionais(dadosAdicionais);
            this.carregarXMLCamposCompl(camposCompl);
            this.carregarXMLAntibiograma(antibiogramaParse);
        }
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("alvaro");
            xml.abrir("exame");
            xml.escrever("codigo", this.getCodigo());
            xml.escrever("descricao", StringUtil.textoDB(this.getDescricao()));
            xml.escrever("material", this.getMaterial());
            xml.escrever("data_alteracao", this.getDataAlteracao());
            xml.escrever("material_descricao", this.getMaterialDescricao());
            xml.escrever("valor_referencia", StringUtil.textoXML(this.getValorReferencia()));
            if (!this.dadosAdicionais.isEmpty()) {
                xml.abrir("dados_adicionais");
                for (DadoAdicional dado : this.dadosAdicionais) {
                    xml.abrir("dado");
                    xml.escrever("descricao", dado.getDescricao());
                    xml.escrever("unidade", dado.getUnidade());
                    xml.fechar("dado");
                }
                xml.fechar("dados_adicionais");
            }
            if (!this.linhasResultado.isEmpty()) {
                xml.abrir("linhas_resultado");
                for (LinhaResultado l : this.linhasResultado) {
                    xml.abrir("linha_resultado");
                    xml.escrever("codigo", l.getCodigo());
                    xml.escrever("descricao", l.getDescricao());
                    if (!Funcoes.textoVazio(l.getUnidade())) {
                        xml.escrever("unidade", l.getUnidade());
                    }
                    xml.escrever("tempos", StringUtil.implode(l.getTempos(), ","));
                    xml.escrever("valorRef_" + l.getCodigo(), "Vlr. ref./p " + l.getDescricao());
                    xml.escrever("metodologia_" + l.getCodigo(), "Unidade de p/" + l.getDescricao());
                    xml.fechar("linha_resultado");
                }
                xml.fechar("linhas_resultado");
            }
            if (!this.camposComplementares.isEmpty()) {
                xml.abrir("campos_compl");
                for (CampoComplementar campo : this.camposComplementares) {
                    xml.abrir("campo_compl");
                    xml.escrever("codigo", String.valueOf(campo.getCodigo()));
                    xml.escrever("label", campo.getLabel());
                    xml.escrever("lista_laudo", String.valueOf(campo.isListaLaudo()));
                    xml.fechar("campo_compl");
                }
                xml.fechar("campos_compl");
            }
            xml.escrever(TAG_FORMATO_PDF, this.formatoPDF ? SIM : NAO);
            if (this.antibiograma != null) {
                xml.abrir("antibiograma");
                xml.escrever("antibiotico", this.antibiograma.getAntibiotico());
                xml.escrever("resistencia", this.antibiograma.getResistencia());
                xml.escrever("mic", this.antibiograma.getMic());
                xml.fechar("antibiograma");
            }
            xml.fechar("exame");
            xml.fechar("alvaro");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameAlvaro: 291");
        }
        return xml.getXML();
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorAlvaro = StringUtil.getValor(xml, "alvaro");
        return valorAlvaro != null && valorAlvaro.trim().length() > 0 && (valorExame = StringUtil.getValor(valorAlvaro, "exame")) != null && valorExame.trim().length() > 0;
    }

    public static List<ExameAlvaro> getExamesImportados(String codigoLabExterno) {
        ArrayList<ExameAlvaro> exames = new ArrayList<ExameAlvaro>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select * \n");
                bui.append("from examesalvaro \n");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("      lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("order by alv_descricaoexame, upper(alv_descricaomaterial) ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    ExameAlvaro exa = new ExameAlvaro();
                    exa.setCodigo(res.getString("alv_codexame"));
                    exa.setMaterial(res.getString("alv_codmaterial"));
                    exa.setMaterialDescricao(res.getString("alv_descricaomaterial"));
                    exa.setDescricao(res.getString("alv_descricaoexame"));
                    exa.parseXml(res.getString("alv_xml"));
                    exames.add(exa);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ExameAlvaro: 290");
            }
        }
        return exames;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExameAlvaro)) {
            return false;
        }
        ExameAlvaro e = (ExameAlvaro)o;
        return e.codigo.equalsIgnoreCase(this.codigo) && e.getMaterial().equalsIgnoreCase(this.material);
    }

    public int hashCode() {
        return this.codigo.hashCode();
    }

    public boolean isFormatoPDF() {
        return this.formatoPDF;
    }

    public void setFormatoPDF(boolean formatoPDF) {
        this.formatoPDF = formatoPDF;
    }
}

