/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro;

import jalis.laboratorio.util.parsers.alvaro.Tempos;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

class EditarTempoLinhaResultado
extends JDialog
implements ActionListener {
    private JPanel panelTempo = new JPanel(new FlowLayout(0));
    private JLabel labelTempo = new JLabel("Tempo");
    private TTextField editTempo = ComponenteFactory.novoTTextField(30, 3);
    private JButton botaoAddTempo = ComponenteFactory.novoJButton("OK", 'K', this);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton botaoOk = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton botaoCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private ModeloGridTable modTempo = new ModeloGridTable(new String[]{"Tempo"});
    private JTable tableTempo = ComponenteFactory.novoJTable(this.modTempo);
    private JScrollPane scrollTempo = new JScrollPane(this.tableTempo);
    private Tempos tempos = new Tempos();
    private int linhaAlterada = -1;

    public EditarTempoLinhaResultado(JDialog parent, String linha, Object tempos) {
        super(parent);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(200, 250));
        this.setLayout(new BorderLayout());
        this.setTitle(linha);
        this.editTempo.setPreferredSize(new Dimension(70, 20));
        this.botaoAddTempo.setMargin(new Insets(2, 2, 2, 2));
        this.panelTempo.add(this.labelTempo);
        this.panelTempo.add(this.editTempo);
        this.panelTempo.add(this.botaoAddTempo);
        this.add((Component)this.panelTempo, "North");
        this.panelBotoes.add(this.botaoOk);
        this.panelBotoes.add(this.botaoCancelar);
        this.add((Component)this.panelBotoes, "South");
        this.scrollTempo.setPreferredSize(new Dimension(200, 50));
        this.add((Component)this.scrollTempo, "Center");
        if (tempos != null) {
            this.tempos = (Tempos)tempos;
        }
        this.populateTalbeWithTempos();
        this.pack();
        this.setLocationRelativeTo(parent);
        Funcoes.montaEnter((JComponent)this.panelTempo);
        this.tableTempo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    EditarTempoLinhaResultado.this.modTempo.removeLine(row);
                }
            }
        });
        this.tableTempo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EditarTempoLinhaResultado.this.alteraTempo(EditarTempoLinhaResultado.this.tableTempo.getSelectedRow());
                }
            }
        });
        this.tableTempo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && EditarTempoLinhaResultado.this.tableTempo.getSelectedRow() > -1) {
                    e.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditarTempoLinhaResultado.this.alteraTempo(EditarTempoLinhaResultado.this.tableTempo.getSelectedRow());
                        }
                    });
                }
            }
        });
    }

    private void alteraTempo(int row) {
        if (row > -1) {
            this.linhaAlterada = row;
            this.editTempo.setText(this.modTempo.getValueAt(this.linhaAlterada, 0).toString());
            this.editTempo.grabFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.populateTemposWhitTable();
            this.setVisible(false);
        } else if (e.getSource() == this.botaoCancelar) {
            while (this.tableTempo.getRowCount() > 0) {
                this.modTempo.removeLine(0);
            }
            this.setVisible(false);
        } else if (e.getSource() == this.botaoAddTempo) {
            int localizado = this.modTempo.localizar(0, this.editTempo.getText());
            if (localizado < 0 || this.linhaAlterada > -1 && localizado == this.linhaAlterada) {
                if (this.linhaAlterada > -1) {
                    this.modTempo.setValueAt(this.editTempo.getText(), this.linhaAlterada, 0);
                    this.linhaAlterada = -1;
                } else {
                    this.modTempo.addLine(new String[]{this.editTempo.getText()});
                    this.editTempo.grabFocus();
                }
            }
            this.editTempo.setText("");
        }
    }

    public Tempos getTempos() {
        return this.tempos;
    }

    private void populateTalbeWithTempos() {
        for (String tempo : this.tempos.getTempos()) {
            this.modTempo.addLine(new Object[]{tempo});
        }
    }

    private void populateTemposWhitTable() {
        this.tempos.clear();
        for (int i = 0; i < this.tableTempo.getRowCount(); ++i) {
            String tempo = this.tableTempo.getValueAt(i, 0).toString();
            this.tempos.add(tempo);
        }
    }
}

