/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloAlvaro
extends AbstractConfiguradorProtocolo {
    public static final String TAG_LOTE = "lote";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_CHAVE = "chave";
    public static final String TAG_AGENTE = "agente";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_ENDERECO_RESULTADO = "enderecoResultado";
    public static final String TAG_ENDERECO_WS = "enderecoWebService";
    public static final String TAG_ENVIAR_MEDICO = "enviarMedico";
    public static final String TAG_ENVIAR_LOTE_WS = "enviarLoteWebService";
    public static final String TAG_PROCESSAR_ENTER = "processarEnter";
    public static final String TAG_ENVIO_AUTOMATICO = "envioAutomatico";
    public static final String TAG_IMPORTAR_LISTA_XLS = "importarListaXls";
    public static final String TAG_ENVIAR_URGENTE = "enviarUrgente";
    public static final String TAG_IMPORTAR_RESULTADO_PDF = "importarResultadoPdf";
    protected JTextField textChave = new TTextField(16, 1);
    protected JTextField textAgente = new TTextField(16, 1);
    protected JTextField textSenha = new TTextField(16, 3);
    protected JTextField textEndWebService = new TTextField(100, 3);
    protected JTextField textEndResultado = new TTextField(100, 3);
    protected JCheckBox checkMedico = new JCheckBox("Enviar os dados do m\u00e9dico");
    protected JCheckBox checkEnviaLoteUsandoWebService = new JCheckBox("Enviar lote utilizando WebService");
    protected JCheckBox checkEnterNoResultado = new JCheckBox("Considerar <ENTER> no resultado");
    protected JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    protected JCheckBox checkImportarXls = new JCheckBox("Importar lista de exames em excel");
    protected JCheckBox checkUrgente = new JCheckBox("Enviar descri\u00e7\u00e3o de exame urgente");
    public JCheckBox checkImportarResultadoPdf = new JCheckBox("Importar resultados no formato PDF");

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloAlvaro((Frame)pai, "Laborat\u00f3rio \u00c1lvaro", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloAlvaro((Dialog)pai, "Laborat\u00f3rio \u00c1lvaro", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloAlvaro(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloAlvaro(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<alvaro>");
        bui.append(StringUtil.getTag(TAG_LOTE, this.textLote.getText()));
        bui.append(StringUtil.getTag(TAG_CODIGO, this.textCodigo.getText()));
        bui.append(StringUtil.getTag(TAG_CHAVE, this.textChave.getText()));
        bui.append(StringUtil.getTag(TAG_AGENTE, this.textAgente.getText()));
        bui.append(StringUtil.getTag(TAG_SENHA, this.textSenha.getText()));
        bui.append(StringUtil.getTag(TAG_ENDERECO_WS, this.textEndWebService.getText()));
        bui.append(StringUtil.getTag(TAG_ENDERECO_RESULTADO, this.textEndResultado.getText()));
        bui.append(StringUtil.getTag(TAG_ENVIAR_MEDICO, this.checkMedico.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_LOTE_WS, this.checkEnviaLoteUsandoWebService.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_PROCESSAR_ENTER, this.checkEnterNoResultado.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIO_AUTOMATICO, this.checkEnvioAutomatico.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_IMPORTAR_LISTA_XLS, this.checkImportarXls.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_URGENTE, this.checkUrgente.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_IMPORTAR_RESULTADO_PDF, this.checkImportarResultadoPdf.isSelected() ? "true" : "false"));
        return bui.append("</alvaro>").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "alvaro");
            this.textLote.setText(StringUtil.getValor(xml, TAG_LOTE));
            this.textCodigo.setText(StringUtil.getValor(xml, TAG_CODIGO));
            this.textChave.setText(StringUtil.getValor(xml, TAG_CHAVE));
            this.textAgente.setText(StringUtil.getValor(xml, TAG_AGENTE));
            this.textSenha.setText(StringUtil.getValor(xml, TAG_SENHA));
            this.textEndWebService.setText(StringUtil.getValor(xml, TAG_ENDERECO_WS));
            this.textEndResultado.setText(StringUtil.getValor(xml, TAG_ENDERECO_RESULTADO));
            this.checkImportarResultadoPdf.setSelected(StringUtil.getBoolean(xml, TAG_IMPORTAR_RESULTADO_PDF));
            this.checkMedico.setSelected(StringUtil.getValor(xml, TAG_ENVIAR_MEDICO).trim().length() > 0 ? StringUtil.getBoolean(xml, TAG_ENVIAR_MEDICO) : false);
            this.checkEnviaLoteUsandoWebService.setSelected(StringUtil.getValor(xml, TAG_ENVIAR_LOTE_WS).trim().length() > 0 ? StringUtil.getBoolean(xml, TAG_ENVIAR_LOTE_WS) : false);
            this.checkEnterNoResultado.setSelected(StringUtil.getValor(xml, TAG_PROCESSAR_ENTER).trim().length() > 0 ? StringUtil.getBoolean(xml, TAG_PROCESSAR_ENTER) : false);
            this.checkEnvioAutomatico.setSelected(StringUtil.getValor(xml, TAG_ENVIO_AUTOMATICO).trim().length() > 0 ? StringUtil.getBoolean(xml, TAG_ENVIO_AUTOMATICO) : false);
            this.checkImportarXls.setSelected(StringUtil.getValor(xml, TAG_IMPORTAR_LISTA_XLS).trim().length() > 0 ? StringUtil.getBoolean(xml, TAG_IMPORTAR_LISTA_XLS) : false);
            this.checkUrgente.setSelected(StringUtil.getValor(xml, TAG_ENVIAR_URGENTE).trim().length() > 0 ? StringUtil.getBoolean(xml, TAG_ENVIAR_URGENTE) : false);
        }
    }

    protected void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        JLabel lblChave = ComponenteFactory.novoJLabel("Chave:", new Dimension(85, 20));
        lblChave.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblChave, cons);
        cons.gridx = 1;
        this.textChave = new TTextField(16, 3);
        this.textChave.setPreferredSize(new Dimension(150, 20));
        this.textChave.setMinimumSize(new Dimension(150, 20));
        this.getPanelCentral().add((Component)this.textChave, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        JLabel lblCodigo = ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(85, 20));
        lblCodigo.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblCodigo, cons);
        cons.gridx = 1;
        this.textCodigo.setPreferredSize(new Dimension(200, 20));
        this.textCodigo.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(85, 20));
        lblLote.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        this.textLote.setPreferredSize(new Dimension(200, 20));
        this.textLote.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        JLabel lblAgente = ComponenteFactory.novoJLabel("Agente:", new Dimension(85, 20));
        lblAgente.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblAgente, cons);
        cons.gridx = 1;
        this.textAgente.setPreferredSize(new Dimension(200, 20));
        this.textAgente.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textAgente, cons);
        this.textSenha.setHorizontalAlignment(4);
        cons.gridx = 0;
        cons.gridy = 4;
        JLabel lblSenha = ComponenteFactory.novoJLabel("Senha:", new Dimension(85, 20));
        lblSenha.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblSenha, cons);
        cons.gridx = 1;
        this.textSenha.setPreferredSize(new Dimension(200, 20));
        this.textSenha.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textSenha, cons);
        cons.gridx = 0;
        cons.gridy = 5;
        JLabel lblService = ComponenteFactory.novoJLabel("Web Services:", new Dimension(100, 20));
        lblSenha.setMinimumSize(new Dimension(100, 20));
        this.getPanelCentral().add((Component)lblService, cons);
        cons.gridx = 1;
        this.textEndWebService.setPreferredSize(new Dimension(200, 20));
        this.textEndWebService.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textEndWebService, cons);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridx = 0;
        cons.gridy = 6;
        JLabel lblResultado = ComponenteFactory.novoJLabel("Web Service resultado:", new Dimension(100, 20));
        this.getPanelCentral().add((Component)lblResultado, cons);
        cons.gridx = 1;
        this.textEndResultado.setPreferredSize(new Dimension(200, 20));
        this.textEndResultado.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textEndResultado, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkEnviaLoteUsandoWebService, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridy = 8;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkMedico, cons);
        cons.gridx = 0;
        cons.gridy = 8;
        cons.gridy = 9;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkEnterNoResultado, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        this.checkEnvioAutomatico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorProtocoloAlvaro.this.checkEnvioAutomatico.isSelected()) {
                    ConfiguradorProtocoloAlvaro.this.checkEnviaLoteUsandoWebService.setSelected(true);
                }
            }
        });
        this.checkEnviaLoteUsandoWebService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ConfiguradorProtocoloAlvaro.this.checkEnviaLoteUsandoWebService.isSelected()) {
                    ConfiguradorProtocoloAlvaro.this.checkEnvioAutomatico.setSelected(false);
                }
            }
        });
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkImportarXls, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkUrgente, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkImportarResultadoPdf, cons);
        this.textChave.setHorizontalAlignment(4);
        this.pack();
        this.setSize(new Dimension(360, 350));
        this.textChave.setHorizontalAlignment(4);
        this.pack();
        this.setSize(new Dimension(410, 390));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textChave);
    }

    public boolean isImportarResultadoPdf() {
        return this.checkImportarResultadoPdf.isSelected();
    }

    @Override
    public boolean acaoOk() {
        if (this.checkEnviaLoteUsandoWebService.isSelected()) {
            if (Funcoes.textoVazio(this.textAgente.getText())) {
                Funcoes.mensagem(this, "Informe o campo agente.", 2);
                ScreenUtil.requisitarFoco(this.textAgente);
                return false;
            }
            if (Funcoes.textoVazio(this.textSenha.getText())) {
                Funcoes.mensagem(this, "Informe o campo senha.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return false;
            }
            if (Funcoes.textoVazio(this.textEndWebService.getText())) {
                Funcoes.mensagem(this, "Informe o campo web services.", 2);
                ScreenUtil.requisitarFoco(this.textEndWebService);
                return false;
            }
        }
        if (Funcoes.textoVazio(this.textChave.getText()) || this.textChave.getText().trim().length() != 16) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado uma chave v\u00e1lida", 2);
            ScreenUtil.requisitarFoco(this.textChave);
        } else if (!this.textCodigo.getText().matches("\\d+")) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um c\u00f3digo v\u00e1lido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
        } else {
            return true;
        }
        return false;
    }
}

