/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.alvaro.Antibiograma;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfiguradorAntibiograma
extends JDialog
implements ActionListener {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private TTextField txtAntibiotico = new TTextField(3, 1);
    private TTextField txtResistencia = new TTextField(3, 1);
    private TTextField txtMic = new TTextField(3, 1);
    private JLabel labelAntibiotico = new JLabel("Antibiotico: ");
    private JLabel labelResistencia = new JLabel("Resistencia: ");
    private JLabel labelMic = new JLabel("Mic: ");
    private JLabel labelAjusteModal = new JLabel("   ");
    private transient Antibiograma antibiograma = new Antibiograma();

    public static ConfiguradorAntibiograma novaInstancia(Object pai, String exameAlvaro, Antibiograma antibiograma) {
        return pai instanceof Frame ? new ConfiguradorAntibiograma((Frame)pai, exameAlvaro, antibiograma) : new ConfiguradorAntibiograma((Dialog)pai, exameAlvaro, antibiograma);
    }

    public ConfiguradorAntibiograma(Frame owner, String exameAlvaro, Antibiograma antibiograma) {
        super(owner, exameAlvaro);
        this.antibiograma = antibiograma;
        try {
            this.jbInit();
            this.repaint();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public ConfiguradorAntibiograma(Dialog owner, String exameAlvaro, Antibiograma antibiograma) {
        super(owner, exameAlvaro);
        this.antibiograma = antibiograma;
        try {
            this.jbInit();
            this.repaint();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setSize(195, 165);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonSalvar.setVisible(true);
        this.buttonCancelar.setVisible(true);
        this.panelTopo.add(this.txtAntibiotico);
        this.panelTopo.add(this.txtResistencia);
        this.panelTopo.add(this.txtMic);
        this.panelTopo.add(this.labelAntibiotico);
        this.panelTopo.add(this.labelResistencia);
        this.panelTopo.add(this.labelMic);
        this.txtAntibiotico.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.txtAntibiotico.setHorizontalAlignment(2);
        this.txtResistencia.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.txtResistencia.setHorizontalAlignment(2);
        this.txtMic.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.txtMic.setHorizontalAlignment(2);
        this.buttonSalvar.setBounds(10, 10, 20, 20);
        this.labelAjusteModal.setBounds(165, 15, 50, 20);
        this.labelAntibiotico.setBounds(8, 15, 150, 14);
        this.labelResistencia.setBounds(8, 40, 150, 14);
        this.labelMic.setBounds(8, 65, 150, 14);
        this.txtAntibiotico.setBounds(118, 15, 40, 20);
        this.txtResistencia.setBounds(118, 40, 40, 20);
        this.txtMic.setBounds(118, 65, 40, 20);
        this.panelTopo.add(this.labelAjusteModal);
        this.buttonSalvar.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.txtAntibiotico.setText(this.antibiograma.getAntibiotico().isEmpty() ? "35" : this.antibiograma.getAntibiotico());
        this.txtResistencia.setText(this.antibiograma.getAntibiotico().isEmpty() ? "15" : this.antibiograma.getResistencia());
        this.txtMic.setText(this.antibiograma.getMic().isEmpty() ? "9" : this.antibiograma.getMic());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ConfiguradorAntibiograma.this.txtAntibiotico.grabFocus();
            }
        });
        this.buttonSalvar.addActionListener(action -> {
            if (this.validaCamposVazios() && this.validaCamposValoresInvalidos()) {
                this.antibiograma.setAntibiotico(this.txtAntibiotico.getText());
                this.antibiograma.setResistencia(this.txtResistencia.getText());
                this.antibiograma.setMic(this.txtMic.getText());
                this.setVisible(false);
                return;
            }
            Funcoes.showAlertaOK(Laboratorio.getInstancia(), "A quantidade de caracteres dos campos n\u00e3o deve ser vazia nem menor ou igual a zero");
        });
        this.buttonCancelar.addActionListener(action -> this.dispose());
    }

    public boolean validaCamposVazios() {
        return !Funcoes.textoVazio(this.txtAntibiotico) && !Funcoes.textoVazio(this.txtResistencia) && !Funcoes.textoVazio(this.txtMic);
    }

    public boolean validaCamposValoresInvalidos() {
        return Integer.valueOf(this.txtAntibiotico.getText()) > 0 && Integer.valueOf(this.txtResistencia.getText()) > 0 && Integer.valueOf(this.txtMic.getText()) > 0;
    }

    public Antibiograma getBiograma() {
        return this.antibiograma;
    }

    public void setBiograma(Antibiograma biograma) {
        this.antibiograma = biograma;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

