/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.alvaro;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.alvaro.Antibiograma;
import jalis.laboratorio.util.parsers.alvaro.ConfiguradorAntibiograma;
import jalis.laboratorio.util.parsers.alvaro.DadoAdicional;
import jalis.laboratorio.util.parsers.alvaro.EditarTempoLinhaResultado;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.laboratorio.util.parsers.alvaro.Tempos;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorAlvaro
extends AbstractConfigurador
implements ListSelectionListener {
    private static final int[] COLUNAS_RESULTADOS = new int[]{75, 0, 150};
    private static final int[] COLUNAS_DADOS_ADICIONAIS = new int[]{0, 40};
    private static final int[] COLUNAS_EXAMES = new int[]{125, 0, 90};
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String MATERIAL = "material";
    private static final String OBJ_EXAME_ALVARO = "objExameAlvaro";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "material");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, COLUNAS_EXAMES);
    private JTextField textLocalizar = new JTextField();
    private ModeloResultSet modDadosAdicionais = new ModeloResultSet("Dado Adicional", "dadoAdicional", "Sel", "selecionado");
    private JTable tableDadosAdicionais = ComponenteFactory.novoJTable((TableModel)this.modDadosAdicionais, null, COLUNAS_DADOS_ADICIONAIS);
    private JScrollPane scrollDadosAdicionais = new JScrollPane(this.tableDadosAdicionais);
    private ModeloResultSet modLinhasResultados = new ModeloResultSet("C\u00f3digo", "codigo", "Descri\u00e7\u00e3o", "descricao", "Tempos", "tempos");
    private JTable tableLinhasResultados = ComponenteFactory.novoJTable((TableModel)this.modLinhasResultados, null, COLUNAS_RESULTADOS);
    private JScrollPane scrollLinhasResultados = new JScrollPane(this.tableLinhasResultados);
    private JCheckBox checkImportarResultadoPDF = new JCheckBox("Importar resultado no formato PDF");
    private JButton buttonAntibiograma = new JButton("Configura\u00e7\u00e3o Antibiograma");
    private transient Antibiograma antibiograma = new Antibiograma();
    private String xmlSelecionado = "";

    public ConfiguradorAlvaro(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Alvaro", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorAlvaro(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Alvaro", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorAlvaro(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorAlvaro(Dialog pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameAlvaro.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameAlvaro exa = new ExameAlvaro(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.equals(reg.getValor(OBJ_EXAME_ALVARO))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                this.checkImportarResultadoPDF.setSelected(exa.isFormatoPDF());
                this.setXmlDadosAdicionais(exa);
                this.setXmlLinhaResultados(exa);
                break;
            }
        }
    }

    private void setXmlDadosAdicionais(ExameAlvaro exa) {
        for (int j = 0; j < this.modDadosAdicionais.getRowCount(); ++j) {
            Registro r = this.modDadosAdicionais.getRegistro(j);
            for (DadoAdicional dado : exa.getDadosAdicionais()) {
                if (!dado.toString().equals(r.getValor("dadoAdicional").toString())) continue;
                r.setValor("selecionado", Boolean.TRUE);
            }
        }
    }

    private void setXmlLinhaResultados(ExameAlvaro exa) {
        for (int j = 0; j < this.modLinhasResultados.getRowCount(); ++j) {
            Registro r = this.modLinhasResultados.getRegistro(j);
            for (LinhaResultado linha : exa.getLinhasResultado()) {
                if (!linha.getCodigo().equalsIgnoreCase(r.getValor("codigo").toString())) continue;
                r.setValor("tempos", new Tempos(linha.getTempos()));
            }
        }
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null) {
            ExameAlvaro exa = new ExameAlvaro(xml);
            return exa.getDescricao();
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameAlvaro exa = new ExameAlvaro(xml);
            return exa.getMaterial() + "|" + exa.getCodigo() + "|1";
        }
        return "";
    }

    public static ConfiguradorAlvaro novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorAlvaro((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorAlvaro((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.scrollDadosAdicionais.setPreferredSize(new Dimension(650, 100));
        this.modDadosAdicionais.setColunaEditavel("selecionado");
        TableColumn col = this.tableDadosAdicionais.getColumnModel().getColumn(1);
        col.setMinWidth(30);
        col.setMaxWidth(30);
        this.buttonAntibiograma.setSize(30, 10);
        this.scrollLinhasResultados.setPreferredSize(new Dimension(650, 100));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Dados Adicionais", (Component)this.scrollDadosAdicionais, null, null, null, null), "Center");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Linhas Resultados", (Component)this.scrollLinhasResultados, null, null, null, null), "South");
        this.getPanelBotoesEsquerda().add(this.checkImportarResultadoPDF);
        this.getPanelBotoesEsquerda().add(this.buttonAntibiograma);
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
        this.buttonAntibiograma.addActionListener(action -> this.configuradorAntibiograma());
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorAlvaro.this.modExa.filtrar(ConfiguradorAlvaro.DESC_EXA, ConfiguradorAlvaro.this.textLocalizar.getText());
                if (ConfiguradorAlvaro.this.modExa.getRowCount() > 0) {
                    ConfiguradorAlvaro.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorAlvaro.this.tableExa.hasFocus() && (row = ConfiguradorAlvaro.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorAlvaro.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorAlvaro.this.tableExa.scrollRectToVisible(ConfiguradorAlvaro.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorAlvaro.this.tableExa.hasFocus() && (row = ConfiguradorAlvaro.this.tableExa.getSelectedRow()) < ConfiguradorAlvaro.this.tableExa.getRowCount() - 1) {
                    ConfiguradorAlvaro.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorAlvaro.this.tableExa.scrollRectToVisible(ConfiguradorAlvaro.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap(this.tableLinhasResultados, KeyStroke.getKeyStroke(32, 0, false), "space", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorAlvaro.this.inserirTempoLinhaResultado(ConfiguradorAlvaro.this.tableLinhasResultados.getSelectedRow());
            }
        });
    }

    private void configuradorAntibiograma() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            ConfiguradorAntibiograma antibiogramasVal = ConfiguradorAntibiograma.novaInstancia(this, ((ExameAlvaro)reg.getValor(OBJ_EXAME_ALVARO)).getCodigo(), ((ExameAlvaro)reg.getValor(OBJ_EXAME_ALVARO)).getAntibiograma());
            antibiogramasVal.setVisible(true);
            this.antibiograma = antibiogramasVal.getBiograma();
        }
        this.atualizarXMLSelecionado();
    }

    private void carregarExames() {
        for (ExameAlvaro exame : ExameAlvaro.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigo());
            reg.setValor(DESC_EXA, exame.getDescricao());
            reg.setValor(MATERIAL, exame.getMaterialDescricao());
            reg.setValor(OBJ_EXAME_ALVARO, exame);
            this.modExa.addRegistro(reg);
        }
    }

    @Override
    public boolean acaoOk() {
        ExameAlvaro exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private boolean atualizarXMLSelecionado() {
        ExameAlvaro exa = this.getExameSelecionado();
        if (exa != null) {
            ArrayList<DadoAdicional> dados = new ArrayList<DadoAdicional>();
            exa.setFormatoPDF(this.checkImportarResultadoPDF.isSelected());
            this.adicionaDadosAdicionais(dados);
            for (int i = 0; i < this.modLinhasResultados.getRowCount(); ++i) {
                Registro r = this.modLinhasResultados.getRegistro(i);
                if (r.getValor("tempos") == null) {
                    Funcoes.mensagem(this, "A linha de resultado: " + r.getValor("descricao").toString() + " esta sem tempo!", 1);
                    return false;
                }
                this.adicionaLinhaResultadoTempos(exa, r);
            }
            exa.setAntibiograma(this.antibiograma);
            exa.setDadosAdicionais(dados);
            this.xmlSelecionado = exa.getXml();
            return true;
        }
        return false;
    }

    private void adicionaLinhaResultadoTempos(ExameAlvaro exa, Registro r) {
        for (LinhaResultado l : exa.getLinhasResultado()) {
            if (!l.getCodigo().equalsIgnoreCase(r.getValor("codigo").toString())) continue;
            for (String tempo : ((Tempos)r.getValor("tempos")).getTempos()) {
                l.addTempo(tempo);
            }
        }
    }

    private void adicionaDadosAdicionais(List<DadoAdicional> dados) {
        for (int i = 0; i < this.modDadosAdicionais.getRowCount(); ++i) {
            Registro r = this.modDadosAdicionais.getRegistro(i);
            if (!r.contemValor("selecionado", Boolean.TRUE)) continue;
            dados.add((DadoAdicional)r.getValor("dadoAdicional"));
        }
    }

    private ExameAlvaro getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameAlvaro)reg.getValor(OBJ_EXAME_ALVARO);
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.antibiograma = new ExameAlvaro(this.xmlSelecionado).getAntibiograma();
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.atualizarDadosAdicionais((ExameAlvaro)reg.getValor(OBJ_EXAME_ALVARO));
            this.atualizarLinhasResultados((ExameAlvaro)reg.getValor(OBJ_EXAME_ALVARO));
            this.atualizarAntibiograma((ExameAlvaro)reg.getValor(OBJ_EXAME_ALVARO));
        }
    }

    private void atualizarAntibiograma(ExameAlvaro exameSelecionado) {
        exameSelecionado.setAntibiograma(this.antibiograma);
    }

    private void atualizarDadosAdicionais(ExameAlvaro exame) {
        this.modDadosAdicionais.limpar();
        if (!exame.getDadosAdicionais().isEmpty()) {
            for (DadoAdicional dado : exame.getDadosAdicionais()) {
                Registro r = new Registro();
                r.setValor("dadoAdicional", dado);
                String xmlExame = StringUtil.getValor(this.xmlSelecionado, "exame");
                boolean semDado = true;
                for (String xmlDado : StringUtil.getValores(this.xmlSelecionado, "dado")) {
                    if (StringUtil.getValor(xmlExame, "codigo").equals(exame.getCodigo()) && StringUtil.getValor(xmlDado, "descricao").equals(dado.getDescricao()) && StringUtil.getValor(xmlDado, "unidade").equals(dado.getUnidade())) {
                        r.setValor("selecionado", Boolean.TRUE);
                        semDado = false;
                        break;
                    }
                    r.setValor("selecionado", Boolean.FALSE);
                }
                if (semDado) {
                    r.setValor("selecionado", Boolean.FALSE);
                }
                this.modDadosAdicionais.addRegistro(r);
            }
        }
    }

    private void atualizarLinhasResultados(ExameAlvaro exame) {
        this.modLinhasResultados.limpar();
        if (!exame.getLinhasResultado().isEmpty()) {
            for (LinhaResultado l : exame.getLinhasResultado()) {
                String descricao = l.getDescricao();
                if (descricao.indexOf("$$") < 0) continue;
                Registro r = new Registro();
                r.setValor("codigo", l.getCodigo());
                r.setValor("descricao", descricao.substring(0, descricao.indexOf("$$")));
                r.setValor("tempos", new Tempos(l.getTempos()));
                this.modLinhasResultados.addRegistro(r);
            }
        }
    }

    private void inserirTempoLinhaResultado(int row) {
        if (row < 0) {
            return;
        }
        Registro r = this.modLinhasResultados.getRegistro(row);
        EditarTempoLinhaResultado tela = new EditarTempoLinhaResultado(this, r.getValor("descricao").toString(), r.getValor("tempos"));
        tela.setVisible(true);
        r.setValor("tempos", tela.getTempos());
        this.repaint();
    }
}

