/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JDialog;

public class RelatorioImportacaoResultadoUtil {
    private static final int COLUNA_REQUISICAO = 0;
    private static final int COLUNA_EXAME = 8;
    private static final int COLUNA_FILIAL = 21;
    private static final int COLUNA_SITUACAO = 20;
    private static final String LANCADO = "Lan\u00e7ado";

    public static ModeloGridTable novoModeloGridTable() {
        ModeloGridTable mod = new ModeloGridTable(new String[]{"codigoRequisicao", "idadePaciente", "codigoRequisicaoApoio", "codigoFilialCodigoRequisicao", "anoMesPaciente", "observacaoRequisicao", "dataRequisicao", "horaRequisicao", "codigoExame", "descricaoExame", "nomePaciente", "dataNascimentoPaciente", "sexoPaciente", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "situacaoExame", "codigoFilial", "descricaoFilial", "codigoLote", "dataLote"});
        return mod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adicionarAoModeloRelatorio(Component owner, int labexterno, ModeloGridTable modeloRelatorio, String filial, String requisicao, String exame, Integer codigoMaterial, String situacao) {
        Statement st = Conexao.getStatement();
        if (requisicao != null && exame != null) {
            try {
                boolean agruparMultiguia;
                ArrayList<String> requisicoes = new ArrayList<String>();
                requisicoes.add(requisicao);
                boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filial, requisicao);
                if (agruparMultiguia) {
                    requisicoes = BDUtil.getReqMultiGuias(filial, requisicao);
                }
                for (String req : requisicoes) {
                    StringBuilder sql = RelatorioImportacaoResultadoUtil.getSql(filial, labexterno, req, exame, codigoMaterial);
                    ResultSet rs = Conexao.executeQuery(st, sql);
                    if (!rs.next()) continue;
                    int colunas = modeloRelatorio.getColumnCount();
                    Object[] linha = new Object[colunas];
                    for (int i = 0; i < colunas; ++i) {
                        int pos = rs.findColumn(modeloRelatorio.getColumnName(i)) - 1;
                        if (pos <= -1) continue;
                        linha[pos] = rs.getObject(modeloRelatorio.getColumnName(i));
                        if (RelatorioImportacaoResultadoUtil.validaColuna(modeloRelatorio.getColumnName(i), "codigoFilialCodigoRequisicao")) {
                            linha[pos] = Funcoes.preencheZero(rs.getInt("codigoFilial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(rs.getInt("codigoRequisicao"), ParametrosGerais.getDigitosTuboRequisicao());
                            continue;
                        }
                        if (!RelatorioImportacaoResultadoUtil.validaColuna(modeloRelatorio.getColumnName(i), "situacaoExame")) continue;
                        linha[pos] = situacao;
                    }
                    if (RelatorioImportacaoResultadoUtil.possuiExameRequisicao(filial, req, exame, modeloRelatorio)) continue;
                    modeloRelatorio.addLine(linha);
                }
            }
            catch (SQLException sqlex) {
                try {
                    ErrorLogger.mostraMensagem(owner, sqlex.getMessage(), sqlex.getStackTrace(), "RelatorioImportacaoResultadoUtil 99");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private static void verificaSituacaoExameDesmembrado(String filial, String requisicao, String exame, String situacao, ModeloGridTable modeloRelatorio) {
        for (int i = 0; i < modeloRelatorio.getRowCount(); ++i) {
            Integer req = (Integer)modeloRelatorio.getValueAt(i, 0);
            String exa = (String)modeloRelatorio.getValueAt(i, 8);
            Integer filAux = (Integer)modeloRelatorio.getValueAt(i, 21);
            String fil = Funcoes.preencheZero(filAux, ParametrosGerais.getDigitosTuboFilial());
            String sit = (String)modeloRelatorio.getValueAt(i, 20);
            if (req != Integer.parseInt(requisicao) || !exa.equalsIgnoreCase(exame) || !fil.equals(filial) || sit.equals(situacao) || sit.equalsIgnoreCase(LANCADO)) continue;
            modeloRelatorio.setValueAt(situacao, i, 20);
        }
    }

    private static boolean validaColuna(String columnName, String nomeCampo) {
        return columnName.equalsIgnoreCase(nomeCampo);
    }

    private static boolean possuiExameRequisicao(String filial, String requisicao, String exame, ModeloGridTable modeloRelatorio) {
        for (int i = 0; i < modeloRelatorio.getRowCount(); ++i) {
            Integer req = (Integer)modeloRelatorio.getValueAt(i, 0);
            String exa = (String)modeloRelatorio.getValueAt(i, 8);
            Integer filAux = (Integer)modeloRelatorio.getValueAt(i, 21);
            String fil = Funcoes.preencheZero(filAux, ParametrosGerais.getDigitosTuboFilial());
            if (req != Integer.parseInt(requisicao) || !exa.equalsIgnoreCase(exame) || !fil.equals(filial)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adicionarAoModeloRelatorio(Component owner, int labexterno, ModeloGridTable modeloRelatorio, String filial, String requisicao, String exame, Integer codigoMaterial, String situacao, boolean labAlvaro) {
        Statement st = Conexao.getStatement();
        if (requisicao != null && exame != null) {
            try {
                boolean agruparMultiguia;
                ArrayList<String> requisicoes = new ArrayList<String>();
                requisicoes.add(requisicao);
                boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filial, requisicao);
                if (agruparMultiguia) {
                    requisicoes = BDUtil.getReqMultiGuias(filial, requisicao);
                }
                for (String req : requisicoes) {
                    StringBuilder sql = RelatorioImportacaoResultadoUtil.getSql(filial, labexterno, req, exame, codigoMaterial);
                    ResultSet rs = Conexao.executeQuery(st, sql);
                    if (!rs.next()) continue;
                    int colunas = modeloRelatorio.getColumnCount();
                    Object[] linha = new Object[colunas];
                    for (int i = 0; i < colunas; ++i) {
                        int pos = rs.findColumn(modeloRelatorio.getColumnName(i)) - 1;
                        if (pos <= -1) continue;
                        linha[pos] = rs.getObject(modeloRelatorio.getColumnName(i));
                        if (RelatorioImportacaoResultadoUtil.validaColuna(modeloRelatorio.getColumnName(i), "codigoFilialCodigoRequisicao")) {
                            linha[pos] = Funcoes.preencheZero(rs.getInt("codigoFilial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(rs.getInt("codigoRequisicao"), ParametrosGerais.getDigitosTuboRequisicao());
                            continue;
                        }
                        if (!RelatorioImportacaoResultadoUtil.validaColuna(modeloRelatorio.getColumnName(i), "situacaoExame")) continue;
                        linha[pos] = situacao;
                    }
                    if (!RelatorioImportacaoResultadoUtil.possuiExameRequisicao(filial, req, exame, modeloRelatorio)) {
                        modeloRelatorio.addLine(linha);
                    }
                    RelatorioImportacaoResultadoUtil.verificaSituacaoExameDesmembrado(filial, req, exame, situacao, modeloRelatorio);
                }
            }
            catch (SQLException sqlex) {
                try {
                    ErrorLogger.mostraMensagem(owner, sqlex.getMessage(), sqlex.getStackTrace(), "RelatorioImportacaoResultadoUtil 99");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private static StringBuilder getSql(String filial, int labexterno, String requisicao, String exame, Integer codigoMaterial) {
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.req_codigo as codigoRequisicao, a.req_idade as idadePaciente, \n");
        sql.append("\trle.rle_codigo as codigoRequisicaoApoio, '' as codigoFilialCodigoRequisicao, \n");
        sql.append("  a.req_anomes as anoMesPaciente, a.req_obs as observacaoRequisicao, \n");
        sql.append("  a.req_data as dataRequisicao, a.req_hora as horaRequisicao, \n");
        sql.append("  c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame, \n");
        sql.append("  d.pac_nome as nomePaciente, d.pac_datanasc as dataNascimentoPaciente, d.pac_sexo as sexoPaciente, \n");
        sql.append("  e.med_conselho as conselhoMedico, e.med_crm as crmMedico, e.med_uf as ufMedico, e.med_nome as nomeMedico, \n");
        sql.append("  f.mco_codigo as codigoMaterialColetado, f.mco_descricao as descricaoMaterialColetado, \n");
        sql.append("  f.mco_abreviatura as abreviaturaMaterialColetado, '' as situacaoExame, a.fil_codigo as codigoFilial, fil.fil_descricao as descricaoFilial, \n");
        sql.append("\tlex.lex_codigo as codigoLote, lex.lex_datahora as dataLote ");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b \n");
        sql.append("  on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join exames c \n");
        sql.append("  on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo \n");
        sql.append("left join paciente d \n");
        sql.append("  on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo \n");
        sql.append("left join medico e \n");
        sql.append("  on a.fil_codigo = e.fil_codigo and a.med_conselho = e.med_conselho and a.med_crm = e.med_crm and a.med_uf = e.med_uf \n");
        sql.append("left join materialcoleta f \n");
        sql.append("  on a.fil_codigo = f.fil_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append("left join loteexternorequisicao lexreq \n");
        sql.append("\ton a.fil_codigo = a.fil_codigo and a.req_codigo = lexreq.req_codigo \n");
        sql.append("left join loteexterno lex \n");
        sql.append("\ton a.fil_codigo = lex.fil_codigo and lexreq.lex_codigo = lex.lex_codigo and lexreq.lae_codigo = lex.lae_codigo \n");
        sql.append("left join requisicaolabexterno rle \n");
        sql.append("\ton a.fil_codigo = rle.fil_codigo ");
        sql.append("\t\tand lexreq.lae_codigo = rle.lae_codigo ");
        sql.append("\t\tand lexreq.req_codigo = rle.req_codigo ");
        sql.append("left join filiais_postocoleta fil on a.fil_codigo = fil.fil_codigo ");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(filial).append(" and \n");
        sql.append("  a.req_codigo = ").append(requisicao).append(" and \n");
        sql.append("  b.exa_codigo = '").append(exame).append("' and \n");
        sql.append("  b.mco_codigo = ").append(codigoMaterial).append(" and \n");
        sql.append("\trle.lae_codigo = ").append(labexterno);
        sql.append(" and a.req_excluida = false and b.exr_excluido = false ");
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imprimirRelatorio(Component owner, ModeloGridTable modeloRelatorio) {
        Statement st;
        block5: {
            if (modeloRelatorio.getRowCount() <= 0) {
                return;
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.delete(0, buf.length());
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioSituacaoLote.getModuloAcesso());
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block5;
                RelatorioImportacaoResultadoUtil.ordernaRelatorio(modeloRelatorio);
                final JDialog dialogo = new JDialog(Laboratorio.getInstancia());
                dialogo.setSize(new Dimension(750, 600));
                dialogo.getContentPane().setLayout(new BorderLayout());
                dialogo.setModal(true);
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        dialogo.dispose();
                    }
                });
                gerador.executar(rs.getString("rel_xml"), modeloRelatorio);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace(), "RelatorioImportacaoResultadoUtil 187");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    private static void ordernaRelatorio(ModeloGridTable modeloRelatorio) {
        ArrayList<HashMap<String, Object>> mod = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < modeloRelatorio.getRowCount(); ++i) {
            mod.add(modeloRelatorio.getLine(i));
        }
        Collections.sort(mod, new Comparator<HashMap<String, Object>>(){

            @Override
            public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                if (o1.get("codigoFilial") instanceof Integer && o1.get("codigoRequisicao") instanceof Integer && o2.get("codigoFilial") instanceof Integer && o2.get("codigoRequisicao") instanceof Integer) {
                    return (String.valueOf(o1.get("codigoFilial")) + String.valueOf(o1.get("codigoRequisicao"))).compareTo(String.valueOf(o2.get("codigoFilial")) + String.valueOf(o2.get("codigoRequisicao")));
                }
                return 0;
            }
        });
        modeloRelatorio.clear();
        for (HashMap hashMap : mod) {
            int colunas = modeloRelatorio.getColumnCount();
            Object[] linha = new Object[colunas];
            for (int i = 0; i < colunas; ++i) {
                linha[i] = hashMap.get(modeloRelatorio.getColumnName(i));
            }
            modeloRelatorio.addLine(linha);
        }
    }
}

