/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;

public class ProtocoloCampoImportacao {
    public final Protocolo protocolo;
    public final String campoImportacao;
    public String versao;
    public boolean alteracao = false;
    public boolean exclusao = false;

    public ProtocoloCampoImportacao(Protocolo protocolo, String campoImportacao, String versaoExclusao, boolean exclusao) {
        Funcoes.validarNaoNull(campoImportacao, "campoImportacao");
        this.protocolo = protocolo;
        this.campoImportacao = campoImportacao;
        this.exclusao = exclusao;
        this.versao = versaoExclusao;
    }

    public ProtocoloCampoImportacao(Protocolo protocolo, String campoImportacao) {
        Funcoes.validarNaoNull(campoImportacao, "campoImportacao");
        this.protocolo = protocolo;
        this.campoImportacao = campoImportacao;
        this.versao = "0";
        if (campoImportacao.indexOf("~") > -1 && this.protocoloUsaComboVersoesPorExame(protocolo)) {
            this.versao = campoImportacao.substring(campoImportacao.indexOf("~") + 1, campoImportacao.indexOf("|"));
        }
    }

    private boolean protocoloUsaComboVersoesPorExame(Protocolo protocolo) {
        return protocolo.equals((Object)Protocolo.HPardini) || protocolo.equals((Object)Protocolo.INDLab) || protocolo.equals((Object)Protocolo.MercolabWS) || protocolo.equals((Object)Protocolo.Shift);
    }

    public boolean isAlteracao() {
        return this.alteracao;
    }

    public void setAlteracao(boolean alteracao) {
        this.alteracao = alteracao;
    }

    public boolean isExclusao() {
        return this.exclusao;
    }

    public void setExclusao(boolean exclusao) {
        this.exclusao = exclusao;
    }

    public boolean vazio() {
        return this.protocolo == null || this.campoImportacao == null || this.campoImportacao.trim().length() == 0;
    }
}

