/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

public enum Protocolo {
    SaoCamilo("S\u00e3o Camilo", true, true, false, "integracao/importar_exames_saocamilo", "integracao/importar_resultados_saocamilo"),
    DB("DB", true, true, false, "integracao/importar_exames_db", "integracao/importar_resultados_db"),
    DBV2("DBv2", true, true, false, "integracao/importar_exames_db", "integracao/importar_resultados_db"),
    Cerba("Cerba", true, true, true, "integracao/importar_exames_cerba", "integracao/importar_resultados_cerba"),
    Jalis("Jalis", true, true, false, "integracao/importar_exames_jalis", "integracao/importar_resultados_jalis"),
    HPardini("HPardini", true, true, false, "integracao/importar_exames_pardini", "integracao/importar_resultados_pardini", true, "", true, true, true),
    Alvaro("Alvaro", true, true, true, "integracao/importar_exames_alvaro", "integracao/importar_resultados_alvaro", true),
    SergioFranco("S\u00e9rgio Franco", true, true, true, "integracao/importar_exames_sergiofranco", "integracao/importar_resultados_sergiofranco"),
    Reacao("Rea\u00e7\u00e3o", true, true, true, "integracao/importar_exames_reacao", "integracao/importar_resultados_reacao"),
    Rede("Rede", true, false, true, "integracao/importar_exames_labrede", "integracao/importar_resultados_labrede"),
    Maricondi("Maricondi", true, true, false, "integracao/importar_exames_maricondi", "integracao/importar_resultados_maricondi"),
    Criesp("Criesp", true, true, false, "integracao/importar_exames_criesp", "integracao/importar_resultados_criesp"),
    Balague("Balague", true, true, false, "integracao/importar_exames_balague", "integracao/importar_resultados_balague"),
    Solucao("Solu\u00e7\u00e3o", true, true, true, "integracao/importar_exames_solucao", "integracao/importar_resultados_solucao"),
    Concent("Concent", true, true, true, "integracao/importar_exames_concent", "integracao/importar_resultados_concent", true),
    SolucaoV2("Solu\u00e7\u00e3oV2", true, true, true, "integracao/importar_exames_solucao", "integracao/importar_resultados_solucao"),
    Unilab("Unilab", true, true, true, "integracao/importar_exames_unilab", "integracao/importar_resultados_unilab"),
    Syslab("Syslab", true, true, true, "integracao/importar_exames_syslab", "integracao/importar_resultados_syslab"),
    SaoMarcos("S\u00e3o Marcos", true, true, true, "integracao/importar_exames_saomarcos", "integracao/importar_resultados_saomarcos"),
    RedeWS("RedeWS", true, true, false, "integracao/importar_exames_labrede", "integracao/importar_resultados_labrede"),
    INDLab("INDLab", true, true, false, "integracao/importar_exames_indlab", "integracao/importar_resultados_indlab"),
    JalisWS("Jalis WS", true, true, false, "integracao/importar_exames_jalis", "integracao/importar_resultados_jalis"),
    MercolabWS("MercolabWS", true, true, false, "integracao/importar_exames_mercolabws", "integracao/importar_resultados_mercolabws"),
    Shift("Shift", true, true, false, "integracao/importar_exames_shift", "integracao/importar_resultados_shift"),
    SoftLab("SoftLab", true, true, false, "integracao/importar_exames_softlab", "integracao/importar_resultados_softlab");

    private String nome;
    private boolean reimprimirEtiquetas = false;
    private boolean reimprimirRelatorio = false;
    private boolean exigeDataNascimento = false;
    private boolean importarExportarDePara = false;
    private boolean apresentarTermoAceite = false;
    private boolean importarModeloLayoutWeb = false;
    private boolean alertaReemiteEtiquetas = false;
    private static Protocolo[] protocolos;
    private String imgImpExames;
    private String imgImpResultado;
    private String pathArquivoDePara;

    private Protocolo(String nome, boolean reimprimeEtiquetas, boolean reimprimeRelatorio, boolean exigeDataNascimento) {
        this.nome = nome;
        this.reimprimirEtiquetas = reimprimeEtiquetas;
        this.reimprimirRelatorio = reimprimeRelatorio;
        this.exigeDataNascimento = exigeDataNascimento;
        this.imgImpExames = Protocolo.getProtocolo(nome).getImgImpExames(false);
        this.imgImpResultado = Protocolo.getProtocolo(nome).getImgImpResultado(false);
    }

    private Protocolo(String nome, boolean reimprimeEtiquetas, boolean reimprimeRelatorio, boolean exigeDataNascimento, String imgImpExames, String imgImpResultado) {
        this.nome = nome;
        this.reimprimirEtiquetas = reimprimeEtiquetas;
        this.reimprimirRelatorio = reimprimeRelatorio;
        this.exigeDataNascimento = exigeDataNascimento;
        this.imgImpExames = imgImpExames;
        this.imgImpResultado = imgImpResultado;
    }

    private Protocolo(String nome, boolean reimprimeEtiquetas, boolean reimprimeRelatorio, boolean exigeDataNascimento, String imgImpExames, String imgImpResultado, boolean alertaReemiteEtiquetas) {
        this.nome = nome;
        this.reimprimirEtiquetas = reimprimeEtiquetas;
        this.reimprimirRelatorio = reimprimeRelatorio;
        this.exigeDataNascimento = exigeDataNascimento;
        this.imgImpExames = imgImpExames;
        this.imgImpResultado = imgImpResultado;
        this.alertaReemiteEtiquetas = alertaReemiteEtiquetas;
    }

    private Protocolo(String nome, boolean reimprimeEtiquetas, boolean reimprimeRelatorio, boolean exigeDataNascimento, String imgImpExames, String imgImpResultado, boolean importarExportarDePara, String pathArquivoDePara, boolean apresentarTermoAceite, boolean importarModeloLayoutWeb, boolean alertaReemiteEtiquetas) {
        this.nome = nome;
        this.reimprimirEtiquetas = reimprimeEtiquetas;
        this.reimprimirRelatorio = reimprimeRelatorio;
        this.exigeDataNascimento = exigeDataNascimento;
        this.imgImpExames = imgImpExames;
        this.imgImpResultado = imgImpResultado;
        this.importarExportarDePara = importarExportarDePara;
        this.pathArquivoDePara = pathArquivoDePara;
        this.apresentarTermoAceite = apresentarTermoAceite;
        this.importarModeloLayoutWeb = importarModeloLayoutWeb;
        this.alertaReemiteEtiquetas = alertaReemiteEtiquetas;
    }

    public String getCodigo() {
        return this.nome;
    }

    public static Protocolo[] getProtocolos() {
        return Protocolo.values();
    }

    public static Protocolo getProtocolo(String nome) {
        for (Protocolo p : Protocolo.values()) {
            if (!p.nome.equals(nome)) continue;
            return p;
        }
        return null;
    }

    public String toString() {
        return this.getCodigo();
    }

    public String getDescricao() {
        return this.nome.replace("V2", "");
    }

    public boolean getReimprimirEtiquetas() {
        return this.reimprimirEtiquetas;
    }

    public boolean getReimprimirRelatorio() {
        return this.reimprimirRelatorio;
    }

    public boolean getExigeDataNascimento() {
        return this.exigeDataNascimento;
    }

    public String getImgImpExames(boolean foco) {
        return this.imgImpExames.concat(foco ? "_on" : "");
    }

    public String getImgImpResultado(boolean foco) {
        return this.imgImpResultado.concat(foco ? "_on" : "");
    }

    public boolean isImportarExportarDePara() {
        return this.importarExportarDePara;
    }

    public void setImportarExportarDePara(boolean importarExportarDePara) {
        this.importarExportarDePara = importarExportarDePara;
    }

    public String getPathArquivoDePara() {
        return this.pathArquivoDePara;
    }

    public void setPathArquivoDePara(String pathArquivoDePara) {
        this.pathArquivoDePara = pathArquivoDePara;
    }

    public boolean isApresentarTermoAceite() {
        return this.apresentarTermoAceite;
    }

    public void setApresentarTermoAceite(boolean apresentarTermoAceite) {
        this.apresentarTermoAceite = apresentarTermoAceite;
    }

    public boolean isImportarModeloLayoutWeb() {
        return this.importarModeloLayoutWeb;
    }

    public void setImportarModeloLayoutWeb(boolean importarModeloLayoutWeb) {
        this.importarModeloLayoutWeb = importarModeloLayoutWeb;
    }

    public boolean isAlertaReemiteEtiquetas() {
        return this.alertaReemiteEtiquetas;
    }

    public boolean permiteEstornoPorExame() {
        return this.equals((Object)INDLab) || this.equals((Object)MercolabWS);
    }

    static {
        protocolos = new Protocolo[]{Jalis, HPardini, Alvaro, Cerba, SergioFranco, Reacao, Rede, SaoCamilo, Maricondi, Criesp, DB, DBV2, Balague, Solucao, Concent, SolucaoV2, Unilab, Syslab, SaoMarcos, RedeWS, INDLab, JalisWS, MercolabWS, Shift, SoftLab};
    }
}

