/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers;

import jalis.util.Funcoes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class ParserUtil {
    public static List<List<String>> parserCsv(String csvTabela, String delimitadorDeCampo, String delimitadorDeTexto) {
        ArrayList<List<String>> linhas = new ArrayList<List<String>>();
        for (String linha : csvTabela.split("\n")) {
            ArrayList<String> campos = new ArrayList<String>();
            StringBuffer buf = new StringBuffer();
            boolean usaDelimitadorDeTexto = !Funcoes.textoVazio(delimitadorDeTexto);
            boolean foraDoTexto = true;
            for (int posicao = 0; posicao < linha.length(); ++posicao) {
                Character caracter = Character.valueOf(linha.charAt(posicao));
                if (usaDelimitadorDeTexto) {
                    if (caracter.toString().equals(delimitadorDeTexto)) {
                        foraDoTexto = !foraDoTexto;
                        continue;
                    }
                    if (foraDoTexto && caracter.toString().equals(delimitadorDeCampo)) {
                        campos.add(buf.toString());
                        buf.delete(0, buf.length());
                        continue;
                    }
                    if (foraDoTexto) continue;
                    buf.append(caracter);
                    continue;
                }
                if (caracter.toString().equals(delimitadorDeCampo)) {
                    campos.add(buf.toString());
                    buf.delete(0, buf.length());
                    continue;
                }
                buf.append(caracter);
            }
            if (buf.length() > 0) {
                campos.add(buf.toString());
                buf.delete(0, buf.length());
            }
            linhas.add(campos);
        }
        return linhas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumeroLinhas(File file) {
        BufferedReader lineRead = null;
        try {
            long tamanhoArquivo = file.length();
            BufferedReader in = new BufferedReader(new FileReader(file));
            lineRead = new LineNumberReader(in);
            ((LineNumberReader)lineRead).skip(tamanhoArquivo);
            int n = ((LineNumberReader)lineRead).getLineNumber() + 1;
            return n;
        }
        catch (IOException tamanhoArquivo) {
        }
        finally {
            try {
                if (lineRead != null) {
                    lineRead.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }
}

